<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryTransaction-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryTransaction-Request
 * @subpackage Structs
 */
class QueryTransaction_Request extends ExtensibleDataContract
{
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The GroupedBasketOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $GroupedBasketOptions;
    /**
     * The IsQueryFinancialJournal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsQueryFinancialJournal;
    /**
     * The GroupingHints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $GroupingHints;
    /**
     * Constructor method for QueryTransaction-Request
     * @uses QueryTransaction_Request::setTransactionGuid()
     * @uses QueryTransaction_Request::setTransactionNumber()
     * @uses QueryTransaction_Request::setTransactionSnapshotType()
     * @uses QueryTransaction_Request::setGroupedBasketOptions()
     * @uses QueryTransaction_Request::setIsQueryFinancialJournal()
     * @uses QueryTransaction_Request::setGroupingHints()
     * @param string $transactionGuid
     * @param int $transactionNumber
     * @param string $transactionSnapshotType
     * @param string[] $groupedBasketOptions
     * @param bool $isQueryFinancialJournal
     * @param \patest\ArrayType\ArrayOfstring $groupingHints
     */
    public function __construct($transactionGuid = null, $transactionNumber = null, $transactionSnapshotType = null, array $groupedBasketOptions = array(), $isQueryFinancialJournal = null, \patest\ArrayType\ArrayOfstring $groupingHints = null)
    {
        $this
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setGroupedBasketOptions($groupedBasketOptions)
            ->setIsQueryFinancialJournal($isQueryFinancialJournal)
            ->setGroupingHints($groupingHints);
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\QueryTransaction_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\QueryTransaction_Request
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\QueryTransaction_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get GroupedBasketOptions value
     * @return string[]|null
     */
    public function getGroupedBasketOptions()
    {
        return $this->GroupedBasketOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupedBasketOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupedBasketOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupedBasketOptionsForArrayConstraintsFromSetGroupedBasketOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queryTransaction_RequestGroupedBasketOptionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\GroupedBasketBuildingOptions::valueIsValid($queryTransaction_RequestGroupedBasketOptionsItem)) {
                $invalidValues[] = is_object($queryTransaction_RequestGroupedBasketOptionsItem) ? get_class($queryTransaction_RequestGroupedBasketOptionsItem) : sprintf('%s(%s)', gettype($queryTransaction_RequestGroupedBasketOptionsItem), var_export($queryTransaction_RequestGroupedBasketOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GroupedBasketBuildingOptions', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\GroupedBasketBuildingOptions::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupedBasketOptions value
     * @uses \patest\EnumType\GroupedBasketBuildingOptions::valueIsValid()
     * @uses \patest\EnumType\GroupedBasketBuildingOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $groupedBasketOptions
     * @return \patest\StructType\QueryTransaction_Request
     */
    public function setGroupedBasketOptions(array $groupedBasketOptions = array())
    {
        // validation for constraint: list
        if ('' !== ($groupedBasketOptionsArrayErrorMessage = self::validateGroupedBasketOptionsForArrayConstraintsFromSetGroupedBasketOptions($groupedBasketOptions))) {
            throw new \InvalidArgumentException($groupedBasketOptionsArrayErrorMessage, __LINE__);
        }
        $this->GroupedBasketOptions = is_array($groupedBasketOptions) ? implode(' ', $groupedBasketOptions) : null;
        return $this;
    }
    /**
     * Get IsQueryFinancialJournal value
     * @return bool|null
     */
    public function getIsQueryFinancialJournal()
    {
        return $this->IsQueryFinancialJournal;
    }
    /**
     * Set IsQueryFinancialJournal value
     * @param bool $isQueryFinancialJournal
     * @return \patest\StructType\QueryTransaction_Request
     */
    public function setIsQueryFinancialJournal($isQueryFinancialJournal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQueryFinancialJournal) && !is_bool($isQueryFinancialJournal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isQueryFinancialJournal, true), gettype($isQueryFinancialJournal)), __LINE__);
        }
        $this->IsQueryFinancialJournal = $isQueryFinancialJournal;
        return $this;
    }
    /**
     * Get GroupingHints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getGroupingHints()
    {
        return isset($this->GroupingHints) ? $this->GroupingHints : null;
    }
    /**
     * Set GroupingHints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $groupingHints
     * @return \patest\StructType\QueryTransaction_Request
     */
    public function setGroupingHints(\patest\ArrayType\ArrayOfstring $groupingHints = null)
    {
        if (is_null($groupingHints) || (is_array($groupingHints) && empty($groupingHints))) {
            unset($this->GroupingHints);
        } else {
            $this->GroupingHints = $groupingHints;
        }
        return $this;
    }
}
