<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QuerySeatingPlanAvailabilityRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QuerySeatingPlanAvailabilityRequest
 * @subpackage Structs
 */
class QuerySeatingPlanAvailabilityRequest extends AbstractStructBase
{
    /**
     * The AccessContext
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SeatingPlanAccessContext
     */
    public $AccessContext;
    /**
     * The AreasToQuery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfQueryAreaAvailabilityRequest
     */
    public $AreasToQuery;
    /**
     * The DefaultSeatPropertiesToQuery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSeatPropertyNames
     */
    public $DefaultSeatPropertiesToQuery;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The SeatingPlanStatisticsToQuery
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $SeatingPlanStatisticsToQuery;
    /**
     * The SessionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SessionId;
    /**
     * The StatisticsToQueryOnAnyNotSpecifiedArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $StatisticsToQueryOnAnyNotSpecifiedArea;
    /**
     * The EffectiveAvailabilityFilter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EffectiveAvailabilityFilterIdentification
     */
    public $EffectiveAvailabilityFilter;
    /**
     * The QueryForAnyNotSpecifiedArea
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\QueryAreaAvailabilityRequest
     */
    public $QueryForAnyNotSpecifiedArea;
    /**
     * The IncludeBasketLevelPriceModifiers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeBasketLevelPriceModifiers;
    /**
     * The OverridePriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $OverridePriceTypeIds;
    /**
     * Constructor method for QuerySeatingPlanAvailabilityRequest
     * @uses QuerySeatingPlanAvailabilityRequest::setAccessContext()
     * @uses QuerySeatingPlanAvailabilityRequest::setAreasToQuery()
     * @uses QuerySeatingPlanAvailabilityRequest::setDefaultSeatPropertiesToQuery()
     * @uses QuerySeatingPlanAvailabilityRequest::setSeatingPlanId()
     * @uses QuerySeatingPlanAvailabilityRequest::setSeatingPlanStatisticsToQuery()
     * @uses QuerySeatingPlanAvailabilityRequest::setSessionId()
     * @uses QuerySeatingPlanAvailabilityRequest::setStatisticsToQueryOnAnyNotSpecifiedArea()
     * @uses QuerySeatingPlanAvailabilityRequest::setEffectiveAvailabilityFilter()
     * @uses QuerySeatingPlanAvailabilityRequest::setQueryForAnyNotSpecifiedArea()
     * @uses QuerySeatingPlanAvailabilityRequest::setIncludeBasketLevelPriceModifiers()
     * @uses QuerySeatingPlanAvailabilityRequest::setOverridePriceTypeIds()
     * @param \patest\StructType\SeatingPlanAccessContext $accessContext
     * @param \patest\ArrayType\ArrayOfQueryAreaAvailabilityRequest $areasToQuery
     * @param \patest\ArrayType\ArrayOfSeatPropertyNames $defaultSeatPropertiesToQuery
     * @param string $seatingPlanId
     * @param string[] $seatingPlanStatisticsToQuery
     * @param string $sessionId
     * @param string[] $statisticsToQueryOnAnyNotSpecifiedArea
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @param \patest\StructType\QueryAreaAvailabilityRequest $queryForAnyNotSpecifiedArea
     * @param bool $includeBasketLevelPriceModifiers
     * @param \patest\ArrayType\ArrayOfguid $overridePriceTypeIds
     */
    public function __construct(\patest\StructType\SeatingPlanAccessContext $accessContext = null, \patest\ArrayType\ArrayOfQueryAreaAvailabilityRequest $areasToQuery = null, \patest\ArrayType\ArrayOfSeatPropertyNames $defaultSeatPropertiesToQuery = null, $seatingPlanId = null, array $seatingPlanStatisticsToQuery = array(), $sessionId = null, array $statisticsToQueryOnAnyNotSpecifiedArea = array(), \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null, \patest\StructType\QueryAreaAvailabilityRequest $queryForAnyNotSpecifiedArea = null, $includeBasketLevelPriceModifiers = null, \patest\ArrayType\ArrayOfguid $overridePriceTypeIds = null)
    {
        $this
            ->setAccessContext($accessContext)
            ->setAreasToQuery($areasToQuery)
            ->setDefaultSeatPropertiesToQuery($defaultSeatPropertiesToQuery)
            ->setSeatingPlanId($seatingPlanId)
            ->setSeatingPlanStatisticsToQuery($seatingPlanStatisticsToQuery)
            ->setSessionId($sessionId)
            ->setStatisticsToQueryOnAnyNotSpecifiedArea($statisticsToQueryOnAnyNotSpecifiedArea)
            ->setEffectiveAvailabilityFilter($effectiveAvailabilityFilter)
            ->setQueryForAnyNotSpecifiedArea($queryForAnyNotSpecifiedArea)
            ->setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers)
            ->setOverridePriceTypeIds($overridePriceTypeIds);
    }
    /**
     * Get AccessContext value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SeatingPlanAccessContext|null
     */
    public function getAccessContext()
    {
        return isset($this->AccessContext) ? $this->AccessContext : null;
    }
    /**
     * Set AccessContext value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SeatingPlanAccessContext $accessContext
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setAccessContext(\patest\StructType\SeatingPlanAccessContext $accessContext = null)
    {
        if (is_null($accessContext) || (is_array($accessContext) && empty($accessContext))) {
            unset($this->AccessContext);
        } else {
            $this->AccessContext = $accessContext;
        }
        return $this;
    }
    /**
     * Get AreasToQuery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfQueryAreaAvailabilityRequest|null
     */
    public function getAreasToQuery()
    {
        return isset($this->AreasToQuery) ? $this->AreasToQuery : null;
    }
    /**
     * Set AreasToQuery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfQueryAreaAvailabilityRequest $areasToQuery
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setAreasToQuery(\patest\ArrayType\ArrayOfQueryAreaAvailabilityRequest $areasToQuery = null)
    {
        if (is_null($areasToQuery) || (is_array($areasToQuery) && empty($areasToQuery))) {
            unset($this->AreasToQuery);
        } else {
            $this->AreasToQuery = $areasToQuery;
        }
        return $this;
    }
    /**
     * Get DefaultSeatPropertiesToQuery value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSeatPropertyNames|null
     */
    public function getDefaultSeatPropertiesToQuery()
    {
        return isset($this->DefaultSeatPropertiesToQuery) ? $this->DefaultSeatPropertiesToQuery : null;
    }
    /**
     * Set DefaultSeatPropertiesToQuery value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSeatPropertyNames $defaultSeatPropertiesToQuery
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setDefaultSeatPropertiesToQuery(\patest\ArrayType\ArrayOfSeatPropertyNames $defaultSeatPropertiesToQuery = null)
    {
        if (is_null($defaultSeatPropertiesToQuery) || (is_array($defaultSeatPropertiesToQuery) && empty($defaultSeatPropertiesToQuery))) {
            unset($this->DefaultSeatPropertiesToQuery);
        } else {
            $this->DefaultSeatPropertiesToQuery = $defaultSeatPropertiesToQuery;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return $this->SeatingPlanId;
    }
    /**
     * Set SeatingPlanId value
     * @param string $seatingPlanId
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        $this->SeatingPlanId = $seatingPlanId;
        return $this;
    }
    /**
     * Get SeatingPlanStatisticsToQuery value
     * @return string[]|null
     */
    public function getSeatingPlanStatisticsToQuery()
    {
        return $this->SeatingPlanStatisticsToQuery;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatingPlanStatisticsToQuery method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatingPlanStatisticsToQuery method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatingPlanStatisticsToQueryForArrayConstraintsFromSetSeatingPlanStatisticsToQuery(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $querySeatingPlanAvailabilityRequestSeatingPlanStatisticsToQueryItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SeatingPlanStatisticsType::valueIsValid($querySeatingPlanAvailabilityRequestSeatingPlanStatisticsToQueryItem)) {
                $invalidValues[] = is_object($querySeatingPlanAvailabilityRequestSeatingPlanStatisticsToQueryItem) ? get_class($querySeatingPlanAvailabilityRequestSeatingPlanStatisticsToQueryItem) : sprintf('%s(%s)', gettype($querySeatingPlanAvailabilityRequestSeatingPlanStatisticsToQueryItem), var_export($querySeatingPlanAvailabilityRequestSeatingPlanStatisticsToQueryItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanStatisticsType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SeatingPlanStatisticsType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatingPlanStatisticsToQuery value
     * @uses \patest\EnumType\SeatingPlanStatisticsType::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanStatisticsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $seatingPlanStatisticsToQuery
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setSeatingPlanStatisticsToQuery(array $seatingPlanStatisticsToQuery = array())
    {
        // validation for constraint: list
        if ('' !== ($seatingPlanStatisticsToQueryArrayErrorMessage = self::validateSeatingPlanStatisticsToQueryForArrayConstraintsFromSetSeatingPlanStatisticsToQuery($seatingPlanStatisticsToQuery))) {
            throw new \InvalidArgumentException($seatingPlanStatisticsToQueryArrayErrorMessage, __LINE__);
        }
        $this->SeatingPlanStatisticsToQuery = is_array($seatingPlanStatisticsToQuery) ? implode(' ', $seatingPlanStatisticsToQuery) : null;
        return $this;
    }
    /**
     * Get SessionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSessionId()
    {
        return isset($this->SessionId) ? $this->SessionId : null;
    }
    /**
     * Set SessionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sessionId
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setSessionId($sessionId = null)
    {
        // validation for constraint: string
        if (!is_null($sessionId) && !is_string($sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sessionId, true), gettype($sessionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sessionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sessionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sessionId, true)), __LINE__);
        }
        if (is_null($sessionId) || (is_array($sessionId) && empty($sessionId))) {
            unset($this->SessionId);
        } else {
            $this->SessionId = $sessionId;
        }
        return $this;
    }
    /**
     * Get StatisticsToQueryOnAnyNotSpecifiedArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getStatisticsToQueryOnAnyNotSpecifiedArea()
    {
        return isset($this->StatisticsToQueryOnAnyNotSpecifiedArea) ? $this->StatisticsToQueryOnAnyNotSpecifiedArea : null;
    }
    /**
     * This method is responsible for validating the values passed to the setStatisticsToQueryOnAnyNotSpecifiedArea method
     * This method is willingly generated in order to preserve the one-line inline validation within the setStatisticsToQueryOnAnyNotSpecifiedArea method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateStatisticsToQueryOnAnyNotSpecifiedAreaForArrayConstraintsFromSetStatisticsToQueryOnAnyNotSpecifiedArea(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $querySeatingPlanAvailabilityRequestStatisticsToQueryOnAnyNotSpecifiedAreaItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\SeatingPlanStatisticsType::valueIsValid($querySeatingPlanAvailabilityRequestStatisticsToQueryOnAnyNotSpecifiedAreaItem)) {
                $invalidValues[] = is_object($querySeatingPlanAvailabilityRequestStatisticsToQueryOnAnyNotSpecifiedAreaItem) ? get_class($querySeatingPlanAvailabilityRequestStatisticsToQueryOnAnyNotSpecifiedAreaItem) : sprintf('%s(%s)', gettype($querySeatingPlanAvailabilityRequestStatisticsToQueryOnAnyNotSpecifiedAreaItem), var_export($querySeatingPlanAvailabilityRequestStatisticsToQueryOnAnyNotSpecifiedAreaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SeatingPlanStatisticsType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\SeatingPlanStatisticsType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set StatisticsToQueryOnAnyNotSpecifiedArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SeatingPlanStatisticsType::valueIsValid()
     * @uses \patest\EnumType\SeatingPlanStatisticsType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $statisticsToQueryOnAnyNotSpecifiedArea
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setStatisticsToQueryOnAnyNotSpecifiedArea(array $statisticsToQueryOnAnyNotSpecifiedArea = array())
    {
        // validation for constraint: list
        if ('' !== ($statisticsToQueryOnAnyNotSpecifiedAreaArrayErrorMessage = self::validateStatisticsToQueryOnAnyNotSpecifiedAreaForArrayConstraintsFromSetStatisticsToQueryOnAnyNotSpecifiedArea($statisticsToQueryOnAnyNotSpecifiedArea))) {
            throw new \InvalidArgumentException($statisticsToQueryOnAnyNotSpecifiedAreaArrayErrorMessage, __LINE__);
        }
        if (is_null($statisticsToQueryOnAnyNotSpecifiedArea) || (is_array($statisticsToQueryOnAnyNotSpecifiedArea) && empty($statisticsToQueryOnAnyNotSpecifiedArea))) {
            unset($this->StatisticsToQueryOnAnyNotSpecifiedArea);
        } else {
            $this->StatisticsToQueryOnAnyNotSpecifiedArea = is_array($statisticsToQueryOnAnyNotSpecifiedArea) ? implode(' ', $statisticsToQueryOnAnyNotSpecifiedArea) : null;
        }
        return $this;
    }
    /**
     * Get EffectiveAvailabilityFilter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EffectiveAvailabilityFilterIdentification|null
     */
    public function getEffectiveAvailabilityFilter()
    {
        return isset($this->EffectiveAvailabilityFilter) ? $this->EffectiveAvailabilityFilter : null;
    }
    /**
     * Set EffectiveAvailabilityFilter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setEffectiveAvailabilityFilter(\patest\StructType\EffectiveAvailabilityFilterIdentification $effectiveAvailabilityFilter = null)
    {
        if (is_null($effectiveAvailabilityFilter) || (is_array($effectiveAvailabilityFilter) && empty($effectiveAvailabilityFilter))) {
            unset($this->EffectiveAvailabilityFilter);
        } else {
            $this->EffectiveAvailabilityFilter = $effectiveAvailabilityFilter;
        }
        return $this;
    }
    /**
     * Get QueryForAnyNotSpecifiedArea value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\QueryAreaAvailabilityRequest|null
     */
    public function getQueryForAnyNotSpecifiedArea()
    {
        return isset($this->QueryForAnyNotSpecifiedArea) ? $this->QueryForAnyNotSpecifiedArea : null;
    }
    /**
     * Set QueryForAnyNotSpecifiedArea value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\QueryAreaAvailabilityRequest $queryForAnyNotSpecifiedArea
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setQueryForAnyNotSpecifiedArea(\patest\StructType\QueryAreaAvailabilityRequest $queryForAnyNotSpecifiedArea = null)
    {
        if (is_null($queryForAnyNotSpecifiedArea) || (is_array($queryForAnyNotSpecifiedArea) && empty($queryForAnyNotSpecifiedArea))) {
            unset($this->QueryForAnyNotSpecifiedArea);
        } else {
            $this->QueryForAnyNotSpecifiedArea = $queryForAnyNotSpecifiedArea;
        }
        return $this;
    }
    /**
     * Get IncludeBasketLevelPriceModifiers value
     * @return bool|null
     */
    public function getIncludeBasketLevelPriceModifiers()
    {
        return $this->IncludeBasketLevelPriceModifiers;
    }
    /**
     * Set IncludeBasketLevelPriceModifiers value
     * @param bool $includeBasketLevelPriceModifiers
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setIncludeBasketLevelPriceModifiers($includeBasketLevelPriceModifiers = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeBasketLevelPriceModifiers) && !is_bool($includeBasketLevelPriceModifiers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeBasketLevelPriceModifiers, true), gettype($includeBasketLevelPriceModifiers)), __LINE__);
        }
        $this->IncludeBasketLevelPriceModifiers = $includeBasketLevelPriceModifiers;
        return $this;
    }
    /**
     * Get OverridePriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getOverridePriceTypeIds()
    {
        return isset($this->OverridePriceTypeIds) ? $this->OverridePriceTypeIds : null;
    }
    /**
     * Set OverridePriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $overridePriceTypeIds
     * @return \patest\StructType\QuerySeatingPlanAvailabilityRequest
     */
    public function setOverridePriceTypeIds(\patest\ArrayType\ArrayOfguid $overridePriceTypeIds = null)
    {
        if (is_null($overridePriceTypeIds) || (is_array($overridePriceTypeIds) && empty($overridePriceTypeIds))) {
            unset($this->OverridePriceTypeIds);
        } else {
            $this->OverridePriceTypeIds = $overridePriceTypeIds;
        }
        return $this;
    }
}
