<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryIdentityPlatformProperties-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryIdentityPlatformProperties-Request
 * @subpackage Structs
 */
class QueryIdentityPlatformProperties_Request extends ExtensibleDataContract
{
    /**
     * The Application
     * Meta information extracted from the WSDL
     * - nillable: true
     * @var string
     */
    public $Application;
    /**
     * The CustomParams
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $CustomParams;
    /**
     * The IdentityPlatformProperties
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $IdentityPlatformProperties;
    /**
     * The IsInitiatedFromSSOEntryPoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsInitiatedFromSSOEntryPoint;
    /**
     * The PredefinedNonce
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PredefinedNonce;
    /**
     * The SerializedState
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerializedState;
    /**
     * The LoginHint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoginHint;
    /**
     * Constructor method for QueryIdentityPlatformProperties-Request
     * @uses QueryIdentityPlatformProperties_Request::setApplication()
     * @uses QueryIdentityPlatformProperties_Request::setCustomParams()
     * @uses QueryIdentityPlatformProperties_Request::setIdentityPlatformProperties()
     * @uses QueryIdentityPlatformProperties_Request::setIsInitiatedFromSSOEntryPoint()
     * @uses QueryIdentityPlatformProperties_Request::setPredefinedNonce()
     * @uses QueryIdentityPlatformProperties_Request::setSerializedState()
     * @uses QueryIdentityPlatformProperties_Request::setLoginHint()
     * @param string $application
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $customParams
     * @param string[] $identityPlatformProperties
     * @param bool $isInitiatedFromSSOEntryPoint
     * @param string $predefinedNonce
     * @param string $serializedState
     * @param string $loginHint
     */
    public function __construct($application = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $customParams = null, array $identityPlatformProperties = array(), $isInitiatedFromSSOEntryPoint = null, $predefinedNonce = null, $serializedState = null, $loginHint = null)
    {
        $this
            ->setApplication($application)
            ->setCustomParams($customParams)
            ->setIdentityPlatformProperties($identityPlatformProperties)
            ->setIsInitiatedFromSSOEntryPoint($isInitiatedFromSSOEntryPoint)
            ->setPredefinedNonce($predefinedNonce)
            ->setSerializedState($serializedState)
            ->setLoginHint($loginHint);
    }
    /**
     * Get Application value
     * @return string|null
     */
    public function getApplication()
    {
        return $this->Application;
    }
    /**
     * Set Application value
     * @param string $application
     * @return \patest\StructType\QueryIdentityPlatformProperties_Request
     */
    public function setApplication($application = null)
    {
        // validation for constraint: string
        if (!is_null($application) && !is_string($application)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($application, true), gettype($application)), __LINE__);
        }
        $this->Application = $application;
        return $this;
    }
    /**
     * Get CustomParams value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getCustomParams()
    {
        return isset($this->CustomParams) ? $this->CustomParams : null;
    }
    /**
     * Set CustomParams value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $customParams
     * @return \patest\StructType\QueryIdentityPlatformProperties_Request
     */
    public function setCustomParams(\patest\ArrayType\ArrayOfKeyValueOfstringstring $customParams = null)
    {
        if (is_null($customParams) || (is_array($customParams) && empty($customParams))) {
            unset($this->CustomParams);
        } else {
            $this->CustomParams = $customParams;
        }
        return $this;
    }
    /**
     * Get IdentityPlatformProperties value
     * @return string[]|null
     */
    public function getIdentityPlatformProperties()
    {
        return $this->IdentityPlatformProperties;
    }
    /**
     * This method is responsible for validating the values passed to the setIdentityPlatformProperties method
     * This method is willingly generated in order to preserve the one-line inline validation within the setIdentityPlatformProperties method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateIdentityPlatformPropertiesForArrayConstraintsFromSetIdentityPlatformProperties(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queryIdentityPlatformProperties_RequestIdentityPlatformPropertiesItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\IdentityPlatformProperties::valueIsValid($queryIdentityPlatformProperties_RequestIdentityPlatformPropertiesItem)) {
                $invalidValues[] = is_object($queryIdentityPlatformProperties_RequestIdentityPlatformPropertiesItem) ? get_class($queryIdentityPlatformProperties_RequestIdentityPlatformPropertiesItem) : sprintf('%s(%s)', gettype($queryIdentityPlatformProperties_RequestIdentityPlatformPropertiesItem), var_export($queryIdentityPlatformProperties_RequestIdentityPlatformPropertiesItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\IdentityPlatformProperties', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\IdentityPlatformProperties::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set IdentityPlatformProperties value
     * @uses \patest\EnumType\IdentityPlatformProperties::valueIsValid()
     * @uses \patest\EnumType\IdentityPlatformProperties::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $identityPlatformProperties
     * @return \patest\StructType\QueryIdentityPlatformProperties_Request
     */
    public function setIdentityPlatformProperties(array $identityPlatformProperties = array())
    {
        // validation for constraint: list
        if ('' !== ($identityPlatformPropertiesArrayErrorMessage = self::validateIdentityPlatformPropertiesForArrayConstraintsFromSetIdentityPlatformProperties($identityPlatformProperties))) {
            throw new \InvalidArgumentException($identityPlatformPropertiesArrayErrorMessage, __LINE__);
        }
        $this->IdentityPlatformProperties = is_array($identityPlatformProperties) ? implode(' ', $identityPlatformProperties) : null;
        return $this;
    }
    /**
     * Get IsInitiatedFromSSOEntryPoint value
     * @return bool|null
     */
    public function getIsInitiatedFromSSOEntryPoint()
    {
        return $this->IsInitiatedFromSSOEntryPoint;
    }
    /**
     * Set IsInitiatedFromSSOEntryPoint value
     * @param bool $isInitiatedFromSSOEntryPoint
     * @return \patest\StructType\QueryIdentityPlatformProperties_Request
     */
    public function setIsInitiatedFromSSOEntryPoint($isInitiatedFromSSOEntryPoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInitiatedFromSSOEntryPoint) && !is_bool($isInitiatedFromSSOEntryPoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInitiatedFromSSOEntryPoint, true), gettype($isInitiatedFromSSOEntryPoint)), __LINE__);
        }
        $this->IsInitiatedFromSSOEntryPoint = $isInitiatedFromSSOEntryPoint;
        return $this;
    }
    /**
     * Get PredefinedNonce value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPredefinedNonce()
    {
        return isset($this->PredefinedNonce) ? $this->PredefinedNonce : null;
    }
    /**
     * Set PredefinedNonce value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $predefinedNonce
     * @return \patest\StructType\QueryIdentityPlatformProperties_Request
     */
    public function setPredefinedNonce($predefinedNonce = null)
    {
        // validation for constraint: string
        if (!is_null($predefinedNonce) && !is_string($predefinedNonce)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($predefinedNonce, true), gettype($predefinedNonce)), __LINE__);
        }
        if (is_null($predefinedNonce) || (is_array($predefinedNonce) && empty($predefinedNonce))) {
            unset($this->PredefinedNonce);
        } else {
            $this->PredefinedNonce = $predefinedNonce;
        }
        return $this;
    }
    /**
     * Get SerializedState value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerializedState()
    {
        return isset($this->SerializedState) ? $this->SerializedState : null;
    }
    /**
     * Set SerializedState value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serializedState
     * @return \patest\StructType\QueryIdentityPlatformProperties_Request
     */
    public function setSerializedState($serializedState = null)
    {
        // validation for constraint: string
        if (!is_null($serializedState) && !is_string($serializedState)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serializedState, true), gettype($serializedState)), __LINE__);
        }
        if (is_null($serializedState) || (is_array($serializedState) && empty($serializedState))) {
            unset($this->SerializedState);
        } else {
            $this->SerializedState = $serializedState;
        }
        return $this;
    }
    /**
     * Get LoginHint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoginHint()
    {
        return isset($this->LoginHint) ? $this->LoginHint : null;
    }
    /**
     * Set LoginHint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loginHint
     * @return \patest\StructType\QueryIdentityPlatformProperties_Request
     */
    public function setLoginHint($loginHint = null)
    {
        // validation for constraint: string
        if (!is_null($loginHint) && !is_string($loginHint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loginHint, true), gettype($loginHint)), __LINE__);
        }
        if (is_null($loginHint) || (is_array($loginHint) && empty($loginHint))) {
            unset($this->LoginHint);
        } else {
            $this->LoginHint = $loginHint;
        }
        return $this;
    }
}
