<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryGroupOfTransactions-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:QueryGroupOfTransactions-Request
 * @subpackage Structs
 */
class QueryGroupOfTransactions_Request extends ExtensibleDataContract
{
    /**
     * The GroupedBasketOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $GroupedBasketOptions;
    /**
     * The TransactionGroupNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionGroupNumber;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TransactionSnapshotType;
    /**
     * The IsQueryFinancialJournal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsQueryFinancialJournal;
    /**
     * Constructor method for QueryGroupOfTransactions-Request
     * @uses QueryGroupOfTransactions_Request::setGroupedBasketOptions()
     * @uses QueryGroupOfTransactions_Request::setTransactionGroupNumber()
     * @uses QueryGroupOfTransactions_Request::setTransactionGuid()
     * @uses QueryGroupOfTransactions_Request::setTransactionSnapshotType()
     * @uses QueryGroupOfTransactions_Request::setIsQueryFinancialJournal()
     * @param string[] $groupedBasketOptions
     * @param int $transactionGroupNumber
     * @param string $transactionGuid
     * @param string $transactionSnapshotType
     * @param bool $isQueryFinancialJournal
     */
    public function __construct(array $groupedBasketOptions = array(), $transactionGroupNumber = null, $transactionGuid = null, $transactionSnapshotType = null, $isQueryFinancialJournal = null)
    {
        $this
            ->setGroupedBasketOptions($groupedBasketOptions)
            ->setTransactionGroupNumber($transactionGroupNumber)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionSnapshotType($transactionSnapshotType)
            ->setIsQueryFinancialJournal($isQueryFinancialJournal);
    }
    /**
     * Get GroupedBasketOptions value
     * @return string[]|null
     */
    public function getGroupedBasketOptions()
    {
        return $this->GroupedBasketOptions;
    }
    /**
     * This method is responsible for validating the values passed to the setGroupedBasketOptions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGroupedBasketOptions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGroupedBasketOptionsForArrayConstraintsFromSetGroupedBasketOptions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $queryGroupOfTransactions_RequestGroupedBasketOptionsItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\GroupedBasketBuildingOptions::valueIsValid($queryGroupOfTransactions_RequestGroupedBasketOptionsItem)) {
                $invalidValues[] = is_object($queryGroupOfTransactions_RequestGroupedBasketOptionsItem) ? get_class($queryGroupOfTransactions_RequestGroupedBasketOptionsItem) : sprintf('%s(%s)', gettype($queryGroupOfTransactions_RequestGroupedBasketOptionsItem), var_export($queryGroupOfTransactions_RequestGroupedBasketOptionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GroupedBasketBuildingOptions', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\GroupedBasketBuildingOptions::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GroupedBasketOptions value
     * @uses \patest\EnumType\GroupedBasketBuildingOptions::valueIsValid()
     * @uses \patest\EnumType\GroupedBasketBuildingOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $groupedBasketOptions
     * @return \patest\StructType\QueryGroupOfTransactions_Request
     */
    public function setGroupedBasketOptions(array $groupedBasketOptions = array())
    {
        // validation for constraint: list
        if ('' !== ($groupedBasketOptionsArrayErrorMessage = self::validateGroupedBasketOptionsForArrayConstraintsFromSetGroupedBasketOptions($groupedBasketOptions))) {
            throw new \InvalidArgumentException($groupedBasketOptionsArrayErrorMessage, __LINE__);
        }
        $this->GroupedBasketOptions = is_array($groupedBasketOptions) ? implode(' ', $groupedBasketOptions) : null;
        return $this;
    }
    /**
     * Get TransactionGroupNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionGroupNumber()
    {
        return isset($this->TransactionGroupNumber) ? $this->TransactionGroupNumber : null;
    }
    /**
     * Set TransactionGroupNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionGroupNumber
     * @return \patest\StructType\QueryGroupOfTransactions_Request
     */
    public function setTransactionGroupNumber($transactionGroupNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionGroupNumber) && !(is_int($transactionGroupNumber) || ctype_digit($transactionGroupNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionGroupNumber, true), gettype($transactionGroupNumber)), __LINE__);
        }
        if (is_null($transactionGroupNumber) || (is_array($transactionGroupNumber) && empty($transactionGroupNumber))) {
            unset($this->TransactionGroupNumber);
        } else {
            $this->TransactionGroupNumber = $transactionGroupNumber;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\QueryGroupOfTransactions_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionSnapshotType value
     * @return string|null
     */
    public function getTransactionSnapshotType()
    {
        return $this->TransactionSnapshotType;
    }
    /**
     * Set TransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $transactionSnapshotType
     * @return \patest\StructType\QueryGroupOfTransactions_Request
     */
    public function setTransactionSnapshotType($transactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($transactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($transactionSnapshotType) ? implode(', ', $transactionSnapshotType) : var_export($transactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->TransactionSnapshotType = $transactionSnapshotType;
        return $this;
    }
    /**
     * Get IsQueryFinancialJournal value
     * @return bool|null
     */
    public function getIsQueryFinancialJournal()
    {
        return $this->IsQueryFinancialJournal;
    }
    /**
     * Set IsQueryFinancialJournal value
     * @param bool $isQueryFinancialJournal
     * @return \patest\StructType\QueryGroupOfTransactions_Request
     */
    public function setIsQueryFinancialJournal($isQueryFinancialJournal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isQueryFinancialJournal) && !is_bool($isQueryFinancialJournal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isQueryFinancialJournal, true), gettype($isQueryFinancialJournal)), __LINE__);
        }
        $this->IsQueryFinancialJournal = $isQueryFinancialJournal;
        return $this;
    }
}
