<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for QueryBuilder.Criteria StructType
 * @subpackage Structs
 */
class QueryBuilder_Criteria extends AnyEntity
{
    /**
     * The AccessibilityStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessibilityStatus;
    /**
     * The ConditionOperator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConditionOperator;
    /**
     * The ConditionOperatorsSet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConditionOperatorsSet;
    /**
     * The ContextProperty
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextProperty;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The ValidOnThisDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ValidOnThisDate;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfQueryBuilder_CriteriaValue
     */
    public $Values;
    /**
     * Constructor method for QueryBuilder.Criteria
     * @uses QueryBuilder_Criteria::setAccessibilityStatus()
     * @uses QueryBuilder_Criteria::setConditionOperator()
     * @uses QueryBuilder_Criteria::setConditionOperatorsSet()
     * @uses QueryBuilder_Criteria::setContextProperty()
     * @uses QueryBuilder_Criteria::setId()
     * @uses QueryBuilder_Criteria::setName()
     * @uses QueryBuilder_Criteria::setOrdinal()
     * @uses QueryBuilder_Criteria::setValidOnThisDate()
     * @uses QueryBuilder_Criteria::setValues()
     * @param string $accessibilityStatus
     * @param string $conditionOperator
     * @param string $conditionOperatorsSet
     * @param string $contextProperty
     * @param string $id
     * @param \patest\StructType\GlobalString $name
     * @param int $ordinal
     * @param string $validOnThisDate
     * @param \patest\StructType\RecordSetOfQueryBuilder_CriteriaValue $values
     */
    public function __construct($accessibilityStatus = null, $conditionOperator = null, $conditionOperatorsSet = null, $contextProperty = null, $id = null, \patest\StructType\GlobalString $name = null, $ordinal = null, $validOnThisDate = null, \patest\StructType\RecordSetOfQueryBuilder_CriteriaValue $values = null)
    {
        $this
            ->setAccessibilityStatus($accessibilityStatus)
            ->setConditionOperator($conditionOperator)
            ->setConditionOperatorsSet($conditionOperatorsSet)
            ->setContextProperty($contextProperty)
            ->setId($id)
            ->setName($name)
            ->setOrdinal($ordinal)
            ->setValidOnThisDate($validOnThisDate)
            ->setValues($values);
    }
    /**
     * Get AccessibilityStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessibilityStatus()
    {
        return isset($this->AccessibilityStatus) ? $this->AccessibilityStatus : null;
    }
    /**
     * Set AccessibilityStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CriteriaAccessibilityStatus::valueIsValid()
     * @uses \patest\EnumType\CriteriaAccessibilityStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $accessibilityStatus
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setAccessibilityStatus($accessibilityStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CriteriaAccessibilityStatus::valueIsValid($accessibilityStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CriteriaAccessibilityStatus', is_array($accessibilityStatus) ? implode(', ', $accessibilityStatus) : var_export($accessibilityStatus, true), implode(', ', \patest\EnumType\CriteriaAccessibilityStatus::getValidValues())), __LINE__);
        }
        if (is_null($accessibilityStatus) || (is_array($accessibilityStatus) && empty($accessibilityStatus))) {
            unset($this->AccessibilityStatus);
        } else {
            $this->AccessibilityStatus = $accessibilityStatus;
        }
        return $this;
    }
    /**
     * Get ConditionOperator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConditionOperator()
    {
        return isset($this->ConditionOperator) ? $this->ConditionOperator : null;
    }
    /**
     * Set ConditionOperator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conditionOperator
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setConditionOperator($conditionOperator = null)
    {
        // validation for constraint: string
        if (!is_null($conditionOperator) && !is_string($conditionOperator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionOperator, true), gettype($conditionOperator)), __LINE__);
        }
        if (is_null($conditionOperator) || (is_array($conditionOperator) && empty($conditionOperator))) {
            unset($this->ConditionOperator);
        } else {
            $this->ConditionOperator = $conditionOperator;
        }
        return $this;
    }
    /**
     * Get ConditionOperatorsSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConditionOperatorsSet()
    {
        return isset($this->ConditionOperatorsSet) ? $this->ConditionOperatorsSet : null;
    }
    /**
     * Set ConditionOperatorsSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conditionOperatorsSet
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setConditionOperatorsSet($conditionOperatorsSet = null)
    {
        // validation for constraint: string
        if (!is_null($conditionOperatorsSet) && !is_string($conditionOperatorsSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($conditionOperatorsSet, true), gettype($conditionOperatorsSet)), __LINE__);
        }
        if (is_null($conditionOperatorsSet) || (is_array($conditionOperatorsSet) && empty($conditionOperatorsSet))) {
            unset($this->ConditionOperatorsSet);
        } else {
            $this->ConditionOperatorsSet = $conditionOperatorsSet;
        }
        return $this;
    }
    /**
     * Get ContextProperty value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextProperty()
    {
        return isset($this->ContextProperty) ? $this->ContextProperty : null;
    }
    /**
     * Set ContextProperty value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextProperty
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setContextProperty($contextProperty = null)
    {
        // validation for constraint: string
        if (!is_null($contextProperty) && !is_string($contextProperty)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextProperty, true), gettype($contextProperty)), __LINE__);
        }
        if (is_null($contextProperty) || (is_array($contextProperty) && empty($contextProperty))) {
            unset($this->ContextProperty);
        } else {
            $this->ContextProperty = $contextProperty;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get ValidOnThisDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidOnThisDate()
    {
        return isset($this->ValidOnThisDate) ? $this->ValidOnThisDate : null;
    }
    /**
     * Set ValidOnThisDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validOnThisDate
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setValidOnThisDate($validOnThisDate = null)
    {
        // validation for constraint: string
        if (!is_null($validOnThisDate) && !is_string($validOnThisDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($validOnThisDate, true), gettype($validOnThisDate)), __LINE__);
        }
        if (is_null($validOnThisDate) || (is_array($validOnThisDate) && empty($validOnThisDate))) {
            unset($this->ValidOnThisDate);
        } else {
            $this->ValidOnThisDate = $validOnThisDate;
        }
        return $this;
    }
    /**
     * Get Values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfQueryBuilder_CriteriaValue|null
     */
    public function getValues()
    {
        return isset($this->Values) ? $this->Values : null;
    }
    /**
     * Set Values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfQueryBuilder_CriteriaValue $values
     * @return \patest\StructType\QueryBuilder_Criteria
     */
    public function setValues(\patest\StructType\RecordSetOfQueryBuilder_CriteriaValue $values = null)
    {
        if (is_null($values) || (is_array($values) && empty($values))) {
            unset($this->Values);
        } else {
            $this->Values = $values;
        }
        return $this;
    }
}
