<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PurchasedForDataMin StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PurchasedForDataMin
 * @subpackage Structs
 */
class PurchasedForDataMin extends SearchResultDataChunk
{
    /**
     * The AccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountName;
    /**
     * The ClientType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $ClientType;
    /**
     * The ContactId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContactId;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PersonName
     */
    public $Name;
    /**
     * Constructor method for PurchasedForDataMin
     * @uses PurchasedForDataMin::setAccountName()
     * @uses PurchasedForDataMin::setClientType()
     * @uses PurchasedForDataMin::setContactId()
     * @uses PurchasedForDataMin::setName()
     * @param string $accountName
     * @param string[] $clientType
     * @param string $contactId
     * @param \patest\StructType\PersonName $name
     */
    public function __construct($accountName = null, array $clientType = array(), $contactId = null, \patest\StructType\PersonName $name = null)
    {
        $this
            ->setAccountName($accountName)
            ->setClientType($clientType)
            ->setContactId($contactId)
            ->setName($name);
    }
    /**
     * Get AccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountName()
    {
        return isset($this->AccountName) ? $this->AccountName : null;
    }
    /**
     * Set AccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountName
     * @return \patest\StructType\PurchasedForDataMin
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountName, true), gettype($accountName)), __LINE__);
        }
        if (is_null($accountName) || (is_array($accountName) && empty($accountName))) {
            unset($this->AccountName);
        } else {
            $this->AccountName = $accountName;
        }
        return $this;
    }
    /**
     * Get ClientType value
     * @return string[]|null
     */
    public function getClientType()
    {
        return $this->ClientType;
    }
    /**
     * This method is responsible for validating the values passed to the setClientType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setClientType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateClientTypeForArrayConstraintsFromSetClientType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $purchasedForDataMinClientTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($purchasedForDataMinClientTypeItem)) {
                $invalidValues[] = is_object($purchasedForDataMinClientTypeItem) ? get_class($purchasedForDataMinClientTypeItem) : sprintf('%s(%s)', gettype($purchasedForDataMinClientTypeItem), var_export($purchasedForDataMinClientTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ClientType value
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $clientType
     * @return \patest\StructType\PurchasedForDataMin
     */
    public function setClientType(array $clientType = array())
    {
        // validation for constraint: list
        if ('' !== ($clientTypeArrayErrorMessage = self::validateClientTypeForArrayConstraintsFromSetClientType($clientType))) {
            throw new \InvalidArgumentException($clientTypeArrayErrorMessage, __LINE__);
        }
        $this->ClientType = is_array($clientType) ? implode(' ', $clientType) : null;
        return $this;
    }
    /**
     * Get ContactId value
     * @return string|null
     */
    public function getContactId()
    {
        return $this->ContactId;
    }
    /**
     * Set ContactId value
     * @param string $contactId
     * @return \patest\StructType\PurchasedForDataMin
     */
    public function setContactId($contactId = null)
    {
        // validation for constraint: string
        if (!is_null($contactId) && !is_string($contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactId, true), gettype($contactId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($contactId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contactId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($contactId, true)), __LINE__);
        }
        $this->ContactId = $contactId;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PersonName|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PersonName $name
     * @return \patest\StructType\PurchasedForDataMin
     */
    public function setName(\patest\StructType\PersonName $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
