<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromptMessage StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PromptMessage
 * @subpackage Structs
 */
class PromptMessage extends AbstractStructBase
{
    /**
     * The DialogFormName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DialogFormName;
    /**
     * The ExtraProductsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PromptExtraProductsDescription
     */
    public $ExtraProductsDescription;
    /**
     * The MessageToDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageToDisplay;
    /**
     * The PromptSubType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PromptSubType;
    /**
     * The ShowOnExtraPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ShowOnExtraPage;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * Constructor method for PromptMessage
     * @uses PromptMessage::setDialogFormName()
     * @uses PromptMessage::setExtraProductsDescription()
     * @uses PromptMessage::setMessageToDisplay()
     * @uses PromptMessage::setPromptSubType()
     * @uses PromptMessage::setShowOnExtraPage()
     * @uses PromptMessage::setType()
     * @param string $dialogFormName
     * @param \patest\StructType\PromptExtraProductsDescription $extraProductsDescription
     * @param string $messageToDisplay
     * @param string $promptSubType
     * @param bool $showOnExtraPage
     * @param string $type
     */
    public function __construct($dialogFormName = null, \patest\StructType\PromptExtraProductsDescription $extraProductsDescription = null, $messageToDisplay = null, $promptSubType = null, $showOnExtraPage = null, $type = null)
    {
        $this
            ->setDialogFormName($dialogFormName)
            ->setExtraProductsDescription($extraProductsDescription)
            ->setMessageToDisplay($messageToDisplay)
            ->setPromptSubType($promptSubType)
            ->setShowOnExtraPage($showOnExtraPage)
            ->setType($type);
    }
    /**
     * Get DialogFormName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDialogFormName()
    {
        return isset($this->DialogFormName) ? $this->DialogFormName : null;
    }
    /**
     * Set DialogFormName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dialogFormName
     * @return \patest\StructType\PromptMessage
     */
    public function setDialogFormName($dialogFormName = null)
    {
        // validation for constraint: string
        if (!is_null($dialogFormName) && !is_string($dialogFormName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dialogFormName, true), gettype($dialogFormName)), __LINE__);
        }
        if (is_null($dialogFormName) || (is_array($dialogFormName) && empty($dialogFormName))) {
            unset($this->DialogFormName);
        } else {
            $this->DialogFormName = $dialogFormName;
        }
        return $this;
    }
    /**
     * Get ExtraProductsDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PromptExtraProductsDescription|null
     */
    public function getExtraProductsDescription()
    {
        return isset($this->ExtraProductsDescription) ? $this->ExtraProductsDescription : null;
    }
    /**
     * Set ExtraProductsDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PromptExtraProductsDescription $extraProductsDescription
     * @return \patest\StructType\PromptMessage
     */
    public function setExtraProductsDescription(\patest\StructType\PromptExtraProductsDescription $extraProductsDescription = null)
    {
        if (is_null($extraProductsDescription) || (is_array($extraProductsDescription) && empty($extraProductsDescription))) {
            unset($this->ExtraProductsDescription);
        } else {
            $this->ExtraProductsDescription = $extraProductsDescription;
        }
        return $this;
    }
    /**
     * Get MessageToDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageToDisplay()
    {
        return isset($this->MessageToDisplay) ? $this->MessageToDisplay : null;
    }
    /**
     * Set MessageToDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageToDisplay
     * @return \patest\StructType\PromptMessage
     */
    public function setMessageToDisplay($messageToDisplay = null)
    {
        // validation for constraint: string
        if (!is_null($messageToDisplay) && !is_string($messageToDisplay)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageToDisplay, true), gettype($messageToDisplay)), __LINE__);
        }
        if (is_null($messageToDisplay) || (is_array($messageToDisplay) && empty($messageToDisplay))) {
            unset($this->MessageToDisplay);
        } else {
            $this->MessageToDisplay = $messageToDisplay;
        }
        return $this;
    }
    /**
     * Get PromptSubType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPromptSubType()
    {
        return isset($this->PromptSubType) ? $this->PromptSubType : null;
    }
    /**
     * Set PromptSubType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PromptSubType::valueIsValid()
     * @uses \patest\EnumType\PromptSubType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $promptSubType
     * @return \patest\StructType\PromptMessage
     */
    public function setPromptSubType($promptSubType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PromptSubType::valueIsValid($promptSubType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PromptSubType', is_array($promptSubType) ? implode(', ', $promptSubType) : var_export($promptSubType, true), implode(', ', \patest\EnumType\PromptSubType::getValidValues())), __LINE__);
        }
        if (is_null($promptSubType) || (is_array($promptSubType) && empty($promptSubType))) {
            unset($this->PromptSubType);
        } else {
            $this->PromptSubType = $promptSubType;
        }
        return $this;
    }
    /**
     * Get ShowOnExtraPage value
     * @return bool|null
     */
    public function getShowOnExtraPage()
    {
        return $this->ShowOnExtraPage;
    }
    /**
     * Set ShowOnExtraPage value
     * @param bool $showOnExtraPage
     * @return \patest\StructType\PromptMessage
     */
    public function setShowOnExtraPage($showOnExtraPage = null)
    {
        // validation for constraint: boolean
        if (!is_null($showOnExtraPage) && !is_bool($showOnExtraPage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showOnExtraPage, true), gettype($showOnExtraPage)), __LINE__);
        }
        $this->ShowOnExtraPage = $showOnExtraPage;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \patest\EnumType\PromptMessageType::valueIsValid()
     * @uses \patest\EnumType\PromptMessageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\PromptMessage
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PromptMessageType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PromptMessageType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\PromptMessageType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
}
