<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PromptExtraProductsDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PromptExtraProductsDescription
 * @subpackage Structs
 */
class PromptExtraProductsDescription extends AbstractStructBase
{
    /**
     * The Elements
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfExtraProductElementDescription
     */
    public $Elements;
    /**
     * The LinkingDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\LinkingProductDetails
     */
    public $LinkingDetails;
    /**
     * The OriginativeItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $OriginativeItemIds;
    /**
     * The PromptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PromptId;
    /**
     * Constructor method for PromptExtraProductsDescription
     * @uses PromptExtraProductsDescription::setElements()
     * @uses PromptExtraProductsDescription::setLinkingDetails()
     * @uses PromptExtraProductsDescription::setOriginativeItemIds()
     * @uses PromptExtraProductsDescription::setPromptId()
     * @param \patest\ArrayType\ArrayOfExtraProductElementDescription $elements
     * @param \patest\StructType\LinkingProductDetails $linkingDetails
     * @param \patest\ArrayType\ArrayOfint $originativeItemIds
     * @param string $promptId
     */
    public function __construct(\patest\ArrayType\ArrayOfExtraProductElementDescription $elements = null, \patest\StructType\LinkingProductDetails $linkingDetails = null, \patest\ArrayType\ArrayOfint $originativeItemIds = null, $promptId = null)
    {
        $this
            ->setElements($elements)
            ->setLinkingDetails($linkingDetails)
            ->setOriginativeItemIds($originativeItemIds)
            ->setPromptId($promptId);
    }
    /**
     * Get Elements value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfExtraProductElementDescription|null
     */
    public function getElements()
    {
        return isset($this->Elements) ? $this->Elements : null;
    }
    /**
     * Set Elements value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfExtraProductElementDescription $elements
     * @return \patest\StructType\PromptExtraProductsDescription
     */
    public function setElements(\patest\ArrayType\ArrayOfExtraProductElementDescription $elements = null)
    {
        if (is_null($elements) || (is_array($elements) && empty($elements))) {
            unset($this->Elements);
        } else {
            $this->Elements = $elements;
        }
        return $this;
    }
    /**
     * Get LinkingDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\LinkingProductDetails|null
     */
    public function getLinkingDetails()
    {
        return isset($this->LinkingDetails) ? $this->LinkingDetails : null;
    }
    /**
     * Set LinkingDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\LinkingProductDetails $linkingDetails
     * @return \patest\StructType\PromptExtraProductsDescription
     */
    public function setLinkingDetails(\patest\StructType\LinkingProductDetails $linkingDetails = null)
    {
        if (is_null($linkingDetails) || (is_array($linkingDetails) && empty($linkingDetails))) {
            unset($this->LinkingDetails);
        } else {
            $this->LinkingDetails = $linkingDetails;
        }
        return $this;
    }
    /**
     * Get OriginativeItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getOriginativeItemIds()
    {
        return isset($this->OriginativeItemIds) ? $this->OriginativeItemIds : null;
    }
    /**
     * Set OriginativeItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $originativeItemIds
     * @return \patest\StructType\PromptExtraProductsDescription
     */
    public function setOriginativeItemIds(\patest\ArrayType\ArrayOfint $originativeItemIds = null)
    {
        if (is_null($originativeItemIds) || (is_array($originativeItemIds) && empty($originativeItemIds))) {
            unset($this->OriginativeItemIds);
        } else {
            $this->OriginativeItemIds = $originativeItemIds;
        }
        return $this;
    }
    /**
     * Get PromptId value
     * @return string|null
     */
    public function getPromptId()
    {
        return $this->PromptId;
    }
    /**
     * Set PromptId value
     * @param string $promptId
     * @return \patest\StructType\PromptExtraProductsDescription
     */
    public function setPromptId($promptId = null)
    {
        // validation for constraint: string
        if (!is_null($promptId) && !is_string($promptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($promptId, true), gettype($promptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($promptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $promptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($promptId, true)), __LINE__);
        }
        $this->PromptId = $promptId;
        return $this;
    }
}
