<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductPriceAxisDescription StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductPriceAxisDescription
 * @subpackage Structs
 */
class ProductPriceAxisDescription extends AbstractStructBase
{
    /**
     * The AxisName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AxisName;
    /**
     * The Values
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValuePairOfguidstring
     */
    public $Values;
    /**
     * Constructor method for ProductPriceAxisDescription
     * @uses ProductPriceAxisDescription::setAxisName()
     * @uses ProductPriceAxisDescription::setValues()
     * @param string $axisName
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $values
     */
    public function __construct($axisName = null, \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $values = null)
    {
        $this
            ->setAxisName($axisName)
            ->setValues($values);
    }
    /**
     * Get AxisName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAxisName()
    {
        return isset($this->AxisName) ? $this->AxisName : null;
    }
    /**
     * Set AxisName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $axisName
     * @return \patest\StructType\ProductPriceAxisDescription
     */
    public function setAxisName($axisName = null)
    {
        // validation for constraint: string
        if (!is_null($axisName) && !is_string($axisName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($axisName, true), gettype($axisName)), __LINE__);
        }
        if (is_null($axisName) || (is_array($axisName) && empty($axisName))) {
            unset($this->AxisName);
        } else {
            $this->AxisName = $axisName;
        }
        return $this;
    }
    /**
     * Get Values value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValuePairOfguidstring|null
     */
    public function getValues()
    {
        return isset($this->Values) ? $this->Values : null;
    }
    /**
     * Set Values value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValuePairOfguidstring $values
     * @return \patest\StructType\ProductPriceAxisDescription
     */
    public function setValues(\patest\ArrayType\ArrayOfKeyValuePairOfguidstring $values = null)
    {
        if (is_null($values) || (is_array($values) && empty($values))) {
            unset($this->Values);
        } else {
            $this->Values = $values;
        }
        return $this;
    }
}
