<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ProductMedia StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:ProductMedia
 * @subpackage Structs
 */
class ProductMedia extends AbstractStructBase
{
    /**
     * The BriefOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BriefOverview;
    /**
     * The DetailOverview
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DetailOverview;
    /**
     * The EffectiveLargeImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveLargeImageUrl;
    /**
     * The EffectiveMediumImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveMediumImageUrl;
    /**
     * The EffectiveOnlineHeroImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveOnlineHeroImageUrl;
    /**
     * The EffectiveOnlineThumbnailImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveOnlineThumbnailImageUrl;
    /**
     * The EffectivePassbookImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectivePassbookImageUrl;
    /**
     * The EffectiveSmallImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveSmallImageUrl;
    /**
     * The EffectiveSocialNetworkImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveSocialNetworkImageUrl;
    /**
     * The EffectiveThumbnailImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveThumbnailImageUrl;
    /**
     * The ImageMedia
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfImageMedia
     */
    public $ImageMedia;
    /**
     * The Incentive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Incentive;
    /**
     * The LargeImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $LargeImageId;
    /**
     * The MediumImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $MediumImageId;
    /**
     * The OnlineHeroImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OnlineHeroImageId;
    /**
     * The OnlineThumbnailImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OnlineThumbnailImageId;
    /**
     * The PassbookImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PassbookImageId;
    /**
     * The ReviewUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ReviewUrl;
    /**
     * The SmallImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SmallImageId;
    /**
     * The SocialNetworkImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SocialNetworkImageId;
    /**
     * The ThumbnailImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ThumbnailImageId;
    /**
     * The TrailerUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TrailerUrl;
    /**
     * Constructor method for ProductMedia
     * @uses ProductMedia::setBriefOverview()
     * @uses ProductMedia::setDetailOverview()
     * @uses ProductMedia::setEffectiveLargeImageUrl()
     * @uses ProductMedia::setEffectiveMediumImageUrl()
     * @uses ProductMedia::setEffectiveOnlineHeroImageUrl()
     * @uses ProductMedia::setEffectiveOnlineThumbnailImageUrl()
     * @uses ProductMedia::setEffectivePassbookImageUrl()
     * @uses ProductMedia::setEffectiveSmallImageUrl()
     * @uses ProductMedia::setEffectiveSocialNetworkImageUrl()
     * @uses ProductMedia::setEffectiveThumbnailImageUrl()
     * @uses ProductMedia::setImageMedia()
     * @uses ProductMedia::setIncentive()
     * @uses ProductMedia::setLargeImageId()
     * @uses ProductMedia::setMediumImageId()
     * @uses ProductMedia::setOnlineHeroImageId()
     * @uses ProductMedia::setOnlineThumbnailImageId()
     * @uses ProductMedia::setPassbookImageId()
     * @uses ProductMedia::setReviewUrl()
     * @uses ProductMedia::setSmallImageId()
     * @uses ProductMedia::setSocialNetworkImageId()
     * @uses ProductMedia::setThumbnailImageId()
     * @uses ProductMedia::setTrailerUrl()
     * @param \patest\StructType\GlobalString $briefOverview
     * @param \patest\StructType\GlobalString $detailOverview
     * @param string $effectiveLargeImageUrl
     * @param string $effectiveMediumImageUrl
     * @param string $effectiveOnlineHeroImageUrl
     * @param string $effectiveOnlineThumbnailImageUrl
     * @param string $effectivePassbookImageUrl
     * @param string $effectiveSmallImageUrl
     * @param string $effectiveSocialNetworkImageUrl
     * @param string $effectiveThumbnailImageUrl
     * @param \patest\ArrayType\ArrayOfImageMedia $imageMedia
     * @param \patest\StructType\GlobalString $incentive
     * @param int $largeImageId
     * @param int $mediumImageId
     * @param int $onlineHeroImageId
     * @param int $onlineThumbnailImageId
     * @param int $passbookImageId
     * @param \patest\StructType\GlobalString $reviewUrl
     * @param int $smallImageId
     * @param int $socialNetworkImageId
     * @param int $thumbnailImageId
     * @param \patest\StructType\GlobalString $trailerUrl
     */
    public function __construct(\patest\StructType\GlobalString $briefOverview = null, \patest\StructType\GlobalString $detailOverview = null, $effectiveLargeImageUrl = null, $effectiveMediumImageUrl = null, $effectiveOnlineHeroImageUrl = null, $effectiveOnlineThumbnailImageUrl = null, $effectivePassbookImageUrl = null, $effectiveSmallImageUrl = null, $effectiveSocialNetworkImageUrl = null, $effectiveThumbnailImageUrl = null, \patest\ArrayType\ArrayOfImageMedia $imageMedia = null, \patest\StructType\GlobalString $incentive = null, $largeImageId = null, $mediumImageId = null, $onlineHeroImageId = null, $onlineThumbnailImageId = null, $passbookImageId = null, \patest\StructType\GlobalString $reviewUrl = null, $smallImageId = null, $socialNetworkImageId = null, $thumbnailImageId = null, \patest\StructType\GlobalString $trailerUrl = null)
    {
        $this
            ->setBriefOverview($briefOverview)
            ->setDetailOverview($detailOverview)
            ->setEffectiveLargeImageUrl($effectiveLargeImageUrl)
            ->setEffectiveMediumImageUrl($effectiveMediumImageUrl)
            ->setEffectiveOnlineHeroImageUrl($effectiveOnlineHeroImageUrl)
            ->setEffectiveOnlineThumbnailImageUrl($effectiveOnlineThumbnailImageUrl)
            ->setEffectivePassbookImageUrl($effectivePassbookImageUrl)
            ->setEffectiveSmallImageUrl($effectiveSmallImageUrl)
            ->setEffectiveSocialNetworkImageUrl($effectiveSocialNetworkImageUrl)
            ->setEffectiveThumbnailImageUrl($effectiveThumbnailImageUrl)
            ->setImageMedia($imageMedia)
            ->setIncentive($incentive)
            ->setLargeImageId($largeImageId)
            ->setMediumImageId($mediumImageId)
            ->setOnlineHeroImageId($onlineHeroImageId)
            ->setOnlineThumbnailImageId($onlineThumbnailImageId)
            ->setPassbookImageId($passbookImageId)
            ->setReviewUrl($reviewUrl)
            ->setSmallImageId($smallImageId)
            ->setSocialNetworkImageId($socialNetworkImageId)
            ->setThumbnailImageId($thumbnailImageId)
            ->setTrailerUrl($trailerUrl);
    }
    /**
     * Get BriefOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBriefOverview()
    {
        return isset($this->BriefOverview) ? $this->BriefOverview : null;
    }
    /**
     * Set BriefOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $briefOverview
     * @return \patest\StructType\ProductMedia
     */
    public function setBriefOverview(\patest\StructType\GlobalString $briefOverview = null)
    {
        if (is_null($briefOverview) || (is_array($briefOverview) && empty($briefOverview))) {
            unset($this->BriefOverview);
        } else {
            $this->BriefOverview = $briefOverview;
        }
        return $this;
    }
    /**
     * Get DetailOverview value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDetailOverview()
    {
        return isset($this->DetailOverview) ? $this->DetailOverview : null;
    }
    /**
     * Set DetailOverview value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $detailOverview
     * @return \patest\StructType\ProductMedia
     */
    public function setDetailOverview(\patest\StructType\GlobalString $detailOverview = null)
    {
        if (is_null($detailOverview) || (is_array($detailOverview) && empty($detailOverview))) {
            unset($this->DetailOverview);
        } else {
            $this->DetailOverview = $detailOverview;
        }
        return $this;
    }
    /**
     * Get EffectiveLargeImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveLargeImageUrl()
    {
        return isset($this->EffectiveLargeImageUrl) ? $this->EffectiveLargeImageUrl : null;
    }
    /**
     * Set EffectiveLargeImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveLargeImageUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setEffectiveLargeImageUrl($effectiveLargeImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveLargeImageUrl) && !is_string($effectiveLargeImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveLargeImageUrl, true), gettype($effectiveLargeImageUrl)), __LINE__);
        }
        if (is_null($effectiveLargeImageUrl) || (is_array($effectiveLargeImageUrl) && empty($effectiveLargeImageUrl))) {
            unset($this->EffectiveLargeImageUrl);
        } else {
            $this->EffectiveLargeImageUrl = $effectiveLargeImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveMediumImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveMediumImageUrl()
    {
        return isset($this->EffectiveMediumImageUrl) ? $this->EffectiveMediumImageUrl : null;
    }
    /**
     * Set EffectiveMediumImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveMediumImageUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setEffectiveMediumImageUrl($effectiveMediumImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveMediumImageUrl) && !is_string($effectiveMediumImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveMediumImageUrl, true), gettype($effectiveMediumImageUrl)), __LINE__);
        }
        if (is_null($effectiveMediumImageUrl) || (is_array($effectiveMediumImageUrl) && empty($effectiveMediumImageUrl))) {
            unset($this->EffectiveMediumImageUrl);
        } else {
            $this->EffectiveMediumImageUrl = $effectiveMediumImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveOnlineHeroImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveOnlineHeroImageUrl()
    {
        return isset($this->EffectiveOnlineHeroImageUrl) ? $this->EffectiveOnlineHeroImageUrl : null;
    }
    /**
     * Set EffectiveOnlineHeroImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveOnlineHeroImageUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setEffectiveOnlineHeroImageUrl($effectiveOnlineHeroImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveOnlineHeroImageUrl) && !is_string($effectiveOnlineHeroImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveOnlineHeroImageUrl, true), gettype($effectiveOnlineHeroImageUrl)), __LINE__);
        }
        if (is_null($effectiveOnlineHeroImageUrl) || (is_array($effectiveOnlineHeroImageUrl) && empty($effectiveOnlineHeroImageUrl))) {
            unset($this->EffectiveOnlineHeroImageUrl);
        } else {
            $this->EffectiveOnlineHeroImageUrl = $effectiveOnlineHeroImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveOnlineThumbnailImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveOnlineThumbnailImageUrl()
    {
        return isset($this->EffectiveOnlineThumbnailImageUrl) ? $this->EffectiveOnlineThumbnailImageUrl : null;
    }
    /**
     * Set EffectiveOnlineThumbnailImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveOnlineThumbnailImageUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setEffectiveOnlineThumbnailImageUrl($effectiveOnlineThumbnailImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveOnlineThumbnailImageUrl) && !is_string($effectiveOnlineThumbnailImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveOnlineThumbnailImageUrl, true), gettype($effectiveOnlineThumbnailImageUrl)), __LINE__);
        }
        if (is_null($effectiveOnlineThumbnailImageUrl) || (is_array($effectiveOnlineThumbnailImageUrl) && empty($effectiveOnlineThumbnailImageUrl))) {
            unset($this->EffectiveOnlineThumbnailImageUrl);
        } else {
            $this->EffectiveOnlineThumbnailImageUrl = $effectiveOnlineThumbnailImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectivePassbookImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectivePassbookImageUrl()
    {
        return isset($this->EffectivePassbookImageUrl) ? $this->EffectivePassbookImageUrl : null;
    }
    /**
     * Set EffectivePassbookImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectivePassbookImageUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setEffectivePassbookImageUrl($effectivePassbookImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectivePassbookImageUrl) && !is_string($effectivePassbookImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectivePassbookImageUrl, true), gettype($effectivePassbookImageUrl)), __LINE__);
        }
        if (is_null($effectivePassbookImageUrl) || (is_array($effectivePassbookImageUrl) && empty($effectivePassbookImageUrl))) {
            unset($this->EffectivePassbookImageUrl);
        } else {
            $this->EffectivePassbookImageUrl = $effectivePassbookImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveSmallImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveSmallImageUrl()
    {
        return isset($this->EffectiveSmallImageUrl) ? $this->EffectiveSmallImageUrl : null;
    }
    /**
     * Set EffectiveSmallImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveSmallImageUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setEffectiveSmallImageUrl($effectiveSmallImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveSmallImageUrl) && !is_string($effectiveSmallImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveSmallImageUrl, true), gettype($effectiveSmallImageUrl)), __LINE__);
        }
        if (is_null($effectiveSmallImageUrl) || (is_array($effectiveSmallImageUrl) && empty($effectiveSmallImageUrl))) {
            unset($this->EffectiveSmallImageUrl);
        } else {
            $this->EffectiveSmallImageUrl = $effectiveSmallImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveSocialNetworkImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveSocialNetworkImageUrl()
    {
        return isset($this->EffectiveSocialNetworkImageUrl) ? $this->EffectiveSocialNetworkImageUrl : null;
    }
    /**
     * Set EffectiveSocialNetworkImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveSocialNetworkImageUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setEffectiveSocialNetworkImageUrl($effectiveSocialNetworkImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveSocialNetworkImageUrl) && !is_string($effectiveSocialNetworkImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveSocialNetworkImageUrl, true), gettype($effectiveSocialNetworkImageUrl)), __LINE__);
        }
        if (is_null($effectiveSocialNetworkImageUrl) || (is_array($effectiveSocialNetworkImageUrl) && empty($effectiveSocialNetworkImageUrl))) {
            unset($this->EffectiveSocialNetworkImageUrl);
        } else {
            $this->EffectiveSocialNetworkImageUrl = $effectiveSocialNetworkImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveThumbnailImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveThumbnailImageUrl()
    {
        return isset($this->EffectiveThumbnailImageUrl) ? $this->EffectiveThumbnailImageUrl : null;
    }
    /**
     * Set EffectiveThumbnailImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveThumbnailImageUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setEffectiveThumbnailImageUrl($effectiveThumbnailImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveThumbnailImageUrl) && !is_string($effectiveThumbnailImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveThumbnailImageUrl, true), gettype($effectiveThumbnailImageUrl)), __LINE__);
        }
        if (is_null($effectiveThumbnailImageUrl) || (is_array($effectiveThumbnailImageUrl) && empty($effectiveThumbnailImageUrl))) {
            unset($this->EffectiveThumbnailImageUrl);
        } else {
            $this->EffectiveThumbnailImageUrl = $effectiveThumbnailImageUrl;
        }
        return $this;
    }
    /**
     * Get ImageMedia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfImageMedia|null
     */
    public function getImageMedia()
    {
        return isset($this->ImageMedia) ? $this->ImageMedia : null;
    }
    /**
     * Set ImageMedia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfImageMedia $imageMedia
     * @return \patest\StructType\ProductMedia
     */
    public function setImageMedia(\patest\ArrayType\ArrayOfImageMedia $imageMedia = null)
    {
        if (is_null($imageMedia) || (is_array($imageMedia) && empty($imageMedia))) {
            unset($this->ImageMedia);
        } else {
            $this->ImageMedia = $imageMedia;
        }
        return $this;
    }
    /**
     * Get Incentive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getIncentive()
    {
        return isset($this->Incentive) ? $this->Incentive : null;
    }
    /**
     * Set Incentive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $incentive
     * @return \patest\StructType\ProductMedia
     */
    public function setIncentive(\patest\StructType\GlobalString $incentive = null)
    {
        if (is_null($incentive) || (is_array($incentive) && empty($incentive))) {
            unset($this->Incentive);
        } else {
            $this->Incentive = $incentive;
        }
        return $this;
    }
    /**
     * Get LargeImageId value
     * @return int|null
     */
    public function getLargeImageId()
    {
        return $this->LargeImageId;
    }
    /**
     * Set LargeImageId value
     * @param int $largeImageId
     * @return \patest\StructType\ProductMedia
     */
    public function setLargeImageId($largeImageId = null)
    {
        // validation for constraint: int
        if (!is_null($largeImageId) && !(is_int($largeImageId) || ctype_digit($largeImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($largeImageId, true), gettype($largeImageId)), __LINE__);
        }
        $this->LargeImageId = $largeImageId;
        return $this;
    }
    /**
     * Get MediumImageId value
     * @return int|null
     */
    public function getMediumImageId()
    {
        return $this->MediumImageId;
    }
    /**
     * Set MediumImageId value
     * @param int $mediumImageId
     * @return \patest\StructType\ProductMedia
     */
    public function setMediumImageId($mediumImageId = null)
    {
        // validation for constraint: int
        if (!is_null($mediumImageId) && !(is_int($mediumImageId) || ctype_digit($mediumImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($mediumImageId, true), gettype($mediumImageId)), __LINE__);
        }
        $this->MediumImageId = $mediumImageId;
        return $this;
    }
    /**
     * Get OnlineHeroImageId value
     * @return int|null
     */
    public function getOnlineHeroImageId()
    {
        return $this->OnlineHeroImageId;
    }
    /**
     * Set OnlineHeroImageId value
     * @param int $onlineHeroImageId
     * @return \patest\StructType\ProductMedia
     */
    public function setOnlineHeroImageId($onlineHeroImageId = null)
    {
        // validation for constraint: int
        if (!is_null($onlineHeroImageId) && !(is_int($onlineHeroImageId) || ctype_digit($onlineHeroImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineHeroImageId, true), gettype($onlineHeroImageId)), __LINE__);
        }
        $this->OnlineHeroImageId = $onlineHeroImageId;
        return $this;
    }
    /**
     * Get OnlineThumbnailImageId value
     * @return int|null
     */
    public function getOnlineThumbnailImageId()
    {
        return $this->OnlineThumbnailImageId;
    }
    /**
     * Set OnlineThumbnailImageId value
     * @param int $onlineThumbnailImageId
     * @return \patest\StructType\ProductMedia
     */
    public function setOnlineThumbnailImageId($onlineThumbnailImageId = null)
    {
        // validation for constraint: int
        if (!is_null($onlineThumbnailImageId) && !(is_int($onlineThumbnailImageId) || ctype_digit($onlineThumbnailImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($onlineThumbnailImageId, true), gettype($onlineThumbnailImageId)), __LINE__);
        }
        $this->OnlineThumbnailImageId = $onlineThumbnailImageId;
        return $this;
    }
    /**
     * Get PassbookImageId value
     * @return int|null
     */
    public function getPassbookImageId()
    {
        return $this->PassbookImageId;
    }
    /**
     * Set PassbookImageId value
     * @param int $passbookImageId
     * @return \patest\StructType\ProductMedia
     */
    public function setPassbookImageId($passbookImageId = null)
    {
        // validation for constraint: int
        if (!is_null($passbookImageId) && !(is_int($passbookImageId) || ctype_digit($passbookImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($passbookImageId, true), gettype($passbookImageId)), __LINE__);
        }
        $this->PassbookImageId = $passbookImageId;
        return $this;
    }
    /**
     * Get ReviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getReviewUrl()
    {
        return isset($this->ReviewUrl) ? $this->ReviewUrl : null;
    }
    /**
     * Set ReviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $reviewUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setReviewUrl(\patest\StructType\GlobalString $reviewUrl = null)
    {
        if (is_null($reviewUrl) || (is_array($reviewUrl) && empty($reviewUrl))) {
            unset($this->ReviewUrl);
        } else {
            $this->ReviewUrl = $reviewUrl;
        }
        return $this;
    }
    /**
     * Get SmallImageId value
     * @return int|null
     */
    public function getSmallImageId()
    {
        return $this->SmallImageId;
    }
    /**
     * Set SmallImageId value
     * @param int $smallImageId
     * @return \patest\StructType\ProductMedia
     */
    public function setSmallImageId($smallImageId = null)
    {
        // validation for constraint: int
        if (!is_null($smallImageId) && !(is_int($smallImageId) || ctype_digit($smallImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($smallImageId, true), gettype($smallImageId)), __LINE__);
        }
        $this->SmallImageId = $smallImageId;
        return $this;
    }
    /**
     * Get SocialNetworkImageId value
     * @return int|null
     */
    public function getSocialNetworkImageId()
    {
        return $this->SocialNetworkImageId;
    }
    /**
     * Set SocialNetworkImageId value
     * @param int $socialNetworkImageId
     * @return \patest\StructType\ProductMedia
     */
    public function setSocialNetworkImageId($socialNetworkImageId = null)
    {
        // validation for constraint: int
        if (!is_null($socialNetworkImageId) && !(is_int($socialNetworkImageId) || ctype_digit($socialNetworkImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($socialNetworkImageId, true), gettype($socialNetworkImageId)), __LINE__);
        }
        $this->SocialNetworkImageId = $socialNetworkImageId;
        return $this;
    }
    /**
     * Get ThumbnailImageId value
     * @return int|null
     */
    public function getThumbnailImageId()
    {
        return $this->ThumbnailImageId;
    }
    /**
     * Set ThumbnailImageId value
     * @param int $thumbnailImageId
     * @return \patest\StructType\ProductMedia
     */
    public function setThumbnailImageId($thumbnailImageId = null)
    {
        // validation for constraint: int
        if (!is_null($thumbnailImageId) && !(is_int($thumbnailImageId) || ctype_digit($thumbnailImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($thumbnailImageId, true), gettype($thumbnailImageId)), __LINE__);
        }
        $this->ThumbnailImageId = $thumbnailImageId;
        return $this;
    }
    /**
     * Get TrailerUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTrailerUrl()
    {
        return isset($this->TrailerUrl) ? $this->TrailerUrl : null;
    }
    /**
     * Set TrailerUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $trailerUrl
     * @return \patest\StructType\ProductMedia
     */
    public function setTrailerUrl(\patest\StructType\GlobalString $trailerUrl = null)
    {
        if (is_null($trailerUrl) || (is_array($trailerUrl) && empty($trailerUrl))) {
            unset($this->TrailerUrl);
        } else {
            $this->TrailerUrl = $trailerUrl;
        }
        return $this;
    }
}
