<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.SpoolItem StructType
 * @subpackage Structs
 */
class Printing_SpoolItem extends PersistableEntity
{
    /**
     * The DocumentDesignerName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentDesignerName;
    /**
     * The GroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GroupId;
    /**
     * The ItemData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemData;
    /**
     * The ItemDataStored
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDataStored;
    /**
     * The ItemDataStoredAsXml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDataStoredAsXml;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemName;
    /**
     * Constructor method for Printing.SpoolItem
     * @uses Printing_SpoolItem::setDocumentDesignerName()
     * @uses Printing_SpoolItem::setGroupId()
     * @uses Printing_SpoolItem::setItemData()
     * @uses Printing_SpoolItem::setItemDataStored()
     * @uses Printing_SpoolItem::setItemDataStoredAsXml()
     * @uses Printing_SpoolItem::setItemDescription()
     * @uses Printing_SpoolItem::setItemName()
     * @param string $documentDesignerName
     * @param string $groupId
     * @param string $itemData
     * @param string $itemDataStored
     * @param string $itemDataStoredAsXml
     * @param string $itemDescription
     * @param string $itemName
     */
    public function __construct($documentDesignerName = null, $groupId = null, $itemData = null, $itemDataStored = null, $itemDataStoredAsXml = null, $itemDescription = null, $itemName = null)
    {
        $this
            ->setDocumentDesignerName($documentDesignerName)
            ->setGroupId($groupId)
            ->setItemData($itemData)
            ->setItemDataStored($itemDataStored)
            ->setItemDataStoredAsXml($itemDataStoredAsXml)
            ->setItemDescription($itemDescription)
            ->setItemName($itemName);
    }
    /**
     * Get DocumentDesignerName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentDesignerName()
    {
        return isset($this->DocumentDesignerName) ? $this->DocumentDesignerName : null;
    }
    /**
     * Set DocumentDesignerName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentDesignerName
     * @return \patest\StructType\Printing_SpoolItem
     */
    public function setDocumentDesignerName($documentDesignerName = null)
    {
        // validation for constraint: string
        if (!is_null($documentDesignerName) && !is_string($documentDesignerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentDesignerName, true), gettype($documentDesignerName)), __LINE__);
        }
        if (is_null($documentDesignerName) || (is_array($documentDesignerName) && empty($documentDesignerName))) {
            unset($this->DocumentDesignerName);
        } else {
            $this->DocumentDesignerName = $documentDesignerName;
        }
        return $this;
    }
    /**
     * Get GroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupId()
    {
        return isset($this->GroupId) ? $this->GroupId : null;
    }
    /**
     * Set GroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupId
     * @return \patest\StructType\Printing_SpoolItem
     */
    public function setGroupId($groupId = null)
    {
        // validation for constraint: string
        if (!is_null($groupId) && !is_string($groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupId, true), gettype($groupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($groupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $groupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($groupId, true)), __LINE__);
        }
        if (is_null($groupId) || (is_array($groupId) && empty($groupId))) {
            unset($this->GroupId);
        } else {
            $this->GroupId = $groupId;
        }
        return $this;
    }
    /**
     * Get ItemData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemData()
    {
        return isset($this->ItemData) ? $this->ItemData : null;
    }
    /**
     * Set ItemData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemData
     * @return \patest\StructType\Printing_SpoolItem
     */
    public function setItemData($itemData = null)
    {
        // validation for constraint: string
        if (!is_null($itemData) && !is_string($itemData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemData, true), gettype($itemData)), __LINE__);
        }
        if (is_null($itemData) || (is_array($itemData) && empty($itemData))) {
            unset($this->ItemData);
        } else {
            $this->ItemData = $itemData;
        }
        return $this;
    }
    /**
     * Get ItemDataStored value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDataStored()
    {
        return isset($this->ItemDataStored) ? $this->ItemDataStored : null;
    }
    /**
     * Set ItemDataStored value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDataStored
     * @return \patest\StructType\Printing_SpoolItem
     */
    public function setItemDataStored($itemDataStored = null)
    {
        // validation for constraint: string
        if (!is_null($itemDataStored) && !is_string($itemDataStored)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDataStored, true), gettype($itemDataStored)), __LINE__);
        }
        if (is_null($itemDataStored) || (is_array($itemDataStored) && empty($itemDataStored))) {
            unset($this->ItemDataStored);
        } else {
            $this->ItemDataStored = $itemDataStored;
        }
        return $this;
    }
    /**
     * Get ItemDataStoredAsXml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDataStoredAsXml()
    {
        return isset($this->ItemDataStoredAsXml) ? $this->ItemDataStoredAsXml : null;
    }
    /**
     * Set ItemDataStoredAsXml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDataStoredAsXml
     * @return \patest\StructType\Printing_SpoolItem
     */
    public function setItemDataStoredAsXml($itemDataStoredAsXml = null)
    {
        // validation for constraint: string
        if (!is_null($itemDataStoredAsXml) && !is_string($itemDataStoredAsXml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDataStoredAsXml, true), gettype($itemDataStoredAsXml)), __LINE__);
        }
        if (is_null($itemDataStoredAsXml) || (is_array($itemDataStoredAsXml) && empty($itemDataStoredAsXml))) {
            unset($this->ItemDataStoredAsXml);
        } else {
            $this->ItemDataStoredAsXml = $itemDataStoredAsXml;
        }
        return $this;
    }
    /**
     * Get ItemDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDescription()
    {
        return isset($this->ItemDescription) ? $this->ItemDescription : null;
    }
    /**
     * Set ItemDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDescription
     * @return \patest\StructType\Printing_SpoolItem
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        if (is_null($itemDescription) || (is_array($itemDescription) && empty($itemDescription))) {
            unset($this->ItemDescription);
        } else {
            $this->ItemDescription = $itemDescription;
        }
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemName
     * @return \patest\StructType\Printing_SpoolItem
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
}
