<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.SpoolGroupsAuditFilter StructType
 * @subpackage Structs
 */
class Printing_SpoolGroupsAuditFilter extends FilterEntity
{
    /**
     * The BatchCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BatchCode;
    /**
     * The CreationDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateFrom;
    /**
     * The CreationDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTo;
    /**
     * The ItemsToShow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemsToShow;
    /**
     * The SalePointId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SalePointId;
    /**
     * The Scenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Scenario;
    /**
     * The ShowAlsoSubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShowAlsoSubordinates;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Printing.SpoolGroupsAuditFilter
     * @uses Printing_SpoolGroupsAuditFilter::setBatchCode()
     * @uses Printing_SpoolGroupsAuditFilter::setCreationDateFrom()
     * @uses Printing_SpoolGroupsAuditFilter::setCreationDateTo()
     * @uses Printing_SpoolGroupsAuditFilter::setItemsToShow()
     * @uses Printing_SpoolGroupsAuditFilter::setSalePointId()
     * @uses Printing_SpoolGroupsAuditFilter::setScenario()
     * @uses Printing_SpoolGroupsAuditFilter::setShowAlsoSubordinates()
     * @uses Printing_SpoolGroupsAuditFilter::setTransactionGuid()
     * @uses Printing_SpoolGroupsAuditFilter::setTransactionNumber()
     * @uses Printing_SpoolGroupsAuditFilter::setUserId()
     * @param int $batchCode
     * @param string $creationDateFrom
     * @param string $creationDateTo
     * @param string $itemsToShow
     * @param string $salePointId
     * @param string $scenario
     * @param bool $showAlsoSubordinates
     * @param string $transactionGuid
     * @param int $transactionNumber
     * @param string $userId
     */
    public function __construct($batchCode = null, $creationDateFrom = null, $creationDateTo = null, $itemsToShow = null, $salePointId = null, $scenario = null, $showAlsoSubordinates = null, $transactionGuid = null, $transactionNumber = null, $userId = null)
    {
        $this
            ->setBatchCode($batchCode)
            ->setCreationDateFrom($creationDateFrom)
            ->setCreationDateTo($creationDateTo)
            ->setItemsToShow($itemsToShow)
            ->setSalePointId($salePointId)
            ->setScenario($scenario)
            ->setShowAlsoSubordinates($showAlsoSubordinates)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber)
            ->setUserId($userId);
    }
    /**
     * Get BatchCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBatchCode()
    {
        return isset($this->BatchCode) ? $this->BatchCode : null;
    }
    /**
     * Set BatchCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $batchCode
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setBatchCode($batchCode = null)
    {
        // validation for constraint: int
        if (!is_null($batchCode) && !(is_int($batchCode) || ctype_digit($batchCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($batchCode, true), gettype($batchCode)), __LINE__);
        }
        if (is_null($batchCode) || (is_array($batchCode) && empty($batchCode))) {
            unset($this->BatchCode);
        } else {
            $this->BatchCode = $batchCode;
        }
        return $this;
    }
    /**
     * Get CreationDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateFrom()
    {
        return isset($this->CreationDateFrom) ? $this->CreationDateFrom : null;
    }
    /**
     * Set CreationDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateFrom
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setCreationDateFrom($creationDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateFrom) && !is_string($creationDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateFrom, true), gettype($creationDateFrom)), __LINE__);
        }
        if (is_null($creationDateFrom) || (is_array($creationDateFrom) && empty($creationDateFrom))) {
            unset($this->CreationDateFrom);
        } else {
            $this->CreationDateFrom = $creationDateFrom;
        }
        return $this;
    }
    /**
     * Get CreationDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTo()
    {
        return isset($this->CreationDateTo) ? $this->CreationDateTo : null;
    }
    /**
     * Set CreationDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTo
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setCreationDateTo($creationDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTo) && !is_string($creationDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTo, true), gettype($creationDateTo)), __LINE__);
        }
        if (is_null($creationDateTo) || (is_array($creationDateTo) && empty($creationDateTo))) {
            unset($this->CreationDateTo);
        } else {
            $this->CreationDateTo = $creationDateTo;
        }
        return $this;
    }
    /**
     * Get ItemsToShow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemsToShow()
    {
        return isset($this->ItemsToShow) ? $this->ItemsToShow : null;
    }
    /**
     * Set ItemsToShow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemsToShow
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setItemsToShow($itemsToShow = null)
    {
        // validation for constraint: string
        if (!is_null($itemsToShow) && !is_string($itemsToShow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemsToShow, true), gettype($itemsToShow)), __LINE__);
        }
        if (is_null($itemsToShow) || (is_array($itemsToShow) && empty($itemsToShow))) {
            unset($this->ItemsToShow);
        } else {
            $this->ItemsToShow = $itemsToShow;
        }
        return $this;
    }
    /**
     * Get SalePointId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalePointId()
    {
        return isset($this->SalePointId) ? $this->SalePointId : null;
    }
    /**
     * Set SalePointId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salePointId
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setSalePointId($salePointId = null)
    {
        // validation for constraint: string
        if (!is_null($salePointId) && !is_string($salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salePointId, true), gettype($salePointId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($salePointId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $salePointId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($salePointId, true)), __LINE__);
        }
        if (is_null($salePointId) || (is_array($salePointId) && empty($salePointId))) {
            unset($this->SalePointId);
        } else {
            $this->SalePointId = $salePointId;
        }
        return $this;
    }
    /**
     * Get Scenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScenario()
    {
        return isset($this->Scenario) ? $this->Scenario : null;
    }
    /**
     * Set Scenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scenario
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setScenario($scenario = null)
    {
        // validation for constraint: string
        if (!is_null($scenario) && !is_string($scenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scenario, true), gettype($scenario)), __LINE__);
        }
        if (is_null($scenario) || (is_array($scenario) && empty($scenario))) {
            unset($this->Scenario);
        } else {
            $this->Scenario = $scenario;
        }
        return $this;
    }
    /**
     * Get ShowAlsoSubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShowAlsoSubordinates()
    {
        return isset($this->ShowAlsoSubordinates) ? $this->ShowAlsoSubordinates : null;
    }
    /**
     * Set ShowAlsoSubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $showAlsoSubordinates
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setShowAlsoSubordinates($showAlsoSubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($showAlsoSubordinates) && !is_bool($showAlsoSubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($showAlsoSubordinates, true), gettype($showAlsoSubordinates)), __LINE__);
        }
        if (is_null($showAlsoSubordinates) || (is_array($showAlsoSubordinates) && empty($showAlsoSubordinates))) {
            unset($this->ShowAlsoSubordinates);
        } else {
            $this->ShowAlsoSubordinates = $showAlsoSubordinates;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Printing_SpoolGroupsAuditFilter
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
