<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrinterServer StructType
 * @subpackage Structs
 */
class Printing_PrinterServer extends PersistableEntity
{
    /**
     * The AccessibleNotManagedPrinters
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AccessiblePrinter
     */
    public $AccessibleNotManagedPrinters;
    /**
     * The AccessiblePrinters
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AccessiblePrinter
     */
    public $AccessiblePrinters;
    /**
     * The AppServerNode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AppServerNode;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsInternal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInternal;
    /**
     * The LastStatusChangeTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastStatusChangeTime;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The PrinterIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PrinterIds
     */
    public $PrinterIds;
    /**
     * The Printers
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_Printer
     */
    public $Printers;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The StatusChangeExplanation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusChangeExplanation;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for Printing.PrinterServer
     * @uses Printing_PrinterServer::setAccessibleNotManagedPrinters()
     * @uses Printing_PrinterServer::setAccessiblePrinters()
     * @uses Printing_PrinterServer::setAppServerNode()
     * @uses Printing_PrinterServer::setDescription()
     * @uses Printing_PrinterServer::setIsActive()
     * @uses Printing_PrinterServer::setIsInternal()
     * @uses Printing_PrinterServer::setLastStatusChangeTime()
     * @uses Printing_PrinterServer::setName()
     * @uses Printing_PrinterServer::setOrganizationUnitId()
     * @uses Printing_PrinterServer::setPrinterIds()
     * @uses Printing_PrinterServer::setPrinters()
     * @uses Printing_PrinterServer::setStatus()
     * @uses Printing_PrinterServer::setStatusChangeExplanation()
     * @uses Printing_PrinterServer::setVisibleBySubordinates()
     * @uses Printing_PrinterServer::setXmlContainer()
     * @param \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessibleNotManagedPrinters
     * @param \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessiblePrinters
     * @param string $appServerNode
     * @param \patest\StructType\GlobalString $description
     * @param bool $isActive
     * @param bool $isInternal
     * @param string $lastStatusChangeTime
     * @param \patest\StructType\GlobalString $name
     * @param string $organizationUnitId
     * @param \patest\StructType\PrinterIds $printerIds
     * @param \patest\StructType\RecordSetOfPrinting_Printer $printers
     * @param string $status
     * @param string $statusChangeExplanation
     * @param bool $visibleBySubordinates
     * @param string $xmlContainer
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessibleNotManagedPrinters = null, \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessiblePrinters = null, $appServerNode = null, \patest\StructType\GlobalString $description = null, $isActive = null, $isInternal = null, $lastStatusChangeTime = null, \patest\StructType\GlobalString $name = null, $organizationUnitId = null, \patest\StructType\PrinterIds $printerIds = null, \patest\StructType\RecordSetOfPrinting_Printer $printers = null, $status = null, $statusChangeExplanation = null, $visibleBySubordinates = null, $xmlContainer = null)
    {
        $this
            ->setAccessibleNotManagedPrinters($accessibleNotManagedPrinters)
            ->setAccessiblePrinters($accessiblePrinters)
            ->setAppServerNode($appServerNode)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setIsInternal($isInternal)
            ->setLastStatusChangeTime($lastStatusChangeTime)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId)
            ->setPrinterIds($printerIds)
            ->setPrinters($printers)
            ->setStatus($status)
            ->setStatusChangeExplanation($statusChangeExplanation)
            ->setVisibleBySubordinates($visibleBySubordinates)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccessibleNotManagedPrinters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AccessiblePrinter|null
     */
    public function getAccessibleNotManagedPrinters()
    {
        return isset($this->AccessibleNotManagedPrinters) ? $this->AccessibleNotManagedPrinters : null;
    }
    /**
     * Set AccessibleNotManagedPrinters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessibleNotManagedPrinters
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setAccessibleNotManagedPrinters(\patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessibleNotManagedPrinters = null)
    {
        if (is_null($accessibleNotManagedPrinters) || (is_array($accessibleNotManagedPrinters) && empty($accessibleNotManagedPrinters))) {
            unset($this->AccessibleNotManagedPrinters);
        } else {
            $this->AccessibleNotManagedPrinters = $accessibleNotManagedPrinters;
        }
        return $this;
    }
    /**
     * Get AccessiblePrinters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AccessiblePrinter|null
     */
    public function getAccessiblePrinters()
    {
        return isset($this->AccessiblePrinters) ? $this->AccessiblePrinters : null;
    }
    /**
     * Set AccessiblePrinters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessiblePrinters
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setAccessiblePrinters(\patest\StructType\RecordSetOfPrinting_AccessiblePrinter $accessiblePrinters = null)
    {
        if (is_null($accessiblePrinters) || (is_array($accessiblePrinters) && empty($accessiblePrinters))) {
            unset($this->AccessiblePrinters);
        } else {
            $this->AccessiblePrinters = $accessiblePrinters;
        }
        return $this;
    }
    /**
     * Get AppServerNode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppServerNode()
    {
        return isset($this->AppServerNode) ? $this->AppServerNode : null;
    }
    /**
     * Set AppServerNode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appServerNode
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setAppServerNode($appServerNode = null)
    {
        // validation for constraint: string
        if (!is_null($appServerNode) && !is_string($appServerNode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appServerNode, true), gettype($appServerNode)), __LINE__);
        }
        if (is_null($appServerNode) || (is_array($appServerNode) && empty($appServerNode))) {
            unset($this->AppServerNode);
        } else {
            $this->AppServerNode = $appServerNode;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsInternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInternal()
    {
        return isset($this->IsInternal) ? $this->IsInternal : null;
    }
    /**
     * Set IsInternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInternal
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setIsInternal($isInternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternal) && !is_bool($isInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternal, true), gettype($isInternal)), __LINE__);
        }
        if (is_null($isInternal) || (is_array($isInternal) && empty($isInternal))) {
            unset($this->IsInternal);
        } else {
            $this->IsInternal = $isInternal;
        }
        return $this;
    }
    /**
     * Get LastStatusChangeTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastStatusChangeTime()
    {
        return isset($this->LastStatusChangeTime) ? $this->LastStatusChangeTime : null;
    }
    /**
     * Set LastStatusChangeTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastStatusChangeTime
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setLastStatusChangeTime($lastStatusChangeTime = null)
    {
        // validation for constraint: string
        if (!is_null($lastStatusChangeTime) && !is_string($lastStatusChangeTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastStatusChangeTime, true), gettype($lastStatusChangeTime)), __LINE__);
        }
        if (is_null($lastStatusChangeTime) || (is_array($lastStatusChangeTime) && empty($lastStatusChangeTime))) {
            unset($this->LastStatusChangeTime);
        } else {
            $this->LastStatusChangeTime = $lastStatusChangeTime;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get PrinterIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PrinterIds|null
     */
    public function getPrinterIds()
    {
        return isset($this->PrinterIds) ? $this->PrinterIds : null;
    }
    /**
     * Set PrinterIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PrinterIds $printerIds
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setPrinterIds(\patest\StructType\PrinterIds $printerIds = null)
    {
        if (is_null($printerIds) || (is_array($printerIds) && empty($printerIds))) {
            unset($this->PrinterIds);
        } else {
            $this->PrinterIds = $printerIds;
        }
        return $this;
    }
    /**
     * Get Printers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_Printer|null
     */
    public function getPrinters()
    {
        return isset($this->Printers) ? $this->Printers : null;
    }
    /**
     * Set Printers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_Printer $printers
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setPrinters(\patest\StructType\RecordSetOfPrinting_Printer $printers = null)
    {
        if (is_null($printers) || (is_array($printers) && empty($printers))) {
            unset($this->Printers);
        } else {
            $this->Printers = $printers;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\WorkingStatus::valueIsValid()
     * @uses \patest\EnumType\WorkingStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\WorkingStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\WorkingStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\WorkingStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get StatusChangeExplanation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusChangeExplanation()
    {
        return isset($this->StatusChangeExplanation) ? $this->StatusChangeExplanation : null;
    }
    /**
     * Set StatusChangeExplanation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusChangeExplanation
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setStatusChangeExplanation($statusChangeExplanation = null)
    {
        // validation for constraint: string
        if (!is_null($statusChangeExplanation) && !is_string($statusChangeExplanation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusChangeExplanation, true), gettype($statusChangeExplanation)), __LINE__);
        }
        if (is_null($statusChangeExplanation) || (is_array($statusChangeExplanation) && empty($statusChangeExplanation))) {
            unset($this->StatusChangeExplanation);
        } else {
            $this->StatusChangeExplanation = $statusChangeExplanation;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\Printing_PrinterServer
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
