<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.Ticket StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_Ticket extends Printing_PrintableItem_BasketItemBase
{
    /**
     * The AccessControlParentDefinitionDataReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlParentDefinitionDataReferenceId;
    /**
     * The AccessControlProductExtensionReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlProductExtensionReferenceId;
    /**
     * The Area
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Area
     */
    public $Area;
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeRefEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeRefEntityName;
    /**
     * The DeliveredAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeliveredAs;
    /**
     * The Event
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Event
     */
    public $Event;
    /**
     * The Gates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Printing_Gate
     */
    public $Gates;
    /**
     * The GatesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatesSummary;
    /**
     * The Hall
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Hall
     */
    public $Hall;
    /**
     * The HasTicketHolder
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasTicketHolder;
    /**
     * The Insurance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance
     */
    public $Insurance;
    /**
     * The IsLastVersion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsLastVersion;
    /**
     * The IsMoved
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMoved;
    /**
     * The IsOnlineForwarded
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOnlineForwarded;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResale;
    /**
     * The IsSubscriberTicket
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubscriberTicket;
    /**
     * The IsValid
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsValid;
    /**
     * The LoadedOnCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LoadedOnCardNumber;
    /**
     * The LocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalId;
    /**
     * The OriginalTicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OriginalTicketId;
    /**
     * The PassbookUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PassbookUrl;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PriceLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_PriceLevel
     */
    public $PriceLevel;
    /**
     * The PriceLevelDisplayStyle
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelDisplayStyle;
    /**
     * The PriceLevelName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PriceLevelName;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The PrintedAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedAs;
    /**
     * The PrintMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethod;
    /**
     * The PrintMethodData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintMethodData;
    /**
     * The Seat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Seat
     */
    public $Seat;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatingPlanId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeatingPlanId;
    /**
     * The Show
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Show
     */
    public $Show;
    /**
     * The ShowTimeNfcPassURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowTimeNfcPassURL;
    /**
     * The ShowType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_ShowType
     */
    public $ShowType;
    /**
     * The Stand
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Stand
     */
    public $Stand;
    /**
     * The SubscriberTicketType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriberTicketType;
    /**
     * The SubscriptionInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_SubscriptionInfo
     */
    public $SubscriptionInfo;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The SubsidizedByAccountName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubsidizedByAccountName;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The Turnstiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_Printing_Turnstile
     */
    public $Turnstiles;
    /**
     * The TurnstilesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstilesSummary;
    /**
     * The Venue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_Printing_Venue
     */
    public $Venue;
    /**
     * Constructor method for Printing.PrintableItem.Ticket
     * @uses Printing_PrintableItem_Ticket::setAccessControlParentDefinitionDataReferenceId()
     * @uses Printing_PrintableItem_Ticket::setAccessControlProductExtensionReferenceId()
     * @uses Printing_PrintableItem_Ticket::setArea()
     * @uses Printing_PrintableItem_Ticket::setAreaId()
     * @uses Printing_PrintableItem_Ticket::setBarcode()
     * @uses Printing_PrintableItem_Ticket::setBarcodeRefEntityName()
     * @uses Printing_PrintableItem_Ticket::setDeliveredAs()
     * @uses Printing_PrintableItem_Ticket::setEvent()
     * @uses Printing_PrintableItem_Ticket::setGates()
     * @uses Printing_PrintableItem_Ticket::setGatesSummary()
     * @uses Printing_PrintableItem_Ticket::setHall()
     * @uses Printing_PrintableItem_Ticket::setHasTicketHolder()
     * @uses Printing_PrintableItem_Ticket::setInsurance()
     * @uses Printing_PrintableItem_Ticket::setIsLastVersion()
     * @uses Printing_PrintableItem_Ticket::setIsMoved()
     * @uses Printing_PrintableItem_Ticket::setIsOnlineForwarded()
     * @uses Printing_PrintableItem_Ticket::setIsResale()
     * @uses Printing_PrintableItem_Ticket::setIsSubscriberTicket()
     * @uses Printing_PrintableItem_Ticket::setIsValid()
     * @uses Printing_PrintableItem_Ticket::setLoadedOnCardNumber()
     * @uses Printing_PrintableItem_Ticket::setLocalId()
     * @uses Printing_PrintableItem_Ticket::setOriginalTicketId()
     * @uses Printing_PrintableItem_Ticket::setPassbookUrl()
     * @uses Printing_PrintableItem_Ticket::setPaymentMethodName()
     * @uses Printing_PrintableItem_Ticket::setPriceLevel()
     * @uses Printing_PrintableItem_Ticket::setPriceLevelDisplayStyle()
     * @uses Printing_PrintableItem_Ticket::setPriceLevelName()
     * @uses Printing_PrintableItem_Ticket::setPrintCount()
     * @uses Printing_PrintableItem_Ticket::setPrintedAs()
     * @uses Printing_PrintableItem_Ticket::setPrintMethod()
     * @uses Printing_PrintableItem_Ticket::setPrintMethodData()
     * @uses Printing_PrintableItem_Ticket::setSeat()
     * @uses Printing_PrintableItem_Ticket::setSeatIdInAreaMap()
     * @uses Printing_PrintableItem_Ticket::setSeatingPlanId()
     * @uses Printing_PrintableItem_Ticket::setShow()
     * @uses Printing_PrintableItem_Ticket::setShowTimeNfcPassURL()
     * @uses Printing_PrintableItem_Ticket::setShowType()
     * @uses Printing_PrintableItem_Ticket::setStand()
     * @uses Printing_PrintableItem_Ticket::setSubscriberTicketType()
     * @uses Printing_PrintableItem_Ticket::setSubscriptionInfo()
     * @uses Printing_PrintableItem_Ticket::setSubscriptionInstanceId()
     * @uses Printing_PrintableItem_Ticket::setSubscriptionNumber()
     * @uses Printing_PrintableItem_Ticket::setSubsidizedByAccountName()
     * @uses Printing_PrintableItem_Ticket::setTicketNumber()
     * @uses Printing_PrintableItem_Ticket::setTurnstiles()
     * @uses Printing_PrintableItem_Ticket::setTurnstilesSummary()
     * @uses Printing_PrintableItem_Ticket::setVenue()
     * @param string $accessControlParentDefinitionDataReferenceId
     * @param string $accessControlProductExtensionReferenceId
     * @param \patest\StructType\Ticketing_Printing_Area $area
     * @param string $areaId
     * @param string $barcode
     * @param string $barcodeRefEntityName
     * @param string $deliveredAs
     * @param \patest\StructType\Ticketing_Printing_Event $event
     * @param \patest\StructType\RecordSetOfTicketing_Printing_Gate $gates
     * @param string $gatesSummary
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @param bool $hasTicketHolder
     * @param \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance $insurance
     * @param bool $isLastVersion
     * @param bool $isMoved
     * @param bool $isOnlineForwarded
     * @param bool $isResale
     * @param bool $isSubscriberTicket
     * @param bool $isValid
     * @param string $loadedOnCardNumber
     * @param int $localId
     * @param string $originalTicketId
     * @param string $passbookUrl
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel
     * @param string $priceLevelDisplayStyle
     * @param \patest\StructType\GlobalString $priceLevelName
     * @param int $printCount
     * @param string $printedAs
     * @param string $printMethod
     * @param string $printMethodData
     * @param \patest\StructType\Ticketing_Printing_Seat $seat
     * @param int $seatIdInAreaMap
     * @param string $seatingPlanId
     * @param \patest\StructType\Ticketing_Printing_Show $show
     * @param string $showTimeNfcPassURL
     * @param \patest\StructType\Ticketing_Printing_ShowType $showType
     * @param \patest\StructType\Ticketing_Printing_Stand $stand
     * @param string $subscriberTicketType
     * @param \patest\StructType\Printing_PrintableItem_SubscriptionInfo $subscriptionInfo
     * @param string $subscriptionInstanceId
     * @param string $subscriptionNumber
     * @param string $subsidizedByAccountName
     * @param int $ticketNumber
     * @param \patest\StructType\RecordSetOfTicketing_Printing_Turnstile $turnstiles
     * @param string $turnstilesSummary
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     */
    public function __construct($accessControlParentDefinitionDataReferenceId = null, $accessControlProductExtensionReferenceId = null, \patest\StructType\Ticketing_Printing_Area $area = null, $areaId = null, $barcode = null, $barcodeRefEntityName = null, $deliveredAs = null, \patest\StructType\Ticketing_Printing_Event $event = null, \patest\StructType\RecordSetOfTicketing_Printing_Gate $gates = null, $gatesSummary = null, \patest\StructType\Ticketing_Printing_Hall $hall = null, $hasTicketHolder = null, \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance $insurance = null, $isLastVersion = null, $isMoved = null, $isOnlineForwarded = null, $isResale = null, $isSubscriberTicket = null, $isValid = null, $loadedOnCardNumber = null, $localId = null, $originalTicketId = null, $passbookUrl = null, \patest\StructType\GlobalString $paymentMethodName = null, \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel = null, $priceLevelDisplayStyle = null, \patest\StructType\GlobalString $priceLevelName = null, $printCount = null, $printedAs = null, $printMethod = null, $printMethodData = null, \patest\StructType\Ticketing_Printing_Seat $seat = null, $seatIdInAreaMap = null, $seatingPlanId = null, \patest\StructType\Ticketing_Printing_Show $show = null, $showTimeNfcPassURL = null, \patest\StructType\Ticketing_Printing_ShowType $showType = null, \patest\StructType\Ticketing_Printing_Stand $stand = null, $subscriberTicketType = null, \patest\StructType\Printing_PrintableItem_SubscriptionInfo $subscriptionInfo = null, $subscriptionInstanceId = null, $subscriptionNumber = null, $subsidizedByAccountName = null, $ticketNumber = null, \patest\StructType\RecordSetOfTicketing_Printing_Turnstile $turnstiles = null, $turnstilesSummary = null, \patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        $this
            ->setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId)
            ->setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId)
            ->setArea($area)
            ->setAreaId($areaId)
            ->setBarcode($barcode)
            ->setBarcodeRefEntityName($barcodeRefEntityName)
            ->setDeliveredAs($deliveredAs)
            ->setEvent($event)
            ->setGates($gates)
            ->setGatesSummary($gatesSummary)
            ->setHall($hall)
            ->setHasTicketHolder($hasTicketHolder)
            ->setInsurance($insurance)
            ->setIsLastVersion($isLastVersion)
            ->setIsMoved($isMoved)
            ->setIsOnlineForwarded($isOnlineForwarded)
            ->setIsResale($isResale)
            ->setIsSubscriberTicket($isSubscriberTicket)
            ->setIsValid($isValid)
            ->setLoadedOnCardNumber($loadedOnCardNumber)
            ->setLocalId($localId)
            ->setOriginalTicketId($originalTicketId)
            ->setPassbookUrl($passbookUrl)
            ->setPaymentMethodName($paymentMethodName)
            ->setPriceLevel($priceLevel)
            ->setPriceLevelDisplayStyle($priceLevelDisplayStyle)
            ->setPriceLevelName($priceLevelName)
            ->setPrintCount($printCount)
            ->setPrintedAs($printedAs)
            ->setPrintMethod($printMethod)
            ->setPrintMethodData($printMethodData)
            ->setSeat($seat)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatingPlanId($seatingPlanId)
            ->setShow($show)
            ->setShowTimeNfcPassURL($showTimeNfcPassURL)
            ->setShowType($showType)
            ->setStand($stand)
            ->setSubscriberTicketType($subscriberTicketType)
            ->setSubscriptionInfo($subscriptionInfo)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setSubsidizedByAccountName($subsidizedByAccountName)
            ->setTicketNumber($ticketNumber)
            ->setTurnstiles($turnstiles)
            ->setTurnstilesSummary($turnstilesSummary)
            ->setVenue($venue);
    }
    /**
     * Get AccessControlParentDefinitionDataReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlParentDefinitionDataReferenceId()
    {
        return isset($this->AccessControlParentDefinitionDataReferenceId) ? $this->AccessControlParentDefinitionDataReferenceId : null;
    }
    /**
     * Set AccessControlParentDefinitionDataReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlParentDefinitionDataReferenceId
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !is_string($accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlParentDefinitionDataReferenceId, true), gettype($accessControlParentDefinitionDataReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlParentDefinitionDataReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlParentDefinitionDataReferenceId) || (is_array($accessControlParentDefinitionDataReferenceId) && empty($accessControlParentDefinitionDataReferenceId))) {
            unset($this->AccessControlParentDefinitionDataReferenceId);
        } else {
            $this->AccessControlParentDefinitionDataReferenceId = $accessControlParentDefinitionDataReferenceId;
        }
        return $this;
    }
    /**
     * Get AccessControlProductExtensionReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProductExtensionReferenceId()
    {
        return isset($this->AccessControlProductExtensionReferenceId) ? $this->AccessControlProductExtensionReferenceId : null;
    }
    /**
     * Set AccessControlProductExtensionReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProductExtensionReferenceId
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProductExtensionReferenceId) && !is_string($accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProductExtensionReferenceId, true), gettype($accessControlProductExtensionReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlProductExtensionReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlProductExtensionReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlProductExtensionReferenceId) || (is_array($accessControlProductExtensionReferenceId) && empty($accessControlProductExtensionReferenceId))) {
            unset($this->AccessControlProductExtensionReferenceId);
        } else {
            $this->AccessControlProductExtensionReferenceId = $accessControlProductExtensionReferenceId;
        }
        return $this;
    }
    /**
     * Get Area value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Area|null
     */
    public function getArea()
    {
        return isset($this->Area) ? $this->Area : null;
    }
    /**
     * Set Area value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Area $area
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setArea(\patest\StructType\Ticketing_Printing_Area $area = null)
    {
        if (is_null($area) || (is_array($area) && empty($area))) {
            unset($this->Area);
        } else {
            $this->Area = $area;
        }
        return $this;
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeRefEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeRefEntityName()
    {
        return isset($this->BarcodeRefEntityName) ? $this->BarcodeRefEntityName : null;
    }
    /**
     * Set BarcodeRefEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeRefEntityName
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setBarcodeRefEntityName($barcodeRefEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeRefEntityName) && !is_string($barcodeRefEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeRefEntityName, true), gettype($barcodeRefEntityName)), __LINE__);
        }
        if (is_null($barcodeRefEntityName) || (is_array($barcodeRefEntityName) && empty($barcodeRefEntityName))) {
            unset($this->BarcodeRefEntityName);
        } else {
            $this->BarcodeRefEntityName = $barcodeRefEntityName;
        }
        return $this;
    }
    /**
     * Get DeliveredAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeliveredAs()
    {
        return isset($this->DeliveredAs) ? $this->DeliveredAs : null;
    }
    /**
     * Set DeliveredAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deliveredAs
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setDeliveredAs($deliveredAs = null)
    {
        // validation for constraint: string
        if (!is_null($deliveredAs) && !is_string($deliveredAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deliveredAs, true), gettype($deliveredAs)), __LINE__);
        }
        if (is_null($deliveredAs) || (is_array($deliveredAs) && empty($deliveredAs))) {
            unset($this->DeliveredAs);
        } else {
            $this->DeliveredAs = $deliveredAs;
        }
        return $this;
    }
    /**
     * Get Event value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Event|null
     */
    public function getEvent()
    {
        return isset($this->Event) ? $this->Event : null;
    }
    /**
     * Set Event value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Event $event
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setEvent(\patest\StructType\Ticketing_Printing_Event $event = null)
    {
        if (is_null($event) || (is_array($event) && empty($event))) {
            unset($this->Event);
        } else {
            $this->Event = $event;
        }
        return $this;
    }
    /**
     * Get Gates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Printing_Gate|null
     */
    public function getGates()
    {
        return isset($this->Gates) ? $this->Gates : null;
    }
    /**
     * Set Gates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Printing_Gate $gates
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setGates(\patest\StructType\RecordSetOfTicketing_Printing_Gate $gates = null)
    {
        if (is_null($gates) || (is_array($gates) && empty($gates))) {
            unset($this->Gates);
        } else {
            $this->Gates = $gates;
        }
        return $this;
    }
    /**
     * Get GatesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatesSummary()
    {
        return isset($this->GatesSummary) ? $this->GatesSummary : null;
    }
    /**
     * Set GatesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatesSummary
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setGatesSummary($gatesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($gatesSummary) && !is_string($gatesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatesSummary, true), gettype($gatesSummary)), __LINE__);
        }
        if (is_null($gatesSummary) || (is_array($gatesSummary) && empty($gatesSummary))) {
            unset($this->GatesSummary);
        } else {
            $this->GatesSummary = $gatesSummary;
        }
        return $this;
    }
    /**
     * Get Hall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Hall|null
     */
    public function getHall()
    {
        return isset($this->Hall) ? $this->Hall : null;
    }
    /**
     * Set Hall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Hall $hall
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setHall(\patest\StructType\Ticketing_Printing_Hall $hall = null)
    {
        if (is_null($hall) || (is_array($hall) && empty($hall))) {
            unset($this->Hall);
        } else {
            $this->Hall = $hall;
        }
        return $this;
    }
    /**
     * Get HasTicketHolder value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasTicketHolder()
    {
        return isset($this->HasTicketHolder) ? $this->HasTicketHolder : null;
    }
    /**
     * Set HasTicketHolder value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasTicketHolder
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setHasTicketHolder($hasTicketHolder = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasTicketHolder) && !is_bool($hasTicketHolder)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasTicketHolder, true), gettype($hasTicketHolder)), __LINE__);
        }
        if (is_null($hasTicketHolder) || (is_array($hasTicketHolder) && empty($hasTicketHolder))) {
            unset($this->HasTicketHolder);
        } else {
            $this->HasTicketHolder = $hasTicketHolder;
        }
        return $this;
    }
    /**
     * Get Insurance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance|null
     */
    public function getInsurance()
    {
        return isset($this->Insurance) ? $this->Insurance : null;
    }
    /**
     * Set Insurance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance $insurance
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setInsurance(\patest\StructType\Printing_AuxiliaryDataItem_ItemInsurance $insurance = null)
    {
        if (is_null($insurance) || (is_array($insurance) && empty($insurance))) {
            unset($this->Insurance);
        } else {
            $this->Insurance = $insurance;
        }
        return $this;
    }
    /**
     * Get IsLastVersion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsLastVersion()
    {
        return isset($this->IsLastVersion) ? $this->IsLastVersion : null;
    }
    /**
     * Set IsLastVersion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isLastVersion
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setIsLastVersion($isLastVersion = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLastVersion) && !is_bool($isLastVersion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLastVersion, true), gettype($isLastVersion)), __LINE__);
        }
        if (is_null($isLastVersion) || (is_array($isLastVersion) && empty($isLastVersion))) {
            unset($this->IsLastVersion);
        } else {
            $this->IsLastVersion = $isLastVersion;
        }
        return $this;
    }
    /**
     * Get IsMoved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMoved()
    {
        return isset($this->IsMoved) ? $this->IsMoved : null;
    }
    /**
     * Set IsMoved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMoved
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setIsMoved($isMoved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMoved) && !is_bool($isMoved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMoved, true), gettype($isMoved)), __LINE__);
        }
        if (is_null($isMoved) || (is_array($isMoved) && empty($isMoved))) {
            unset($this->IsMoved);
        } else {
            $this->IsMoved = $isMoved;
        }
        return $this;
    }
    /**
     * Get IsOnlineForwarded value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOnlineForwarded()
    {
        return isset($this->IsOnlineForwarded) ? $this->IsOnlineForwarded : null;
    }
    /**
     * Set IsOnlineForwarded value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOnlineForwarded
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setIsOnlineForwarded($isOnlineForwarded = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOnlineForwarded) && !is_bool($isOnlineForwarded)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOnlineForwarded, true), gettype($isOnlineForwarded)), __LINE__);
        }
        if (is_null($isOnlineForwarded) || (is_array($isOnlineForwarded) && empty($isOnlineForwarded))) {
            unset($this->IsOnlineForwarded);
        } else {
            $this->IsOnlineForwarded = $isOnlineForwarded;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResale()
    {
        return isset($this->IsResale) ? $this->IsResale : null;
    }
    /**
     * Set IsResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResale
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        if (is_null($isResale) || (is_array($isResale) && empty($isResale))) {
            unset($this->IsResale);
        } else {
            $this->IsResale = $isResale;
        }
        return $this;
    }
    /**
     * Get IsSubscriberTicket value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubscriberTicket()
    {
        return isset($this->IsSubscriberTicket) ? $this->IsSubscriberTicket : null;
    }
    /**
     * Set IsSubscriberTicket value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubscriberTicket
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setIsSubscriberTicket($isSubscriberTicket = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubscriberTicket) && !is_bool($isSubscriberTicket)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubscriberTicket, true), gettype($isSubscriberTicket)), __LINE__);
        }
        if (is_null($isSubscriberTicket) || (is_array($isSubscriberTicket) && empty($isSubscriberTicket))) {
            unset($this->IsSubscriberTicket);
        } else {
            $this->IsSubscriberTicket = $isSubscriberTicket;
        }
        return $this;
    }
    /**
     * Get IsValid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsValid()
    {
        return isset($this->IsValid) ? $this->IsValid : null;
    }
    /**
     * Set IsValid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isValid
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setIsValid($isValid = null)
    {
        // validation for constraint: boolean
        if (!is_null($isValid) && !is_bool($isValid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isValid, true), gettype($isValid)), __LINE__);
        }
        if (is_null($isValid) || (is_array($isValid) && empty($isValid))) {
            unset($this->IsValid);
        } else {
            $this->IsValid = $isValid;
        }
        return $this;
    }
    /**
     * Get LoadedOnCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLoadedOnCardNumber()
    {
        return isset($this->LoadedOnCardNumber) ? $this->LoadedOnCardNumber : null;
    }
    /**
     * Set LoadedOnCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $loadedOnCardNumber
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setLoadedOnCardNumber($loadedOnCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($loadedOnCardNumber) && !is_string($loadedOnCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($loadedOnCardNumber, true), gettype($loadedOnCardNumber)), __LINE__);
        }
        if (is_null($loadedOnCardNumber) || (is_array($loadedOnCardNumber) && empty($loadedOnCardNumber))) {
            unset($this->LoadedOnCardNumber);
        } else {
            $this->LoadedOnCardNumber = $loadedOnCardNumber;
        }
        return $this;
    }
    /**
     * Get LocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalId()
    {
        return isset($this->LocalId) ? $this->LocalId : null;
    }
    /**
     * Set LocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localId
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setLocalId($localId = null)
    {
        // validation for constraint: int
        if (!is_null($localId) && !(is_int($localId) || ctype_digit($localId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localId, true), gettype($localId)), __LINE__);
        }
        if (is_null($localId) || (is_array($localId) && empty($localId))) {
            unset($this->LocalId);
        } else {
            $this->LocalId = $localId;
        }
        return $this;
    }
    /**
     * Get OriginalTicketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOriginalTicketId()
    {
        return isset($this->OriginalTicketId) ? $this->OriginalTicketId : null;
    }
    /**
     * Set OriginalTicketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $originalTicketId
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setOriginalTicketId($originalTicketId = null)
    {
        // validation for constraint: string
        if (!is_null($originalTicketId) && !is_string($originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($originalTicketId, true), gettype($originalTicketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($originalTicketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $originalTicketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($originalTicketId, true)), __LINE__);
        }
        if (is_null($originalTicketId) || (is_array($originalTicketId) && empty($originalTicketId))) {
            unset($this->OriginalTicketId);
        } else {
            $this->OriginalTicketId = $originalTicketId;
        }
        return $this;
    }
    /**
     * Get PassbookUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassbookUrl()
    {
        return isset($this->PassbookUrl) ? $this->PassbookUrl : null;
    }
    /**
     * Set PassbookUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $passbookUrl
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPassbookUrl($passbookUrl = null)
    {
        // validation for constraint: string
        if (!is_null($passbookUrl) && !is_string($passbookUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($passbookUrl, true), gettype($passbookUrl)), __LINE__);
        }
        if (is_null($passbookUrl) || (is_array($passbookUrl) && empty($passbookUrl))) {
            unset($this->PassbookUrl);
        } else {
            $this->PassbookUrl = $passbookUrl;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PriceLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_PriceLevel|null
     */
    public function getPriceLevel()
    {
        return isset($this->PriceLevel) ? $this->PriceLevel : null;
    }
    /**
     * Set PriceLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_PriceLevel $priceLevel
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPriceLevel(\patest\StructType\Ticketing_Printing_PriceLevel $priceLevel = null)
    {
        if (is_null($priceLevel) || (is_array($priceLevel) && empty($priceLevel))) {
            unset($this->PriceLevel);
        } else {
            $this->PriceLevel = $priceLevel;
        }
        return $this;
    }
    /**
     * Get PriceLevelDisplayStyle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelDisplayStyle()
    {
        return isset($this->PriceLevelDisplayStyle) ? $this->PriceLevelDisplayStyle : null;
    }
    /**
     * Set PriceLevelDisplayStyle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelDisplayStyle
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPriceLevelDisplayStyle($priceLevelDisplayStyle = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelDisplayStyle) && !is_string($priceLevelDisplayStyle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelDisplayStyle, true), gettype($priceLevelDisplayStyle)), __LINE__);
        }
        if (is_null($priceLevelDisplayStyle) || (is_array($priceLevelDisplayStyle) && empty($priceLevelDisplayStyle))) {
            unset($this->PriceLevelDisplayStyle);
        } else {
            $this->PriceLevelDisplayStyle = $priceLevelDisplayStyle;
        }
        return $this;
    }
    /**
     * Get PriceLevelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPriceLevelName()
    {
        return isset($this->PriceLevelName) ? $this->PriceLevelName : null;
    }
    /**
     * Set PriceLevelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $priceLevelName
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPriceLevelName(\patest\StructType\GlobalString $priceLevelName = null)
    {
        if (is_null($priceLevelName) || (is_array($priceLevelName) && empty($priceLevelName))) {
            unset($this->PriceLevelName);
        } else {
            $this->PriceLevelName = $priceLevelName;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get PrintedAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedAs()
    {
        return isset($this->PrintedAs) ? $this->PrintedAs : null;
    }
    /**
     * Set PrintedAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedAs
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPrintedAs($printedAs = null)
    {
        // validation for constraint: string
        if (!is_null($printedAs) && !is_string($printedAs)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedAs, true), gettype($printedAs)), __LINE__);
        }
        if (is_null($printedAs) || (is_array($printedAs) && empty($printedAs))) {
            unset($this->PrintedAs);
        } else {
            $this->PrintedAs = $printedAs;
        }
        return $this;
    }
    /**
     * Get PrintMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethod()
    {
        return isset($this->PrintMethod) ? $this->PrintMethod : null;
    }
    /**
     * Set PrintMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethod
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPrintMethod($printMethod = null)
    {
        // validation for constraint: string
        if (!is_null($printMethod) && !is_string($printMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethod, true), gettype($printMethod)), __LINE__);
        }
        if (is_null($printMethod) || (is_array($printMethod) && empty($printMethod))) {
            unset($this->PrintMethod);
        } else {
            $this->PrintMethod = $printMethod;
        }
        return $this;
    }
    /**
     * Get PrintMethodData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintMethodData()
    {
        return isset($this->PrintMethodData) ? $this->PrintMethodData : null;
    }
    /**
     * Set PrintMethodData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printMethodData
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setPrintMethodData($printMethodData = null)
    {
        // validation for constraint: string
        if (!is_null($printMethodData) && !is_string($printMethodData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printMethodData, true), gettype($printMethodData)), __LINE__);
        }
        if (is_null($printMethodData) || (is_array($printMethodData) && empty($printMethodData))) {
            unset($this->PrintMethodData);
        } else {
            $this->PrintMethodData = $printMethodData;
        }
        return $this;
    }
    /**
     * Get Seat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Seat|null
     */
    public function getSeat()
    {
        return isset($this->Seat) ? $this->Seat : null;
    }
    /**
     * Set Seat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Seat $seat
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setSeat(\patest\StructType\Ticketing_Printing_Seat $seat = null)
    {
        if (is_null($seat) || (is_array($seat) && empty($seat))) {
            unset($this->Seat);
        } else {
            $this->Seat = $seat;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatingPlanId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatingPlanId()
    {
        return isset($this->SeatingPlanId) ? $this->SeatingPlanId : null;
    }
    /**
     * Set SeatingPlanId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatingPlanId
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setSeatingPlanId($seatingPlanId = null)
    {
        // validation for constraint: string
        if (!is_null($seatingPlanId) && !is_string($seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatingPlanId, true), gettype($seatingPlanId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seatingPlanId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seatingPlanId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seatingPlanId, true)), __LINE__);
        }
        if (is_null($seatingPlanId) || (is_array($seatingPlanId) && empty($seatingPlanId))) {
            unset($this->SeatingPlanId);
        } else {
            $this->SeatingPlanId = $seatingPlanId;
        }
        return $this;
    }
    /**
     * Get Show value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Show|null
     */
    public function getShow()
    {
        return isset($this->Show) ? $this->Show : null;
    }
    /**
     * Set Show value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Show $show
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setShow(\patest\StructType\Ticketing_Printing_Show $show = null)
    {
        if (is_null($show) || (is_array($show) && empty($show))) {
            unset($this->Show);
        } else {
            $this->Show = $show;
        }
        return $this;
    }
    /**
     * Get ShowTimeNfcPassURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowTimeNfcPassURL()
    {
        return isset($this->ShowTimeNfcPassURL) ? $this->ShowTimeNfcPassURL : null;
    }
    /**
     * Set ShowTimeNfcPassURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showTimeNfcPassURL
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setShowTimeNfcPassURL($showTimeNfcPassURL = null)
    {
        // validation for constraint: string
        if (!is_null($showTimeNfcPassURL) && !is_string($showTimeNfcPassURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showTimeNfcPassURL, true), gettype($showTimeNfcPassURL)), __LINE__);
        }
        if (is_null($showTimeNfcPassURL) || (is_array($showTimeNfcPassURL) && empty($showTimeNfcPassURL))) {
            unset($this->ShowTimeNfcPassURL);
        } else {
            $this->ShowTimeNfcPassURL = $showTimeNfcPassURL;
        }
        return $this;
    }
    /**
     * Get ShowType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_ShowType|null
     */
    public function getShowType()
    {
        return isset($this->ShowType) ? $this->ShowType : null;
    }
    /**
     * Set ShowType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_ShowType $showType
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setShowType(\patest\StructType\Ticketing_Printing_ShowType $showType = null)
    {
        if (is_null($showType) || (is_array($showType) && empty($showType))) {
            unset($this->ShowType);
        } else {
            $this->ShowType = $showType;
        }
        return $this;
    }
    /**
     * Get Stand value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Stand|null
     */
    public function getStand()
    {
        return isset($this->Stand) ? $this->Stand : null;
    }
    /**
     * Set Stand value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Stand $stand
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setStand(\patest\StructType\Ticketing_Printing_Stand $stand = null)
    {
        if (is_null($stand) || (is_array($stand) && empty($stand))) {
            unset($this->Stand);
        } else {
            $this->Stand = $stand;
        }
        return $this;
    }
    /**
     * Get SubscriberTicketType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriberTicketType()
    {
        return isset($this->SubscriberTicketType) ? $this->SubscriberTicketType : null;
    }
    /**
     * Set SubscriberTicketType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriberTicketType::valueIsValid()
     * @uses \patest\EnumType\SubscriberTicketType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $subscriberTicketType
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setSubscriberTicketType($subscriberTicketType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriberTicketType::valueIsValid($subscriberTicketType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriberTicketType', is_array($subscriberTicketType) ? implode(', ', $subscriberTicketType) : var_export($subscriberTicketType, true), implode(', ', \patest\EnumType\SubscriberTicketType::getValidValues())), __LINE__);
        }
        if (is_null($subscriberTicketType) || (is_array($subscriberTicketType) && empty($subscriberTicketType))) {
            unset($this->SubscriberTicketType);
        } else {
            $this->SubscriberTicketType = $subscriberTicketType;
        }
        return $this;
    }
    /**
     * Get SubscriptionInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_SubscriptionInfo|null
     */
    public function getSubscriptionInfo()
    {
        return isset($this->SubscriptionInfo) ? $this->SubscriptionInfo : null;
    }
    /**
     * Set SubscriptionInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_SubscriptionInfo $subscriptionInfo
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setSubscriptionInfo(\patest\StructType\Printing_PrintableItem_SubscriptionInfo $subscriptionInfo = null)
    {
        if (is_null($subscriptionInfo) || (is_array($subscriptionInfo) && empty($subscriptionInfo))) {
            unset($this->SubscriptionInfo);
        } else {
            $this->SubscriptionInfo = $subscriptionInfo;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get SubsidizedByAccountName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubsidizedByAccountName()
    {
        return isset($this->SubsidizedByAccountName) ? $this->SubsidizedByAccountName : null;
    }
    /**
     * Set SubsidizedByAccountName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subsidizedByAccountName
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setSubsidizedByAccountName($subsidizedByAccountName = null)
    {
        // validation for constraint: string
        if (!is_null($subsidizedByAccountName) && !is_string($subsidizedByAccountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subsidizedByAccountName, true), gettype($subsidizedByAccountName)), __LINE__);
        }
        if (is_null($subsidizedByAccountName) || (is_array($subsidizedByAccountName) && empty($subsidizedByAccountName))) {
            unset($this->SubsidizedByAccountName);
        } else {
            $this->SubsidizedByAccountName = $subsidizedByAccountName;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get Turnstiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_Printing_Turnstile|null
     */
    public function getTurnstiles()
    {
        return isset($this->Turnstiles) ? $this->Turnstiles : null;
    }
    /**
     * Set Turnstiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_Printing_Turnstile $turnstiles
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setTurnstiles(\patest\StructType\RecordSetOfTicketing_Printing_Turnstile $turnstiles = null)
    {
        if (is_null($turnstiles) || (is_array($turnstiles) && empty($turnstiles))) {
            unset($this->Turnstiles);
        } else {
            $this->Turnstiles = $turnstiles;
        }
        return $this;
    }
    /**
     * Get TurnstilesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstilesSummary()
    {
        return isset($this->TurnstilesSummary) ? $this->TurnstilesSummary : null;
    }
    /**
     * Set TurnstilesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstilesSummary
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setTurnstilesSummary($turnstilesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($turnstilesSummary) && !is_string($turnstilesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstilesSummary, true), gettype($turnstilesSummary)), __LINE__);
        }
        if (is_null($turnstilesSummary) || (is_array($turnstilesSummary) && empty($turnstilesSummary))) {
            unset($this->TurnstilesSummary);
        } else {
            $this->TurnstilesSummary = $turnstilesSummary;
        }
        return $this;
    }
    /**
     * Get Venue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_Printing_Venue|null
     */
    public function getVenue()
    {
        return isset($this->Venue) ? $this->Venue : null;
    }
    /**
     * Set Venue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_Printing_Venue $venue
     * @return \patest\StructType\Printing_PrintableItem_Ticket
     */
    public function setVenue(\patest\StructType\Ticketing_Printing_Venue $venue = null)
    {
        if (is_null($venue) || (is_array($venue) && empty($venue))) {
            unset($this->Venue);
        } else {
            $this->Venue = $venue;
        }
        return $this;
    }
}
