<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.PaymentItemBase StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_PaymentItemBase extends Printing_PrintableItem_Base
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The ClientCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCurrencyCode;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CompanyAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyAmount;
    /**
     * The CompanyCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCurrencyCode;
    /**
     * The InsertionMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InsertionMode;
    /**
     * The IsConfirmed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsConfirmed;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PaymentMethodSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodSystemName;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The ProviderSpecificDataSource
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProviderSpecificDataSource;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceNumber;
    /**
     * The SiteAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SiteAmount;
    /**
     * The SiteCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencyCode;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Printing.PrintableItem.PaymentItemBase
     * @uses Printing_PrintableItem_PaymentItemBase::setClientAmount()
     * @uses Printing_PrintableItem_PaymentItemBase::setClientCurrencyCode()
     * @uses Printing_PrintableItem_PaymentItemBase::setClientId()
     * @uses Printing_PrintableItem_PaymentItemBase::setCompanyAmount()
     * @uses Printing_PrintableItem_PaymentItemBase::setCompanyCurrencyCode()
     * @uses Printing_PrintableItem_PaymentItemBase::setInsertionMode()
     * @uses Printing_PrintableItem_PaymentItemBase::setIsConfirmed()
     * @uses Printing_PrintableItem_PaymentItemBase::setPaymentMethodId()
     * @uses Printing_PrintableItem_PaymentItemBase::setPaymentMethodName()
     * @uses Printing_PrintableItem_PaymentItemBase::setPaymentMethodSystemName()
     * @uses Printing_PrintableItem_PaymentItemBase::setPaymentMethodType()
     * @uses Printing_PrintableItem_PaymentItemBase::setProviderSpecificDataSource()
     * @uses Printing_PrintableItem_PaymentItemBase::setReferenceNumber()
     * @uses Printing_PrintableItem_PaymentItemBase::setSiteAmount()
     * @uses Printing_PrintableItem_PaymentItemBase::setSiteCurrencyCode()
     * @uses Printing_PrintableItem_PaymentItemBase::setTransactionGuid()
     * @param \patest\StructType\Money $clientAmount
     * @param string $clientCurrencyCode
     * @param string $clientId
     * @param \patest\StructType\Money $companyAmount
     * @param string $companyCurrencyCode
     * @param string $insertionMode
     * @param bool $isConfirmed
     * @param string $paymentMethodId
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param string $paymentMethodSystemName
     * @param string $paymentMethodType
     * @param string $providerSpecificDataSource
     * @param string $referenceNumber
     * @param \patest\StructType\Money $siteAmount
     * @param string $siteCurrencyCode
     * @param string $transactionGuid
     */
    public function __construct(\patest\StructType\Money $clientAmount = null, $clientCurrencyCode = null, $clientId = null, \patest\StructType\Money $companyAmount = null, $companyCurrencyCode = null, $insertionMode = null, $isConfirmed = null, $paymentMethodId = null, \patest\StructType\GlobalString $paymentMethodName = null, $paymentMethodSystemName = null, $paymentMethodType = null, $providerSpecificDataSource = null, $referenceNumber = null, \patest\StructType\Money $siteAmount = null, $siteCurrencyCode = null, $transactionGuid = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setClientCurrencyCode($clientCurrencyCode)
            ->setClientId($clientId)
            ->setCompanyAmount($companyAmount)
            ->setCompanyCurrencyCode($companyCurrencyCode)
            ->setInsertionMode($insertionMode)
            ->setIsConfirmed($isConfirmed)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentMethodSystemName($paymentMethodSystemName)
            ->setPaymentMethodType($paymentMethodType)
            ->setProviderSpecificDataSource($providerSpecificDataSource)
            ->setReferenceNumber($referenceNumber)
            ->setSiteAmount($siteAmount)
            ->setSiteCurrencyCode($siteCurrencyCode)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get ClientCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCurrencyCode()
    {
        return isset($this->ClientCurrencyCode) ? $this->ClientCurrencyCode : null;
    }
    /**
     * Set ClientCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCurrencyCode
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setClientCurrencyCode($clientCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCurrencyCode) && !is_string($clientCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCurrencyCode, true), gettype($clientCurrencyCode)), __LINE__);
        }
        if (is_null($clientCurrencyCode) || (is_array($clientCurrencyCode) && empty($clientCurrencyCode))) {
            unset($this->ClientCurrencyCode);
        } else {
            $this->ClientCurrencyCode = $clientCurrencyCode;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CompanyAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyAmount()
    {
        return isset($this->CompanyAmount) ? $this->CompanyAmount : null;
    }
    /**
     * Set CompanyAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyAmount
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setCompanyAmount(\patest\StructType\Money $companyAmount = null)
    {
        if (is_null($companyAmount) || (is_array($companyAmount) && empty($companyAmount))) {
            unset($this->CompanyAmount);
        } else {
            $this->CompanyAmount = $companyAmount;
        }
        return $this;
    }
    /**
     * Get CompanyCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCurrencyCode()
    {
        return isset($this->CompanyCurrencyCode) ? $this->CompanyCurrencyCode : null;
    }
    /**
     * Set CompanyCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCurrencyCode
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setCompanyCurrencyCode($companyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCurrencyCode) && !is_string($companyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCurrencyCode, true), gettype($companyCurrencyCode)), __LINE__);
        }
        if (is_null($companyCurrencyCode) || (is_array($companyCurrencyCode) && empty($companyCurrencyCode))) {
            unset($this->CompanyCurrencyCode);
        } else {
            $this->CompanyCurrencyCode = $companyCurrencyCode;
        }
        return $this;
    }
    /**
     * Get InsertionMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInsertionMode()
    {
        return isset($this->InsertionMode) ? $this->InsertionMode : null;
    }
    /**
     * Set InsertionMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemInsertionMode::valueIsValid()
     * @uses \patest\EnumType\ItemInsertionMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $insertionMode
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setInsertionMode($insertionMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemInsertionMode::valueIsValid($insertionMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemInsertionMode', is_array($insertionMode) ? implode(', ', $insertionMode) : var_export($insertionMode, true), implode(', ', \patest\EnumType\ItemInsertionMode::getValidValues())), __LINE__);
        }
        if (is_null($insertionMode) || (is_array($insertionMode) && empty($insertionMode))) {
            unset($this->InsertionMode);
        } else {
            $this->InsertionMode = $insertionMode;
        }
        return $this;
    }
    /**
     * Get IsConfirmed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsConfirmed()
    {
        return isset($this->IsConfirmed) ? $this->IsConfirmed : null;
    }
    /**
     * Set IsConfirmed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isConfirmed
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setIsConfirmed($isConfirmed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConfirmed) && !is_bool($isConfirmed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConfirmed, true), gettype($isConfirmed)), __LINE__);
        }
        if (is_null($isConfirmed) || (is_array($isConfirmed) && empty($isConfirmed))) {
            unset($this->IsConfirmed);
        } else {
            $this->IsConfirmed = $isConfirmed;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentMethodSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodSystemName()
    {
        return isset($this->PaymentMethodSystemName) ? $this->PaymentMethodSystemName : null;
    }
    /**
     * Set PaymentMethodSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodSystemName
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setPaymentMethodSystemName($paymentMethodSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodSystemName) && !is_string($paymentMethodSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodSystemName, true), gettype($paymentMethodSystemName)), __LINE__);
        }
        if (is_null($paymentMethodSystemName) || (is_array($paymentMethodSystemName) && empty($paymentMethodSystemName))) {
            unset($this->PaymentMethodSystemName);
        } else {
            $this->PaymentMethodSystemName = $paymentMethodSystemName;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get ProviderSpecificDataSource value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSpecificDataSource()
    {
        return isset($this->ProviderSpecificDataSource) ? $this->ProviderSpecificDataSource : null;
    }
    /**
     * Set ProviderSpecificDataSource value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSpecificDataSource
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setProviderSpecificDataSource($providerSpecificDataSource = null)
    {
        // validation for constraint: string
        if (!is_null($providerSpecificDataSource) && !is_string($providerSpecificDataSource)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSpecificDataSource, true), gettype($providerSpecificDataSource)), __LINE__);
        }
        if (is_null($providerSpecificDataSource) || (is_array($providerSpecificDataSource) && empty($providerSpecificDataSource))) {
            unset($this->ProviderSpecificDataSource);
        } else {
            $this->ProviderSpecificDataSource = $providerSpecificDataSource;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceNumber
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($referenceNumber) && !is_string($referenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get SiteAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSiteAmount()
    {
        return isset($this->SiteAmount) ? $this->SiteAmount : null;
    }
    /**
     * Set SiteAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $siteAmount
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setSiteAmount(\patest\StructType\Money $siteAmount = null)
    {
        if (is_null($siteAmount) || (is_array($siteAmount) && empty($siteAmount))) {
            unset($this->SiteAmount);
        } else {
            $this->SiteAmount = $siteAmount;
        }
        return $this;
    }
    /**
     * Get SiteCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencyCode()
    {
        return isset($this->SiteCurrencyCode) ? $this->SiteCurrencyCode : null;
    }
    /**
     * Set SiteCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencyCode
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setSiteCurrencyCode($siteCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencyCode) && !is_string($siteCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencyCode, true), gettype($siteCurrencyCode)), __LINE__);
        }
        if (is_null($siteCurrencyCode) || (is_array($siteCurrencyCode) && empty($siteCurrencyCode))) {
            unset($this->SiteCurrencyCode);
        } else {
            $this->SiteCurrencyCode = $siteCurrencyCode;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Printing_PrintableItem_PaymentItemBase
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
