<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.Membership StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_Membership extends Printing_PrintableItem_BasketItemBase
{
    /**
     * The AccessControlParentDefinitionDataReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlParentDefinitionDataReferenceId;
    /**
     * The AccessControlProductExtensionReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlProductExtensionReferenceId;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BarcodeRefEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeRefEntityName;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * The CurrentEndDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentEndDate;
    /**
     * The CurrentInstance
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Membership_Printing_MembershipInstance
     */
    public $CurrentInstance;
    /**
     * The CurrentStartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentStartDate;
    /**
     * The CurrentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentStatus;
    /**
     * The EndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EndDate;
    /**
     * The ExtrasPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ExtrasPriceTypeId;
    /**
     * The GuestsPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuestsPriceTypeId;
    /**
     * The IsGift
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGift;
    /**
     * The IsJoint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsJoint;
    /**
     * The IsRenewed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsRenewed;
    /**
     * The JointMembers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfMembership_JointMembershipMember
     */
    public $JointMembers;
    /**
     * The JointMembership
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Membership_Printing_JointMembershipInfo
     */
    public $JointMembership;
    /**
     * The MembershipDefinition
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Membership_Printing_MembershipDefinition
     */
    public $MembershipDefinition;
    /**
     * The MembershipDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $MembershipDefinitionId;
    /**
     * The MembershipNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipNumber;
    /**
     * The MemberSince
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MemberSince;
    /**
     * The NameOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NameOnCard;
    /**
     * The NumberOfExtras
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfExtras;
    /**
     * The NumberOfGuests
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfGuests;
    /**
     * The NumberOfOwners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfOwners;
    /**
     * The OwnersPriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnersPriceTypeId;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The RenewOfInstanceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RenewOfInstanceId;
    /**
     * The SchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SchemeId;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The UpdateOfInstanceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UpdateOfInstanceId;
    /**
     * Constructor method for Printing.PrintableItem.Membership
     * @uses Printing_PrintableItem_Membership::setAccessControlParentDefinitionDataReferenceId()
     * @uses Printing_PrintableItem_Membership::setAccessControlProductExtensionReferenceId()
     * @uses Printing_PrintableItem_Membership::setBarcode()
     * @uses Printing_PrintableItem_Membership::setBarcodeRefEntityName()
     * @uses Printing_PrintableItem_Membership::setCardNumber()
     * @uses Printing_PrintableItem_Membership::setCurrentEndDate()
     * @uses Printing_PrintableItem_Membership::setCurrentInstance()
     * @uses Printing_PrintableItem_Membership::setCurrentStartDate()
     * @uses Printing_PrintableItem_Membership::setCurrentStatus()
     * @uses Printing_PrintableItem_Membership::setEndDate()
     * @uses Printing_PrintableItem_Membership::setExtrasPriceTypeId()
     * @uses Printing_PrintableItem_Membership::setGuestsPriceTypeId()
     * @uses Printing_PrintableItem_Membership::setIsGift()
     * @uses Printing_PrintableItem_Membership::setIsJoint()
     * @uses Printing_PrintableItem_Membership::setIsRenewed()
     * @uses Printing_PrintableItem_Membership::setJointMembers()
     * @uses Printing_PrintableItem_Membership::setJointMembership()
     * @uses Printing_PrintableItem_Membership::setMembershipDefinition()
     * @uses Printing_PrintableItem_Membership::setMembershipDefinitionId()
     * @uses Printing_PrintableItem_Membership::setMembershipNumber()
     * @uses Printing_PrintableItem_Membership::setMemberSince()
     * @uses Printing_PrintableItem_Membership::setNameOnCard()
     * @uses Printing_PrintableItem_Membership::setNumberOfExtras()
     * @uses Printing_PrintableItem_Membership::setNumberOfGuests()
     * @uses Printing_PrintableItem_Membership::setNumberOfOwners()
     * @uses Printing_PrintableItem_Membership::setOwnersPriceTypeId()
     * @uses Printing_PrintableItem_Membership::setPrintCount()
     * @uses Printing_PrintableItem_Membership::setRenewOfInstanceId()
     * @uses Printing_PrintableItem_Membership::setSchemeId()
     * @uses Printing_PrintableItem_Membership::setStartDate()
     * @uses Printing_PrintableItem_Membership::setStatus()
     * @uses Printing_PrintableItem_Membership::setUpdateOfInstanceId()
     * @param string $accessControlParentDefinitionDataReferenceId
     * @param string $accessControlProductExtensionReferenceId
     * @param string $barcode
     * @param string $barcodeRefEntityName
     * @param string $cardNumber
     * @param string $currentEndDate
     * @param \patest\StructType\Membership_Printing_MembershipInstance $currentInstance
     * @param string $currentStartDate
     * @param string $currentStatus
     * @param string $endDate
     * @param string $extrasPriceTypeId
     * @param string $guestsPriceTypeId
     * @param bool $isGift
     * @param bool $isJoint
     * @param bool $isRenewed
     * @param \patest\StructType\RecordSetOfMembership_JointMembershipMember $jointMembers
     * @param \patest\StructType\Membership_Printing_JointMembershipInfo $jointMembership
     * @param \patest\StructType\Membership_Printing_MembershipDefinition $membershipDefinition
     * @param string $membershipDefinitionId
     * @param string $membershipNumber
     * @param string $memberSince
     * @param string $nameOnCard
     * @param int $numberOfExtras
     * @param int $numberOfGuests
     * @param int $numberOfOwners
     * @param string $ownersPriceTypeId
     * @param int $printCount
     * @param string $renewOfInstanceId
     * @param string $schemeId
     * @param string $startDate
     * @param string $status
     * @param string $updateOfInstanceId
     */
    public function __construct($accessControlParentDefinitionDataReferenceId = null, $accessControlProductExtensionReferenceId = null, $barcode = null, $barcodeRefEntityName = null, $cardNumber = null, $currentEndDate = null, \patest\StructType\Membership_Printing_MembershipInstance $currentInstance = null, $currentStartDate = null, $currentStatus = null, $endDate = null, $extrasPriceTypeId = null, $guestsPriceTypeId = null, $isGift = null, $isJoint = null, $isRenewed = null, \patest\StructType\RecordSetOfMembership_JointMembershipMember $jointMembers = null, \patest\StructType\Membership_Printing_JointMembershipInfo $jointMembership = null, \patest\StructType\Membership_Printing_MembershipDefinition $membershipDefinition = null, $membershipDefinitionId = null, $membershipNumber = null, $memberSince = null, $nameOnCard = null, $numberOfExtras = null, $numberOfGuests = null, $numberOfOwners = null, $ownersPriceTypeId = null, $printCount = null, $renewOfInstanceId = null, $schemeId = null, $startDate = null, $status = null, $updateOfInstanceId = null)
    {
        $this
            ->setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId)
            ->setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId)
            ->setBarcode($barcode)
            ->setBarcodeRefEntityName($barcodeRefEntityName)
            ->setCardNumber($cardNumber)
            ->setCurrentEndDate($currentEndDate)
            ->setCurrentInstance($currentInstance)
            ->setCurrentStartDate($currentStartDate)
            ->setCurrentStatus($currentStatus)
            ->setEndDate($endDate)
            ->setExtrasPriceTypeId($extrasPriceTypeId)
            ->setGuestsPriceTypeId($guestsPriceTypeId)
            ->setIsGift($isGift)
            ->setIsJoint($isJoint)
            ->setIsRenewed($isRenewed)
            ->setJointMembers($jointMembers)
            ->setJointMembership($jointMembership)
            ->setMembershipDefinition($membershipDefinition)
            ->setMembershipDefinitionId($membershipDefinitionId)
            ->setMembershipNumber($membershipNumber)
            ->setMemberSince($memberSince)
            ->setNameOnCard($nameOnCard)
            ->setNumberOfExtras($numberOfExtras)
            ->setNumberOfGuests($numberOfGuests)
            ->setNumberOfOwners($numberOfOwners)
            ->setOwnersPriceTypeId($ownersPriceTypeId)
            ->setPrintCount($printCount)
            ->setRenewOfInstanceId($renewOfInstanceId)
            ->setSchemeId($schemeId)
            ->setStartDate($startDate)
            ->setStatus($status)
            ->setUpdateOfInstanceId($updateOfInstanceId);
    }
    /**
     * Get AccessControlParentDefinitionDataReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlParentDefinitionDataReferenceId()
    {
        return isset($this->AccessControlParentDefinitionDataReferenceId) ? $this->AccessControlParentDefinitionDataReferenceId : null;
    }
    /**
     * Set AccessControlParentDefinitionDataReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlParentDefinitionDataReferenceId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setAccessControlParentDefinitionDataReferenceId($accessControlParentDefinitionDataReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !is_string($accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlParentDefinitionDataReferenceId, true), gettype($accessControlParentDefinitionDataReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlParentDefinitionDataReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlParentDefinitionDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlParentDefinitionDataReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlParentDefinitionDataReferenceId) || (is_array($accessControlParentDefinitionDataReferenceId) && empty($accessControlParentDefinitionDataReferenceId))) {
            unset($this->AccessControlParentDefinitionDataReferenceId);
        } else {
            $this->AccessControlParentDefinitionDataReferenceId = $accessControlParentDefinitionDataReferenceId;
        }
        return $this;
    }
    /**
     * Get AccessControlProductExtensionReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlProductExtensionReferenceId()
    {
        return isset($this->AccessControlProductExtensionReferenceId) ? $this->AccessControlProductExtensionReferenceId : null;
    }
    /**
     * Set AccessControlProductExtensionReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlProductExtensionReferenceId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setAccessControlProductExtensionReferenceId($accessControlProductExtensionReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlProductExtensionReferenceId) && !is_string($accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlProductExtensionReferenceId, true), gettype($accessControlProductExtensionReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlProductExtensionReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlProductExtensionReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlProductExtensionReferenceId, true)), __LINE__);
        }
        if (is_null($accessControlProductExtensionReferenceId) || (is_array($accessControlProductExtensionReferenceId) && empty($accessControlProductExtensionReferenceId))) {
            unset($this->AccessControlProductExtensionReferenceId);
        } else {
            $this->AccessControlProductExtensionReferenceId = $accessControlProductExtensionReferenceId;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BarcodeRefEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeRefEntityName()
    {
        return isset($this->BarcodeRefEntityName) ? $this->BarcodeRefEntityName : null;
    }
    /**
     * Set BarcodeRefEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeRefEntityName
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setBarcodeRefEntityName($barcodeRefEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeRefEntityName) && !is_string($barcodeRefEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeRefEntityName, true), gettype($barcodeRefEntityName)), __LINE__);
        }
        if (is_null($barcodeRefEntityName) || (is_array($barcodeRefEntityName) && empty($barcodeRefEntityName))) {
            unset($this->BarcodeRefEntityName);
        } else {
            $this->BarcodeRefEntityName = $barcodeRefEntityName;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
    /**
     * Get CurrentEndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentEndDate()
    {
        return isset($this->CurrentEndDate) ? $this->CurrentEndDate : null;
    }
    /**
     * Set CurrentEndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentEndDate
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setCurrentEndDate($currentEndDate = null)
    {
        // validation for constraint: string
        if (!is_null($currentEndDate) && !is_string($currentEndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentEndDate, true), gettype($currentEndDate)), __LINE__);
        }
        if (is_null($currentEndDate) || (is_array($currentEndDate) && empty($currentEndDate))) {
            unset($this->CurrentEndDate);
        } else {
            $this->CurrentEndDate = $currentEndDate;
        }
        return $this;
    }
    /**
     * Get CurrentInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Membership_Printing_MembershipInstance|null
     */
    public function getCurrentInstance()
    {
        return isset($this->CurrentInstance) ? $this->CurrentInstance : null;
    }
    /**
     * Set CurrentInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Membership_Printing_MembershipInstance $currentInstance
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setCurrentInstance(\patest\StructType\Membership_Printing_MembershipInstance $currentInstance = null)
    {
        if (is_null($currentInstance) || (is_array($currentInstance) && empty($currentInstance))) {
            unset($this->CurrentInstance);
        } else {
            $this->CurrentInstance = $currentInstance;
        }
        return $this;
    }
    /**
     * Get CurrentStartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentStartDate()
    {
        return isset($this->CurrentStartDate) ? $this->CurrentStartDate : null;
    }
    /**
     * Set CurrentStartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentStartDate
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setCurrentStartDate($currentStartDate = null)
    {
        // validation for constraint: string
        if (!is_null($currentStartDate) && !is_string($currentStartDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentStartDate, true), gettype($currentStartDate)), __LINE__);
        }
        if (is_null($currentStartDate) || (is_array($currentStartDate) && empty($currentStartDate))) {
            unset($this->CurrentStartDate);
        } else {
            $this->CurrentStartDate = $currentStartDate;
        }
        return $this;
    }
    /**
     * Get CurrentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentStatus()
    {
        return isset($this->CurrentStatus) ? $this->CurrentStatus : null;
    }
    /**
     * Set CurrentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $currentStatus
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setCurrentStatus($currentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($currentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($currentStatus) ? implode(', ', $currentStatus) : var_export($currentStatus, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($currentStatus) || (is_array($currentStatus) && empty($currentStatus))) {
            unset($this->CurrentStatus);
        } else {
            $this->CurrentStatus = $currentStatus;
        }
        return $this;
    }
    /**
     * Get EndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEndDate()
    {
        return isset($this->EndDate) ? $this->EndDate : null;
    }
    /**
     * Set EndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $endDate
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setEndDate($endDate = null)
    {
        // validation for constraint: string
        if (!is_null($endDate) && !is_string($endDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($endDate, true), gettype($endDate)), __LINE__);
        }
        if (is_null($endDate) || (is_array($endDate) && empty($endDate))) {
            unset($this->EndDate);
        } else {
            $this->EndDate = $endDate;
        }
        return $this;
    }
    /**
     * Get ExtrasPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExtrasPriceTypeId()
    {
        return isset($this->ExtrasPriceTypeId) ? $this->ExtrasPriceTypeId : null;
    }
    /**
     * Set ExtrasPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $extrasPriceTypeId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setExtrasPriceTypeId($extrasPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($extrasPriceTypeId) && !is_string($extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($extrasPriceTypeId, true), gettype($extrasPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($extrasPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $extrasPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($extrasPriceTypeId, true)), __LINE__);
        }
        if (is_null($extrasPriceTypeId) || (is_array($extrasPriceTypeId) && empty($extrasPriceTypeId))) {
            unset($this->ExtrasPriceTypeId);
        } else {
            $this->ExtrasPriceTypeId = $extrasPriceTypeId;
        }
        return $this;
    }
    /**
     * Get GuestsPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGuestsPriceTypeId()
    {
        return isset($this->GuestsPriceTypeId) ? $this->GuestsPriceTypeId : null;
    }
    /**
     * Set GuestsPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $guestsPriceTypeId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setGuestsPriceTypeId($guestsPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($guestsPriceTypeId) && !is_string($guestsPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guestsPriceTypeId, true), gettype($guestsPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guestsPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guestsPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guestsPriceTypeId, true)), __LINE__);
        }
        if (is_null($guestsPriceTypeId) || (is_array($guestsPriceTypeId) && empty($guestsPriceTypeId))) {
            unset($this->GuestsPriceTypeId);
        } else {
            $this->GuestsPriceTypeId = $guestsPriceTypeId;
        }
        return $this;
    }
    /**
     * Get IsGift value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGift()
    {
        return isset($this->IsGift) ? $this->IsGift : null;
    }
    /**
     * Set IsGift value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGift
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setIsGift($isGift = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGift) && !is_bool($isGift)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGift, true), gettype($isGift)), __LINE__);
        }
        if (is_null($isGift) || (is_array($isGift) && empty($isGift))) {
            unset($this->IsGift);
        } else {
            $this->IsGift = $isGift;
        }
        return $this;
    }
    /**
     * Get IsJoint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsJoint()
    {
        return isset($this->IsJoint) ? $this->IsJoint : null;
    }
    /**
     * Set IsJoint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isJoint
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setIsJoint($isJoint = null)
    {
        // validation for constraint: boolean
        if (!is_null($isJoint) && !is_bool($isJoint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isJoint, true), gettype($isJoint)), __LINE__);
        }
        if (is_null($isJoint) || (is_array($isJoint) && empty($isJoint))) {
            unset($this->IsJoint);
        } else {
            $this->IsJoint = $isJoint;
        }
        return $this;
    }
    /**
     * Get IsRenewed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsRenewed()
    {
        return isset($this->IsRenewed) ? $this->IsRenewed : null;
    }
    /**
     * Set IsRenewed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isRenewed
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setIsRenewed($isRenewed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isRenewed) && !is_bool($isRenewed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isRenewed, true), gettype($isRenewed)), __LINE__);
        }
        if (is_null($isRenewed) || (is_array($isRenewed) && empty($isRenewed))) {
            unset($this->IsRenewed);
        } else {
            $this->IsRenewed = $isRenewed;
        }
        return $this;
    }
    /**
     * Get JointMembers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfMembership_JointMembershipMember|null
     */
    public function getJointMembers()
    {
        return isset($this->JointMembers) ? $this->JointMembers : null;
    }
    /**
     * Set JointMembers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfMembership_JointMembershipMember $jointMembers
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setJointMembers(\patest\StructType\RecordSetOfMembership_JointMembershipMember $jointMembers = null)
    {
        if (is_null($jointMembers) || (is_array($jointMembers) && empty($jointMembers))) {
            unset($this->JointMembers);
        } else {
            $this->JointMembers = $jointMembers;
        }
        return $this;
    }
    /**
     * Get JointMembership value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Membership_Printing_JointMembershipInfo|null
     */
    public function getJointMembership()
    {
        return isset($this->JointMembership) ? $this->JointMembership : null;
    }
    /**
     * Set JointMembership value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Membership_Printing_JointMembershipInfo $jointMembership
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setJointMembership(\patest\StructType\Membership_Printing_JointMembershipInfo $jointMembership = null)
    {
        if (is_null($jointMembership) || (is_array($jointMembership) && empty($jointMembership))) {
            unset($this->JointMembership);
        } else {
            $this->JointMembership = $jointMembership;
        }
        return $this;
    }
    /**
     * Get MembershipDefinition value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Membership_Printing_MembershipDefinition|null
     */
    public function getMembershipDefinition()
    {
        return isset($this->MembershipDefinition) ? $this->MembershipDefinition : null;
    }
    /**
     * Set MembershipDefinition value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Membership_Printing_MembershipDefinition $membershipDefinition
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setMembershipDefinition(\patest\StructType\Membership_Printing_MembershipDefinition $membershipDefinition = null)
    {
        if (is_null($membershipDefinition) || (is_array($membershipDefinition) && empty($membershipDefinition))) {
            unset($this->MembershipDefinition);
        } else {
            $this->MembershipDefinition = $membershipDefinition;
        }
        return $this;
    }
    /**
     * Get MembershipDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipDefinitionId()
    {
        return isset($this->MembershipDefinitionId) ? $this->MembershipDefinitionId : null;
    }
    /**
     * Set MembershipDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipDefinitionId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setMembershipDefinitionId($membershipDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($membershipDefinitionId) && !is_string($membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipDefinitionId, true), gettype($membershipDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($membershipDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $membershipDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($membershipDefinitionId, true)), __LINE__);
        }
        if (is_null($membershipDefinitionId) || (is_array($membershipDefinitionId) && empty($membershipDefinitionId))) {
            unset($this->MembershipDefinitionId);
        } else {
            $this->MembershipDefinitionId = $membershipDefinitionId;
        }
        return $this;
    }
    /**
     * Get MembershipNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipNumber()
    {
        return isset($this->MembershipNumber) ? $this->MembershipNumber : null;
    }
    /**
     * Set MembershipNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $membershipNumber
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setMembershipNumber($membershipNumber = null)
    {
        // validation for constraint: string
        if (!is_null($membershipNumber) && !is_string($membershipNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($membershipNumber, true), gettype($membershipNumber)), __LINE__);
        }
        if (is_null($membershipNumber) || (is_array($membershipNumber) && empty($membershipNumber))) {
            unset($this->MembershipNumber);
        } else {
            $this->MembershipNumber = $membershipNumber;
        }
        return $this;
    }
    /**
     * Get MemberSince value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMemberSince()
    {
        return isset($this->MemberSince) ? $this->MemberSince : null;
    }
    /**
     * Set MemberSince value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $memberSince
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setMemberSince($memberSince = null)
    {
        // validation for constraint: string
        if (!is_null($memberSince) && !is_string($memberSince)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($memberSince, true), gettype($memberSince)), __LINE__);
        }
        if (is_null($memberSince) || (is_array($memberSince) && empty($memberSince))) {
            unset($this->MemberSince);
        } else {
            $this->MemberSince = $memberSince;
        }
        return $this;
    }
    /**
     * Get NameOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNameOnCard()
    {
        return isset($this->NameOnCard) ? $this->NameOnCard : null;
    }
    /**
     * Set NameOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nameOnCard
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setNameOnCard($nameOnCard = null)
    {
        // validation for constraint: string
        if (!is_null($nameOnCard) && !is_string($nameOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nameOnCard, true), gettype($nameOnCard)), __LINE__);
        }
        if (is_null($nameOnCard) || (is_array($nameOnCard) && empty($nameOnCard))) {
            unset($this->NameOnCard);
        } else {
            $this->NameOnCard = $nameOnCard;
        }
        return $this;
    }
    /**
     * Get NumberOfExtras value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfExtras()
    {
        return isset($this->NumberOfExtras) ? $this->NumberOfExtras : null;
    }
    /**
     * Set NumberOfExtras value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfExtras
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setNumberOfExtras($numberOfExtras = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfExtras) && !(is_int($numberOfExtras) || ctype_digit($numberOfExtras))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfExtras, true), gettype($numberOfExtras)), __LINE__);
        }
        if (is_null($numberOfExtras) || (is_array($numberOfExtras) && empty($numberOfExtras))) {
            unset($this->NumberOfExtras);
        } else {
            $this->NumberOfExtras = $numberOfExtras;
        }
        return $this;
    }
    /**
     * Get NumberOfGuests value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfGuests()
    {
        return isset($this->NumberOfGuests) ? $this->NumberOfGuests : null;
    }
    /**
     * Set NumberOfGuests value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfGuests
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setNumberOfGuests($numberOfGuests = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfGuests) && !(is_int($numberOfGuests) || ctype_digit($numberOfGuests))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfGuests, true), gettype($numberOfGuests)), __LINE__);
        }
        if (is_null($numberOfGuests) || (is_array($numberOfGuests) && empty($numberOfGuests))) {
            unset($this->NumberOfGuests);
        } else {
            $this->NumberOfGuests = $numberOfGuests;
        }
        return $this;
    }
    /**
     * Get NumberOfOwners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfOwners()
    {
        return isset($this->NumberOfOwners) ? $this->NumberOfOwners : null;
    }
    /**
     * Set NumberOfOwners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfOwners
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setNumberOfOwners($numberOfOwners = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfOwners) && !(is_int($numberOfOwners) || ctype_digit($numberOfOwners))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfOwners, true), gettype($numberOfOwners)), __LINE__);
        }
        if (is_null($numberOfOwners) || (is_array($numberOfOwners) && empty($numberOfOwners))) {
            unset($this->NumberOfOwners);
        } else {
            $this->NumberOfOwners = $numberOfOwners;
        }
        return $this;
    }
    /**
     * Get OwnersPriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnersPriceTypeId()
    {
        return isset($this->OwnersPriceTypeId) ? $this->OwnersPriceTypeId : null;
    }
    /**
     * Set OwnersPriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownersPriceTypeId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setOwnersPriceTypeId($ownersPriceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($ownersPriceTypeId) && !is_string($ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownersPriceTypeId, true), gettype($ownersPriceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownersPriceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownersPriceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownersPriceTypeId, true)), __LINE__);
        }
        if (is_null($ownersPriceTypeId) || (is_array($ownersPriceTypeId) && empty($ownersPriceTypeId))) {
            unset($this->OwnersPriceTypeId);
        } else {
            $this->OwnersPriceTypeId = $ownersPriceTypeId;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get RenewOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRenewOfInstanceId()
    {
        return isset($this->RenewOfInstanceId) ? $this->RenewOfInstanceId : null;
    }
    /**
     * Set RenewOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $renewOfInstanceId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setRenewOfInstanceId($renewOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($renewOfInstanceId) && !is_string($renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($renewOfInstanceId, true), gettype($renewOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($renewOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $renewOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($renewOfInstanceId, true)), __LINE__);
        }
        if (is_null($renewOfInstanceId) || (is_array($renewOfInstanceId) && empty($renewOfInstanceId))) {
            unset($this->RenewOfInstanceId);
        } else {
            $this->RenewOfInstanceId = $renewOfInstanceId;
        }
        return $this;
    }
    /**
     * Get SchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSchemeId()
    {
        return isset($this->SchemeId) ? $this->SchemeId : null;
    }
    /**
     * Set SchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $schemeId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setSchemeId($schemeId = null)
    {
        // validation for constraint: string
        if (!is_null($schemeId) && !is_string($schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($schemeId, true), gettype($schemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($schemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $schemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($schemeId, true)), __LINE__);
        }
        if (is_null($schemeId) || (is_array($schemeId) && empty($schemeId))) {
            unset($this->SchemeId);
        } else {
            $this->SchemeId = $schemeId;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\MembershipStatus::valueIsValid()
     * @uses \patest\EnumType\MembershipStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\MembershipStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\MembershipStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\MembershipStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get UpdateOfInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateOfInstanceId()
    {
        return isset($this->UpdateOfInstanceId) ? $this->UpdateOfInstanceId : null;
    }
    /**
     * Set UpdateOfInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateOfInstanceId
     * @return \patest\StructType\Printing_PrintableItem_Membership
     */
    public function setUpdateOfInstanceId($updateOfInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($updateOfInstanceId) && !is_string($updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateOfInstanceId, true), gettype($updateOfInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($updateOfInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $updateOfInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($updateOfInstanceId, true)), __LINE__);
        }
        if (is_null($updateOfInstanceId) || (is_array($updateOfInstanceId) && empty($updateOfInstanceId))) {
            unset($this->UpdateOfInstanceId);
        } else {
            $this->UpdateOfInstanceId = $updateOfInstanceId;
        }
        return $this;
    }
}
