<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.MatchingGiftDonor StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_MatchingGiftDonor extends Printing_Item_ComplexProperty_Base
{
    /**
     * The BusinessPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessPhone;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DisplayName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayName;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The Fax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Fax;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The PrimaryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_PostalAddress
     */
    public $PrimaryAddress;
    /**
     * Constructor method for Printing.PrintableItem.MatchingGiftDonor
     * @uses Printing_PrintableItem_MatchingGiftDonor::setBusinessPhone()
     * @uses Printing_PrintableItem_MatchingGiftDonor::setClientId()
     * @uses Printing_PrintableItem_MatchingGiftDonor::setDisplayName()
     * @uses Printing_PrintableItem_MatchingGiftDonor::setEmail()
     * @uses Printing_PrintableItem_MatchingGiftDonor::setFax()
     * @uses Printing_PrintableItem_MatchingGiftDonor::setHomePhone()
     * @uses Printing_PrintableItem_MatchingGiftDonor::setMobilePhone()
     * @uses Printing_PrintableItem_MatchingGiftDonor::setPrimaryAddress()
     * @param string $businessPhone
     * @param string $clientId
     * @param string $displayName
     * @param string $email
     * @param string $fax
     * @param string $homePhone
     * @param string $mobilePhone
     * @param \patest\StructType\Crm_PostalAddress $primaryAddress
     */
    public function __construct($businessPhone = null, $clientId = null, $displayName = null, $email = null, $fax = null, $homePhone = null, $mobilePhone = null, \patest\StructType\Crm_PostalAddress $primaryAddress = null)
    {
        $this
            ->setBusinessPhone($businessPhone)
            ->setClientId($clientId)
            ->setDisplayName($displayName)
            ->setEmail($email)
            ->setFax($fax)
            ->setHomePhone($homePhone)
            ->setMobilePhone($mobilePhone)
            ->setPrimaryAddress($primaryAddress);
    }
    /**
     * Get BusinessPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessPhone()
    {
        return isset($this->BusinessPhone) ? $this->BusinessPhone : null;
    }
    /**
     * Set BusinessPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessPhone
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public function setBusinessPhone($businessPhone = null)
    {
        // validation for constraint: string
        if (!is_null($businessPhone) && !is_string($businessPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessPhone, true), gettype($businessPhone)), __LINE__);
        }
        if (is_null($businessPhone) || (is_array($businessPhone) && empty($businessPhone))) {
            unset($this->BusinessPhone);
        } else {
            $this->BusinessPhone = $businessPhone;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DisplayName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayName()
    {
        return isset($this->DisplayName) ? $this->DisplayName : null;
    }
    /**
     * Set DisplayName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $displayName
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public function setDisplayName($displayName = null)
    {
        // validation for constraint: string
        if (!is_null($displayName) && !is_string($displayName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($displayName, true), gettype($displayName)), __LINE__);
        }
        if (is_null($displayName) || (is_array($displayName) && empty($displayName))) {
            unset($this->DisplayName);
        } else {
            $this->DisplayName = $displayName;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get Fax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFax()
    {
        return isset($this->Fax) ? $this->Fax : null;
    }
    /**
     * Set Fax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fax
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public function setFax($fax = null)
    {
        // validation for constraint: string
        if (!is_null($fax) && !is_string($fax)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fax, true), gettype($fax)), __LINE__);
        }
        if (is_null($fax) || (is_array($fax) && empty($fax))) {
            unset($this->Fax);
        } else {
            $this->Fax = $fax;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get PrimaryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_PostalAddress|null
     */
    public function getPrimaryAddress()
    {
        return isset($this->PrimaryAddress) ? $this->PrimaryAddress : null;
    }
    /**
     * Set PrimaryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_PostalAddress $primaryAddress
     * @return \patest\StructType\Printing_PrintableItem_MatchingGiftDonor
     */
    public function setPrimaryAddress(\patest\StructType\Crm_PostalAddress $primaryAddress = null)
    {
        if (is_null($primaryAddress) || (is_array($primaryAddress) && empty($primaryAddress))) {
            unset($this->PrimaryAddress);
        } else {
            $this->PrimaryAddress = $primaryAddress;
        }
        return $this;
    }
}
