<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.MarketingDocument StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_MarketingDocument extends AnyEntity
{
    /**
     * The BusinessPhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BusinessPhone;
    /**
     * The City
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $City;
    /**
     * The Country
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Country;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The Email
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Email;
    /**
     * The FirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstName;
    /**
     * The Gender
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gender;
    /**
     * The HomeAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomeAddress;
    /**
     * The HomePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HomePhone;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The JobTitle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $JobTitle;
    /**
     * The LastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastName;
    /**
     * The MobilePhone
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MobilePhone;
    /**
     * The PreferredCultureId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PreferredCultureId;
    /**
     * The Region
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Region;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $State;
    /**
     * Constructor method for Printing.PrintableItem.MarketingDocument
     * @uses Printing_PrintableItem_MarketingDocument::setBusinessPhone()
     * @uses Printing_PrintableItem_MarketingDocument::setCity()
     * @uses Printing_PrintableItem_MarketingDocument::setCountry()
     * @uses Printing_PrintableItem_MarketingDocument::setCrmId()
     * @uses Printing_PrintableItem_MarketingDocument::setEmail()
     * @uses Printing_PrintableItem_MarketingDocument::setFirstName()
     * @uses Printing_PrintableItem_MarketingDocument::setGender()
     * @uses Printing_PrintableItem_MarketingDocument::setHomeAddress()
     * @uses Printing_PrintableItem_MarketingDocument::setHomePhone()
     * @uses Printing_PrintableItem_MarketingDocument::setId()
     * @uses Printing_PrintableItem_MarketingDocument::setIsActive()
     * @uses Printing_PrintableItem_MarketingDocument::setJobTitle()
     * @uses Printing_PrintableItem_MarketingDocument::setLastName()
     * @uses Printing_PrintableItem_MarketingDocument::setMobilePhone()
     * @uses Printing_PrintableItem_MarketingDocument::setPreferredCultureId()
     * @uses Printing_PrintableItem_MarketingDocument::setRegion()
     * @uses Printing_PrintableItem_MarketingDocument::setState()
     * @param string $businessPhone
     * @param \patest\StructType\GlobalString $city
     * @param \patest\StructType\GlobalString $country
     * @param string $crmId
     * @param string $email
     * @param string $firstName
     * @param string $gender
     * @param string $homeAddress
     * @param string $homePhone
     * @param string $id
     * @param bool $isActive
     * @param \patest\StructType\GlobalString $jobTitle
     * @param string $lastName
     * @param string $mobilePhone
     * @param int $preferredCultureId
     * @param \patest\StructType\GlobalString $region
     * @param \patest\StructType\GlobalString $state
     */
    public function __construct($businessPhone = null, \patest\StructType\GlobalString $city = null, \patest\StructType\GlobalString $country = null, $crmId = null, $email = null, $firstName = null, $gender = null, $homeAddress = null, $homePhone = null, $id = null, $isActive = null, \patest\StructType\GlobalString $jobTitle = null, $lastName = null, $mobilePhone = null, $preferredCultureId = null, \patest\StructType\GlobalString $region = null, \patest\StructType\GlobalString $state = null)
    {
        $this
            ->setBusinessPhone($businessPhone)
            ->setCity($city)
            ->setCountry($country)
            ->setCrmId($crmId)
            ->setEmail($email)
            ->setFirstName($firstName)
            ->setGender($gender)
            ->setHomeAddress($homeAddress)
            ->setHomePhone($homePhone)
            ->setId($id)
            ->setIsActive($isActive)
            ->setJobTitle($jobTitle)
            ->setLastName($lastName)
            ->setMobilePhone($mobilePhone)
            ->setPreferredCultureId($preferredCultureId)
            ->setRegion($region)
            ->setState($state);
    }
    /**
     * Get BusinessPhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBusinessPhone()
    {
        return isset($this->BusinessPhone) ? $this->BusinessPhone : null;
    }
    /**
     * Set BusinessPhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $businessPhone
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setBusinessPhone($businessPhone = null)
    {
        // validation for constraint: string
        if (!is_null($businessPhone) && !is_string($businessPhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($businessPhone, true), gettype($businessPhone)), __LINE__);
        }
        if (is_null($businessPhone) || (is_array($businessPhone) && empty($businessPhone))) {
            unset($this->BusinessPhone);
        } else {
            $this->BusinessPhone = $businessPhone;
        }
        return $this;
    }
    /**
     * Get City value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCity()
    {
        return isset($this->City) ? $this->City : null;
    }
    /**
     * Set City value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $city
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setCity(\patest\StructType\GlobalString $city = null)
    {
        if (is_null($city) || (is_array($city) && empty($city))) {
            unset($this->City);
        } else {
            $this->City = $city;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $country
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setCountry(\patest\StructType\GlobalString $country = null)
    {
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get Email value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmail()
    {
        return isset($this->Email) ? $this->Email : null;
    }
    /**
     * Set Email value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $email
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($email, true), gettype($email)), __LINE__);
        }
        if (is_null($email) || (is_array($email) && empty($email))) {
            unset($this->Email);
        } else {
            $this->Email = $email;
        }
        return $this;
    }
    /**
     * Get FirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstName()
    {
        return isset($this->FirstName) ? $this->FirstName : null;
    }
    /**
     * Set FirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstName
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setFirstName($firstName = null)
    {
        // validation for constraint: string
        if (!is_null($firstName) && !is_string($firstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstName, true), gettype($firstName)), __LINE__);
        }
        if (is_null($firstName) || (is_array($firstName) && empty($firstName))) {
            unset($this->FirstName);
        } else {
            $this->FirstName = $firstName;
        }
        return $this;
    }
    /**
     * Get Gender value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGender()
    {
        return isset($this->Gender) ? $this->Gender : null;
    }
    /**
     * Set Gender value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\GenderKind::valueIsValid()
     * @uses \patest\EnumType\GenderKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $gender
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setGender($gender = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\GenderKind::valueIsValid($gender)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\GenderKind', is_array($gender) ? implode(', ', $gender) : var_export($gender, true), implode(', ', \patest\EnumType\GenderKind::getValidValues())), __LINE__);
        }
        if (is_null($gender) || (is_array($gender) && empty($gender))) {
            unset($this->Gender);
        } else {
            $this->Gender = $gender;
        }
        return $this;
    }
    /**
     * Get HomeAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomeAddress()
    {
        return isset($this->HomeAddress) ? $this->HomeAddress : null;
    }
    /**
     * Set HomeAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homeAddress
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setHomeAddress($homeAddress = null)
    {
        // validation for constraint: string
        if (!is_null($homeAddress) && !is_string($homeAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homeAddress, true), gettype($homeAddress)), __LINE__);
        }
        if (is_null($homeAddress) || (is_array($homeAddress) && empty($homeAddress))) {
            unset($this->HomeAddress);
        } else {
            $this->HomeAddress = $homeAddress;
        }
        return $this;
    }
    /**
     * Get HomePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHomePhone()
    {
        return isset($this->HomePhone) ? $this->HomePhone : null;
    }
    /**
     * Set HomePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $homePhone
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setHomePhone($homePhone = null)
    {
        // validation for constraint: string
        if (!is_null($homePhone) && !is_string($homePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($homePhone, true), gettype($homePhone)), __LINE__);
        }
        if (is_null($homePhone) || (is_array($homePhone) && empty($homePhone))) {
            unset($this->HomePhone);
        } else {
            $this->HomePhone = $homePhone;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get JobTitle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getJobTitle()
    {
        return isset($this->JobTitle) ? $this->JobTitle : null;
    }
    /**
     * Set JobTitle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $jobTitle
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setJobTitle(\patest\StructType\GlobalString $jobTitle = null)
    {
        if (is_null($jobTitle) || (is_array($jobTitle) && empty($jobTitle))) {
            unset($this->JobTitle);
        } else {
            $this->JobTitle = $jobTitle;
        }
        return $this;
    }
    /**
     * Get LastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastName()
    {
        return isset($this->LastName) ? $this->LastName : null;
    }
    /**
     * Set LastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastName
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setLastName($lastName = null)
    {
        // validation for constraint: string
        if (!is_null($lastName) && !is_string($lastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastName, true), gettype($lastName)), __LINE__);
        }
        if (is_null($lastName) || (is_array($lastName) && empty($lastName))) {
            unset($this->LastName);
        } else {
            $this->LastName = $lastName;
        }
        return $this;
    }
    /**
     * Get MobilePhone value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMobilePhone()
    {
        return isset($this->MobilePhone) ? $this->MobilePhone : null;
    }
    /**
     * Set MobilePhone value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mobilePhone
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setMobilePhone($mobilePhone = null)
    {
        // validation for constraint: string
        if (!is_null($mobilePhone) && !is_string($mobilePhone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mobilePhone, true), gettype($mobilePhone)), __LINE__);
        }
        if (is_null($mobilePhone) || (is_array($mobilePhone) && empty($mobilePhone))) {
            unset($this->MobilePhone);
        } else {
            $this->MobilePhone = $mobilePhone;
        }
        return $this;
    }
    /**
     * Get PreferredCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPreferredCultureId()
    {
        return isset($this->PreferredCultureId) ? $this->PreferredCultureId : null;
    }
    /**
     * Set PreferredCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $preferredCultureId
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setPreferredCultureId($preferredCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($preferredCultureId) && !(is_int($preferredCultureId) || ctype_digit($preferredCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($preferredCultureId, true), gettype($preferredCultureId)), __LINE__);
        }
        if (is_null($preferredCultureId) || (is_array($preferredCultureId) && empty($preferredCultureId))) {
            unset($this->PreferredCultureId);
        } else {
            $this->PreferredCultureId = $preferredCultureId;
        }
        return $this;
    }
    /**
     * Get Region value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getRegion()
    {
        return isset($this->Region) ? $this->Region : null;
    }
    /**
     * Set Region value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $region
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setRegion(\patest\StructType\GlobalString $region = null)
    {
        if (is_null($region) || (is_array($region) && empty($region))) {
            unset($this->Region);
        } else {
            $this->Region = $region;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $state
     * @return \patest\StructType\Printing_PrintableItem_MarketingDocument
     */
    public function setState(\patest\StructType\GlobalString $state = null)
    {
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
}
