<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.InventoryForm StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_InventoryForm extends Printing_PrintableItem_Base
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountId;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comments;
    /**
     * The CompanyDiscountValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyDiscountValue;
    /**
     * The CompanyGrandTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyGrandTotal;
    /**
     * The CompanyTotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyTotalCost;
    /**
     * The CompanyTotalEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $CompanyTotalEsv;
    /**
     * The CurrencyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyName;
    /**
     * The CurrencyRate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CurrencyRate;
    /**
     * The DeliveryTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DeliveryTypeName;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DiscountPercent;
    /**
     * The DiscountValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DiscountValue;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The FormDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormDate;
    /**
     * The FormLines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryForm_Line
     */
    public $FormLines;
    /**
     * The FormNo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormNo;
    /**
     * The FormTemplateName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FormTemplateName;
    /**
     * The FormTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FormTypeName;
    /**
     * The FromLocaltionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $FromLocaltionName;
    /**
     * The GrandTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $GrandTotal;
    /**
     * The IsDelivered
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDelivered;
    /**
     * The IsFinalized
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsFinalized;
    /**
     * The IsOpeningStock
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOpeningStock;
    /**
     * The StockAdjReasonName
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $StockAdjReasonName;
    /**
     * The SupplierAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupplierAddress;
    /**
     * The SupplierName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SupplierName;
    /**
     * The ToLocaltionName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ToLocaltionName;
    /**
     * The TotalCost
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalCost;
    /**
     * The TotalEsv
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalEsv;
    /**
     * The TotalQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalQuantity;
    /**
     * Constructor method for Printing.PrintableItem.InventoryForm
     * @uses Printing_PrintableItem_InventoryForm::setAccountId()
     * @uses Printing_PrintableItem_InventoryForm::setComments()
     * @uses Printing_PrintableItem_InventoryForm::setCompanyDiscountValue()
     * @uses Printing_PrintableItem_InventoryForm::setCompanyGrandTotal()
     * @uses Printing_PrintableItem_InventoryForm::setCompanyTotalCost()
     * @uses Printing_PrintableItem_InventoryForm::setCompanyTotalEsv()
     * @uses Printing_PrintableItem_InventoryForm::setCurrencyName()
     * @uses Printing_PrintableItem_InventoryForm::setCurrencyRate()
     * @uses Printing_PrintableItem_InventoryForm::setDeliveryTypeName()
     * @uses Printing_PrintableItem_InventoryForm::setDiscountPercent()
     * @uses Printing_PrintableItem_InventoryForm::setDiscountValue()
     * @uses Printing_PrintableItem_InventoryForm::setDueDate()
     * @uses Printing_PrintableItem_InventoryForm::setFormDate()
     * @uses Printing_PrintableItem_InventoryForm::setFormLines()
     * @uses Printing_PrintableItem_InventoryForm::setFormNo()
     * @uses Printing_PrintableItem_InventoryForm::setFormTemplateName()
     * @uses Printing_PrintableItem_InventoryForm::setFormTypeName()
     * @uses Printing_PrintableItem_InventoryForm::setFromLocaltionName()
     * @uses Printing_PrintableItem_InventoryForm::setGrandTotal()
     * @uses Printing_PrintableItem_InventoryForm::setIsDelivered()
     * @uses Printing_PrintableItem_InventoryForm::setIsFinalized()
     * @uses Printing_PrintableItem_InventoryForm::setIsOpeningStock()
     * @uses Printing_PrintableItem_InventoryForm::setStockAdjReasonName()
     * @uses Printing_PrintableItem_InventoryForm::setSupplierAddress()
     * @uses Printing_PrintableItem_InventoryForm::setSupplierName()
     * @uses Printing_PrintableItem_InventoryForm::setToLocaltionName()
     * @uses Printing_PrintableItem_InventoryForm::setTotalCost()
     * @uses Printing_PrintableItem_InventoryForm::setTotalEsv()
     * @uses Printing_PrintableItem_InventoryForm::setTotalQuantity()
     * @param string $accountId
     * @param \patest\StructType\GlobalString $comments
     * @param \patest\StructType\Money $companyDiscountValue
     * @param \patest\StructType\Money $companyGrandTotal
     * @param \patest\StructType\Money $companyTotalCost
     * @param \patest\StructType\Money $companyTotalEsv
     * @param string $currencyName
     * @param float $currencyRate
     * @param \patest\StructType\GlobalString $deliveryTypeName
     * @param float $discountPercent
     * @param \patest\StructType\Money $discountValue
     * @param string $dueDate
     * @param string $formDate
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryForm_Line $formLines
     * @param string $formNo
     * @param \patest\StructType\GlobalString $formTemplateName
     * @param \patest\StructType\GlobalString $formTypeName
     * @param \patest\StructType\GlobalString $fromLocaltionName
     * @param \patest\StructType\Money $grandTotal
     * @param bool $isDelivered
     * @param bool $isFinalized
     * @param bool $isOpeningStock
     * @param string $stockAdjReasonName
     * @param string $supplierAddress
     * @param string $supplierName
     * @param \patest\StructType\GlobalString $toLocaltionName
     * @param \patest\StructType\Money $totalCost
     * @param \patest\StructType\Money $totalEsv
     * @param float $totalQuantity
     */
    public function __construct($accountId = null, \patest\StructType\GlobalString $comments = null, \patest\StructType\Money $companyDiscountValue = null, \patest\StructType\Money $companyGrandTotal = null, \patest\StructType\Money $companyTotalCost = null, \patest\StructType\Money $companyTotalEsv = null, $currencyName = null, $currencyRate = null, \patest\StructType\GlobalString $deliveryTypeName = null, $discountPercent = null, \patest\StructType\Money $discountValue = null, $dueDate = null, $formDate = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryForm_Line $formLines = null, $formNo = null, \patest\StructType\GlobalString $formTemplateName = null, \patest\StructType\GlobalString $formTypeName = null, \patest\StructType\GlobalString $fromLocaltionName = null, \patest\StructType\Money $grandTotal = null, $isDelivered = null, $isFinalized = null, $isOpeningStock = null, $stockAdjReasonName = null, $supplierAddress = null, $supplierName = null, \patest\StructType\GlobalString $toLocaltionName = null, \patest\StructType\Money $totalCost = null, \patest\StructType\Money $totalEsv = null, $totalQuantity = null)
    {
        $this
            ->setAccountId($accountId)
            ->setComments($comments)
            ->setCompanyDiscountValue($companyDiscountValue)
            ->setCompanyGrandTotal($companyGrandTotal)
            ->setCompanyTotalCost($companyTotalCost)
            ->setCompanyTotalEsv($companyTotalEsv)
            ->setCurrencyName($currencyName)
            ->setCurrencyRate($currencyRate)
            ->setDeliveryTypeName($deliveryTypeName)
            ->setDiscountPercent($discountPercent)
            ->setDiscountValue($discountValue)
            ->setDueDate($dueDate)
            ->setFormDate($formDate)
            ->setFormLines($formLines)
            ->setFormNo($formNo)
            ->setFormTemplateName($formTemplateName)
            ->setFormTypeName($formTypeName)
            ->setFromLocaltionName($fromLocaltionName)
            ->setGrandTotal($grandTotal)
            ->setIsDelivered($isDelivered)
            ->setIsFinalized($isFinalized)
            ->setIsOpeningStock($isOpeningStock)
            ->setStockAdjReasonName($stockAdjReasonName)
            ->setSupplierAddress($supplierAddress)
            ->setSupplierName($supplierName)
            ->setToLocaltionName($toLocaltionName)
            ->setTotalCost($totalCost)
            ->setTotalEsv($totalEsv)
            ->setTotalQuantity($totalQuantity);
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comments
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setComments(\patest\StructType\GlobalString $comments = null)
    {
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get CompanyDiscountValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyDiscountValue()
    {
        return isset($this->CompanyDiscountValue) ? $this->CompanyDiscountValue : null;
    }
    /**
     * Set CompanyDiscountValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyDiscountValue
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setCompanyDiscountValue(\patest\StructType\Money $companyDiscountValue = null)
    {
        if (is_null($companyDiscountValue) || (is_array($companyDiscountValue) && empty($companyDiscountValue))) {
            unset($this->CompanyDiscountValue);
        } else {
            $this->CompanyDiscountValue = $companyDiscountValue;
        }
        return $this;
    }
    /**
     * Get CompanyGrandTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyGrandTotal()
    {
        return isset($this->CompanyGrandTotal) ? $this->CompanyGrandTotal : null;
    }
    /**
     * Set CompanyGrandTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyGrandTotal
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setCompanyGrandTotal(\patest\StructType\Money $companyGrandTotal = null)
    {
        if (is_null($companyGrandTotal) || (is_array($companyGrandTotal) && empty($companyGrandTotal))) {
            unset($this->CompanyGrandTotal);
        } else {
            $this->CompanyGrandTotal = $companyGrandTotal;
        }
        return $this;
    }
    /**
     * Get CompanyTotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyTotalCost()
    {
        return isset($this->CompanyTotalCost) ? $this->CompanyTotalCost : null;
    }
    /**
     * Set CompanyTotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyTotalCost
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setCompanyTotalCost(\patest\StructType\Money $companyTotalCost = null)
    {
        if (is_null($companyTotalCost) || (is_array($companyTotalCost) && empty($companyTotalCost))) {
            unset($this->CompanyTotalCost);
        } else {
            $this->CompanyTotalCost = $companyTotalCost;
        }
        return $this;
    }
    /**
     * Get CompanyTotalEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getCompanyTotalEsv()
    {
        return isset($this->CompanyTotalEsv) ? $this->CompanyTotalEsv : null;
    }
    /**
     * Set CompanyTotalEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $companyTotalEsv
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setCompanyTotalEsv(\patest\StructType\Money $companyTotalEsv = null)
    {
        if (is_null($companyTotalEsv) || (is_array($companyTotalEsv) && empty($companyTotalEsv))) {
            unset($this->CompanyTotalEsv);
        } else {
            $this->CompanyTotalEsv = $companyTotalEsv;
        }
        return $this;
    }
    /**
     * Get CurrencyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyName()
    {
        return isset($this->CurrencyName) ? $this->CurrencyName : null;
    }
    /**
     * Set CurrencyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setCurrencyName($currencyName = null)
    {
        // validation for constraint: string
        if (!is_null($currencyName) && !is_string($currencyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyName, true), gettype($currencyName)), __LINE__);
        }
        if (is_null($currencyName) || (is_array($currencyName) && empty($currencyName))) {
            unset($this->CurrencyName);
        } else {
            $this->CurrencyName = $currencyName;
        }
        return $this;
    }
    /**
     * Get CurrencyRate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCurrencyRate()
    {
        return isset($this->CurrencyRate) ? $this->CurrencyRate : null;
    }
    /**
     * Set CurrencyRate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $currencyRate
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setCurrencyRate($currencyRate = null)
    {
        // validation for constraint: float
        if (!is_null($currencyRate) && !(is_float($currencyRate) || is_numeric($currencyRate))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($currencyRate, true), gettype($currencyRate)), __LINE__);
        }
        if (is_null($currencyRate) || (is_array($currencyRate) && empty($currencyRate))) {
            unset($this->CurrencyRate);
        } else {
            $this->CurrencyRate = $currencyRate;
        }
        return $this;
    }
    /**
     * Get DeliveryTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDeliveryTypeName()
    {
        return isset($this->DeliveryTypeName) ? $this->DeliveryTypeName : null;
    }
    /**
     * Set DeliveryTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $deliveryTypeName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setDeliveryTypeName(\patest\StructType\GlobalString $deliveryTypeName = null)
    {
        if (is_null($deliveryTypeName) || (is_array($deliveryTypeName) && empty($deliveryTypeName))) {
            unset($this->DeliveryTypeName);
        } else {
            $this->DeliveryTypeName = $deliveryTypeName;
        }
        return $this;
    }
    /**
     * Get DiscountPercent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return isset($this->DiscountPercent) ? $this->DiscountPercent : null;
    }
    /**
     * Set DiscountPercent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $discountPercent
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        if (is_null($discountPercent) || (is_array($discountPercent) && empty($discountPercent))) {
            unset($this->DiscountPercent);
        } else {
            $this->DiscountPercent = $discountPercent;
        }
        return $this;
    }
    /**
     * Get DiscountValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDiscountValue()
    {
        return isset($this->DiscountValue) ? $this->DiscountValue : null;
    }
    /**
     * Set DiscountValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $discountValue
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setDiscountValue(\patest\StructType\Money $discountValue = null)
    {
        if (is_null($discountValue) || (is_array($discountValue) && empty($discountValue))) {
            unset($this->DiscountValue);
        } else {
            $this->DiscountValue = $discountValue;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDate
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get FormDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormDate()
    {
        return isset($this->FormDate) ? $this->FormDate : null;
    }
    /**
     * Set FormDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formDate
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setFormDate($formDate = null)
    {
        // validation for constraint: string
        if (!is_null($formDate) && !is_string($formDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formDate, true), gettype($formDate)), __LINE__);
        }
        if (is_null($formDate) || (is_array($formDate) && empty($formDate))) {
            unset($this->FormDate);
        } else {
            $this->FormDate = $formDate;
        }
        return $this;
    }
    /**
     * Get FormLines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryForm_Line|null
     */
    public function getFormLines()
    {
        return isset($this->FormLines) ? $this->FormLines : null;
    }
    /**
     * Set FormLines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryForm_Line $formLines
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setFormLines(\patest\StructType\RecordSetOfPrinting_PrintableItem_InventoryForm_Line $formLines = null)
    {
        if (is_null($formLines) || (is_array($formLines) && empty($formLines))) {
            unset($this->FormLines);
        } else {
            $this->FormLines = $formLines;
        }
        return $this;
    }
    /**
     * Get FormNo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormNo()
    {
        return isset($this->FormNo) ? $this->FormNo : null;
    }
    /**
     * Set FormNo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formNo
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setFormNo($formNo = null)
    {
        // validation for constraint: string
        if (!is_null($formNo) && !is_string($formNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formNo, true), gettype($formNo)), __LINE__);
        }
        if (is_null($formNo) || (is_array($formNo) && empty($formNo))) {
            unset($this->FormNo);
        } else {
            $this->FormNo = $formNo;
        }
        return $this;
    }
    /**
     * Get FormTemplateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFormTemplateName()
    {
        return isset($this->FormTemplateName) ? $this->FormTemplateName : null;
    }
    /**
     * Set FormTemplateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $formTemplateName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setFormTemplateName(\patest\StructType\GlobalString $formTemplateName = null)
    {
        if (is_null($formTemplateName) || (is_array($formTemplateName) && empty($formTemplateName))) {
            unset($this->FormTemplateName);
        } else {
            $this->FormTemplateName = $formTemplateName;
        }
        return $this;
    }
    /**
     * Get FormTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFormTypeName()
    {
        return isset($this->FormTypeName) ? $this->FormTypeName : null;
    }
    /**
     * Set FormTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $formTypeName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setFormTypeName(\patest\StructType\GlobalString $formTypeName = null)
    {
        if (is_null($formTypeName) || (is_array($formTypeName) && empty($formTypeName))) {
            unset($this->FormTypeName);
        } else {
            $this->FormTypeName = $formTypeName;
        }
        return $this;
    }
    /**
     * Get FromLocaltionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFromLocaltionName()
    {
        return isset($this->FromLocaltionName) ? $this->FromLocaltionName : null;
    }
    /**
     * Set FromLocaltionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fromLocaltionName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setFromLocaltionName(\patest\StructType\GlobalString $fromLocaltionName = null)
    {
        if (is_null($fromLocaltionName) || (is_array($fromLocaltionName) && empty($fromLocaltionName))) {
            unset($this->FromLocaltionName);
        } else {
            $this->FromLocaltionName = $fromLocaltionName;
        }
        return $this;
    }
    /**
     * Get GrandTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getGrandTotal()
    {
        return isset($this->GrandTotal) ? $this->GrandTotal : null;
    }
    /**
     * Set GrandTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $grandTotal
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setGrandTotal(\patest\StructType\Money $grandTotal = null)
    {
        if (is_null($grandTotal) || (is_array($grandTotal) && empty($grandTotal))) {
            unset($this->GrandTotal);
        } else {
            $this->GrandTotal = $grandTotal;
        }
        return $this;
    }
    /**
     * Get IsDelivered value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDelivered()
    {
        return isset($this->IsDelivered) ? $this->IsDelivered : null;
    }
    /**
     * Set IsDelivered value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDelivered
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setIsDelivered($isDelivered = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDelivered) && !is_bool($isDelivered)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDelivered, true), gettype($isDelivered)), __LINE__);
        }
        if (is_null($isDelivered) || (is_array($isDelivered) && empty($isDelivered))) {
            unset($this->IsDelivered);
        } else {
            $this->IsDelivered = $isDelivered;
        }
        return $this;
    }
    /**
     * Get IsFinalized value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsFinalized()
    {
        return isset($this->IsFinalized) ? $this->IsFinalized : null;
    }
    /**
     * Set IsFinalized value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isFinalized
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setIsFinalized($isFinalized = null)
    {
        // validation for constraint: boolean
        if (!is_null($isFinalized) && !is_bool($isFinalized)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isFinalized, true), gettype($isFinalized)), __LINE__);
        }
        if (is_null($isFinalized) || (is_array($isFinalized) && empty($isFinalized))) {
            unset($this->IsFinalized);
        } else {
            $this->IsFinalized = $isFinalized;
        }
        return $this;
    }
    /**
     * Get IsOpeningStock value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOpeningStock()
    {
        return isset($this->IsOpeningStock) ? $this->IsOpeningStock : null;
    }
    /**
     * Set IsOpeningStock value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOpeningStock
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setIsOpeningStock($isOpeningStock = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOpeningStock) && !is_bool($isOpeningStock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOpeningStock, true), gettype($isOpeningStock)), __LINE__);
        }
        if (is_null($isOpeningStock) || (is_array($isOpeningStock) && empty($isOpeningStock))) {
            unset($this->IsOpeningStock);
        } else {
            $this->IsOpeningStock = $isOpeningStock;
        }
        return $this;
    }
    /**
     * Get StockAdjReasonName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStockAdjReasonName()
    {
        return isset($this->StockAdjReasonName) ? $this->StockAdjReasonName : null;
    }
    /**
     * Set StockAdjReasonName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stockAdjReasonName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setStockAdjReasonName($stockAdjReasonName = null)
    {
        // validation for constraint: string
        if (!is_null($stockAdjReasonName) && !is_string($stockAdjReasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stockAdjReasonName, true), gettype($stockAdjReasonName)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($stockAdjReasonName) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $stockAdjReasonName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($stockAdjReasonName, true)), __LINE__);
        }
        if (is_null($stockAdjReasonName) || (is_array($stockAdjReasonName) && empty($stockAdjReasonName))) {
            unset($this->StockAdjReasonName);
        } else {
            $this->StockAdjReasonName = $stockAdjReasonName;
        }
        return $this;
    }
    /**
     * Get SupplierAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierAddress()
    {
        return isset($this->SupplierAddress) ? $this->SupplierAddress : null;
    }
    /**
     * Set SupplierAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierAddress
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setSupplierAddress($supplierAddress = null)
    {
        // validation for constraint: string
        if (!is_null($supplierAddress) && !is_string($supplierAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierAddress, true), gettype($supplierAddress)), __LINE__);
        }
        if (is_null($supplierAddress) || (is_array($supplierAddress) && empty($supplierAddress))) {
            unset($this->SupplierAddress);
        } else {
            $this->SupplierAddress = $supplierAddress;
        }
        return $this;
    }
    /**
     * Get SupplierName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSupplierName()
    {
        return isset($this->SupplierName) ? $this->SupplierName : null;
    }
    /**
     * Set SupplierName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $supplierName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setSupplierName($supplierName = null)
    {
        // validation for constraint: string
        if (!is_null($supplierName) && !is_string($supplierName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($supplierName, true), gettype($supplierName)), __LINE__);
        }
        if (is_null($supplierName) || (is_array($supplierName) && empty($supplierName))) {
            unset($this->SupplierName);
        } else {
            $this->SupplierName = $supplierName;
        }
        return $this;
    }
    /**
     * Get ToLocaltionName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getToLocaltionName()
    {
        return isset($this->ToLocaltionName) ? $this->ToLocaltionName : null;
    }
    /**
     * Set ToLocaltionName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $toLocaltionName
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setToLocaltionName(\patest\StructType\GlobalString $toLocaltionName = null)
    {
        if (is_null($toLocaltionName) || (is_array($toLocaltionName) && empty($toLocaltionName))) {
            unset($this->ToLocaltionName);
        } else {
            $this->ToLocaltionName = $toLocaltionName;
        }
        return $this;
    }
    /**
     * Get TotalCost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalCost()
    {
        return isset($this->TotalCost) ? $this->TotalCost : null;
    }
    /**
     * Set TotalCost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalCost
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setTotalCost(\patest\StructType\Money $totalCost = null)
    {
        if (is_null($totalCost) || (is_array($totalCost) && empty($totalCost))) {
            unset($this->TotalCost);
        } else {
            $this->TotalCost = $totalCost;
        }
        return $this;
    }
    /**
     * Get TotalEsv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalEsv()
    {
        return isset($this->TotalEsv) ? $this->TotalEsv : null;
    }
    /**
     * Set TotalEsv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalEsv
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setTotalEsv(\patest\StructType\Money $totalEsv = null)
    {
        if (is_null($totalEsv) || (is_array($totalEsv) && empty($totalEsv))) {
            unset($this->TotalEsv);
        } else {
            $this->TotalEsv = $totalEsv;
        }
        return $this;
    }
    /**
     * Get TotalQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalQuantity()
    {
        return isset($this->TotalQuantity) ? $this->TotalQuantity : null;
    }
    /**
     * Set TotalQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalQuantity
     * @return \patest\StructType\Printing_PrintableItem_InventoryForm
     */
    public function setTotalQuantity($totalQuantity = null)
    {
        // validation for constraint: float
        if (!is_null($totalQuantity) && !(is_float($totalQuantity) || is_numeric($totalQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalQuantity, true), gettype($totalQuantity)), __LINE__);
        }
        if (is_null($totalQuantity) || (is_array($totalQuantity) && empty($totalQuantity))) {
            unset($this->TotalQuantity);
        } else {
            $this->TotalQuantity = $totalQuantity;
        }
        return $this;
    }
}
