<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.DraftInvoice StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_DraftInvoice extends Printing_PrintableItem_Base
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The Deposits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit
     */
    public $Deposits;
    /**
     * The GlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalNumber;
    /**
     * The ItemRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceItemsGroupRecord
     */
    public $ItemRecords;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The PurposeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PurposeName;
    /**
     * The ReferencedDeposits
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit
     */
    public $ReferencedDeposits;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The TotalAccountCreditAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAccountCreditAmount;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The TotalAmountDue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmountDue;
    /**
     * The TotalAproximateCommission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAproximateCommission;
    /**
     * The TotalItemCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalItemCommissionAmount;
    /**
     * The TotalItemFacePrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalItemFacePrice;
    /**
     * The TotalTax
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTax;
    /**
     * Constructor method for Printing.PrintableItem.DraftInvoice
     * @uses Printing_PrintableItem_DraftInvoice::setClientId()
     * @uses Printing_PrintableItem_DraftInvoice::setCreationDateTime()
     * @uses Printing_PrintableItem_DraftInvoice::setDeposits()
     * @uses Printing_PrintableItem_DraftInvoice::setGlobalNumber()
     * @uses Printing_PrintableItem_DraftInvoice::setItemRecords()
     * @uses Printing_PrintableItem_DraftInvoice::setPaidAmount()
     * @uses Printing_PrintableItem_DraftInvoice::setPurposeName()
     * @uses Printing_PrintableItem_DraftInvoice::setReferencedDeposits()
     * @uses Printing_PrintableItem_DraftInvoice::setRemark()
     * @uses Printing_PrintableItem_DraftInvoice::setTotalAccountCreditAmount()
     * @uses Printing_PrintableItem_DraftInvoice::setTotalAmount()
     * @uses Printing_PrintableItem_DraftInvoice::setTotalAmountDue()
     * @uses Printing_PrintableItem_DraftInvoice::setTotalAproximateCommission()
     * @uses Printing_PrintableItem_DraftInvoice::setTotalItemCommissionAmount()
     * @uses Printing_PrintableItem_DraftInvoice::setTotalItemFacePrice()
     * @uses Printing_PrintableItem_DraftInvoice::setTotalTax()
     * @param string $clientId
     * @param string $creationDateTime
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit $deposits
     * @param int $globalNumber
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceItemsGroupRecord $itemRecords
     * @param \patest\StructType\Money $paidAmount
     * @param \patest\StructType\GlobalString $purposeName
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit $referencedDeposits
     * @param string $remark
     * @param \patest\StructType\Money $totalAccountCreditAmount
     * @param \patest\StructType\Money $totalAmount
     * @param \patest\StructType\Money $totalAmountDue
     * @param \patest\StructType\Money $totalAproximateCommission
     * @param \patest\StructType\Money $totalItemCommissionAmount
     * @param \patest\StructType\Money $totalItemFacePrice
     * @param \patest\StructType\Money $totalTax
     */
    public function __construct($clientId = null, $creationDateTime = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit $deposits = null, $globalNumber = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceItemsGroupRecord $itemRecords = null, \patest\StructType\Money $paidAmount = null, \patest\StructType\GlobalString $purposeName = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit $referencedDeposits = null, $remark = null, \patest\StructType\Money $totalAccountCreditAmount = null, \patest\StructType\Money $totalAmount = null, \patest\StructType\Money $totalAmountDue = null, \patest\StructType\Money $totalAproximateCommission = null, \patest\StructType\Money $totalItemCommissionAmount = null, \patest\StructType\Money $totalItemFacePrice = null, \patest\StructType\Money $totalTax = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreationDateTime($creationDateTime)
            ->setDeposits($deposits)
            ->setGlobalNumber($globalNumber)
            ->setItemRecords($itemRecords)
            ->setPaidAmount($paidAmount)
            ->setPurposeName($purposeName)
            ->setReferencedDeposits($referencedDeposits)
            ->setRemark($remark)
            ->setTotalAccountCreditAmount($totalAccountCreditAmount)
            ->setTotalAmount($totalAmount)
            ->setTotalAmountDue($totalAmountDue)
            ->setTotalAproximateCommission($totalAproximateCommission)
            ->setTotalItemCommissionAmount($totalItemCommissionAmount)
            ->setTotalItemFacePrice($totalItemFacePrice)
            ->setTotalTax($totalTax);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get Deposits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit|null
     */
    public function getDeposits()
    {
        return isset($this->Deposits) ? $this->Deposits : null;
    }
    /**
     * Set Deposits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit $deposits
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setDeposits(\patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit $deposits = null)
    {
        if (is_null($deposits) || (is_array($deposits) && empty($deposits))) {
            unset($this->Deposits);
        } else {
            $this->Deposits = $deposits;
        }
        return $this;
    }
    /**
     * Get GlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalNumber()
    {
        return isset($this->GlobalNumber) ? $this->GlobalNumber : null;
    }
    /**
     * Set GlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalNumber
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setGlobalNumber($globalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($globalNumber) && !(is_int($globalNumber) || ctype_digit($globalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalNumber, true), gettype($globalNumber)), __LINE__);
        }
        if (is_null($globalNumber) || (is_array($globalNumber) && empty($globalNumber))) {
            unset($this->GlobalNumber);
        } else {
            $this->GlobalNumber = $globalNumber;
        }
        return $this;
    }
    /**
     * Get ItemRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceItemsGroupRecord|null
     */
    public function getItemRecords()
    {
        return isset($this->ItemRecords) ? $this->ItemRecords : null;
    }
    /**
     * Set ItemRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceItemsGroupRecord $itemRecords
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setItemRecords(\patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceItemsGroupRecord $itemRecords = null)
    {
        if (is_null($itemRecords) || (is_array($itemRecords) && empty($itemRecords))) {
            unset($this->ItemRecords);
        } else {
            $this->ItemRecords = $itemRecords;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get PurposeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPurposeName()
    {
        return isset($this->PurposeName) ? $this->PurposeName : null;
    }
    /**
     * Set PurposeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $purposeName
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setPurposeName(\patest\StructType\GlobalString $purposeName = null)
    {
        if (is_null($purposeName) || (is_array($purposeName) && empty($purposeName))) {
            unset($this->PurposeName);
        } else {
            $this->PurposeName = $purposeName;
        }
        return $this;
    }
    /**
     * Get ReferencedDeposits value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit|null
     */
    public function getReferencedDeposits()
    {
        return isset($this->ReferencedDeposits) ? $this->ReferencedDeposits : null;
    }
    /**
     * Set ReferencedDeposits value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit $referencedDeposits
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setReferencedDeposits(\patest\StructType\RecordSetOfPrinting_PrintableItem_DraftInvoiceDeposit $referencedDeposits = null)
    {
        if (is_null($referencedDeposits) || (is_array($referencedDeposits) && empty($referencedDeposits))) {
            unset($this->ReferencedDeposits);
        } else {
            $this->ReferencedDeposits = $referencedDeposits;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get TotalAccountCreditAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAccountCreditAmount()
    {
        return isset($this->TotalAccountCreditAmount) ? $this->TotalAccountCreditAmount : null;
    }
    /**
     * Set TotalAccountCreditAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAccountCreditAmount
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setTotalAccountCreditAmount(\patest\StructType\Money $totalAccountCreditAmount = null)
    {
        if (is_null($totalAccountCreditAmount) || (is_array($totalAccountCreditAmount) && empty($totalAccountCreditAmount))) {
            unset($this->TotalAccountCreditAmount);
        } else {
            $this->TotalAccountCreditAmount = $totalAccountCreditAmount;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TotalAmountDue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmountDue()
    {
        return isset($this->TotalAmountDue) ? $this->TotalAmountDue : null;
    }
    /**
     * Set TotalAmountDue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmountDue
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setTotalAmountDue(\patest\StructType\Money $totalAmountDue = null)
    {
        if (is_null($totalAmountDue) || (is_array($totalAmountDue) && empty($totalAmountDue))) {
            unset($this->TotalAmountDue);
        } else {
            $this->TotalAmountDue = $totalAmountDue;
        }
        return $this;
    }
    /**
     * Get TotalAproximateCommission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAproximateCommission()
    {
        return isset($this->TotalAproximateCommission) ? $this->TotalAproximateCommission : null;
    }
    /**
     * Set TotalAproximateCommission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAproximateCommission
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setTotalAproximateCommission(\patest\StructType\Money $totalAproximateCommission = null)
    {
        if (is_null($totalAproximateCommission) || (is_array($totalAproximateCommission) && empty($totalAproximateCommission))) {
            unset($this->TotalAproximateCommission);
        } else {
            $this->TotalAproximateCommission = $totalAproximateCommission;
        }
        return $this;
    }
    /**
     * Get TotalItemCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalItemCommissionAmount()
    {
        return isset($this->TotalItemCommissionAmount) ? $this->TotalItemCommissionAmount : null;
    }
    /**
     * Set TotalItemCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalItemCommissionAmount
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setTotalItemCommissionAmount(\patest\StructType\Money $totalItemCommissionAmount = null)
    {
        if (is_null($totalItemCommissionAmount) || (is_array($totalItemCommissionAmount) && empty($totalItemCommissionAmount))) {
            unset($this->TotalItemCommissionAmount);
        } else {
            $this->TotalItemCommissionAmount = $totalItemCommissionAmount;
        }
        return $this;
    }
    /**
     * Get TotalItemFacePrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalItemFacePrice()
    {
        return isset($this->TotalItemFacePrice) ? $this->TotalItemFacePrice : null;
    }
    /**
     * Set TotalItemFacePrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalItemFacePrice
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setTotalItemFacePrice(\patest\StructType\Money $totalItemFacePrice = null)
    {
        if (is_null($totalItemFacePrice) || (is_array($totalItemFacePrice) && empty($totalItemFacePrice))) {
            unset($this->TotalItemFacePrice);
        } else {
            $this->TotalItemFacePrice = $totalItemFacePrice;
        }
        return $this;
    }
    /**
     * Get TotalTax value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTax()
    {
        return isset($this->TotalTax) ? $this->TotalTax : null;
    }
    /**
     * Set TotalTax value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTax
     * @return \patest\StructType\Printing_PrintableItem_DraftInvoice
     */
    public function setTotalTax(\patest\StructType\Money $totalTax = null)
    {
        if (is_null($totalTax) || (is_array($totalTax) && empty($totalTax))) {
            unset($this->TotalTax);
        } else {
            $this->TotalTax = $totalTax;
        }
        return $this;
    }
}
