<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.DonationThankYouLetter StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_DonationThankYouLetter extends Printing_PrintableItem_DonationBase
{
    /**
     * The Donations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo
     */
    public $Donations;
    /**
     * The TotalDonatedAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalDonatedAmount;
    /**
     * Constructor method for Printing.PrintableItem.DonationThankYouLetter
     * @uses Printing_PrintableItem_DonationThankYouLetter::setDonations()
     * @uses Printing_PrintableItem_DonationThankYouLetter::setTotalDonatedAmount()
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo $donations
     * @param float $totalDonatedAmount
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo $donations = null, $totalDonatedAmount = null)
    {
        $this
            ->setDonations($donations)
            ->setTotalDonatedAmount($totalDonatedAmount);
    }
    /**
     * Get Donations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo|null
     */
    public function getDonations()
    {
        return isset($this->Donations) ? $this->Donations : null;
    }
    /**
     * Set Donations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo $donations
     * @return \patest\StructType\Printing_PrintableItem_DonationThankYouLetter
     */
    public function setDonations(\patest\StructType\RecordSetOfPrinting_PrintableItem_DonationInfo $donations = null)
    {
        if (is_null($donations) || (is_array($donations) && empty($donations))) {
            unset($this->Donations);
        } else {
            $this->Donations = $donations;
        }
        return $this;
    }
    /**
     * Get TotalDonatedAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalDonatedAmount()
    {
        return isset($this->TotalDonatedAmount) ? $this->TotalDonatedAmount : null;
    }
    /**
     * Set TotalDonatedAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalDonatedAmount
     * @return \patest\StructType\Printing_PrintableItem_DonationThankYouLetter
     */
    public function setTotalDonatedAmount($totalDonatedAmount = null)
    {
        // validation for constraint: float
        if (!is_null($totalDonatedAmount) && !(is_float($totalDonatedAmount) || is_numeric($totalDonatedAmount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($totalDonatedAmount, true), gettype($totalDonatedAmount)), __LINE__);
        }
        if (is_null($totalDonatedAmount) || (is_array($totalDonatedAmount) && empty($totalDonatedAmount))) {
            unset($this->TotalDonatedAmount);
        } else {
            $this->TotalDonatedAmount = $totalDonatedAmount;
        }
        return $this;
    }
}
