<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.DonationInfo StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_DonationInfo extends Printing_PrintableItem_DonationBase
{
    /**
     * The Appeal_Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Appeal_Description;
    /**
     * The Appeal_Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Appeal_Id;
    /**
     * The Appeal_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Appeal_Name;
    /**
     * The Campaign_Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Campaign_Description;
    /**
     * The Campaign_Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Campaign_Id;
    /**
     * The Campaign_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Campaign_Name;
    /**
     * The DonationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DonationDate;
    /**
     * The Donation_Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Donation_Description;
    /**
     * The Donation_Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Donation_Id;
    /**
     * The Donation_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Donation_Name;
    /**
     * The Fund_Description
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Fund_Description;
    /**
     * The Fund_Id
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Fund_Id;
    /**
     * The Fund_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Fund_Name;
    /**
     * The GenerateTaxStatement
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateTaxStatement;
    /**
     * The GenerateThankYouLetter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $GenerateThankYouLetter;
    /**
     * The Solicitor_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Solicitor_Name;
    /**
     * The TaxStatementNumbers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxStatementNumbers;
    /**
     * The TaxStatementPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TaxStatementPrintCount;
    /**
     * The TaxStatementPrintedOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TaxStatementPrintedOn;
    /**
     * The ThankYouLetterPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ThankYouLetterPrintCount;
    /**
     * The ThankYouLetterSpecialMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ThankYouLetterSpecialMessage;
    /**
     * The TributeLetterPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TributeLetterPrintCount;
    /**
     * The TributeLetterSpecialMessage
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeLetterSpecialMessage;
    /**
     * The TributeTargetEmailAddress
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeTargetEmailAddress;
    /**
     * The TributeTo_Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeTo_Name;
    /**
     * The TributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeType;
    /**
     * The TributeTypeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TributeTypeText;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Value;
    /**
     * Constructor method for Printing.PrintableItem.DonationInfo
     * @uses Printing_PrintableItem_DonationInfo::setAppeal_Description()
     * @uses Printing_PrintableItem_DonationInfo::setAppeal_Id()
     * @uses Printing_PrintableItem_DonationInfo::setAppeal_Name()
     * @uses Printing_PrintableItem_DonationInfo::setCampaign_Description()
     * @uses Printing_PrintableItem_DonationInfo::setCampaign_Id()
     * @uses Printing_PrintableItem_DonationInfo::setCampaign_Name()
     * @uses Printing_PrintableItem_DonationInfo::setDonationDate()
     * @uses Printing_PrintableItem_DonationInfo::setDonation_Description()
     * @uses Printing_PrintableItem_DonationInfo::setDonation_Id()
     * @uses Printing_PrintableItem_DonationInfo::setDonation_Name()
     * @uses Printing_PrintableItem_DonationInfo::setFund_Description()
     * @uses Printing_PrintableItem_DonationInfo::setFund_Id()
     * @uses Printing_PrintableItem_DonationInfo::setFund_Name()
     * @uses Printing_PrintableItem_DonationInfo::setGenerateTaxStatement()
     * @uses Printing_PrintableItem_DonationInfo::setGenerateThankYouLetter()
     * @uses Printing_PrintableItem_DonationInfo::setSolicitor_Name()
     * @uses Printing_PrintableItem_DonationInfo::setTaxStatementNumbers()
     * @uses Printing_PrintableItem_DonationInfo::setTaxStatementPrintCount()
     * @uses Printing_PrintableItem_DonationInfo::setTaxStatementPrintedOn()
     * @uses Printing_PrintableItem_DonationInfo::setThankYouLetterPrintCount()
     * @uses Printing_PrintableItem_DonationInfo::setThankYouLetterSpecialMessage()
     * @uses Printing_PrintableItem_DonationInfo::setTributeLetterPrintCount()
     * @uses Printing_PrintableItem_DonationInfo::setTributeLetterSpecialMessage()
     * @uses Printing_PrintableItem_DonationInfo::setTributeTargetEmailAddress()
     * @uses Printing_PrintableItem_DonationInfo::setTributeTo_Name()
     * @uses Printing_PrintableItem_DonationInfo::setTributeType()
     * @uses Printing_PrintableItem_DonationInfo::setTributeTypeText()
     * @uses Printing_PrintableItem_DonationInfo::setValue()
     * @param \patest\StructType\GlobalString $appeal_Description
     * @param string $appeal_Id
     * @param \patest\StructType\GlobalString $appeal_Name
     * @param \patest\StructType\GlobalString $campaign_Description
     * @param string $campaign_Id
     * @param \patest\StructType\GlobalString $campaign_Name
     * @param string $donationDate
     * @param \patest\StructType\GlobalString $donation_Description
     * @param string $donation_Id
     * @param \patest\StructType\GlobalString $donation_Name
     * @param \patest\StructType\GlobalString $fund_Description
     * @param string $fund_Id
     * @param \patest\StructType\GlobalString $fund_Name
     * @param bool $generateTaxStatement
     * @param bool $generateThankYouLetter
     * @param \patest\StructType\GlobalString $solicitor_Name
     * @param string $taxStatementNumbers
     * @param int $taxStatementPrintCount
     * @param string $taxStatementPrintedOn
     * @param int $thankYouLetterPrintCount
     * @param string $thankYouLetterSpecialMessage
     * @param int $tributeLetterPrintCount
     * @param string $tributeLetterSpecialMessage
     * @param string $tributeTargetEmailAddress
     * @param string $tributeTo_Name
     * @param string $tributeType
     * @param string $tributeTypeText
     * @param float $value
     */
    public function __construct(\patest\StructType\GlobalString $appeal_Description = null, $appeal_Id = null, \patest\StructType\GlobalString $appeal_Name = null, \patest\StructType\GlobalString $campaign_Description = null, $campaign_Id = null, \patest\StructType\GlobalString $campaign_Name = null, $donationDate = null, \patest\StructType\GlobalString $donation_Description = null, $donation_Id = null, \patest\StructType\GlobalString $donation_Name = null, \patest\StructType\GlobalString $fund_Description = null, $fund_Id = null, \patest\StructType\GlobalString $fund_Name = null, $generateTaxStatement = null, $generateThankYouLetter = null, \patest\StructType\GlobalString $solicitor_Name = null, $taxStatementNumbers = null, $taxStatementPrintCount = null, $taxStatementPrintedOn = null, $thankYouLetterPrintCount = null, $thankYouLetterSpecialMessage = null, $tributeLetterPrintCount = null, $tributeLetterSpecialMessage = null, $tributeTargetEmailAddress = null, $tributeTo_Name = null, $tributeType = null, $tributeTypeText = null, $value = null)
    {
        $this
            ->setAppeal_Description($appeal_Description)
            ->setAppeal_Id($appeal_Id)
            ->setAppeal_Name($appeal_Name)
            ->setCampaign_Description($campaign_Description)
            ->setCampaign_Id($campaign_Id)
            ->setCampaign_Name($campaign_Name)
            ->setDonationDate($donationDate)
            ->setDonation_Description($donation_Description)
            ->setDonation_Id($donation_Id)
            ->setDonation_Name($donation_Name)
            ->setFund_Description($fund_Description)
            ->setFund_Id($fund_Id)
            ->setFund_Name($fund_Name)
            ->setGenerateTaxStatement($generateTaxStatement)
            ->setGenerateThankYouLetter($generateThankYouLetter)
            ->setSolicitor_Name($solicitor_Name)
            ->setTaxStatementNumbers($taxStatementNumbers)
            ->setTaxStatementPrintCount($taxStatementPrintCount)
            ->setTaxStatementPrintedOn($taxStatementPrintedOn)
            ->setThankYouLetterPrintCount($thankYouLetterPrintCount)
            ->setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage)
            ->setTributeLetterPrintCount($tributeLetterPrintCount)
            ->setTributeLetterSpecialMessage($tributeLetterSpecialMessage)
            ->setTributeTargetEmailAddress($tributeTargetEmailAddress)
            ->setTributeTo_Name($tributeTo_Name)
            ->setTributeType($tributeType)
            ->setTributeTypeText($tributeTypeText)
            ->setValue($value);
    }
    /**
     * Get Appeal_Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAppeal_Description()
    {
        return isset($this->Appeal_Description) ? $this->Appeal_Description : null;
    }
    /**
     * Set Appeal_Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $appeal_Description
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setAppeal_Description(\patest\StructType\GlobalString $appeal_Description = null)
    {
        if (is_null($appeal_Description) || (is_array($appeal_Description) && empty($appeal_Description))) {
            unset($this->Appeal_Description);
        } else {
            $this->Appeal_Description = $appeal_Description;
        }
        return $this;
    }
    /**
     * Get Appeal_Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppeal_Id()
    {
        return isset($this->Appeal_Id) ? $this->Appeal_Id : null;
    }
    /**
     * Set Appeal_Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appeal_Id
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setAppeal_Id($appeal_Id = null)
    {
        // validation for constraint: string
        if (!is_null($appeal_Id) && !is_string($appeal_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appeal_Id, true), gettype($appeal_Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appeal_Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appeal_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appeal_Id, true)), __LINE__);
        }
        if (is_null($appeal_Id) || (is_array($appeal_Id) && empty($appeal_Id))) {
            unset($this->Appeal_Id);
        } else {
            $this->Appeal_Id = $appeal_Id;
        }
        return $this;
    }
    /**
     * Get Appeal_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAppeal_Name()
    {
        return isset($this->Appeal_Name) ? $this->Appeal_Name : null;
    }
    /**
     * Set Appeal_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $appeal_Name
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setAppeal_Name(\patest\StructType\GlobalString $appeal_Name = null)
    {
        if (is_null($appeal_Name) || (is_array($appeal_Name) && empty($appeal_Name))) {
            unset($this->Appeal_Name);
        } else {
            $this->Appeal_Name = $appeal_Name;
        }
        return $this;
    }
    /**
     * Get Campaign_Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCampaign_Description()
    {
        return isset($this->Campaign_Description) ? $this->Campaign_Description : null;
    }
    /**
     * Set Campaign_Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $campaign_Description
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setCampaign_Description(\patest\StructType\GlobalString $campaign_Description = null)
    {
        if (is_null($campaign_Description) || (is_array($campaign_Description) && empty($campaign_Description))) {
            unset($this->Campaign_Description);
        } else {
            $this->Campaign_Description = $campaign_Description;
        }
        return $this;
    }
    /**
     * Get Campaign_Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaign_Id()
    {
        return isset($this->Campaign_Id) ? $this->Campaign_Id : null;
    }
    /**
     * Set Campaign_Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaign_Id
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setCampaign_Id($campaign_Id = null)
    {
        // validation for constraint: string
        if (!is_null($campaign_Id) && !is_string($campaign_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaign_Id, true), gettype($campaign_Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaign_Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaign_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaign_Id, true)), __LINE__);
        }
        if (is_null($campaign_Id) || (is_array($campaign_Id) && empty($campaign_Id))) {
            unset($this->Campaign_Id);
        } else {
            $this->Campaign_Id = $campaign_Id;
        }
        return $this;
    }
    /**
     * Get Campaign_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCampaign_Name()
    {
        return isset($this->Campaign_Name) ? $this->Campaign_Name : null;
    }
    /**
     * Set Campaign_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $campaign_Name
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setCampaign_Name(\patest\StructType\GlobalString $campaign_Name = null)
    {
        if (is_null($campaign_Name) || (is_array($campaign_Name) && empty($campaign_Name))) {
            unset($this->Campaign_Name);
        } else {
            $this->Campaign_Name = $campaign_Name;
        }
        return $this;
    }
    /**
     * Get DonationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonationDate()
    {
        return isset($this->DonationDate) ? $this->DonationDate : null;
    }
    /**
     * Set DonationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donationDate
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setDonationDate($donationDate = null)
    {
        // validation for constraint: string
        if (!is_null($donationDate) && !is_string($donationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donationDate, true), gettype($donationDate)), __LINE__);
        }
        if (is_null($donationDate) || (is_array($donationDate) && empty($donationDate))) {
            unset($this->DonationDate);
        } else {
            $this->DonationDate = $donationDate;
        }
        return $this;
    }
    /**
     * Get Donation_Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDonation_Description()
    {
        return isset($this->Donation_Description) ? $this->Donation_Description : null;
    }
    /**
     * Set Donation_Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $donation_Description
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setDonation_Description(\patest\StructType\GlobalString $donation_Description = null)
    {
        if (is_null($donation_Description) || (is_array($donation_Description) && empty($donation_Description))) {
            unset($this->Donation_Description);
        } else {
            $this->Donation_Description = $donation_Description;
        }
        return $this;
    }
    /**
     * Get Donation_Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDonation_Id()
    {
        return isset($this->Donation_Id) ? $this->Donation_Id : null;
    }
    /**
     * Set Donation_Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $donation_Id
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setDonation_Id($donation_Id = null)
    {
        // validation for constraint: string
        if (!is_null($donation_Id) && !is_string($donation_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($donation_Id, true), gettype($donation_Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($donation_Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $donation_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($donation_Id, true)), __LINE__);
        }
        if (is_null($donation_Id) || (is_array($donation_Id) && empty($donation_Id))) {
            unset($this->Donation_Id);
        } else {
            $this->Donation_Id = $donation_Id;
        }
        return $this;
    }
    /**
     * Get Donation_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDonation_Name()
    {
        return isset($this->Donation_Name) ? $this->Donation_Name : null;
    }
    /**
     * Set Donation_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $donation_Name
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setDonation_Name(\patest\StructType\GlobalString $donation_Name = null)
    {
        if (is_null($donation_Name) || (is_array($donation_Name) && empty($donation_Name))) {
            unset($this->Donation_Name);
        } else {
            $this->Donation_Name = $donation_Name;
        }
        return $this;
    }
    /**
     * Get Fund_Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFund_Description()
    {
        return isset($this->Fund_Description) ? $this->Fund_Description : null;
    }
    /**
     * Set Fund_Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fund_Description
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setFund_Description(\patest\StructType\GlobalString $fund_Description = null)
    {
        if (is_null($fund_Description) || (is_array($fund_Description) && empty($fund_Description))) {
            unset($this->Fund_Description);
        } else {
            $this->Fund_Description = $fund_Description;
        }
        return $this;
    }
    /**
     * Get Fund_Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFund_Id()
    {
        return isset($this->Fund_Id) ? $this->Fund_Id : null;
    }
    /**
     * Set Fund_Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fund_Id
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setFund_Id($fund_Id = null)
    {
        // validation for constraint: string
        if (!is_null($fund_Id) && !is_string($fund_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fund_Id, true), gettype($fund_Id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($fund_Id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $fund_Id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($fund_Id, true)), __LINE__);
        }
        if (is_null($fund_Id) || (is_array($fund_Id) && empty($fund_Id))) {
            unset($this->Fund_Id);
        } else {
            $this->Fund_Id = $fund_Id;
        }
        return $this;
    }
    /**
     * Get Fund_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getFund_Name()
    {
        return isset($this->Fund_Name) ? $this->Fund_Name : null;
    }
    /**
     * Set Fund_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $fund_Name
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setFund_Name(\patest\StructType\GlobalString $fund_Name = null)
    {
        if (is_null($fund_Name) || (is_array($fund_Name) && empty($fund_Name))) {
            unset($this->Fund_Name);
        } else {
            $this->Fund_Name = $fund_Name;
        }
        return $this;
    }
    /**
     * Get GenerateTaxStatement value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateTaxStatement()
    {
        return isset($this->GenerateTaxStatement) ? $this->GenerateTaxStatement : null;
    }
    /**
     * Set GenerateTaxStatement value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateTaxStatement
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setGenerateTaxStatement($generateTaxStatement = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateTaxStatement) && !is_bool($generateTaxStatement)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateTaxStatement, true), gettype($generateTaxStatement)), __LINE__);
        }
        if (is_null($generateTaxStatement) || (is_array($generateTaxStatement) && empty($generateTaxStatement))) {
            unset($this->GenerateTaxStatement);
        } else {
            $this->GenerateTaxStatement = $generateTaxStatement;
        }
        return $this;
    }
    /**
     * Get GenerateThankYouLetter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getGenerateThankYouLetter()
    {
        return isset($this->GenerateThankYouLetter) ? $this->GenerateThankYouLetter : null;
    }
    /**
     * Set GenerateThankYouLetter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $generateThankYouLetter
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setGenerateThankYouLetter($generateThankYouLetter = null)
    {
        // validation for constraint: boolean
        if (!is_null($generateThankYouLetter) && !is_bool($generateThankYouLetter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($generateThankYouLetter, true), gettype($generateThankYouLetter)), __LINE__);
        }
        if (is_null($generateThankYouLetter) || (is_array($generateThankYouLetter) && empty($generateThankYouLetter))) {
            unset($this->GenerateThankYouLetter);
        } else {
            $this->GenerateThankYouLetter = $generateThankYouLetter;
        }
        return $this;
    }
    /**
     * Get Solicitor_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSolicitor_Name()
    {
        return isset($this->Solicitor_Name) ? $this->Solicitor_Name : null;
    }
    /**
     * Set Solicitor_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $solicitor_Name
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setSolicitor_Name(\patest\StructType\GlobalString $solicitor_Name = null)
    {
        if (is_null($solicitor_Name) || (is_array($solicitor_Name) && empty($solicitor_Name))) {
            unset($this->Solicitor_Name);
        } else {
            $this->Solicitor_Name = $solicitor_Name;
        }
        return $this;
    }
    /**
     * Get TaxStatementNumbers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxStatementNumbers()
    {
        return isset($this->TaxStatementNumbers) ? $this->TaxStatementNumbers : null;
    }
    /**
     * Set TaxStatementNumbers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxStatementNumbers
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTaxStatementNumbers($taxStatementNumbers = null)
    {
        // validation for constraint: string
        if (!is_null($taxStatementNumbers) && !is_string($taxStatementNumbers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxStatementNumbers, true), gettype($taxStatementNumbers)), __LINE__);
        }
        if (is_null($taxStatementNumbers) || (is_array($taxStatementNumbers) && empty($taxStatementNumbers))) {
            unset($this->TaxStatementNumbers);
        } else {
            $this->TaxStatementNumbers = $taxStatementNumbers;
        }
        return $this;
    }
    /**
     * Get TaxStatementPrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTaxStatementPrintCount()
    {
        return isset($this->TaxStatementPrintCount) ? $this->TaxStatementPrintCount : null;
    }
    /**
     * Set TaxStatementPrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $taxStatementPrintCount
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTaxStatementPrintCount($taxStatementPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($taxStatementPrintCount) && !(is_int($taxStatementPrintCount) || ctype_digit($taxStatementPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($taxStatementPrintCount, true), gettype($taxStatementPrintCount)), __LINE__);
        }
        if (is_null($taxStatementPrintCount) || (is_array($taxStatementPrintCount) && empty($taxStatementPrintCount))) {
            unset($this->TaxStatementPrintCount);
        } else {
            $this->TaxStatementPrintCount = $taxStatementPrintCount;
        }
        return $this;
    }
    /**
     * Get TaxStatementPrintedOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTaxStatementPrintedOn()
    {
        return isset($this->TaxStatementPrintedOn) ? $this->TaxStatementPrintedOn : null;
    }
    /**
     * Set TaxStatementPrintedOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $taxStatementPrintedOn
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTaxStatementPrintedOn($taxStatementPrintedOn = null)
    {
        // validation for constraint: string
        if (!is_null($taxStatementPrintedOn) && !is_string($taxStatementPrintedOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxStatementPrintedOn, true), gettype($taxStatementPrintedOn)), __LINE__);
        }
        if (is_null($taxStatementPrintedOn) || (is_array($taxStatementPrintedOn) && empty($taxStatementPrintedOn))) {
            unset($this->TaxStatementPrintedOn);
        } else {
            $this->TaxStatementPrintedOn = $taxStatementPrintedOn;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterPrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getThankYouLetterPrintCount()
    {
        return isset($this->ThankYouLetterPrintCount) ? $this->ThankYouLetterPrintCount : null;
    }
    /**
     * Set ThankYouLetterPrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $thankYouLetterPrintCount
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setThankYouLetterPrintCount($thankYouLetterPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($thankYouLetterPrintCount) && !(is_int($thankYouLetterPrintCount) || ctype_digit($thankYouLetterPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($thankYouLetterPrintCount, true), gettype($thankYouLetterPrintCount)), __LINE__);
        }
        if (is_null($thankYouLetterPrintCount) || (is_array($thankYouLetterPrintCount) && empty($thankYouLetterPrintCount))) {
            unset($this->ThankYouLetterPrintCount);
        } else {
            $this->ThankYouLetterPrintCount = $thankYouLetterPrintCount;
        }
        return $this;
    }
    /**
     * Get ThankYouLetterSpecialMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getThankYouLetterSpecialMessage()
    {
        return isset($this->ThankYouLetterSpecialMessage) ? $this->ThankYouLetterSpecialMessage : null;
    }
    /**
     * Set ThankYouLetterSpecialMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $thankYouLetterSpecialMessage
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setThankYouLetterSpecialMessage($thankYouLetterSpecialMessage = null)
    {
        // validation for constraint: string
        if (!is_null($thankYouLetterSpecialMessage) && !is_string($thankYouLetterSpecialMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($thankYouLetterSpecialMessage, true), gettype($thankYouLetterSpecialMessage)), __LINE__);
        }
        if (is_null($thankYouLetterSpecialMessage) || (is_array($thankYouLetterSpecialMessage) && empty($thankYouLetterSpecialMessage))) {
            unset($this->ThankYouLetterSpecialMessage);
        } else {
            $this->ThankYouLetterSpecialMessage = $thankYouLetterSpecialMessage;
        }
        return $this;
    }
    /**
     * Get TributeLetterPrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTributeLetterPrintCount()
    {
        return isset($this->TributeLetterPrintCount) ? $this->TributeLetterPrintCount : null;
    }
    /**
     * Set TributeLetterPrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tributeLetterPrintCount
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTributeLetterPrintCount($tributeLetterPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($tributeLetterPrintCount) && !(is_int($tributeLetterPrintCount) || ctype_digit($tributeLetterPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($tributeLetterPrintCount, true), gettype($tributeLetterPrintCount)), __LINE__);
        }
        if (is_null($tributeLetterPrintCount) || (is_array($tributeLetterPrintCount) && empty($tributeLetterPrintCount))) {
            unset($this->TributeLetterPrintCount);
        } else {
            $this->TributeLetterPrintCount = $tributeLetterPrintCount;
        }
        return $this;
    }
    /**
     * Get TributeLetterSpecialMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeLetterSpecialMessage()
    {
        return isset($this->TributeLetterSpecialMessage) ? $this->TributeLetterSpecialMessage : null;
    }
    /**
     * Set TributeLetterSpecialMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tributeLetterSpecialMessage
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTributeLetterSpecialMessage($tributeLetterSpecialMessage = null)
    {
        // validation for constraint: string
        if (!is_null($tributeLetterSpecialMessage) && !is_string($tributeLetterSpecialMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tributeLetterSpecialMessage, true), gettype($tributeLetterSpecialMessage)), __LINE__);
        }
        if (is_null($tributeLetterSpecialMessage) || (is_array($tributeLetterSpecialMessage) && empty($tributeLetterSpecialMessage))) {
            unset($this->TributeLetterSpecialMessage);
        } else {
            $this->TributeLetterSpecialMessage = $tributeLetterSpecialMessage;
        }
        return $this;
    }
    /**
     * Get TributeTargetEmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeTargetEmailAddress()
    {
        return isset($this->TributeTargetEmailAddress) ? $this->TributeTargetEmailAddress : null;
    }
    /**
     * Set TributeTargetEmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tributeTargetEmailAddress
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTributeTargetEmailAddress($tributeTargetEmailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($tributeTargetEmailAddress) && !is_string($tributeTargetEmailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tributeTargetEmailAddress, true), gettype($tributeTargetEmailAddress)), __LINE__);
        }
        if (is_null($tributeTargetEmailAddress) || (is_array($tributeTargetEmailAddress) && empty($tributeTargetEmailAddress))) {
            unset($this->TributeTargetEmailAddress);
        } else {
            $this->TributeTargetEmailAddress = $tributeTargetEmailAddress;
        }
        return $this;
    }
    /**
     * Get TributeTo_Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeTo_Name()
    {
        return isset($this->TributeTo_Name) ? $this->TributeTo_Name : null;
    }
    /**
     * Set TributeTo_Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tributeTo_Name
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTributeTo_Name($tributeTo_Name = null)
    {
        // validation for constraint: string
        if (!is_null($tributeTo_Name) && !is_string($tributeTo_Name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tributeTo_Name, true), gettype($tributeTo_Name)), __LINE__);
        }
        if (is_null($tributeTo_Name) || (is_array($tributeTo_Name) && empty($tributeTo_Name))) {
            unset($this->TributeTo_Name);
        } else {
            $this->TributeTo_Name = $tributeTo_Name;
        }
        return $this;
    }
    /**
     * Get TributeType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeType()
    {
        return isset($this->TributeType) ? $this->TributeType : null;
    }
    /**
     * Set TributeType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TributeType::valueIsValid()
     * @uses \patest\EnumType\TributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tributeType
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTributeType($tributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TributeType::valueIsValid($tributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TributeType', is_array($tributeType) ? implode(', ', $tributeType) : var_export($tributeType, true), implode(', ', \patest\EnumType\TributeType::getValidValues())), __LINE__);
        }
        if (is_null($tributeType) || (is_array($tributeType) && empty($tributeType))) {
            unset($this->TributeType);
        } else {
            $this->TributeType = $tributeType;
        }
        return $this;
    }
    /**
     * Get TributeTypeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTributeTypeText()
    {
        return isset($this->TributeTypeText) ? $this->TributeTypeText : null;
    }
    /**
     * Set TributeTypeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tributeTypeText
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setTributeTypeText($tributeTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($tributeTypeText) && !is_string($tributeTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tributeTypeText, true), gettype($tributeTypeText)), __LINE__);
        }
        if (is_null($tributeTypeText) || (is_array($tributeTypeText) && empty($tributeTypeText))) {
            unset($this->TributeTypeText);
        } else {
            $this->TributeTypeText = $tributeTypeText;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $value
     * @return \patest\StructType\Printing_PrintableItem_DonationInfo
     */
    public function setValue($value = null)
    {
        // validation for constraint: float
        if (!is_null($value) && !(is_float($value) || is_numeric($value))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
