<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.DirectDebitPaymentItemForInvoice
 * StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_DirectDebitPaymentItemForInvoice extends Printing_PrintableItem_AnyPaymentRecord
{
    /**
     * The AccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccountNumber;
    /**
     * The BankCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankCode;
    /**
     * The BankName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankName;
    /**
     * The GiroAccountNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiroAccountNumber;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Installments;
    /**
     * The MandateName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandateName;
    /**
     * The MandateNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MandateNumber;
    /**
     * Constructor method for Printing.PrintableItem.DirectDebitPaymentItemForInvoice
     * @uses Printing_PrintableItem_DirectDebitPaymentItemForInvoice::setAccountNumber()
     * @uses Printing_PrintableItem_DirectDebitPaymentItemForInvoice::setBankCode()
     * @uses Printing_PrintableItem_DirectDebitPaymentItemForInvoice::setBankName()
     * @uses Printing_PrintableItem_DirectDebitPaymentItemForInvoice::setGiroAccountNumber()
     * @uses Printing_PrintableItem_DirectDebitPaymentItemForInvoice::setInstallments()
     * @uses Printing_PrintableItem_DirectDebitPaymentItemForInvoice::setMandateName()
     * @uses Printing_PrintableItem_DirectDebitPaymentItemForInvoice::setMandateNumber()
     * @param string $accountNumber
     * @param string $bankCode
     * @param string $bankName
     * @param string $giroAccountNumber
     * @param int $installments
     * @param string $mandateName
     * @param string $mandateNumber
     */
    public function __construct($accountNumber = null, $bankCode = null, $bankName = null, $giroAccountNumber = null, $installments = null, $mandateName = null, $mandateNumber = null)
    {
        $this
            ->setAccountNumber($accountNumber)
            ->setBankCode($bankCode)
            ->setBankName($bankName)
            ->setGiroAccountNumber($giroAccountNumber)
            ->setInstallments($installments)
            ->setMandateName($mandateName)
            ->setMandateNumber($mandateNumber);
    }
    /**
     * Get AccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountNumber()
    {
        return isset($this->AccountNumber) ? $this->AccountNumber : null;
    }
    /**
     * Set AccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountNumber
     * @return \patest\StructType\Printing_PrintableItem_DirectDebitPaymentItemForInvoice
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountNumber, true), gettype($accountNumber)), __LINE__);
        }
        if (is_null($accountNumber) || (is_array($accountNumber) && empty($accountNumber))) {
            unset($this->AccountNumber);
        } else {
            $this->AccountNumber = $accountNumber;
        }
        return $this;
    }
    /**
     * Get BankCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankCode()
    {
        return isset($this->BankCode) ? $this->BankCode : null;
    }
    /**
     * Set BankCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankCode
     * @return \patest\StructType\Printing_PrintableItem_DirectDebitPaymentItemForInvoice
     */
    public function setBankCode($bankCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankCode) && !is_string($bankCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankCode, true), gettype($bankCode)), __LINE__);
        }
        if (is_null($bankCode) || (is_array($bankCode) && empty($bankCode))) {
            unset($this->BankCode);
        } else {
            $this->BankCode = $bankCode;
        }
        return $this;
    }
    /**
     * Get BankName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankName()
    {
        return isset($this->BankName) ? $this->BankName : null;
    }
    /**
     * Set BankName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankName
     * @return \patest\StructType\Printing_PrintableItem_DirectDebitPaymentItemForInvoice
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankName, true), gettype($bankName)), __LINE__);
        }
        if (is_null($bankName) || (is_array($bankName) && empty($bankName))) {
            unset($this->BankName);
        } else {
            $this->BankName = $bankName;
        }
        return $this;
    }
    /**
     * Get GiroAccountNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiroAccountNumber()
    {
        return isset($this->GiroAccountNumber) ? $this->GiroAccountNumber : null;
    }
    /**
     * Set GiroAccountNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giroAccountNumber
     * @return \patest\StructType\Printing_PrintableItem_DirectDebitPaymentItemForInvoice
     */
    public function setGiroAccountNumber($giroAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($giroAccountNumber) && !is_string($giroAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giroAccountNumber, true), gettype($giroAccountNumber)), __LINE__);
        }
        if (is_null($giroAccountNumber) || (is_array($giroAccountNumber) && empty($giroAccountNumber))) {
            unset($this->GiroAccountNumber);
        } else {
            $this->GiroAccountNumber = $giroAccountNumber;
        }
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $installments
     * @return \patest\StructType\Printing_PrintableItem_DirectDebitPaymentItemForInvoice
     */
    public function setInstallments($installments = null)
    {
        // validation for constraint: int
        if (!is_null($installments) && !(is_int($installments) || ctype_digit($installments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($installments, true), gettype($installments)), __LINE__);
        }
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get MandateName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateName()
    {
        return isset($this->MandateName) ? $this->MandateName : null;
    }
    /**
     * Set MandateName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateName
     * @return \patest\StructType\Printing_PrintableItem_DirectDebitPaymentItemForInvoice
     */
    public function setMandateName($mandateName = null)
    {
        // validation for constraint: string
        if (!is_null($mandateName) && !is_string($mandateName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateName, true), gettype($mandateName)), __LINE__);
        }
        if (is_null($mandateName) || (is_array($mandateName) && empty($mandateName))) {
            unset($this->MandateName);
        } else {
            $this->MandateName = $mandateName;
        }
        return $this;
    }
    /**
     * Get MandateNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMandateNumber()
    {
        return isset($this->MandateNumber) ? $this->MandateNumber : null;
    }
    /**
     * Set MandateNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mandateNumber
     * @return \patest\StructType\Printing_PrintableItem_DirectDebitPaymentItemForInvoice
     */
    public function setMandateNumber($mandateNumber = null)
    {
        // validation for constraint: string
        if (!is_null($mandateNumber) && !is_string($mandateNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($mandateNumber, true), gettype($mandateNumber)), __LINE__);
        }
        if (is_null($mandateNumber) || (is_array($mandateNumber) && empty($mandateNumber))) {
            unset($this->MandateNumber);
        } else {
            $this->MandateNumber = $mandateNumber;
        }
        return $this;
    }
}
