<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.DeliveryNoteItemsGroupRecord
 * StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_DeliveryNoteItemsGroupRecord extends Printing_PrintableItem_Base
{
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_AccountingDocumentItemDetails
     */
    public $Details;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The PriceTypeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeDetails;
    /**
     * The Quantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantity;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Printing.PrintableItem.DeliveryNoteItemsGroupRecord
     * @uses Printing_PrintableItem_DeliveryNoteItemsGroupRecord::setDetails()
     * @uses Printing_PrintableItem_DeliveryNoteItemsGroupRecord::setEventDate()
     * @uses Printing_PrintableItem_DeliveryNoteItemsGroupRecord::setItemType()
     * @uses Printing_PrintableItem_DeliveryNoteItemsGroupRecord::setPriceTypeDetails()
     * @uses Printing_PrintableItem_DeliveryNoteItemsGroupRecord::setQuantity()
     * @uses Printing_PrintableItem_DeliveryNoteItemsGroupRecord::setTotalAmount()
     * @uses Printing_PrintableItem_DeliveryNoteItemsGroupRecord::setTransactionNumber()
     * @param \patest\StructType\Printing_PrintableItem_AccountingDocumentItemDetails $details
     * @param string $eventDate
     * @param int $itemType
     * @param string $priceTypeDetails
     * @param int $quantity
     * @param \patest\StructType\Money $totalAmount
     * @param int $transactionNumber
     */
    public function __construct(\patest\StructType\Printing_PrintableItem_AccountingDocumentItemDetails $details = null, $eventDate = null, $itemType = null, $priceTypeDetails = null, $quantity = null, \patest\StructType\Money $totalAmount = null, $transactionNumber = null)
    {
        $this
            ->setDetails($details)
            ->setEventDate($eventDate)
            ->setItemType($itemType)
            ->setPriceTypeDetails($priceTypeDetails)
            ->setQuantity($quantity)
            ->setTotalAmount($totalAmount)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_AccountingDocumentItemDetails|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_AccountingDocumentItemDetails $details
     * @return \patest\StructType\Printing_PrintableItem_DeliveryNoteItemsGroupRecord
     */
    public function setDetails(\patest\StructType\Printing_PrintableItem_AccountingDocumentItemDetails $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Printing_PrintableItem_DeliveryNoteItemsGroupRecord
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\Printing_PrintableItem_DeliveryNoteItemsGroupRecord
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get PriceTypeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeDetails()
    {
        return isset($this->PriceTypeDetails) ? $this->PriceTypeDetails : null;
    }
    /**
     * Set PriceTypeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeDetails
     * @return \patest\StructType\Printing_PrintableItem_DeliveryNoteItemsGroupRecord
     */
    public function setPriceTypeDetails($priceTypeDetails = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeDetails) && !is_string($priceTypeDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeDetails, true), gettype($priceTypeDetails)), __LINE__);
        }
        if (is_null($priceTypeDetails) || (is_array($priceTypeDetails) && empty($priceTypeDetails))) {
            unset($this->PriceTypeDetails);
        } else {
            $this->PriceTypeDetails = $priceTypeDetails;
        }
        return $this;
    }
    /**
     * Get Quantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantity()
    {
        return isset($this->Quantity) ? $this->Quantity : null;
    }
    /**
     * Set Quantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantity
     * @return \patest\StructType\Printing_PrintableItem_DeliveryNoteItemsGroupRecord
     */
    public function setQuantity($quantity = null)
    {
        // validation for constraint: int
        if (!is_null($quantity) && !(is_int($quantity) || ctype_digit($quantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($quantity, true), gettype($quantity)), __LINE__);
        }
        if (is_null($quantity) || (is_array($quantity) && empty($quantity))) {
            unset($this->Quantity);
        } else {
            $this->Quantity = $quantity;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Printing_PrintableItem_DeliveryNoteItemsGroupRecord
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Printing_PrintableItem_DeliveryNoteItemsGroupRecord
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
