<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.ComboTicket StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_ComboTicket extends Printing_PrintableItem_MultiTicketBase
{
    /**
     * The PackageDefinitionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PackageDefinitionId;
    /**
     * Constructor method for Printing.PrintableItem.ComboTicket
     * @uses Printing_PrintableItem_ComboTicket::setPackageDefinitionId()
     * @param string $packageDefinitionId
     */
    public function __construct($packageDefinitionId = null)
    {
        $this
            ->setPackageDefinitionId($packageDefinitionId);
    }
    /**
     * Get PackageDefinitionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPackageDefinitionId()
    {
        return isset($this->PackageDefinitionId) ? $this->PackageDefinitionId : null;
    }
    /**
     * Set PackageDefinitionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $packageDefinitionId
     * @return \patest\StructType\Printing_PrintableItem_ComboTicket
     */
    public function setPackageDefinitionId($packageDefinitionId = null)
    {
        // validation for constraint: string
        if (!is_null($packageDefinitionId) && !is_string($packageDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($packageDefinitionId, true), gettype($packageDefinitionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($packageDefinitionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $packageDefinitionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($packageDefinitionId, true)), __LINE__);
        }
        if (is_null($packageDefinitionId) || (is_array($packageDefinitionId) && empty($packageDefinitionId))) {
            unset($this->PackageDefinitionId);
        } else {
            $this->PackageDefinitionId = $packageDefinitionId;
        }
        return $this;
    }
}
