<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.BillInvoice StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_BillInvoice extends Printing_PrintableItem_Base
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The GlobalNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GlobalNumber;
    /**
     * The IsPrinted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinted;
    /**
     * The ItemRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableItem_InvoiceItemsGroupRecord
     */
    public $ItemRecords;
    /**
     * The PaidAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $PaidAmount;
    /**
     * The PayDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PayDate;
    /**
     * The PaymentRecords
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_PaymentRecords
     */
    public $PaymentRecords;
    /**
     * The PaymentTermName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentTermName;
    /**
     * The PrintedDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedDateTime;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The TotalAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmount;
    /**
     * The TotalAmountNeto
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalAmountNeto;
    /**
     * The TotalInsideCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalInsideCommissionAmount;
    /**
     * The TotalTransactionCommissionAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalTransactionCommissionAmount;
    /**
     * The TotalVatAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalVatAmount;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * Constructor method for Printing.PrintableItem.BillInvoice
     * @uses Printing_PrintableItem_BillInvoice::setClientId()
     * @uses Printing_PrintableItem_BillInvoice::setCreationDateTime()
     * @uses Printing_PrintableItem_BillInvoice::setGlobalNumber()
     * @uses Printing_PrintableItem_BillInvoice::setIsPrinted()
     * @uses Printing_PrintableItem_BillInvoice::setItemRecords()
     * @uses Printing_PrintableItem_BillInvoice::setPaidAmount()
     * @uses Printing_PrintableItem_BillInvoice::setPayDate()
     * @uses Printing_PrintableItem_BillInvoice::setPaymentRecords()
     * @uses Printing_PrintableItem_BillInvoice::setPaymentTermName()
     * @uses Printing_PrintableItem_BillInvoice::setPrintedDateTime()
     * @uses Printing_PrintableItem_BillInvoice::setRemark()
     * @uses Printing_PrintableItem_BillInvoice::setTotalAmount()
     * @uses Printing_PrintableItem_BillInvoice::setTotalAmountNeto()
     * @uses Printing_PrintableItem_BillInvoice::setTotalInsideCommissionAmount()
     * @uses Printing_PrintableItem_BillInvoice::setTotalTransactionCommissionAmount()
     * @uses Printing_PrintableItem_BillInvoice::setTotalVatAmount()
     * @uses Printing_PrintableItem_BillInvoice::setTransactionNumber()
     * @param string $clientId
     * @param string $creationDateTime
     * @param int $globalNumber
     * @param bool $isPrinted
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_InvoiceItemsGroupRecord $itemRecords
     * @param \patest\StructType\Money $paidAmount
     * @param string $payDate
     * @param \patest\StructType\Printing_PrintableItem_PaymentRecords $paymentRecords
     * @param \patest\StructType\GlobalString $paymentTermName
     * @param string $printedDateTime
     * @param string $remark
     * @param \patest\StructType\Money $totalAmount
     * @param \patest\StructType\Money $totalAmountNeto
     * @param \patest\StructType\Money $totalInsideCommissionAmount
     * @param \patest\StructType\Money $totalTransactionCommissionAmount
     * @param \patest\StructType\Money $totalVatAmount
     * @param int $transactionNumber
     */
    public function __construct($clientId = null, $creationDateTime = null, $globalNumber = null, $isPrinted = null, \patest\StructType\RecordSetOfPrinting_PrintableItem_InvoiceItemsGroupRecord $itemRecords = null, \patest\StructType\Money $paidAmount = null, $payDate = null, \patest\StructType\Printing_PrintableItem_PaymentRecords $paymentRecords = null, \patest\StructType\GlobalString $paymentTermName = null, $printedDateTime = null, $remark = null, \patest\StructType\Money $totalAmount = null, \patest\StructType\Money $totalAmountNeto = null, \patest\StructType\Money $totalInsideCommissionAmount = null, \patest\StructType\Money $totalTransactionCommissionAmount = null, \patest\StructType\Money $totalVatAmount = null, $transactionNumber = null)
    {
        $this
            ->setClientId($clientId)
            ->setCreationDateTime($creationDateTime)
            ->setGlobalNumber($globalNumber)
            ->setIsPrinted($isPrinted)
            ->setItemRecords($itemRecords)
            ->setPaidAmount($paidAmount)
            ->setPayDate($payDate)
            ->setPaymentRecords($paymentRecords)
            ->setPaymentTermName($paymentTermName)
            ->setPrintedDateTime($printedDateTime)
            ->setRemark($remark)
            ->setTotalAmount($totalAmount)
            ->setTotalAmountNeto($totalAmountNeto)
            ->setTotalInsideCommissionAmount($totalInsideCommissionAmount)
            ->setTotalTransactionCommissionAmount($totalTransactionCommissionAmount)
            ->setTotalVatAmount($totalVatAmount)
            ->setTransactionNumber($transactionNumber);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get GlobalNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGlobalNumber()
    {
        return isset($this->GlobalNumber) ? $this->GlobalNumber : null;
    }
    /**
     * Set GlobalNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $globalNumber
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setGlobalNumber($globalNumber = null)
    {
        // validation for constraint: int
        if (!is_null($globalNumber) && !(is_int($globalNumber) || ctype_digit($globalNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($globalNumber, true), gettype($globalNumber)), __LINE__);
        }
        if (is_null($globalNumber) || (is_array($globalNumber) && empty($globalNumber))) {
            unset($this->GlobalNumber);
        } else {
            $this->GlobalNumber = $globalNumber;
        }
        return $this;
    }
    /**
     * Get IsPrinted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinted()
    {
        return isset($this->IsPrinted) ? $this->IsPrinted : null;
    }
    /**
     * Set IsPrinted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinted
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setIsPrinted($isPrinted = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinted) && !is_bool($isPrinted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinted, true), gettype($isPrinted)), __LINE__);
        }
        if (is_null($isPrinted) || (is_array($isPrinted) && empty($isPrinted))) {
            unset($this->IsPrinted);
        } else {
            $this->IsPrinted = $isPrinted;
        }
        return $this;
    }
    /**
     * Get ItemRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableItem_InvoiceItemsGroupRecord|null
     */
    public function getItemRecords()
    {
        return isset($this->ItemRecords) ? $this->ItemRecords : null;
    }
    /**
     * Set ItemRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableItem_InvoiceItemsGroupRecord $itemRecords
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setItemRecords(\patest\StructType\RecordSetOfPrinting_PrintableItem_InvoiceItemsGroupRecord $itemRecords = null)
    {
        if (is_null($itemRecords) || (is_array($itemRecords) && empty($itemRecords))) {
            unset($this->ItemRecords);
        } else {
            $this->ItemRecords = $itemRecords;
        }
        return $this;
    }
    /**
     * Get PaidAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getPaidAmount()
    {
        return isset($this->PaidAmount) ? $this->PaidAmount : null;
    }
    /**
     * Set PaidAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $paidAmount
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setPaidAmount(\patest\StructType\Money $paidAmount = null)
    {
        if (is_null($paidAmount) || (is_array($paidAmount) && empty($paidAmount))) {
            unset($this->PaidAmount);
        } else {
            $this->PaidAmount = $paidAmount;
        }
        return $this;
    }
    /**
     * Get PayDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPayDate()
    {
        return isset($this->PayDate) ? $this->PayDate : null;
    }
    /**
     * Set PayDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $payDate
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setPayDate($payDate = null)
    {
        // validation for constraint: string
        if (!is_null($payDate) && !is_string($payDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($payDate, true), gettype($payDate)), __LINE__);
        }
        if (is_null($payDate) || (is_array($payDate) && empty($payDate))) {
            unset($this->PayDate);
        } else {
            $this->PayDate = $payDate;
        }
        return $this;
    }
    /**
     * Get PaymentRecords value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_PaymentRecords|null
     */
    public function getPaymentRecords()
    {
        return isset($this->PaymentRecords) ? $this->PaymentRecords : null;
    }
    /**
     * Set PaymentRecords value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_PaymentRecords $paymentRecords
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setPaymentRecords(\patest\StructType\Printing_PrintableItem_PaymentRecords $paymentRecords = null)
    {
        if (is_null($paymentRecords) || (is_array($paymentRecords) && empty($paymentRecords))) {
            unset($this->PaymentRecords);
        } else {
            $this->PaymentRecords = $paymentRecords;
        }
        return $this;
    }
    /**
     * Get PaymentTermName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentTermName()
    {
        return isset($this->PaymentTermName) ? $this->PaymentTermName : null;
    }
    /**
     * Set PaymentTermName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentTermName
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setPaymentTermName(\patest\StructType\GlobalString $paymentTermName = null)
    {
        if (is_null($paymentTermName) || (is_array($paymentTermName) && empty($paymentTermName))) {
            unset($this->PaymentTermName);
        } else {
            $this->PaymentTermName = $paymentTermName;
        }
        return $this;
    }
    /**
     * Get PrintedDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedDateTime()
    {
        return isset($this->PrintedDateTime) ? $this->PrintedDateTime : null;
    }
    /**
     * Set PrintedDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedDateTime
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setPrintedDateTime($printedDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($printedDateTime) && !is_string($printedDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedDateTime, true), gettype($printedDateTime)), __LINE__);
        }
        if (is_null($printedDateTime) || (is_array($printedDateTime) && empty($printedDateTime))) {
            unset($this->PrintedDateTime);
        } else {
            $this->PrintedDateTime = $printedDateTime;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get TotalAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmount()
    {
        return isset($this->TotalAmount) ? $this->TotalAmount : null;
    }
    /**
     * Set TotalAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmount
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setTotalAmount(\patest\StructType\Money $totalAmount = null)
    {
        if (is_null($totalAmount) || (is_array($totalAmount) && empty($totalAmount))) {
            unset($this->TotalAmount);
        } else {
            $this->TotalAmount = $totalAmount;
        }
        return $this;
    }
    /**
     * Get TotalAmountNeto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalAmountNeto()
    {
        return isset($this->TotalAmountNeto) ? $this->TotalAmountNeto : null;
    }
    /**
     * Set TotalAmountNeto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalAmountNeto
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setTotalAmountNeto(\patest\StructType\Money $totalAmountNeto = null)
    {
        if (is_null($totalAmountNeto) || (is_array($totalAmountNeto) && empty($totalAmountNeto))) {
            unset($this->TotalAmountNeto);
        } else {
            $this->TotalAmountNeto = $totalAmountNeto;
        }
        return $this;
    }
    /**
     * Get TotalInsideCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalInsideCommissionAmount()
    {
        return isset($this->TotalInsideCommissionAmount) ? $this->TotalInsideCommissionAmount : null;
    }
    /**
     * Set TotalInsideCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalInsideCommissionAmount
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setTotalInsideCommissionAmount(\patest\StructType\Money $totalInsideCommissionAmount = null)
    {
        if (is_null($totalInsideCommissionAmount) || (is_array($totalInsideCommissionAmount) && empty($totalInsideCommissionAmount))) {
            unset($this->TotalInsideCommissionAmount);
        } else {
            $this->TotalInsideCommissionAmount = $totalInsideCommissionAmount;
        }
        return $this;
    }
    /**
     * Get TotalTransactionCommissionAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalTransactionCommissionAmount()
    {
        return isset($this->TotalTransactionCommissionAmount) ? $this->TotalTransactionCommissionAmount : null;
    }
    /**
     * Set TotalTransactionCommissionAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalTransactionCommissionAmount
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setTotalTransactionCommissionAmount(\patest\StructType\Money $totalTransactionCommissionAmount = null)
    {
        if (is_null($totalTransactionCommissionAmount) || (is_array($totalTransactionCommissionAmount) && empty($totalTransactionCommissionAmount))) {
            unset($this->TotalTransactionCommissionAmount);
        } else {
            $this->TotalTransactionCommissionAmount = $totalTransactionCommissionAmount;
        }
        return $this;
    }
    /**
     * Get TotalVatAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalVatAmount()
    {
        return isset($this->TotalVatAmount) ? $this->TotalVatAmount : null;
    }
    /**
     * Set TotalVatAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalVatAmount
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setTotalVatAmount(\patest\StructType\Money $totalVatAmount = null)
    {
        if (is_null($totalVatAmount) || (is_array($totalVatAmount) && empty($totalVatAmount))) {
            unset($this->TotalVatAmount);
        } else {
            $this->TotalVatAmount = $totalVatAmount;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Printing_PrintableItem_BillInvoice
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
}
