<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.Base StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_Base extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The BarcodeProviderId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BarcodeProviderId;
    /**
     * The BasketItemServiceSpecificId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BasketItemServiceSpecificId;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentId;
    /**
     * The DocumentTypeId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentTypeId;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The FromPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FromPage;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IsDataOnlyItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDataOnlyItem;
    /**
     * The IsDataOnlyItemNeedsNewBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsDataOnlyItemNeedsNewBarcode;
    /**
     * The IsOptional
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOptional;
    /**
     * The IsPrinting
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrinting;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemName;
    /**
     * The NewBarcodeGenerated
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NewBarcodeGenerated;
    /**
     * The NoTargetPrinterOveride
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NoTargetPrinterOveride;
    /**
     * The NumberOfCopies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfCopies;
    /**
     * The OldBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldBarcode;
    /**
     * The PrintedInsteadIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintedInsteadIds;
    /**
     * The ReferenceEntityName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceEntityName;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferenceId;
    /**
     * The ReportedError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReportedError;
    /**
     * The SpoolItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpoolItemId;
    /**
     * The TargetEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetEmail;
    /**
     * The TargetEmailClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetEmailClientId;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The ToPage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ToPage;
    /**
     * Constructor method for Printing.PrintableItem.Base
     * @uses Printing_PrintableItem_Base::setAccessControlSystemId()
     * @uses Printing_PrintableItem_Base::setBarcodeProviderId()
     * @uses Printing_PrintableItem_Base::setBasketItemServiceSpecificId()
     * @uses Printing_PrintableItem_Base::setDocumentId()
     * @uses Printing_PrintableItem_Base::setDocumentTypeId()
     * @uses Printing_PrintableItem_Base::setFileName()
     * @uses Printing_PrintableItem_Base::setFromPage()
     * @uses Printing_PrintableItem_Base::setId()
     * @uses Printing_PrintableItem_Base::setIsDataOnlyItem()
     * @uses Printing_PrintableItem_Base::setIsDataOnlyItemNeedsNewBarcode()
     * @uses Printing_PrintableItem_Base::setIsOptional()
     * @uses Printing_PrintableItem_Base::setIsPrinting()
     * @uses Printing_PrintableItem_Base::setItemDescription()
     * @uses Printing_PrintableItem_Base::setItemName()
     * @uses Printing_PrintableItem_Base::setNewBarcodeGenerated()
     * @uses Printing_PrintableItem_Base::setNoTargetPrinterOveride()
     * @uses Printing_PrintableItem_Base::setNumberOfCopies()
     * @uses Printing_PrintableItem_Base::setOldBarcode()
     * @uses Printing_PrintableItem_Base::setPrintedInsteadIds()
     * @uses Printing_PrintableItem_Base::setReferenceEntityName()
     * @uses Printing_PrintableItem_Base::setReferenceId()
     * @uses Printing_PrintableItem_Base::setReportedError()
     * @uses Printing_PrintableItem_Base::setSpoolItemId()
     * @uses Printing_PrintableItem_Base::setTargetEmail()
     * @uses Printing_PrintableItem_Base::setTargetEmailClientId()
     * @uses Printing_PrintableItem_Base::setTargetPrinterId()
     * @uses Printing_PrintableItem_Base::setToPage()
     * @param string $accessControlSystemId
     * @param string $barcodeProviderId
     * @param string $basketItemServiceSpecificId
     * @param string $documentId
     * @param string $documentTypeId
     * @param string $fileName
     * @param int $fromPage
     * @param string $id
     * @param bool $isDataOnlyItem
     * @param bool $isDataOnlyItemNeedsNewBarcode
     * @param bool $isOptional
     * @param bool $isPrinting
     * @param string $itemDescription
     * @param string $itemName
     * @param bool $newBarcodeGenerated
     * @param bool $noTargetPrinterOveride
     * @param int $numberOfCopies
     * @param string $oldBarcode
     * @param string $printedInsteadIds
     * @param string $referenceEntityName
     * @param string $referenceId
     * @param string $reportedError
     * @param string $spoolItemId
     * @param string $targetEmail
     * @param string $targetEmailClientId
     * @param string $targetPrinterId
     * @param int $toPage
     */
    public function __construct($accessControlSystemId = null, $barcodeProviderId = null, $basketItemServiceSpecificId = null, $documentId = null, $documentTypeId = null, $fileName = null, $fromPage = null, $id = null, $isDataOnlyItem = null, $isDataOnlyItemNeedsNewBarcode = null, $isOptional = null, $isPrinting = null, $itemDescription = null, $itemName = null, $newBarcodeGenerated = null, $noTargetPrinterOveride = null, $numberOfCopies = null, $oldBarcode = null, $printedInsteadIds = null, $referenceEntityName = null, $referenceId = null, $reportedError = null, $spoolItemId = null, $targetEmail = null, $targetEmailClientId = null, $targetPrinterId = null, $toPage = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setBarcodeProviderId($barcodeProviderId)
            ->setBasketItemServiceSpecificId($basketItemServiceSpecificId)
            ->setDocumentId($documentId)
            ->setDocumentTypeId($documentTypeId)
            ->setFileName($fileName)
            ->setFromPage($fromPage)
            ->setId($id)
            ->setIsDataOnlyItem($isDataOnlyItem)
            ->setIsDataOnlyItemNeedsNewBarcode($isDataOnlyItemNeedsNewBarcode)
            ->setIsOptional($isOptional)
            ->setIsPrinting($isPrinting)
            ->setItemDescription($itemDescription)
            ->setItemName($itemName)
            ->setNewBarcodeGenerated($newBarcodeGenerated)
            ->setNoTargetPrinterOveride($noTargetPrinterOveride)
            ->setNumberOfCopies($numberOfCopies)
            ->setOldBarcode($oldBarcode)
            ->setPrintedInsteadIds($printedInsteadIds)
            ->setReferenceEntityName($referenceEntityName)
            ->setReferenceId($referenceId)
            ->setReportedError($reportedError)
            ->setSpoolItemId($spoolItemId)
            ->setTargetEmail($targetEmail)
            ->setTargetEmailClientId($targetEmailClientId)
            ->setTargetPrinterId($targetPrinterId)
            ->setToPage($toPage);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get BarcodeProviderId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeProviderId()
    {
        return isset($this->BarcodeProviderId) ? $this->BarcodeProviderId : null;
    }
    /**
     * Set BarcodeProviderId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeProviderId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setBarcodeProviderId($barcodeProviderId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeProviderId) && !is_string($barcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeProviderId, true), gettype($barcodeProviderId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($barcodeProviderId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $barcodeProviderId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($barcodeProviderId, true)), __LINE__);
        }
        if (is_null($barcodeProviderId) || (is_array($barcodeProviderId) && empty($barcodeProviderId))) {
            unset($this->BarcodeProviderId);
        } else {
            $this->BarcodeProviderId = $barcodeProviderId;
        }
        return $this;
    }
    /**
     * Get BasketItemServiceSpecificId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasketItemServiceSpecificId()
    {
        return isset($this->BasketItemServiceSpecificId) ? $this->BasketItemServiceSpecificId : null;
    }
    /**
     * Set BasketItemServiceSpecificId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $basketItemServiceSpecificId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setBasketItemServiceSpecificId($basketItemServiceSpecificId = null)
    {
        // validation for constraint: string
        if (!is_null($basketItemServiceSpecificId) && !is_string($basketItemServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($basketItemServiceSpecificId, true), gettype($basketItemServiceSpecificId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($basketItemServiceSpecificId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $basketItemServiceSpecificId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($basketItemServiceSpecificId, true)), __LINE__);
        }
        if (is_null($basketItemServiceSpecificId) || (is_array($basketItemServiceSpecificId) && empty($basketItemServiceSpecificId))) {
            unset($this->BasketItemServiceSpecificId);
        } else {
            $this->BasketItemServiceSpecificId = $basketItemServiceSpecificId;
        }
        return $this;
    }
    /**
     * Get DocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentId()
    {
        return isset($this->DocumentId) ? $this->DocumentId : null;
    }
    /**
     * Set DocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentId, true)), __LINE__);
        }
        if (is_null($documentId) || (is_array($documentId) && empty($documentId))) {
            unset($this->DocumentId);
        } else {
            $this->DocumentId = $documentId;
        }
        return $this;
    }
    /**
     * Get DocumentTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentTypeId()
    {
        return isset($this->DocumentTypeId) ? $this->DocumentTypeId : null;
    }
    /**
     * Set DocumentTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentTypeId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeId) && !is_string($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeId, true), gettype($documentTypeId)), __LINE__);
        }
        if (is_null($documentTypeId) || (is_array($documentTypeId) && empty($documentTypeId))) {
            unset($this->DocumentTypeId);
        } else {
            $this->DocumentTypeId = $documentTypeId;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get FromPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFromPage()
    {
        return isset($this->FromPage) ? $this->FromPage : null;
    }
    /**
     * Set FromPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fromPage
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setFromPage($fromPage = null)
    {
        // validation for constraint: int
        if (!is_null($fromPage) && !(is_int($fromPage) || ctype_digit($fromPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fromPage, true), gettype($fromPage)), __LINE__);
        }
        if (is_null($fromPage) || (is_array($fromPage) && empty($fromPage))) {
            unset($this->FromPage);
        } else {
            $this->FromPage = $fromPage;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get IsDataOnlyItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDataOnlyItem()
    {
        return isset($this->IsDataOnlyItem) ? $this->IsDataOnlyItem : null;
    }
    /**
     * Set IsDataOnlyItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDataOnlyItem
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setIsDataOnlyItem($isDataOnlyItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDataOnlyItem) && !is_bool($isDataOnlyItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDataOnlyItem, true), gettype($isDataOnlyItem)), __LINE__);
        }
        if (is_null($isDataOnlyItem) || (is_array($isDataOnlyItem) && empty($isDataOnlyItem))) {
            unset($this->IsDataOnlyItem);
        } else {
            $this->IsDataOnlyItem = $isDataOnlyItem;
        }
        return $this;
    }
    /**
     * Get IsDataOnlyItemNeedsNewBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsDataOnlyItemNeedsNewBarcode()
    {
        return isset($this->IsDataOnlyItemNeedsNewBarcode) ? $this->IsDataOnlyItemNeedsNewBarcode : null;
    }
    /**
     * Set IsDataOnlyItemNeedsNewBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isDataOnlyItemNeedsNewBarcode
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setIsDataOnlyItemNeedsNewBarcode($isDataOnlyItemNeedsNewBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isDataOnlyItemNeedsNewBarcode) && !is_bool($isDataOnlyItemNeedsNewBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isDataOnlyItemNeedsNewBarcode, true), gettype($isDataOnlyItemNeedsNewBarcode)), __LINE__);
        }
        if (is_null($isDataOnlyItemNeedsNewBarcode) || (is_array($isDataOnlyItemNeedsNewBarcode) && empty($isDataOnlyItemNeedsNewBarcode))) {
            unset($this->IsDataOnlyItemNeedsNewBarcode);
        } else {
            $this->IsDataOnlyItemNeedsNewBarcode = $isDataOnlyItemNeedsNewBarcode;
        }
        return $this;
    }
    /**
     * Get IsOptional value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOptional()
    {
        return isset($this->IsOptional) ? $this->IsOptional : null;
    }
    /**
     * Set IsOptional value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOptional
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setIsOptional($isOptional = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOptional) && !is_bool($isOptional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOptional, true), gettype($isOptional)), __LINE__);
        }
        if (is_null($isOptional) || (is_array($isOptional) && empty($isOptional))) {
            unset($this->IsOptional);
        } else {
            $this->IsOptional = $isOptional;
        }
        return $this;
    }
    /**
     * Get IsPrinting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrinting()
    {
        return isset($this->IsPrinting) ? $this->IsPrinting : null;
    }
    /**
     * Set IsPrinting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrinting
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setIsPrinting($isPrinting = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrinting) && !is_bool($isPrinting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrinting, true), gettype($isPrinting)), __LINE__);
        }
        if (is_null($isPrinting) || (is_array($isPrinting) && empty($isPrinting))) {
            unset($this->IsPrinting);
        } else {
            $this->IsPrinting = $isPrinting;
        }
        return $this;
    }
    /**
     * Get ItemDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDescription()
    {
        return isset($this->ItemDescription) ? $this->ItemDescription : null;
    }
    /**
     * Set ItemDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDescription
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        if (is_null($itemDescription) || (is_array($itemDescription) && empty($itemDescription))) {
            unset($this->ItemDescription);
        } else {
            $this->ItemDescription = $itemDescription;
        }
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemName
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get NewBarcodeGenerated value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNewBarcodeGenerated()
    {
        return isset($this->NewBarcodeGenerated) ? $this->NewBarcodeGenerated : null;
    }
    /**
     * Set NewBarcodeGenerated value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $newBarcodeGenerated
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setNewBarcodeGenerated($newBarcodeGenerated = null)
    {
        // validation for constraint: boolean
        if (!is_null($newBarcodeGenerated) && !is_bool($newBarcodeGenerated)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($newBarcodeGenerated, true), gettype($newBarcodeGenerated)), __LINE__);
        }
        if (is_null($newBarcodeGenerated) || (is_array($newBarcodeGenerated) && empty($newBarcodeGenerated))) {
            unset($this->NewBarcodeGenerated);
        } else {
            $this->NewBarcodeGenerated = $newBarcodeGenerated;
        }
        return $this;
    }
    /**
     * Get NoTargetPrinterOveride value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNoTargetPrinterOveride()
    {
        return isset($this->NoTargetPrinterOveride) ? $this->NoTargetPrinterOveride : null;
    }
    /**
     * Set NoTargetPrinterOveride value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $noTargetPrinterOveride
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setNoTargetPrinterOveride($noTargetPrinterOveride = null)
    {
        // validation for constraint: boolean
        if (!is_null($noTargetPrinterOveride) && !is_bool($noTargetPrinterOveride)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($noTargetPrinterOveride, true), gettype($noTargetPrinterOveride)), __LINE__);
        }
        if (is_null($noTargetPrinterOveride) || (is_array($noTargetPrinterOveride) && empty($noTargetPrinterOveride))) {
            unset($this->NoTargetPrinterOveride);
        } else {
            $this->NoTargetPrinterOveride = $noTargetPrinterOveride;
        }
        return $this;
    }
    /**
     * Get NumberOfCopies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfCopies()
    {
        return isset($this->NumberOfCopies) ? $this->NumberOfCopies : null;
    }
    /**
     * Set NumberOfCopies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfCopies
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setNumberOfCopies($numberOfCopies = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfCopies) && !(is_int($numberOfCopies) || ctype_digit($numberOfCopies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfCopies, true), gettype($numberOfCopies)), __LINE__);
        }
        if (is_null($numberOfCopies) || (is_array($numberOfCopies) && empty($numberOfCopies))) {
            unset($this->NumberOfCopies);
        } else {
            $this->NumberOfCopies = $numberOfCopies;
        }
        return $this;
    }
    /**
     * Get OldBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldBarcode()
    {
        return isset($this->OldBarcode) ? $this->OldBarcode : null;
    }
    /**
     * Set OldBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldBarcode
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setOldBarcode($oldBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($oldBarcode) && !is_string($oldBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldBarcode, true), gettype($oldBarcode)), __LINE__);
        }
        if (is_null($oldBarcode) || (is_array($oldBarcode) && empty($oldBarcode))) {
            unset($this->OldBarcode);
        } else {
            $this->OldBarcode = $oldBarcode;
        }
        return $this;
    }
    /**
     * Get PrintedInsteadIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintedInsteadIds()
    {
        return isset($this->PrintedInsteadIds) ? $this->PrintedInsteadIds : null;
    }
    /**
     * Set PrintedInsteadIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printedInsteadIds
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setPrintedInsteadIds($printedInsteadIds = null)
    {
        // validation for constraint: string
        if (!is_null($printedInsteadIds) && !is_string($printedInsteadIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printedInsteadIds, true), gettype($printedInsteadIds)), __LINE__);
        }
        if (is_null($printedInsteadIds) || (is_array($printedInsteadIds) && empty($printedInsteadIds))) {
            unset($this->PrintedInsteadIds);
        } else {
            $this->PrintedInsteadIds = $printedInsteadIds;
        }
        return $this;
    }
    /**
     * Get ReferenceEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceEntityName()
    {
        return isset($this->ReferenceEntityName) ? $this->ReferenceEntityName : null;
    }
    /**
     * Set ReferenceEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceEntityName
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setReferenceEntityName($referenceEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($referenceEntityName) && !is_string($referenceEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceEntityName, true), gettype($referenceEntityName)), __LINE__);
        }
        if (is_null($referenceEntityName) || (is_array($referenceEntityName) && empty($referenceEntityName))) {
            unset($this->ReferenceEntityName);
        } else {
            $this->ReferenceEntityName = $referenceEntityName;
        }
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referenceId, true)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
    /**
     * Get ReportedError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReportedError()
    {
        return isset($this->ReportedError) ? $this->ReportedError : null;
    }
    /**
     * Set ReportedError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $reportedError
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setReportedError($reportedError = null)
    {
        // validation for constraint: string
        if (!is_null($reportedError) && !is_string($reportedError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($reportedError, true), gettype($reportedError)), __LINE__);
        }
        if (is_null($reportedError) || (is_array($reportedError) && empty($reportedError))) {
            unset($this->ReportedError);
        } else {
            $this->ReportedError = $reportedError;
        }
        return $this;
    }
    /**
     * Get SpoolItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpoolItemId()
    {
        return isset($this->SpoolItemId) ? $this->SpoolItemId : null;
    }
    /**
     * Set SpoolItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spoolItemId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setSpoolItemId($spoolItemId = null)
    {
        // validation for constraint: string
        if (!is_null($spoolItemId) && !is_string($spoolItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spoolItemId, true), gettype($spoolItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($spoolItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $spoolItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($spoolItemId, true)), __LINE__);
        }
        if (is_null($spoolItemId) || (is_array($spoolItemId) && empty($spoolItemId))) {
            unset($this->SpoolItemId);
        } else {
            $this->SpoolItemId = $spoolItemId;
        }
        return $this;
    }
    /**
     * Get TargetEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetEmail()
    {
        return isset($this->TargetEmail) ? $this->TargetEmail : null;
    }
    /**
     * Set TargetEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetEmail
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setTargetEmail($targetEmail = null)
    {
        // validation for constraint: string
        if (!is_null($targetEmail) && !is_string($targetEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetEmail, true), gettype($targetEmail)), __LINE__);
        }
        if (is_null($targetEmail) || (is_array($targetEmail) && empty($targetEmail))) {
            unset($this->TargetEmail);
        } else {
            $this->TargetEmail = $targetEmail;
        }
        return $this;
    }
    /**
     * Get TargetEmailClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetEmailClientId()
    {
        return isset($this->TargetEmailClientId) ? $this->TargetEmailClientId : null;
    }
    /**
     * Set TargetEmailClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetEmailClientId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setTargetEmailClientId($targetEmailClientId = null)
    {
        // validation for constraint: string
        if (!is_null($targetEmailClientId) && !is_string($targetEmailClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetEmailClientId, true), gettype($targetEmailClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetEmailClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetEmailClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetEmailClientId, true)), __LINE__);
        }
        if (is_null($targetEmailClientId) || (is_array($targetEmailClientId) && empty($targetEmailClientId))) {
            unset($this->TargetEmailClientId);
        } else {
            $this->TargetEmailClientId = $targetEmailClientId;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get ToPage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getToPage()
    {
        return isset($this->ToPage) ? $this->ToPage : null;
    }
    /**
     * Set ToPage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $toPage
     * @return \patest\StructType\Printing_PrintableItem_Base
     */
    public function setToPage($toPage = null)
    {
        // validation for constraint: int
        if (!is_null($toPage) && !(is_int($toPage) || ctype_digit($toPage))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($toPage, true), gettype($toPage)), __LINE__);
        }
        if (is_null($toPage) || (is_array($toPage) && empty($toPage))) {
            unset($this->ToPage);
        } else {
            $this->ToPage = $toPage;
        }
        return $this;
    }
}
