<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableItem.AnyPaymentItem StructType
 * @subpackage Structs
 */
class Printing_PrintableItem_AnyPaymentItem extends Printing_PrintableItem_PaymentItemWithPaymentSession
{
    /**
     * The BankTransferPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_BankTransferPayment
     */
    public $BankTransferPayment;
    /**
     * The ChequeDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Printing_ChequeDetails
     */
    public $ChequeDetails;
    /**
     * The DirectDebitPayment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Printing_DirectDebitPayment
     */
    public $DirectDebitPayment;
    /**
     * The GiftCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_PrintableItem_GiftCard
     */
    public $GiftCard;
    /**
     * The LoyaltyPoints
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Printing_LoyaltyPointsDetails
     */
    public $LoyaltyPoints;
    /**
     * The PaymentsPlanDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public $PaymentsPlanDetails;
    /**
     * The RefundVoucher
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Printing_RefundVoucher
     */
    public $RefundVoucher;
    /**
     * Constructor method for Printing.PrintableItem.AnyPaymentItem
     * @uses Printing_PrintableItem_AnyPaymentItem::setBankTransferPayment()
     * @uses Printing_PrintableItem_AnyPaymentItem::setChequeDetails()
     * @uses Printing_PrintableItem_AnyPaymentItem::setDirectDebitPayment()
     * @uses Printing_PrintableItem_AnyPaymentItem::setGiftCard()
     * @uses Printing_PrintableItem_AnyPaymentItem::setLoyaltyPoints()
     * @uses Printing_PrintableItem_AnyPaymentItem::setPaymentsPlanDetails()
     * @uses Printing_PrintableItem_AnyPaymentItem::setRefundVoucher()
     * @param \patest\StructType\Payment_BankTransferPayment $bankTransferPayment
     * @param \patest\StructType\Payment_Printing_ChequeDetails $chequeDetails
     * @param \patest\StructType\Payment_Printing_DirectDebitPayment $directDebitPayment
     * @param \patest\StructType\Payment_PrintableItem_GiftCard $giftCard
     * @param \patest\StructType\Payment_Printing_LoyaltyPointsDetails $loyaltyPoints
     * @param \patest\StructType\Payment_Printing_PaymentsPlanDetails $paymentsPlanDetails
     * @param \patest\StructType\Payment_Printing_RefundVoucher $refundVoucher
     */
    public function __construct(\patest\StructType\Payment_BankTransferPayment $bankTransferPayment = null, \patest\StructType\Payment_Printing_ChequeDetails $chequeDetails = null, \patest\StructType\Payment_Printing_DirectDebitPayment $directDebitPayment = null, \patest\StructType\Payment_PrintableItem_GiftCard $giftCard = null, \patest\StructType\Payment_Printing_LoyaltyPointsDetails $loyaltyPoints = null, \patest\StructType\Payment_Printing_PaymentsPlanDetails $paymentsPlanDetails = null, \patest\StructType\Payment_Printing_RefundVoucher $refundVoucher = null)
    {
        $this
            ->setBankTransferPayment($bankTransferPayment)
            ->setChequeDetails($chequeDetails)
            ->setDirectDebitPayment($directDebitPayment)
            ->setGiftCard($giftCard)
            ->setLoyaltyPoints($loyaltyPoints)
            ->setPaymentsPlanDetails($paymentsPlanDetails)
            ->setRefundVoucher($refundVoucher);
    }
    /**
     * Get BankTransferPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_BankTransferPayment|null
     */
    public function getBankTransferPayment()
    {
        return isset($this->BankTransferPayment) ? $this->BankTransferPayment : null;
    }
    /**
     * Set BankTransferPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_BankTransferPayment $bankTransferPayment
     * @return \patest\StructType\Printing_PrintableItem_AnyPaymentItem
     */
    public function setBankTransferPayment(\patest\StructType\Payment_BankTransferPayment $bankTransferPayment = null)
    {
        if (is_null($bankTransferPayment) || (is_array($bankTransferPayment) && empty($bankTransferPayment))) {
            unset($this->BankTransferPayment);
        } else {
            $this->BankTransferPayment = $bankTransferPayment;
        }
        return $this;
    }
    /**
     * Get ChequeDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Printing_ChequeDetails|null
     */
    public function getChequeDetails()
    {
        return isset($this->ChequeDetails) ? $this->ChequeDetails : null;
    }
    /**
     * Set ChequeDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Printing_ChequeDetails $chequeDetails
     * @return \patest\StructType\Printing_PrintableItem_AnyPaymentItem
     */
    public function setChequeDetails(\patest\StructType\Payment_Printing_ChequeDetails $chequeDetails = null)
    {
        if (is_null($chequeDetails) || (is_array($chequeDetails) && empty($chequeDetails))) {
            unset($this->ChequeDetails);
        } else {
            $this->ChequeDetails = $chequeDetails;
        }
        return $this;
    }
    /**
     * Get DirectDebitPayment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Printing_DirectDebitPayment|null
     */
    public function getDirectDebitPayment()
    {
        return isset($this->DirectDebitPayment) ? $this->DirectDebitPayment : null;
    }
    /**
     * Set DirectDebitPayment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Printing_DirectDebitPayment $directDebitPayment
     * @return \patest\StructType\Printing_PrintableItem_AnyPaymentItem
     */
    public function setDirectDebitPayment(\patest\StructType\Payment_Printing_DirectDebitPayment $directDebitPayment = null)
    {
        if (is_null($directDebitPayment) || (is_array($directDebitPayment) && empty($directDebitPayment))) {
            unset($this->DirectDebitPayment);
        } else {
            $this->DirectDebitPayment = $directDebitPayment;
        }
        return $this;
    }
    /**
     * Get GiftCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_PrintableItem_GiftCard|null
     */
    public function getGiftCard()
    {
        return isset($this->GiftCard) ? $this->GiftCard : null;
    }
    /**
     * Set GiftCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_PrintableItem_GiftCard $giftCard
     * @return \patest\StructType\Printing_PrintableItem_AnyPaymentItem
     */
    public function setGiftCard(\patest\StructType\Payment_PrintableItem_GiftCard $giftCard = null)
    {
        if (is_null($giftCard) || (is_array($giftCard) && empty($giftCard))) {
            unset($this->GiftCard);
        } else {
            $this->GiftCard = $giftCard;
        }
        return $this;
    }
    /**
     * Get LoyaltyPoints value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Printing_LoyaltyPointsDetails|null
     */
    public function getLoyaltyPoints()
    {
        return isset($this->LoyaltyPoints) ? $this->LoyaltyPoints : null;
    }
    /**
     * Set LoyaltyPoints value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Printing_LoyaltyPointsDetails $loyaltyPoints
     * @return \patest\StructType\Printing_PrintableItem_AnyPaymentItem
     */
    public function setLoyaltyPoints(\patest\StructType\Payment_Printing_LoyaltyPointsDetails $loyaltyPoints = null)
    {
        if (is_null($loyaltyPoints) || (is_array($loyaltyPoints) && empty($loyaltyPoints))) {
            unset($this->LoyaltyPoints);
        } else {
            $this->LoyaltyPoints = $loyaltyPoints;
        }
        return $this;
    }
    /**
     * Get PaymentsPlanDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails|null
     */
    public function getPaymentsPlanDetails()
    {
        return isset($this->PaymentsPlanDetails) ? $this->PaymentsPlanDetails : null;
    }
    /**
     * Set PaymentsPlanDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Printing_PaymentsPlanDetails $paymentsPlanDetails
     * @return \patest\StructType\Printing_PrintableItem_AnyPaymentItem
     */
    public function setPaymentsPlanDetails(\patest\StructType\Payment_Printing_PaymentsPlanDetails $paymentsPlanDetails = null)
    {
        if (is_null($paymentsPlanDetails) || (is_array($paymentsPlanDetails) && empty($paymentsPlanDetails))) {
            unset($this->PaymentsPlanDetails);
        } else {
            $this->PaymentsPlanDetails = $paymentsPlanDetails;
        }
        return $this;
    }
    /**
     * Get RefundVoucher value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Printing_RefundVoucher|null
     */
    public function getRefundVoucher()
    {
        return isset($this->RefundVoucher) ? $this->RefundVoucher : null;
    }
    /**
     * Set RefundVoucher value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Printing_RefundVoucher $refundVoucher
     * @return \patest\StructType\Printing_PrintableItem_AnyPaymentItem
     */
    public function setRefundVoucher(\patest\StructType\Payment_Printing_RefundVoucher $refundVoucher = null)
    {
        if (is_null($refundVoucher) || (is_array($refundVoucher) && empty($refundVoucher))) {
            unset($this->RefundVoucher);
        } else {
            $this->RefundVoucher = $refundVoucher;
        }
        return $this;
    }
}
