<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PrintableDocument StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Printing.PrintableDocument
 * @subpackage Structs
 */
class Printing_PrintableDocument extends MaintainableNotDistributableGlobalizedEntity
{
    /**
     * The AccountSalutationFormatId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountSalutationFormatId;
    /**
     * The AclSchemeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AclSchemeId;
    /**
     * The CustomerSalutationFormatId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CustomerSalutationFormatId;
    /**
     * The Design
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Design;
    /**
     * The DocumentTypeId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentTypeId;
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filter;
    /**
     * The ImageResolution
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ImageResolution;
    /**
     * The IncreaseImageQualityForPDF
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncreaseImageQualityForPDF;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The OptimizedDesign
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OptimizedDesign;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferenceId;
    /**
     * The ShouldUseOptimizedDesign
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldUseOptimizedDesign;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * The XmlContainer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $XmlContainer;
    /**
     * Constructor method for Printing.PrintableDocument
     * @uses Printing_PrintableDocument::setAccountSalutationFormatId()
     * @uses Printing_PrintableDocument::setAclSchemeId()
     * @uses Printing_PrintableDocument::setCustomerSalutationFormatId()
     * @uses Printing_PrintableDocument::setDesign()
     * @uses Printing_PrintableDocument::setDocumentTypeId()
     * @uses Printing_PrintableDocument::setFilter()
     * @uses Printing_PrintableDocument::setImageResolution()
     * @uses Printing_PrintableDocument::setIncreaseImageQualityForPDF()
     * @uses Printing_PrintableDocument::setIsActive()
     * @uses Printing_PrintableDocument::setOptimizedDesign()
     * @uses Printing_PrintableDocument::setOrganizationUnitId()
     * @uses Printing_PrintableDocument::setReferenceId()
     * @uses Printing_PrintableDocument::setShouldUseOptimizedDesign()
     * @uses Printing_PrintableDocument::setVisibleBySubordinates()
     * @uses Printing_PrintableDocument::setXmlContainer()
     * @param string $accountSalutationFormatId
     * @param int $aclSchemeId
     * @param string $customerSalutationFormatId
     * @param string $design
     * @param string $documentTypeId
     * @param string $filter
     * @param int $imageResolution
     * @param bool $increaseImageQualityForPDF
     * @param bool $isActive
     * @param string $optimizedDesign
     * @param string $organizationUnitId
     * @param string $referenceId
     * @param bool $shouldUseOptimizedDesign
     * @param bool $visibleBySubordinates
     * @param string $xmlContainer
     */
    public function __construct($accountSalutationFormatId = null, $aclSchemeId = null, $customerSalutationFormatId = null, $design = null, $documentTypeId = null, $filter = null, $imageResolution = null, $increaseImageQualityForPDF = null, $isActive = null, $optimizedDesign = null, $organizationUnitId = null, $referenceId = null, $shouldUseOptimizedDesign = null, $visibleBySubordinates = null, $xmlContainer = null)
    {
        $this
            ->setAccountSalutationFormatId($accountSalutationFormatId)
            ->setAclSchemeId($aclSchemeId)
            ->setCustomerSalutationFormatId($customerSalutationFormatId)
            ->setDesign($design)
            ->setDocumentTypeId($documentTypeId)
            ->setFilter($filter)
            ->setImageResolution($imageResolution)
            ->setIncreaseImageQualityForPDF($increaseImageQualityForPDF)
            ->setIsActive($isActive)
            ->setOptimizedDesign($optimizedDesign)
            ->setOrganizationUnitId($organizationUnitId)
            ->setReferenceId($referenceId)
            ->setShouldUseOptimizedDesign($shouldUseOptimizedDesign)
            ->setVisibleBySubordinates($visibleBySubordinates)
            ->setXmlContainer($xmlContainer);
    }
    /**
     * Get AccountSalutationFormatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountSalutationFormatId()
    {
        return isset($this->AccountSalutationFormatId) ? $this->AccountSalutationFormatId : null;
    }
    /**
     * Set AccountSalutationFormatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountSalutationFormatId
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setAccountSalutationFormatId($accountSalutationFormatId = null)
    {
        // validation for constraint: string
        if (!is_null($accountSalutationFormatId) && !is_string($accountSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountSalutationFormatId, true), gettype($accountSalutationFormatId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountSalutationFormatId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountSalutationFormatId, true)), __LINE__);
        }
        if (is_null($accountSalutationFormatId) || (is_array($accountSalutationFormatId) && empty($accountSalutationFormatId))) {
            unset($this->AccountSalutationFormatId);
        } else {
            $this->AccountSalutationFormatId = $accountSalutationFormatId;
        }
        return $this;
    }
    /**
     * Get AclSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAclSchemeId()
    {
        return isset($this->AclSchemeId) ? $this->AclSchemeId : null;
    }
    /**
     * Set AclSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $aclSchemeId
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setAclSchemeId($aclSchemeId = null)
    {
        // validation for constraint: int
        if (!is_null($aclSchemeId) && !(is_int($aclSchemeId) || ctype_digit($aclSchemeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($aclSchemeId, true), gettype($aclSchemeId)), __LINE__);
        }
        if (is_null($aclSchemeId) || (is_array($aclSchemeId) && empty($aclSchemeId))) {
            unset($this->AclSchemeId);
        } else {
            $this->AclSchemeId = $aclSchemeId;
        }
        return $this;
    }
    /**
     * Get CustomerSalutationFormatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomerSalutationFormatId()
    {
        return isset($this->CustomerSalutationFormatId) ? $this->CustomerSalutationFormatId : null;
    }
    /**
     * Set CustomerSalutationFormatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customerSalutationFormatId
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setCustomerSalutationFormatId($customerSalutationFormatId = null)
    {
        // validation for constraint: string
        if (!is_null($customerSalutationFormatId) && !is_string($customerSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customerSalutationFormatId, true), gettype($customerSalutationFormatId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($customerSalutationFormatId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $customerSalutationFormatId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($customerSalutationFormatId, true)), __LINE__);
        }
        if (is_null($customerSalutationFormatId) || (is_array($customerSalutationFormatId) && empty($customerSalutationFormatId))) {
            unset($this->CustomerSalutationFormatId);
        } else {
            $this->CustomerSalutationFormatId = $customerSalutationFormatId;
        }
        return $this;
    }
    /**
     * Get Design value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDesign()
    {
        return isset($this->Design) ? $this->Design : null;
    }
    /**
     * Set Design value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $design
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setDesign($design = null)
    {
        // validation for constraint: string
        if (!is_null($design) && !is_string($design)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($design, true), gettype($design)), __LINE__);
        }
        if (is_null($design) || (is_array($design) && empty($design))) {
            unset($this->Design);
        } else {
            $this->Design = $design;
        }
        return $this;
    }
    /**
     * Get DocumentTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentTypeId()
    {
        return isset($this->DocumentTypeId) ? $this->DocumentTypeId : null;
    }
    /**
     * Set DocumentTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentTypeId
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setDocumentTypeId($documentTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($documentTypeId) && !is_string($documentTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentTypeId, true), gettype($documentTypeId)), __LINE__);
        }
        if (is_null($documentTypeId) || (is_array($documentTypeId) && empty($documentTypeId))) {
            unset($this->DocumentTypeId);
        } else {
            $this->DocumentTypeId = $documentTypeId;
        }
        return $this;
    }
    /**
     * Get Filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilter()
    {
        return isset($this->Filter) ? $this->Filter : null;
    }
    /**
     * Set Filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filter
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setFilter($filter = null)
    {
        // validation for constraint: string
        if (!is_null($filter) && !is_string($filter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($filter, true), gettype($filter)), __LINE__);
        }
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->Filter);
        } else {
            $this->Filter = $filter;
        }
        return $this;
    }
    /**
     * Get ImageResolution value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getImageResolution()
    {
        return isset($this->ImageResolution) ? $this->ImageResolution : null;
    }
    /**
     * Set ImageResolution value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $imageResolution
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setImageResolution($imageResolution = null)
    {
        // validation for constraint: int
        if (!is_null($imageResolution) && !(is_int($imageResolution) || ctype_digit($imageResolution))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($imageResolution, true), gettype($imageResolution)), __LINE__);
        }
        if (is_null($imageResolution) || (is_array($imageResolution) && empty($imageResolution))) {
            unset($this->ImageResolution);
        } else {
            $this->ImageResolution = $imageResolution;
        }
        return $this;
    }
    /**
     * Get IncreaseImageQualityForPDF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncreaseImageQualityForPDF()
    {
        return isset($this->IncreaseImageQualityForPDF) ? $this->IncreaseImageQualityForPDF : null;
    }
    /**
     * Set IncreaseImageQualityForPDF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $increaseImageQualityForPDF
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setIncreaseImageQualityForPDF($increaseImageQualityForPDF = null)
    {
        // validation for constraint: boolean
        if (!is_null($increaseImageQualityForPDF) && !is_bool($increaseImageQualityForPDF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($increaseImageQualityForPDF, true), gettype($increaseImageQualityForPDF)), __LINE__);
        }
        if (is_null($increaseImageQualityForPDF) || (is_array($increaseImageQualityForPDF) && empty($increaseImageQualityForPDF))) {
            unset($this->IncreaseImageQualityForPDF);
        } else {
            $this->IncreaseImageQualityForPDF = $increaseImageQualityForPDF;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get OptimizedDesign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOptimizedDesign()
    {
        return isset($this->OptimizedDesign) ? $this->OptimizedDesign : null;
    }
    /**
     * Set OptimizedDesign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $optimizedDesign
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setOptimizedDesign($optimizedDesign = null)
    {
        // validation for constraint: string
        if (!is_null($optimizedDesign) && !is_string($optimizedDesign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($optimizedDesign, true), gettype($optimizedDesign)), __LINE__);
        }
        if (is_null($optimizedDesign) || (is_array($optimizedDesign) && empty($optimizedDesign))) {
            unset($this->OptimizedDesign);
        } else {
            $this->OptimizedDesign = $optimizedDesign;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referenceId, true)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
    /**
     * Get ShouldUseOptimizedDesign value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldUseOptimizedDesign()
    {
        return isset($this->ShouldUseOptimizedDesign) ? $this->ShouldUseOptimizedDesign : null;
    }
    /**
     * Set ShouldUseOptimizedDesign value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldUseOptimizedDesign
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setShouldUseOptimizedDesign($shouldUseOptimizedDesign = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldUseOptimizedDesign) && !is_bool($shouldUseOptimizedDesign)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldUseOptimizedDesign, true), gettype($shouldUseOptimizedDesign)), __LINE__);
        }
        if (is_null($shouldUseOptimizedDesign) || (is_array($shouldUseOptimizedDesign) && empty($shouldUseOptimizedDesign))) {
            unset($this->ShouldUseOptimizedDesign);
        } else {
            $this->ShouldUseOptimizedDesign = $shouldUseOptimizedDesign;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
    /**
     * Get XmlContainer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getXmlContainer()
    {
        return isset($this->XmlContainer) ? $this->XmlContainer : null;
    }
    /**
     * Set XmlContainer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $xmlContainer
     * @return \patest\StructType\Printing_PrintableDocument
     */
    public function setXmlContainer($xmlContainer = null)
    {
        // validation for constraint: string
        if (!is_null($xmlContainer) && !is_string($xmlContainer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($xmlContainer, true), gettype($xmlContainer)), __LINE__);
        }
        if (is_null($xmlContainer) || (is_array($xmlContainer) && empty($xmlContainer))) {
            unset($this->XmlContainer);
        } else {
            $this->XmlContainer = $xmlContainer;
        }
        return $this;
    }
}
