<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.PreparedDocumentsSendingHistory StructType
 * @subpackage Structs
 */
class Printing_PreparedDocumentsSendingHistory extends PersistableEntity
{
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The GenerationError
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GenerationError;
    /**
     * The SentToAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SentToAddress;
    /**
     * The SpoolGroupId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpoolGroupId;
    /**
     * The SpoolPrintableItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpoolPrintableItemId;
    /**
     * The SpoolPrintableItemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SpoolPrintableItemName;
    /**
     * Constructor method for Printing.PreparedDocumentsSendingHistory
     * @uses Printing_PreparedDocumentsSendingHistory::setCreationDateTime()
     * @uses Printing_PreparedDocumentsSendingHistory::setGenerationError()
     * @uses Printing_PreparedDocumentsSendingHistory::setSentToAddress()
     * @uses Printing_PreparedDocumentsSendingHistory::setSpoolGroupId()
     * @uses Printing_PreparedDocumentsSendingHistory::setSpoolPrintableItemId()
     * @uses Printing_PreparedDocumentsSendingHistory::setSpoolPrintableItemName()
     * @param string $creationDateTime
     * @param string $generationError
     * @param string $sentToAddress
     * @param string $spoolGroupId
     * @param string $spoolPrintableItemId
     * @param string $spoolPrintableItemName
     */
    public function __construct($creationDateTime = null, $generationError = null, $sentToAddress = null, $spoolGroupId = null, $spoolPrintableItemId = null, $spoolPrintableItemName = null)
    {
        $this
            ->setCreationDateTime($creationDateTime)
            ->setGenerationError($generationError)
            ->setSentToAddress($sentToAddress)
            ->setSpoolGroupId($spoolGroupId)
            ->setSpoolPrintableItemId($spoolPrintableItemId)
            ->setSpoolPrintableItemName($spoolPrintableItemName);
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Printing_PreparedDocumentsSendingHistory
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get GenerationError value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGenerationError()
    {
        return isset($this->GenerationError) ? $this->GenerationError : null;
    }
    /**
     * Set GenerationError value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $generationError
     * @return \patest\StructType\Printing_PreparedDocumentsSendingHistory
     */
    public function setGenerationError($generationError = null)
    {
        // validation for constraint: string
        if (!is_null($generationError) && !is_string($generationError)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($generationError, true), gettype($generationError)), __LINE__);
        }
        if (is_null($generationError) || (is_array($generationError) && empty($generationError))) {
            unset($this->GenerationError);
        } else {
            $this->GenerationError = $generationError;
        }
        return $this;
    }
    /**
     * Get SentToAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSentToAddress()
    {
        return isset($this->SentToAddress) ? $this->SentToAddress : null;
    }
    /**
     * Set SentToAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sentToAddress
     * @return \patest\StructType\Printing_PreparedDocumentsSendingHistory
     */
    public function setSentToAddress($sentToAddress = null)
    {
        // validation for constraint: string
        if (!is_null($sentToAddress) && !is_string($sentToAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sentToAddress, true), gettype($sentToAddress)), __LINE__);
        }
        if (is_null($sentToAddress) || (is_array($sentToAddress) && empty($sentToAddress))) {
            unset($this->SentToAddress);
        } else {
            $this->SentToAddress = $sentToAddress;
        }
        return $this;
    }
    /**
     * Get SpoolGroupId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpoolGroupId()
    {
        return isset($this->SpoolGroupId) ? $this->SpoolGroupId : null;
    }
    /**
     * Set SpoolGroupId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spoolGroupId
     * @return \patest\StructType\Printing_PreparedDocumentsSendingHistory
     */
    public function setSpoolGroupId($spoolGroupId = null)
    {
        // validation for constraint: string
        if (!is_null($spoolGroupId) && !is_string($spoolGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spoolGroupId, true), gettype($spoolGroupId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($spoolGroupId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $spoolGroupId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($spoolGroupId, true)), __LINE__);
        }
        if (is_null($spoolGroupId) || (is_array($spoolGroupId) && empty($spoolGroupId))) {
            unset($this->SpoolGroupId);
        } else {
            $this->SpoolGroupId = $spoolGroupId;
        }
        return $this;
    }
    /**
     * Get SpoolPrintableItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpoolPrintableItemId()
    {
        return isset($this->SpoolPrintableItemId) ? $this->SpoolPrintableItemId : null;
    }
    /**
     * Set SpoolPrintableItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spoolPrintableItemId
     * @return \patest\StructType\Printing_PreparedDocumentsSendingHistory
     */
    public function setSpoolPrintableItemId($spoolPrintableItemId = null)
    {
        // validation for constraint: string
        if (!is_null($spoolPrintableItemId) && !is_string($spoolPrintableItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spoolPrintableItemId, true), gettype($spoolPrintableItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($spoolPrintableItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $spoolPrintableItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($spoolPrintableItemId, true)), __LINE__);
        }
        if (is_null($spoolPrintableItemId) || (is_array($spoolPrintableItemId) && empty($spoolPrintableItemId))) {
            unset($this->SpoolPrintableItemId);
        } else {
            $this->SpoolPrintableItemId = $spoolPrintableItemId;
        }
        return $this;
    }
    /**
     * Get SpoolPrintableItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpoolPrintableItemName()
    {
        return isset($this->SpoolPrintableItemName) ? $this->SpoolPrintableItemName : null;
    }
    /**
     * Set SpoolPrintableItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $spoolPrintableItemName
     * @return \patest\StructType\Printing_PreparedDocumentsSendingHistory
     */
    public function setSpoolPrintableItemName($spoolPrintableItemName = null)
    {
        // validation for constraint: string
        if (!is_null($spoolPrintableItemName) && !is_string($spoolPrintableItemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($spoolPrintableItemName, true), gettype($spoolPrintableItemName)), __LINE__);
        }
        if (is_null($spoolPrintableItemName) || (is_array($spoolPrintableItemName) && empty($spoolPrintableItemName))) {
            unset($this->SpoolPrintableItemName);
        } else {
            $this->SpoolPrintableItemName = $spoolPrintableItemName;
        }
        return $this;
    }
}
