<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.BatchPrint StructType
 * @subpackage Structs
 */
class Printing_BatchPrint extends PersistableEntity
{
    /**
     * The BarcodesGeneratingStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodesGeneratingStatus;
    /**
     * The BatchPrintReasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BatchPrintReasonId;
    /**
     * The BatchPrintRequestData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchPrintRequestData;
    /**
     * The BatchType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BatchType;
    /**
     * The ConnectionAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConnectionAuditId;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The ErroneousGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ErroneousGroups;
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The GeneratedDocuments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_BatchPrintGeneratedDocument
     */
    public $GeneratedDocuments;
    /**
     * The NotifyOnCompletion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotifyOnCompletion;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProcessedGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ProcessedGroups;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TotalGroups
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalGroups;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * Constructor method for Printing.BatchPrint
     * @uses Printing_BatchPrint::setBarcodesGeneratingStatus()
     * @uses Printing_BatchPrint::setBatchPrintReasonId()
     * @uses Printing_BatchPrint::setBatchPrintRequestData()
     * @uses Printing_BatchPrint::setBatchType()
     * @uses Printing_BatchPrint::setConnectionAuditId()
     * @uses Printing_BatchPrint::setCreationDateTime()
     * @uses Printing_BatchPrint::setErroneousGroups()
     * @uses Printing_BatchPrint::setError()
     * @uses Printing_BatchPrint::setGeneratedDocuments()
     * @uses Printing_BatchPrint::setNotifyOnCompletion()
     * @uses Printing_BatchPrint::setOrganizationUnitId()
     * @uses Printing_BatchPrint::setProcessedGroups()
     * @uses Printing_BatchPrint::setStatus()
     * @uses Printing_BatchPrint::setTotalGroups()
     * @uses Printing_BatchPrint::setUserId()
     * @param string $barcodesGeneratingStatus
     * @param string $batchPrintReasonId
     * @param string $batchPrintRequestData
     * @param string $batchType
     * @param int $connectionAuditId
     * @param string $creationDateTime
     * @param int $erroneousGroups
     * @param string $error
     * @param \patest\StructType\RecordSetOfPrinting_BatchPrintGeneratedDocument $generatedDocuments
     * @param string $notifyOnCompletion
     * @param string $organizationUnitId
     * @param int $processedGroups
     * @param string $status
     * @param int $totalGroups
     * @param string $userId
     */
    public function __construct($barcodesGeneratingStatus = null, $batchPrintReasonId = null, $batchPrintRequestData = null, $batchType = null, $connectionAuditId = null, $creationDateTime = null, $erroneousGroups = null, $error = null, \patest\StructType\RecordSetOfPrinting_BatchPrintGeneratedDocument $generatedDocuments = null, $notifyOnCompletion = null, $organizationUnitId = null, $processedGroups = null, $status = null, $totalGroups = null, $userId = null)
    {
        $this
            ->setBarcodesGeneratingStatus($barcodesGeneratingStatus)
            ->setBatchPrintReasonId($batchPrintReasonId)
            ->setBatchPrintRequestData($batchPrintRequestData)
            ->setBatchType($batchType)
            ->setConnectionAuditId($connectionAuditId)
            ->setCreationDateTime($creationDateTime)
            ->setErroneousGroups($erroneousGroups)
            ->setError($error)
            ->setGeneratedDocuments($generatedDocuments)
            ->setNotifyOnCompletion($notifyOnCompletion)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProcessedGroups($processedGroups)
            ->setStatus($status)
            ->setTotalGroups($totalGroups)
            ->setUserId($userId);
    }
    /**
     * Get BarcodesGeneratingStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodesGeneratingStatus()
    {
        return isset($this->BarcodesGeneratingStatus) ? $this->BarcodesGeneratingStatus : null;
    }
    /**
     * Set BarcodesGeneratingStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintStatus::valueIsValid()
     * @uses \patest\EnumType\BatchPrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $barcodesGeneratingStatus
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setBarcodesGeneratingStatus($barcodesGeneratingStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintStatus::valueIsValid($barcodesGeneratingStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintStatus', is_array($barcodesGeneratingStatus) ? implode(', ', $barcodesGeneratingStatus) : var_export($barcodesGeneratingStatus, true), implode(', ', \patest\EnumType\BatchPrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($barcodesGeneratingStatus) || (is_array($barcodesGeneratingStatus) && empty($barcodesGeneratingStatus))) {
            unset($this->BarcodesGeneratingStatus);
        } else {
            $this->BarcodesGeneratingStatus = $barcodesGeneratingStatus;
        }
        return $this;
    }
    /**
     * Get BatchPrintReasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchPrintReasonId()
    {
        return isset($this->BatchPrintReasonId) ? $this->BatchPrintReasonId : null;
    }
    /**
     * Set BatchPrintReasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchPrintReasonId
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setBatchPrintReasonId($batchPrintReasonId = null)
    {
        // validation for constraint: string
        if (!is_null($batchPrintReasonId) && !is_string($batchPrintReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchPrintReasonId, true), gettype($batchPrintReasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($batchPrintReasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $batchPrintReasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($batchPrintReasonId, true)), __LINE__);
        }
        if (is_null($batchPrintReasonId) || (is_array($batchPrintReasonId) && empty($batchPrintReasonId))) {
            unset($this->BatchPrintReasonId);
        } else {
            $this->BatchPrintReasonId = $batchPrintReasonId;
        }
        return $this;
    }
    /**
     * Get BatchPrintRequestData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchPrintRequestData()
    {
        return isset($this->BatchPrintRequestData) ? $this->BatchPrintRequestData : null;
    }
    /**
     * Set BatchPrintRequestData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchPrintRequestData
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setBatchPrintRequestData($batchPrintRequestData = null)
    {
        // validation for constraint: string
        if (!is_null($batchPrintRequestData) && !is_string($batchPrintRequestData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchPrintRequestData, true), gettype($batchPrintRequestData)), __LINE__);
        }
        if (is_null($batchPrintRequestData) || (is_array($batchPrintRequestData) && empty($batchPrintRequestData))) {
            unset($this->BatchPrintRequestData);
        } else {
            $this->BatchPrintRequestData = $batchPrintRequestData;
        }
        return $this;
    }
    /**
     * Get BatchType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBatchType()
    {
        return isset($this->BatchType) ? $this->BatchType : null;
    }
    /**
     * Set BatchType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $batchType
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setBatchType($batchType = null)
    {
        // validation for constraint: string
        if (!is_null($batchType) && !is_string($batchType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($batchType, true), gettype($batchType)), __LINE__);
        }
        if (is_null($batchType) || (is_array($batchType) && empty($batchType))) {
            unset($this->BatchType);
        } else {
            $this->BatchType = $batchType;
        }
        return $this;
    }
    /**
     * Get ConnectionAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConnectionAuditId()
    {
        return isset($this->ConnectionAuditId) ? $this->ConnectionAuditId : null;
    }
    /**
     * Set ConnectionAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $connectionAuditId
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setConnectionAuditId($connectionAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($connectionAuditId) && !(is_int($connectionAuditId) || ctype_digit($connectionAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($connectionAuditId, true), gettype($connectionAuditId)), __LINE__);
        }
        if (is_null($connectionAuditId) || (is_array($connectionAuditId) && empty($connectionAuditId))) {
            unset($this->ConnectionAuditId);
        } else {
            $this->ConnectionAuditId = $connectionAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get ErroneousGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getErroneousGroups()
    {
        return isset($this->ErroneousGroups) ? $this->ErroneousGroups : null;
    }
    /**
     * Set ErroneousGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $erroneousGroups
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setErroneousGroups($erroneousGroups = null)
    {
        // validation for constraint: int
        if (!is_null($erroneousGroups) && !(is_int($erroneousGroups) || ctype_digit($erroneousGroups))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($erroneousGroups, true), gettype($erroneousGroups)), __LINE__);
        }
        if (is_null($erroneousGroups) || (is_array($erroneousGroups) && empty($erroneousGroups))) {
            unset($this->ErroneousGroups);
        } else {
            $this->ErroneousGroups = $erroneousGroups;
        }
        return $this;
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get GeneratedDocuments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_BatchPrintGeneratedDocument|null
     */
    public function getGeneratedDocuments()
    {
        return isset($this->GeneratedDocuments) ? $this->GeneratedDocuments : null;
    }
    /**
     * Set GeneratedDocuments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_BatchPrintGeneratedDocument $generatedDocuments
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setGeneratedDocuments(\patest\StructType\RecordSetOfPrinting_BatchPrintGeneratedDocument $generatedDocuments = null)
    {
        if (is_null($generatedDocuments) || (is_array($generatedDocuments) && empty($generatedDocuments))) {
            unset($this->GeneratedDocuments);
        } else {
            $this->GeneratedDocuments = $generatedDocuments;
        }
        return $this;
    }
    /**
     * Get NotifyOnCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotifyOnCompletion()
    {
        return isset($this->NotifyOnCompletion) ? $this->NotifyOnCompletion : null;
    }
    /**
     * Set NotifyOnCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notifyOnCompletion
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setNotifyOnCompletion($notifyOnCompletion = null)
    {
        // validation for constraint: string
        if (!is_null($notifyOnCompletion) && !is_string($notifyOnCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notifyOnCompletion, true), gettype($notifyOnCompletion)), __LINE__);
        }
        if (is_null($notifyOnCompletion) || (is_array($notifyOnCompletion) && empty($notifyOnCompletion))) {
            unset($this->NotifyOnCompletion);
        } else {
            $this->NotifyOnCompletion = $notifyOnCompletion;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProcessedGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getProcessedGroups()
    {
        return isset($this->ProcessedGroups) ? $this->ProcessedGroups : null;
    }
    /**
     * Set ProcessedGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $processedGroups
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setProcessedGroups($processedGroups = null)
    {
        // validation for constraint: int
        if (!is_null($processedGroups) && !(is_int($processedGroups) || ctype_digit($processedGroups))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processedGroups, true), gettype($processedGroups)), __LINE__);
        }
        if (is_null($processedGroups) || (is_array($processedGroups) && empty($processedGroups))) {
            unset($this->ProcessedGroups);
        } else {
            $this->ProcessedGroups = $processedGroups;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintStatus::valueIsValid()
     * @uses \patest\EnumType\BatchPrintStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BatchPrintStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TotalGroups value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalGroups()
    {
        return isset($this->TotalGroups) ? $this->TotalGroups : null;
    }
    /**
     * Set TotalGroups value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalGroups
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setTotalGroups($totalGroups = null)
    {
        // validation for constraint: int
        if (!is_null($totalGroups) && !(is_int($totalGroups) || ctype_digit($totalGroups))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalGroups, true), gettype($totalGroups)), __LINE__);
        }
        if (is_null($totalGroups) || (is_array($totalGroups) && empty($totalGroups))) {
            unset($this->TotalGroups);
        } else {
            $this->TotalGroups = $totalGroups;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Printing_BatchPrint
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
}
