<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AvailableDocumentTypes StructType
 * @subpackage Structs
 */
class Printing_AvailableDocumentTypes extends AnyEntity
{
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentId;
    /**
     * The DocumentName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentName;
    /**
     * The IsProductItemDocumentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsProductItemDocumentType;
    /**
     * The IsSubsTicketDocument
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSubsTicketDocument;
    /**
     * Constructor method for Printing.AvailableDocumentTypes
     * @uses Printing_AvailableDocumentTypes::setDocumentId()
     * @uses Printing_AvailableDocumentTypes::setDocumentName()
     * @uses Printing_AvailableDocumentTypes::setIsProductItemDocumentType()
     * @uses Printing_AvailableDocumentTypes::setIsSubsTicketDocument()
     * @param string $documentId
     * @param string $documentName
     * @param bool $isProductItemDocumentType
     * @param bool $isSubsTicketDocument
     */
    public function __construct($documentId = null, $documentName = null, $isProductItemDocumentType = null, $isSubsTicketDocument = null)
    {
        $this
            ->setDocumentId($documentId)
            ->setDocumentName($documentName)
            ->setIsProductItemDocumentType($isProductItemDocumentType)
            ->setIsSubsTicketDocument($isSubsTicketDocument);
    }
    /**
     * Get DocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentId()
    {
        return isset($this->DocumentId) ? $this->DocumentId : null;
    }
    /**
     * Set DocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentId
     * @return \patest\StructType\Printing_AvailableDocumentTypes
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        if (is_null($documentId) || (is_array($documentId) && empty($documentId))) {
            unset($this->DocumentId);
        } else {
            $this->DocumentId = $documentId;
        }
        return $this;
    }
    /**
     * Get DocumentName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentName()
    {
        return isset($this->DocumentName) ? $this->DocumentName : null;
    }
    /**
     * Set DocumentName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentName
     * @return \patest\StructType\Printing_AvailableDocumentTypes
     */
    public function setDocumentName($documentName = null)
    {
        // validation for constraint: string
        if (!is_null($documentName) && !is_string($documentName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentName, true), gettype($documentName)), __LINE__);
        }
        if (is_null($documentName) || (is_array($documentName) && empty($documentName))) {
            unset($this->DocumentName);
        } else {
            $this->DocumentName = $documentName;
        }
        return $this;
    }
    /**
     * Get IsProductItemDocumentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsProductItemDocumentType()
    {
        return isset($this->IsProductItemDocumentType) ? $this->IsProductItemDocumentType : null;
    }
    /**
     * Set IsProductItemDocumentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isProductItemDocumentType
     * @return \patest\StructType\Printing_AvailableDocumentTypes
     */
    public function setIsProductItemDocumentType($isProductItemDocumentType = null)
    {
        // validation for constraint: boolean
        if (!is_null($isProductItemDocumentType) && !is_bool($isProductItemDocumentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isProductItemDocumentType, true), gettype($isProductItemDocumentType)), __LINE__);
        }
        if (is_null($isProductItemDocumentType) || (is_array($isProductItemDocumentType) && empty($isProductItemDocumentType))) {
            unset($this->IsProductItemDocumentType);
        } else {
            $this->IsProductItemDocumentType = $isProductItemDocumentType;
        }
        return $this;
    }
    /**
     * Get IsSubsTicketDocument value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSubsTicketDocument()
    {
        return isset($this->IsSubsTicketDocument) ? $this->IsSubsTicketDocument : null;
    }
    /**
     * Set IsSubsTicketDocument value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSubsTicketDocument
     * @return \patest\StructType\Printing_AvailableDocumentTypes
     */
    public function setIsSubsTicketDocument($isSubsTicketDocument = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSubsTicketDocument) && !is_bool($isSubsTicketDocument)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSubsTicketDocument, true), gettype($isSubsTicketDocument)), __LINE__);
        }
        if (is_null($isSubsTicketDocument) || (is_array($isSubsTicketDocument) && empty($isSubsTicketDocument))) {
            unset($this->IsSubsTicketDocument);
        } else {
            $this->IsSubsTicketDocument = $isSubsTicketDocument;
        }
        return $this;
    }
}
