<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.DeliveryItem StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_DeliveryItem extends Printing_AuxiliaryDataItem_Base
{
    /**
     * The Client
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_Owner
     */
    public $Client;
    /**
     * The CrmAddressId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CrmAddressId;
    /**
     * The CrmClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CrmClientId;
    /**
     * The DeliveryAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_PrintableItem_DeliveryAddress
     */
    public $DeliveryAddress;
    /**
     * The DeliveryMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DeliveryMethod;
    /**
     * The Totals
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Sales_Printing_ItemTotals
     */
    public $Totals;
    /**
     * Constructor method for Printing.AuxDataItem.DeliveryItem
     * @uses Printing_AuxDataItem_DeliveryItem::setClient()
     * @uses Printing_AuxDataItem_DeliveryItem::setCrmAddressId()
     * @uses Printing_AuxDataItem_DeliveryItem::setCrmClientId()
     * @uses Printing_AuxDataItem_DeliveryItem::setDeliveryAddress()
     * @uses Printing_AuxDataItem_DeliveryItem::setDeliveryMethod()
     * @uses Printing_AuxDataItem_DeliveryItem::setTotals()
     * @param \patest\StructType\Printing_AuxDataItem_Owner $client
     * @param string $crmAddressId
     * @param string $crmClientId
     * @param \patest\StructType\Printing_PrintableItem_DeliveryAddress $deliveryAddress
     * @param \patest\StructType\GlobalString $deliveryMethod
     * @param \patest\StructType\Sales_Printing_ItemTotals $totals
     */
    public function __construct(\patest\StructType\Printing_AuxDataItem_Owner $client = null, $crmAddressId = null, $crmClientId = null, \patest\StructType\Printing_PrintableItem_DeliveryAddress $deliveryAddress = null, \patest\StructType\GlobalString $deliveryMethod = null, \patest\StructType\Sales_Printing_ItemTotals $totals = null)
    {
        $this
            ->setClient($client)
            ->setCrmAddressId($crmAddressId)
            ->setCrmClientId($crmClientId)
            ->setDeliveryAddress($deliveryAddress)
            ->setDeliveryMethod($deliveryMethod)
            ->setTotals($totals);
    }
    /**
     * Get Client value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_Owner|null
     */
    public function getClient()
    {
        return isset($this->Client) ? $this->Client : null;
    }
    /**
     * Set Client value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_Owner $client
     * @return \patest\StructType\Printing_AuxDataItem_DeliveryItem
     */
    public function setClient(\patest\StructType\Printing_AuxDataItem_Owner $client = null)
    {
        if (is_null($client) || (is_array($client) && empty($client))) {
            unset($this->Client);
        } else {
            $this->Client = $client;
        }
        return $this;
    }
    /**
     * Get CrmAddressId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmAddressId()
    {
        return isset($this->CrmAddressId) ? $this->CrmAddressId : null;
    }
    /**
     * Set CrmAddressId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmAddressId
     * @return \patest\StructType\Printing_AuxDataItem_DeliveryItem
     */
    public function setCrmAddressId($crmAddressId = null)
    {
        // validation for constraint: string
        if (!is_null($crmAddressId) && !is_string($crmAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmAddressId, true), gettype($crmAddressId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($crmAddressId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $crmAddressId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($crmAddressId, true)), __LINE__);
        }
        if (is_null($crmAddressId) || (is_array($crmAddressId) && empty($crmAddressId))) {
            unset($this->CrmAddressId);
        } else {
            $this->CrmAddressId = $crmAddressId;
        }
        return $this;
    }
    /**
     * Get CrmClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmClientId()
    {
        return isset($this->CrmClientId) ? $this->CrmClientId : null;
    }
    /**
     * Set CrmClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmClientId
     * @return \patest\StructType\Printing_AuxDataItem_DeliveryItem
     */
    public function setCrmClientId($crmClientId = null)
    {
        // validation for constraint: string
        if (!is_null($crmClientId) && !is_string($crmClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmClientId, true), gettype($crmClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($crmClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $crmClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($crmClientId, true)), __LINE__);
        }
        if (is_null($crmClientId) || (is_array($crmClientId) && empty($crmClientId))) {
            unset($this->CrmClientId);
        } else {
            $this->CrmClientId = $crmClientId;
        }
        return $this;
    }
    /**
     * Get DeliveryAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_PrintableItem_DeliveryAddress|null
     */
    public function getDeliveryAddress()
    {
        return isset($this->DeliveryAddress) ? $this->DeliveryAddress : null;
    }
    /**
     * Set DeliveryAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_PrintableItem_DeliveryAddress $deliveryAddress
     * @return \patest\StructType\Printing_AuxDataItem_DeliveryItem
     */
    public function setDeliveryAddress(\patest\StructType\Printing_PrintableItem_DeliveryAddress $deliveryAddress = null)
    {
        if (is_null($deliveryAddress) || (is_array($deliveryAddress) && empty($deliveryAddress))) {
            unset($this->DeliveryAddress);
        } else {
            $this->DeliveryAddress = $deliveryAddress;
        }
        return $this;
    }
    /**
     * Get DeliveryMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDeliveryMethod()
    {
        return isset($this->DeliveryMethod) ? $this->DeliveryMethod : null;
    }
    /**
     * Set DeliveryMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $deliveryMethod
     * @return \patest\StructType\Printing_AuxDataItem_DeliveryItem
     */
    public function setDeliveryMethod(\patest\StructType\GlobalString $deliveryMethod = null)
    {
        if (is_null($deliveryMethod) || (is_array($deliveryMethod) && empty($deliveryMethod))) {
            unset($this->DeliveryMethod);
        } else {
            $this->DeliveryMethod = $deliveryMethod;
        }
        return $this;
    }
    /**
     * Get Totals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Sales_Printing_ItemTotals|null
     */
    public function getTotals()
    {
        return isset($this->Totals) ? $this->Totals : null;
    }
    /**
     * Set Totals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Sales_Printing_ItemTotals $totals
     * @return \patest\StructType\Printing_AuxDataItem_DeliveryItem
     */
    public function setTotals(\patest\StructType\Sales_Printing_ItemTotals $totals = null)
    {
        if (is_null($totals) || (is_array($totals) && empty($totals))) {
            unset($this->Totals);
        } else {
            $this->Totals = $totals;
        }
        return $this;
    }
}
