<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.ConnectionProperties StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_ConnectionProperties extends Printing_AuxiliaryDataItem_Base
{
    /**
     * The ApplicationChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationChannel;
    /**
     * The ApplicationChannelName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ApplicationChannelName;
    /**
     * The AuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AuditId;
    /**
     * The CompanyCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCurrencyCode;
    /**
     * The CompanyCurrencySymbol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyCurrencySymbol;
    /**
     * The CompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CompanyName;
    /**
     * The CompanyTimezoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CompanyTimezoneId;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The FallbackCultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FallbackCultureId;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The OrganizationUnitName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganizationUnitName;
    /**
     * The OrgUnitAccount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount
     */
    public $OrgUnitAccount;
    /**
     * The PrintingCultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintingCultureId;
    /**
     * The SalePointName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalePointName;
    /**
     * The SecurityTokenName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SecurityTokenName;
    /**
     * The SiteCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencyCode;
    /**
     * The SiteCurrencySymbol
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteCurrencySymbol;
    /**
     * The SiteName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SiteName;
    /**
     * The SiteTimezoneId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SiteTimezoneId;
    /**
     * The SystemFallbackCultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SystemFallbackCultureId;
    /**
     * The TillGroupName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TillGroupName;
    /**
     * The TillName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $TillName;
    /**
     * The UserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserId;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * The UserProfileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $UserProfileName;
    /**
     * Constructor method for Printing.AuxDataItem.ConnectionProperties
     * @uses Printing_AuxDataItem_ConnectionProperties::setApplicationChannel()
     * @uses Printing_AuxDataItem_ConnectionProperties::setApplicationChannelName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setAuditId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setCompanyCurrencyCode()
     * @uses Printing_AuxDataItem_ConnectionProperties::setCompanyCurrencySymbol()
     * @uses Printing_AuxDataItem_ConnectionProperties::setCompanyName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setCompanyTimezoneId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setCultureId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setFallbackCultureId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setOrganizationUnitId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setOrganizationUnitName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setOrgUnitAccount()
     * @uses Printing_AuxDataItem_ConnectionProperties::setPrintingCultureId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setSalePointName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setSecurityTokenName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setSiteCurrencyCode()
     * @uses Printing_AuxDataItem_ConnectionProperties::setSiteCurrencySymbol()
     * @uses Printing_AuxDataItem_ConnectionProperties::setSiteName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setSiteTimezoneId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setSystemFallbackCultureId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setTillGroupName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setTillName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setUserId()
     * @uses Printing_AuxDataItem_ConnectionProperties::setUserName()
     * @uses Printing_AuxDataItem_ConnectionProperties::setUserProfileName()
     * @param string $applicationChannel
     * @param \patest\StructType\GlobalString $applicationChannelName
     * @param int $auditId
     * @param string $companyCurrencyCode
     * @param string $companyCurrencySymbol
     * @param \patest\StructType\GlobalString $companyName
     * @param string $companyTimezoneId
     * @param int $cultureId
     * @param int $fallbackCultureId
     * @param string $organizationUnitId
     * @param string $organizationUnitName
     * @param \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $orgUnitAccount
     * @param int $printingCultureId
     * @param \patest\StructType\GlobalString $salePointName
     * @param \patest\StructType\GlobalString $securityTokenName
     * @param string $siteCurrencyCode
     * @param string $siteCurrencySymbol
     * @param \patest\StructType\GlobalString $siteName
     * @param string $siteTimezoneId
     * @param int $systemFallbackCultureId
     * @param \patest\StructType\GlobalString $tillGroupName
     * @param \patest\StructType\GlobalString $tillName
     * @param string $userId
     * @param string $userName
     * @param \patest\StructType\GlobalString $userProfileName
     */
    public function __construct($applicationChannel = null, \patest\StructType\GlobalString $applicationChannelName = null, $auditId = null, $companyCurrencyCode = null, $companyCurrencySymbol = null, \patest\StructType\GlobalString $companyName = null, $companyTimezoneId = null, $cultureId = null, $fallbackCultureId = null, $organizationUnitId = null, $organizationUnitName = null, \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $orgUnitAccount = null, $printingCultureId = null, \patest\StructType\GlobalString $salePointName = null, \patest\StructType\GlobalString $securityTokenName = null, $siteCurrencyCode = null, $siteCurrencySymbol = null, \patest\StructType\GlobalString $siteName = null, $siteTimezoneId = null, $systemFallbackCultureId = null, \patest\StructType\GlobalString $tillGroupName = null, \patest\StructType\GlobalString $tillName = null, $userId = null, $userName = null, \patest\StructType\GlobalString $userProfileName = null)
    {
        $this
            ->setApplicationChannel($applicationChannel)
            ->setApplicationChannelName($applicationChannelName)
            ->setAuditId($auditId)
            ->setCompanyCurrencyCode($companyCurrencyCode)
            ->setCompanyCurrencySymbol($companyCurrencySymbol)
            ->setCompanyName($companyName)
            ->setCompanyTimezoneId($companyTimezoneId)
            ->setCultureId($cultureId)
            ->setFallbackCultureId($fallbackCultureId)
            ->setOrganizationUnitId($organizationUnitId)
            ->setOrganizationUnitName($organizationUnitName)
            ->setOrgUnitAccount($orgUnitAccount)
            ->setPrintingCultureId($printingCultureId)
            ->setSalePointName($salePointName)
            ->setSecurityTokenName($securityTokenName)
            ->setSiteCurrencyCode($siteCurrencyCode)
            ->setSiteCurrencySymbol($siteCurrencySymbol)
            ->setSiteName($siteName)
            ->setSiteTimezoneId($siteTimezoneId)
            ->setSystemFallbackCultureId($systemFallbackCultureId)
            ->setTillGroupName($tillGroupName)
            ->setTillName($tillName)
            ->setUserId($userId)
            ->setUserName($userName)
            ->setUserProfileName($userProfileName);
    }
    /**
     * Get ApplicationChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationChannel()
    {
        return isset($this->ApplicationChannel) ? $this->ApplicationChannel : null;
    }
    /**
     * Set ApplicationChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationChannel
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setApplicationChannel($applicationChannel = null)
    {
        // validation for constraint: string
        if (!is_null($applicationChannel) && !is_string($applicationChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationChannel, true), gettype($applicationChannel)), __LINE__);
        }
        if (is_null($applicationChannel) || (is_array($applicationChannel) && empty($applicationChannel))) {
            unset($this->ApplicationChannel);
        } else {
            $this->ApplicationChannel = $applicationChannel;
        }
        return $this;
    }
    /**
     * Get ApplicationChannelName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getApplicationChannelName()
    {
        return isset($this->ApplicationChannelName) ? $this->ApplicationChannelName : null;
    }
    /**
     * Set ApplicationChannelName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $applicationChannelName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setApplicationChannelName(\patest\StructType\GlobalString $applicationChannelName = null)
    {
        if (is_null($applicationChannelName) || (is_array($applicationChannelName) && empty($applicationChannelName))) {
            unset($this->ApplicationChannelName);
        } else {
            $this->ApplicationChannelName = $applicationChannelName;
        }
        return $this;
    }
    /**
     * Get AuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAuditId()
    {
        return isset($this->AuditId) ? $this->AuditId : null;
    }
    /**
     * Set AuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $auditId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setAuditId($auditId = null)
    {
        // validation for constraint: int
        if (!is_null($auditId) && !(is_int($auditId) || ctype_digit($auditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($auditId, true), gettype($auditId)), __LINE__);
        }
        if (is_null($auditId) || (is_array($auditId) && empty($auditId))) {
            unset($this->AuditId);
        } else {
            $this->AuditId = $auditId;
        }
        return $this;
    }
    /**
     * Get CompanyCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCurrencyCode()
    {
        return isset($this->CompanyCurrencyCode) ? $this->CompanyCurrencyCode : null;
    }
    /**
     * Set CompanyCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCurrencyCode
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setCompanyCurrencyCode($companyCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($companyCurrencyCode) && !is_string($companyCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCurrencyCode, true), gettype($companyCurrencyCode)), __LINE__);
        }
        if (is_null($companyCurrencyCode) || (is_array($companyCurrencyCode) && empty($companyCurrencyCode))) {
            unset($this->CompanyCurrencyCode);
        } else {
            $this->CompanyCurrencyCode = $companyCurrencyCode;
        }
        return $this;
    }
    /**
     * Get CompanyCurrencySymbol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyCurrencySymbol()
    {
        return isset($this->CompanyCurrencySymbol) ? $this->CompanyCurrencySymbol : null;
    }
    /**
     * Set CompanyCurrencySymbol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyCurrencySymbol
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setCompanyCurrencySymbol($companyCurrencySymbol = null)
    {
        // validation for constraint: string
        if (!is_null($companyCurrencySymbol) && !is_string($companyCurrencySymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyCurrencySymbol, true), gettype($companyCurrencySymbol)), __LINE__);
        }
        if (is_null($companyCurrencySymbol) || (is_array($companyCurrencySymbol) && empty($companyCurrencySymbol))) {
            unset($this->CompanyCurrencySymbol);
        } else {
            $this->CompanyCurrencySymbol = $companyCurrencySymbol;
        }
        return $this;
    }
    /**
     * Get CompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCompanyName()
    {
        return isset($this->CompanyName) ? $this->CompanyName : null;
    }
    /**
     * Set CompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $companyName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setCompanyName(\patest\StructType\GlobalString $companyName = null)
    {
        if (is_null($companyName) || (is_array($companyName) && empty($companyName))) {
            unset($this->CompanyName);
        } else {
            $this->CompanyName = $companyName;
        }
        return $this;
    }
    /**
     * Get CompanyTimezoneId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCompanyTimezoneId()
    {
        return isset($this->CompanyTimezoneId) ? $this->CompanyTimezoneId : null;
    }
    /**
     * Set CompanyTimezoneId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $companyTimezoneId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setCompanyTimezoneId($companyTimezoneId = null)
    {
        // validation for constraint: string
        if (!is_null($companyTimezoneId) && !is_string($companyTimezoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($companyTimezoneId, true), gettype($companyTimezoneId)), __LINE__);
        }
        if (is_null($companyTimezoneId) || (is_array($companyTimezoneId) && empty($companyTimezoneId))) {
            unset($this->CompanyTimezoneId);
        } else {
            $this->CompanyTimezoneId = $companyTimezoneId;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get FallbackCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFallbackCultureId()
    {
        return isset($this->FallbackCultureId) ? $this->FallbackCultureId : null;
    }
    /**
     * Set FallbackCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $fallbackCultureId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setFallbackCultureId($fallbackCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($fallbackCultureId) && !(is_int($fallbackCultureId) || ctype_digit($fallbackCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($fallbackCultureId, true), gettype($fallbackCultureId)), __LINE__);
        }
        if (is_null($fallbackCultureId) || (is_array($fallbackCultureId) && empty($fallbackCultureId))) {
            unset($this->FallbackCultureId);
        } else {
            $this->FallbackCultureId = $fallbackCultureId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitName()
    {
        return isset($this->OrganizationUnitName) ? $this->OrganizationUnitName : null;
    }
    /**
     * Set OrganizationUnitName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setOrganizationUnitName($organizationUnitName = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitName) && !is_string($organizationUnitName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitName, true), gettype($organizationUnitName)), __LINE__);
        }
        if (is_null($organizationUnitName) || (is_array($organizationUnitName) && empty($organizationUnitName))) {
            unset($this->OrganizationUnitName);
        } else {
            $this->OrganizationUnitName = $organizationUnitName;
        }
        return $this;
    }
    /**
     * Get OrgUnitAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount|null
     */
    public function getOrgUnitAccount()
    {
        return isset($this->OrgUnitAccount) ? $this->OrgUnitAccount : null;
    }
    /**
     * Set OrgUnitAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $orgUnitAccount
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setOrgUnitAccount(\patest\StructType\Printing_AuxDataItem_BusinessPartyAccount $orgUnitAccount = null)
    {
        if (is_null($orgUnitAccount) || (is_array($orgUnitAccount) && empty($orgUnitAccount))) {
            unset($this->OrgUnitAccount);
        } else {
            $this->OrgUnitAccount = $orgUnitAccount;
        }
        return $this;
    }
    /**
     * Get PrintingCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintingCultureId()
    {
        return isset($this->PrintingCultureId) ? $this->PrintingCultureId : null;
    }
    /**
     * Set PrintingCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printingCultureId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setPrintingCultureId($printingCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($printingCultureId) && !(is_int($printingCultureId) || ctype_digit($printingCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printingCultureId, true), gettype($printingCultureId)), __LINE__);
        }
        if (is_null($printingCultureId) || (is_array($printingCultureId) && empty($printingCultureId))) {
            unset($this->PrintingCultureId);
        } else {
            $this->PrintingCultureId = $printingCultureId;
        }
        return $this;
    }
    /**
     * Get SalePointName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalePointName()
    {
        return isset($this->SalePointName) ? $this->SalePointName : null;
    }
    /**
     * Set SalePointName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salePointName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setSalePointName(\patest\StructType\GlobalString $salePointName = null)
    {
        if (is_null($salePointName) || (is_array($salePointName) && empty($salePointName))) {
            unset($this->SalePointName);
        } else {
            $this->SalePointName = $salePointName;
        }
        return $this;
    }
    /**
     * Get SecurityTokenName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSecurityTokenName()
    {
        return isset($this->SecurityTokenName) ? $this->SecurityTokenName : null;
    }
    /**
     * Set SecurityTokenName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $securityTokenName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setSecurityTokenName(\patest\StructType\GlobalString $securityTokenName = null)
    {
        if (is_null($securityTokenName) || (is_array($securityTokenName) && empty($securityTokenName))) {
            unset($this->SecurityTokenName);
        } else {
            $this->SecurityTokenName = $securityTokenName;
        }
        return $this;
    }
    /**
     * Get SiteCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencyCode()
    {
        return isset($this->SiteCurrencyCode) ? $this->SiteCurrencyCode : null;
    }
    /**
     * Set SiteCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencyCode
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setSiteCurrencyCode($siteCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencyCode) && !is_string($siteCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencyCode, true), gettype($siteCurrencyCode)), __LINE__);
        }
        if (is_null($siteCurrencyCode) || (is_array($siteCurrencyCode) && empty($siteCurrencyCode))) {
            unset($this->SiteCurrencyCode);
        } else {
            $this->SiteCurrencyCode = $siteCurrencyCode;
        }
        return $this;
    }
    /**
     * Get SiteCurrencySymbol value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteCurrencySymbol()
    {
        return isset($this->SiteCurrencySymbol) ? $this->SiteCurrencySymbol : null;
    }
    /**
     * Set SiteCurrencySymbol value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteCurrencySymbol
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setSiteCurrencySymbol($siteCurrencySymbol = null)
    {
        // validation for constraint: string
        if (!is_null($siteCurrencySymbol) && !is_string($siteCurrencySymbol)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteCurrencySymbol, true), gettype($siteCurrencySymbol)), __LINE__);
        }
        if (is_null($siteCurrencySymbol) || (is_array($siteCurrencySymbol) && empty($siteCurrencySymbol))) {
            unset($this->SiteCurrencySymbol);
        } else {
            $this->SiteCurrencySymbol = $siteCurrencySymbol;
        }
        return $this;
    }
    /**
     * Get SiteName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSiteName()
    {
        return isset($this->SiteName) ? $this->SiteName : null;
    }
    /**
     * Set SiteName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $siteName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setSiteName(\patest\StructType\GlobalString $siteName = null)
    {
        if (is_null($siteName) || (is_array($siteName) && empty($siteName))) {
            unset($this->SiteName);
        } else {
            $this->SiteName = $siteName;
        }
        return $this;
    }
    /**
     * Get SiteTimezoneId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSiteTimezoneId()
    {
        return isset($this->SiteTimezoneId) ? $this->SiteTimezoneId : null;
    }
    /**
     * Set SiteTimezoneId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $siteTimezoneId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setSiteTimezoneId($siteTimezoneId = null)
    {
        // validation for constraint: string
        if (!is_null($siteTimezoneId) && !is_string($siteTimezoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($siteTimezoneId, true), gettype($siteTimezoneId)), __LINE__);
        }
        if (is_null($siteTimezoneId) || (is_array($siteTimezoneId) && empty($siteTimezoneId))) {
            unset($this->SiteTimezoneId);
        } else {
            $this->SiteTimezoneId = $siteTimezoneId;
        }
        return $this;
    }
    /**
     * Get SystemFallbackCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSystemFallbackCultureId()
    {
        return isset($this->SystemFallbackCultureId) ? $this->SystemFallbackCultureId : null;
    }
    /**
     * Set SystemFallbackCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $systemFallbackCultureId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setSystemFallbackCultureId($systemFallbackCultureId = null)
    {
        // validation for constraint: int
        if (!is_null($systemFallbackCultureId) && !(is_int($systemFallbackCultureId) || ctype_digit($systemFallbackCultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($systemFallbackCultureId, true), gettype($systemFallbackCultureId)), __LINE__);
        }
        if (is_null($systemFallbackCultureId) || (is_array($systemFallbackCultureId) && empty($systemFallbackCultureId))) {
            unset($this->SystemFallbackCultureId);
        } else {
            $this->SystemFallbackCultureId = $systemFallbackCultureId;
        }
        return $this;
    }
    /**
     * Get TillGroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTillGroupName()
    {
        return isset($this->TillGroupName) ? $this->TillGroupName : null;
    }
    /**
     * Set TillGroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $tillGroupName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setTillGroupName(\patest\StructType\GlobalString $tillGroupName = null)
    {
        if (is_null($tillGroupName) || (is_array($tillGroupName) && empty($tillGroupName))) {
            unset($this->TillGroupName);
        } else {
            $this->TillGroupName = $tillGroupName;
        }
        return $this;
    }
    /**
     * Get TillName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getTillName()
    {
        return isset($this->TillName) ? $this->TillName : null;
    }
    /**
     * Set TillName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $tillName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setTillName(\patest\StructType\GlobalString $tillName = null)
    {
        if (is_null($tillName) || (is_array($tillName) && empty($tillName))) {
            unset($this->TillName);
        } else {
            $this->TillName = $tillName;
        }
        return $this;
    }
    /**
     * Get UserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserId()
    {
        return isset($this->UserId) ? $this->UserId : null;
    }
    /**
     * Set UserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userId
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userId, true), gettype($userId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userId, true)), __LINE__);
        }
        if (is_null($userId) || (is_array($userId) && empty($userId))) {
            unset($this->UserId);
        } else {
            $this->UserId = $userId;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
    /**
     * Get UserProfileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getUserProfileName()
    {
        return isset($this->UserProfileName) ? $this->UserProfileName : null;
    }
    /**
     * Set UserProfileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $userProfileName
     * @return \patest\StructType\Printing_AuxDataItem_ConnectionProperties
     */
    public function setUserProfileName(\patest\StructType\GlobalString $userProfileName = null)
    {
        if (is_null($userProfileName) || (is_array($userProfileName) && empty($userProfileName))) {
            unset($this->UserProfileName);
        } else {
            $this->UserProfileName = $userProfileName;
        }
        return $this;
    }
}
