<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Printing.AuxDataItem.Client StructType
 * @subpackage Structs
 */
class Printing_AuxDataItem_Client extends Printing_AuxiliaryDataItem_Base
{
    /**
     * The AddressDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails
     */
    public $AddressDetails;
    /**
     * The Addresses
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientAddresses
     */
    public $Addresses;
    /**
     * The ClientTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientTypeDetail
     */
    public $ClientTypes;
    /**
     * The ContactDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail
     */
    public $ContactDetails;
    /**
     * The Contacts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientContacts
     */
    public $Contacts;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDateTime;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrmId;
    /**
     * The CultureId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CultureId;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ExtraFields
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Printing_AuxDataItem_ClientExtraFields
     */
    public $ExtraFields;
    /**
     * The IsGroupLeader
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsGroupLeader;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Note;
    /**
     * The PictureUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PictureUrl;
    /**
     * The PreferredCultureId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PreferredCultureId;
    /**
     * The SalutationIndividualText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SalutationIndividualText;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $Type;
    /**
     * The VatRegistrationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VatRegistrationNumber;
    /**
     * Constructor method for Printing.AuxDataItem.Client
     * @uses Printing_AuxDataItem_Client::setAddressDetails()
     * @uses Printing_AuxDataItem_Client::setAddresses()
     * @uses Printing_AuxDataItem_Client::setClientTypes()
     * @uses Printing_AuxDataItem_Client::setContactDetails()
     * @uses Printing_AuxDataItem_Client::setContacts()
     * @uses Printing_AuxDataItem_Client::setCreationDateTime()
     * @uses Printing_AuxDataItem_Client::setCrmId()
     * @uses Printing_AuxDataItem_Client::setCultureId()
     * @uses Printing_AuxDataItem_Client::setExternalId()
     * @uses Printing_AuxDataItem_Client::setExtraFields()
     * @uses Printing_AuxDataItem_Client::setIsGroupLeader()
     * @uses Printing_AuxDataItem_Client::setName()
     * @uses Printing_AuxDataItem_Client::setNote()
     * @uses Printing_AuxDataItem_Client::setPictureUrl()
     * @uses Printing_AuxDataItem_Client::setPreferredCultureId()
     * @uses Printing_AuxDataItem_Client::setSalutationIndividualText()
     * @uses Printing_AuxDataItem_Client::setType()
     * @uses Printing_AuxDataItem_Client::setVatRegistrationNumber()
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientTypeDetail $clientTypes
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails
     * @param \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts
     * @param string $creationDateTime
     * @param string $crmId
     * @param int $cultureId
     * @param string $externalId
     * @param \patest\StructType\Printing_AuxDataItem_ClientExtraFields $extraFields
     * @param bool $isGroupLeader
     * @param string $name
     * @param \patest\StructType\GlobalString $note
     * @param string $pictureUrl
     * @param string $preferredCultureId
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @param string[] $type
     * @param string $vatRegistrationNumber
     */
    public function __construct(\patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails = null, \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses = null, \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientTypeDetail $clientTypes = null, \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails = null, \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts = null, $creationDateTime = null, $crmId = null, $cultureId = null, $externalId = null, \patest\StructType\Printing_AuxDataItem_ClientExtraFields $extraFields = null, $isGroupLeader = null, $name = null, \patest\StructType\GlobalString $note = null, $pictureUrl = null, $preferredCultureId = null, \patest\StructType\GlobalString $salutationIndividualText = null, array $type = array(), $vatRegistrationNumber = null)
    {
        $this
            ->setAddressDetails($addressDetails)
            ->setAddresses($addresses)
            ->setClientTypes($clientTypes)
            ->setContactDetails($contactDetails)
            ->setContacts($contacts)
            ->setCreationDateTime($creationDateTime)
            ->setCrmId($crmId)
            ->setCultureId($cultureId)
            ->setExternalId($externalId)
            ->setExtraFields($extraFields)
            ->setIsGroupLeader($isGroupLeader)
            ->setName($name)
            ->setNote($note)
            ->setPictureUrl($pictureUrl)
            ->setPreferredCultureId($preferredCultureId)
            ->setSalutationIndividualText($salutationIndividualText)
            ->setType($type)
            ->setVatRegistrationNumber($vatRegistrationNumber);
    }
    /**
     * Get AddressDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails|null
     */
    public function getAddressDetails()
    {
        return isset($this->AddressDetails) ? $this->AddressDetails : null;
    }
    /**
     * Set AddressDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setAddressDetails(\patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientAddressDetails $addressDetails = null)
    {
        if (is_null($addressDetails) || (is_array($addressDetails) && empty($addressDetails))) {
            unset($this->AddressDetails);
        } else {
            $this->AddressDetails = $addressDetails;
        }
        return $this;
    }
    /**
     * Get Addresses value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientAddresses|null
     */
    public function getAddresses()
    {
        return isset($this->Addresses) ? $this->Addresses : null;
    }
    /**
     * Set Addresses value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setAddresses(\patest\StructType\Printing_AuxDataItem_ClientAddresses $addresses = null)
    {
        if (is_null($addresses) || (is_array($addresses) && empty($addresses))) {
            unset($this->Addresses);
        } else {
            $this->Addresses = $addresses;
        }
        return $this;
    }
    /**
     * Get ClientTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientTypeDetail|null
     */
    public function getClientTypes()
    {
        return isset($this->ClientTypes) ? $this->ClientTypes : null;
    }
    /**
     * Set ClientTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientTypeDetail $clientTypes
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setClientTypes(\patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientTypeDetail $clientTypes = null)
    {
        if (is_null($clientTypes) || (is_array($clientTypes) && empty($clientTypes))) {
            unset($this->ClientTypes);
        } else {
            $this->ClientTypes = $clientTypes;
        }
        return $this;
    }
    /**
     * Get ContactDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail|null
     */
    public function getContactDetails()
    {
        return isset($this->ContactDetails) ? $this->ContactDetails : null;
    }
    /**
     * Set ContactDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setContactDetails(\patest\StructType\RecordSetOfPrinting_AuxDataItem_ClientContactDetail $contactDetails = null)
    {
        if (is_null($contactDetails) || (is_array($contactDetails) && empty($contactDetails))) {
            unset($this->ContactDetails);
        } else {
            $this->ContactDetails = $contactDetails;
        }
        return $this;
    }
    /**
     * Get Contacts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientContacts|null
     */
    public function getContacts()
    {
        return isset($this->Contacts) ? $this->Contacts : null;
    }
    /**
     * Set Contacts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientContacts $contacts
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setContacts(\patest\StructType\Printing_AuxDataItem_ClientContacts $contacts = null)
    {
        if (is_null($contacts) || (is_array($contacts) && empty($contacts))) {
            unset($this->Contacts);
        } else {
            $this->Contacts = $contacts;
        }
        return $this;
    }
    /**
     * Get CreationDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return isset($this->CreationDateTime) ? $this->CreationDateTime : null;
    }
    /**
     * Set CreationDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDateTime
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        if (is_null($creationDateTime) || (is_array($creationDateTime) && empty($creationDateTime))) {
            unset($this->CreationDateTime);
        } else {
            $this->CreationDateTime = $creationDateTime;
        }
        return $this;
    }
    /**
     * Get CrmId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrmId()
    {
        return isset($this->CrmId) ? $this->CrmId : null;
    }
    /**
     * Set CrmId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crmId
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        if (is_null($crmId) || (is_array($crmId) && empty($crmId))) {
            unset($this->CrmId);
        } else {
            $this->CrmId = $crmId;
        }
        return $this;
    }
    /**
     * Get CultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCultureId()
    {
        return isset($this->CultureId) ? $this->CultureId : null;
    }
    /**
     * Set CultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $cultureId
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setCultureId($cultureId = null)
    {
        // validation for constraint: int
        if (!is_null($cultureId) && !(is_int($cultureId) || ctype_digit($cultureId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($cultureId, true), gettype($cultureId)), __LINE__);
        }
        if (is_null($cultureId) || (is_array($cultureId) && empty($cultureId))) {
            unset($this->CultureId);
        } else {
            $this->CultureId = $cultureId;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ExtraFields value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Printing_AuxDataItem_ClientExtraFields|null
     */
    public function getExtraFields()
    {
        return isset($this->ExtraFields) ? $this->ExtraFields : null;
    }
    /**
     * Set ExtraFields value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Printing_AuxDataItem_ClientExtraFields $extraFields
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setExtraFields(\patest\StructType\Printing_AuxDataItem_ClientExtraFields $extraFields = null)
    {
        if (is_null($extraFields) || (is_array($extraFields) && empty($extraFields))) {
            unset($this->ExtraFields);
        } else {
            $this->ExtraFields = $extraFields;
        }
        return $this;
    }
    /**
     * Get IsGroupLeader value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsGroupLeader()
    {
        return isset($this->IsGroupLeader) ? $this->IsGroupLeader : null;
    }
    /**
     * Set IsGroupLeader value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isGroupLeader
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setIsGroupLeader($isGroupLeader = null)
    {
        // validation for constraint: boolean
        if (!is_null($isGroupLeader) && !is_bool($isGroupLeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isGroupLeader, true), gettype($isGroupLeader)), __LINE__);
        }
        if (is_null($isGroupLeader) || (is_array($isGroupLeader) && empty($isGroupLeader))) {
            unset($this->IsGroupLeader);
        } else {
            $this->IsGroupLeader = $isGroupLeader;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $note
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setNote(\patest\StructType\GlobalString $note = null)
    {
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get PictureUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPictureUrl()
    {
        return isset($this->PictureUrl) ? $this->PictureUrl : null;
    }
    /**
     * Set PictureUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pictureUrl
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setPictureUrl($pictureUrl = null)
    {
        // validation for constraint: string
        if (!is_null($pictureUrl) && !is_string($pictureUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pictureUrl, true), gettype($pictureUrl)), __LINE__);
        }
        if (is_null($pictureUrl) || (is_array($pictureUrl) && empty($pictureUrl))) {
            unset($this->PictureUrl);
        } else {
            $this->PictureUrl = $pictureUrl;
        }
        return $this;
    }
    /**
     * Get PreferredCultureId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreferredCultureId()
    {
        return isset($this->PreferredCultureId) ? $this->PreferredCultureId : null;
    }
    /**
     * Set PreferredCultureId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $preferredCultureId
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setPreferredCultureId($preferredCultureId = null)
    {
        // validation for constraint: string
        if (!is_null($preferredCultureId) && !is_string($preferredCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($preferredCultureId, true), gettype($preferredCultureId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($preferredCultureId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $preferredCultureId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($preferredCultureId, true)), __LINE__);
        }
        if (is_null($preferredCultureId) || (is_array($preferredCultureId) && empty($preferredCultureId))) {
            unset($this->PreferredCultureId);
        } else {
            $this->PreferredCultureId = $preferredCultureId;
        }
        return $this;
    }
    /**
     * Get SalutationIndividualText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSalutationIndividualText()
    {
        return isset($this->SalutationIndividualText) ? $this->SalutationIndividualText : null;
    }
    /**
     * Set SalutationIndividualText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $salutationIndividualText
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setSalutationIndividualText(\patest\StructType\GlobalString $salutationIndividualText = null)
    {
        if (is_null($salutationIndividualText) || (is_array($salutationIndividualText) && empty($salutationIndividualText))) {
            unset($this->SalutationIndividualText);
        } else {
            $this->SalutationIndividualText = $salutationIndividualText;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * This method is responsible for validating the values passed to the setType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTypeForArrayConstraintsFromSetType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $printing_AuxDataItem_ClientTypeItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CrmClientKind::valueIsValid($printing_AuxDataItem_ClientTypeItem)) {
                $invalidValues[] = is_object($printing_AuxDataItem_ClientTypeItem) ? get_class($printing_AuxDataItem_ClientTypeItem) : sprintf('%s(%s)', gettype($printing_AuxDataItem_ClientTypeItem), var_export($printing_AuxDataItem_ClientTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrmClientKind', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CrmClientKind::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrmClientKind::valueIsValid()
     * @uses \patest\EnumType\CrmClientKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $type
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setType(array $type = array())
    {
        // validation for constraint: list
        if ('' !== ($typeArrayErrorMessage = self::validateTypeForArrayConstraintsFromSetType($type))) {
            throw new \InvalidArgumentException($typeArrayErrorMessage, __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = is_array($type) ? implode(' ', $type) : null;
        }
        return $this;
    }
    /**
     * Get VatRegistrationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVatRegistrationNumber()
    {
        return isset($this->VatRegistrationNumber) ? $this->VatRegistrationNumber : null;
    }
    /**
     * Set VatRegistrationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vatRegistrationNumber
     * @return \patest\StructType\Printing_AuxDataItem_Client
     */
    public function setVatRegistrationNumber($vatRegistrationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($vatRegistrationNumber) && !is_string($vatRegistrationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($vatRegistrationNumber, true), gettype($vatRegistrationNumber)), __LINE__);
        }
        if (is_null($vatRegistrationNumber) || (is_array($vatRegistrationNumber) && empty($vatRegistrationNumber))) {
            unset($this->VatRegistrationNumber);
        } else {
            $this->VatRegistrationNumber = $vatRegistrationNumber;
        }
        return $this;
    }
}
