<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceTypeDescriptor StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceTypeDescriptor
 * @subpackage Structs
 */
class PriceTypeDescriptor extends AbstractStructBase
{
    /**
     * The DescriptionForDisplay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $DescriptionForDisplay;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * Constructor method for PriceTypeDescriptor
     * @uses PriceTypeDescriptor::setDescriptionForDisplay()
     * @uses PriceTypeDescriptor::setId()
     * @param \patest\StructType\GlobalString $descriptionForDisplay
     * @param string $id
     */
    public function __construct(\patest\StructType\GlobalString $descriptionForDisplay = null, $id = null)
    {
        $this
            ->setDescriptionForDisplay($descriptionForDisplay)
            ->setId($id);
    }
    /**
     * Get DescriptionForDisplay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescriptionForDisplay()
    {
        return isset($this->DescriptionForDisplay) ? $this->DescriptionForDisplay : null;
    }
    /**
     * Set DescriptionForDisplay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $descriptionForDisplay
     * @return \patest\StructType\PriceTypeDescriptor
     */
    public function setDescriptionForDisplay(\patest\StructType\GlobalString $descriptionForDisplay = null)
    {
        if (is_null($descriptionForDisplay) || (is_array($descriptionForDisplay) && empty($descriptionForDisplay))) {
            unset($this->DescriptionForDisplay);
        } else {
            $this->DescriptionForDisplay = $descriptionForDisplay;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\PriceTypeDescriptor
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
}
