<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PriceModifierOverride StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PriceModifierOverride
 * @subpackage Structs
 */
class PriceModifierOverride extends AbstractStructBase
{
    /**
     * The NewAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var \patest\StructType\Money
     */
    public $NewAmount;
    /**
     * The PriceModifierId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $PriceModifierId;
    /**
     * The ResetToDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ResetToDefault;
    /**
     * Constructor method for PriceModifierOverride
     * @uses PriceModifierOverride::setNewAmount()
     * @uses PriceModifierOverride::setPriceModifierId()
     * @uses PriceModifierOverride::setResetToDefault()
     * @param \patest\StructType\Money $newAmount
     * @param int $priceModifierId
     * @param bool $resetToDefault
     */
    public function __construct(\patest\StructType\Money $newAmount = null, $priceModifierId = null, $resetToDefault = null)
    {
        $this
            ->setNewAmount($newAmount)
            ->setPriceModifierId($priceModifierId)
            ->setResetToDefault($resetToDefault);
    }
    /**
     * Get NewAmount value
     * @return \patest\StructType\Money|null
     */
    public function getNewAmount()
    {
        return $this->NewAmount;
    }
    /**
     * Set NewAmount value
     * @param \patest\StructType\Money $newAmount
     * @return \patest\StructType\PriceModifierOverride
     */
    public function setNewAmount(\patest\StructType\Money $newAmount = null)
    {
        $this->NewAmount = $newAmount;
        return $this;
    }
    /**
     * Get PriceModifierId value
     * @return int|null
     */
    public function getPriceModifierId()
    {
        return $this->PriceModifierId;
    }
    /**
     * Set PriceModifierId value
     * @param int $priceModifierId
     * @return \patest\StructType\PriceModifierOverride
     */
    public function setPriceModifierId($priceModifierId = null)
    {
        // validation for constraint: int
        if (!is_null($priceModifierId) && !(is_int($priceModifierId) || ctype_digit($priceModifierId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priceModifierId, true), gettype($priceModifierId)), __LINE__);
        }
        $this->PriceModifierId = $priceModifierId;
        return $this;
    }
    /**
     * Get ResetToDefault value
     * @return bool|null
     */
    public function getResetToDefault()
    {
        return $this->ResetToDefault;
    }
    /**
     * Set ResetToDefault value
     * @param bool $resetToDefault
     * @return \patest\StructType\PriceModifierOverride
     */
    public function setResetToDefault($resetToDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($resetToDefault) && !is_bool($resetToDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($resetToDefault, true), gettype($resetToDefault)), __LINE__);
        }
        $this->ResetToDefault = $resetToDefault;
        return $this;
    }
}
