<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresalesRankWeightResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PresalesRankWeightResponse
 * @subpackage Structs
 */
class PresalesRankWeightResponse extends AbstractStructBase
{
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The RankWeight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RankWeight;
    /**
     * Constructor method for PresalesRankWeightResponse
     * @uses PresalesRankWeightResponse::setId()
     * @uses PresalesRankWeightResponse::setRankWeight()
     * @param string $id
     * @param int $rankWeight
     */
    public function __construct($id = null, $rankWeight = null)
    {
        $this
            ->setId($id)
            ->setRankWeight($rankWeight);
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\PresalesRankWeightResponse
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get RankWeight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRankWeight()
    {
        return isset($this->RankWeight) ? $this->RankWeight : null;
    }
    /**
     * Set RankWeight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rankWeight
     * @return \patest\StructType\PresalesRankWeightResponse
     */
    public function setRankWeight($rankWeight = null)
    {
        // validation for constraint: int
        if (!is_null($rankWeight) && !(is_int($rankWeight) || ctype_digit($rankWeight))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rankWeight, true), gettype($rankWeight)), __LINE__);
        }
        if (is_null($rankWeight) || (is_array($rankWeight) && empty($rankWeight))) {
            unset($this->RankWeight);
        } else {
            $this->RankWeight = $rankWeight;
        }
        return $this;
    }
}
