<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresaleHistoryDescriptor StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PresaleHistoryDescriptor
 * @subpackage Structs
 */
class PresaleHistoryDescriptor extends AbstractStructBase
{
    /**
     * The Activity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Activity;
    /**
     * The DateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DateTime;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The NewValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewValue;
    /**
     * The OldValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldValue;
    /**
     * The PropertyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PropertyName;
    /**
     * The UserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserName;
    /**
     * Constructor method for PresaleHistoryDescriptor
     * @uses PresaleHistoryDescriptor::setActivity()
     * @uses PresaleHistoryDescriptor::setDateTime()
     * @uses PresaleHistoryDescriptor::setId()
     * @uses PresaleHistoryDescriptor::setNewValue()
     * @uses PresaleHistoryDescriptor::setOldValue()
     * @uses PresaleHistoryDescriptor::setPropertyName()
     * @uses PresaleHistoryDescriptor::setUserName()
     * @param string $activity
     * @param string $dateTime
     * @param string $id
     * @param string $newValue
     * @param string $oldValue
     * @param string $propertyName
     * @param string $userName
     */
    public function __construct($activity = null, $dateTime = null, $id = null, $newValue = null, $oldValue = null, $propertyName = null, $userName = null)
    {
        $this
            ->setActivity($activity)
            ->setDateTime($dateTime)
            ->setId($id)
            ->setNewValue($newValue)
            ->setOldValue($oldValue)
            ->setPropertyName($propertyName)
            ->setUserName($userName);
    }
    /**
     * Get Activity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActivity()
    {
        return isset($this->Activity) ? $this->Activity : null;
    }
    /**
     * Set Activity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $activity
     * @return \patest\StructType\PresaleHistoryDescriptor
     */
    public function setActivity($activity = null)
    {
        // validation for constraint: string
        if (!is_null($activity) && !is_string($activity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($activity, true), gettype($activity)), __LINE__);
        }
        if (is_null($activity) || (is_array($activity) && empty($activity))) {
            unset($this->Activity);
        } else {
            $this->Activity = $activity;
        }
        return $this;
    }
    /**
     * Get DateTime value
     * @return string|null
     */
    public function getDateTime()
    {
        return $this->DateTime;
    }
    /**
     * Set DateTime value
     * @param string $dateTime
     * @return \patest\StructType\PresaleHistoryDescriptor
     */
    public function setDateTime($dateTime = null)
    {
        // validation for constraint: string
        if (!is_null($dateTime) && !is_string($dateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTime, true), gettype($dateTime)), __LINE__);
        }
        $this->DateTime = $dateTime;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\PresaleHistoryDescriptor
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get NewValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewValue()
    {
        return isset($this->NewValue) ? $this->NewValue : null;
    }
    /**
     * Set NewValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newValue
     * @return \patest\StructType\PresaleHistoryDescriptor
     */
    public function setNewValue($newValue = null)
    {
        // validation for constraint: string
        if (!is_null($newValue) && !is_string($newValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newValue, true), gettype($newValue)), __LINE__);
        }
        if (is_null($newValue) || (is_array($newValue) && empty($newValue))) {
            unset($this->NewValue);
        } else {
            $this->NewValue = $newValue;
        }
        return $this;
    }
    /**
     * Get OldValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldValue()
    {
        return isset($this->OldValue) ? $this->OldValue : null;
    }
    /**
     * Set OldValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldValue
     * @return \patest\StructType\PresaleHistoryDescriptor
     */
    public function setOldValue($oldValue = null)
    {
        // validation for constraint: string
        if (!is_null($oldValue) && !is_string($oldValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldValue, true), gettype($oldValue)), __LINE__);
        }
        if (is_null($oldValue) || (is_array($oldValue) && empty($oldValue))) {
            unset($this->OldValue);
        } else {
            $this->OldValue = $oldValue;
        }
        return $this;
    }
    /**
     * Get PropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPropertyName()
    {
        return isset($this->PropertyName) ? $this->PropertyName : null;
    }
    /**
     * Set PropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $propertyName
     * @return \patest\StructType\PresaleHistoryDescriptor
     */
    public function setPropertyName($propertyName = null)
    {
        // validation for constraint: string
        if (!is_null($propertyName) && !is_string($propertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($propertyName, true), gettype($propertyName)), __LINE__);
        }
        if (is_null($propertyName) || (is_array($propertyName) && empty($propertyName))) {
            unset($this->PropertyName);
        } else {
            $this->PropertyName = $propertyName;
        }
        return $this;
    }
    /**
     * Get UserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserName()
    {
        return isset($this->UserName) ? $this->UserName : null;
    }
    /**
     * Set UserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userName
     * @return \patest\StructType\PresaleHistoryDescriptor
     */
    public function setUserName($userName = null)
    {
        // validation for constraint: string
        if (!is_null($userName) && !is_string($userName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userName, true), gettype($userName)), __LINE__);
        }
        if (is_null($userName) || (is_array($userName) && empty($userName))) {
            unset($this->UserName);
        } else {
            $this->UserName = $userName;
        }
        return $this;
    }
}
