<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresaleEventDescriptor StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PresaleEventDescriptor
 * @subpackage Structs
 */
class PresaleEventDescriptor extends AbstractStructBase
{
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $EventDate;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The PreviewUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreviewUrl;
    /**
     * The PublicVisibilityEndTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublicVisibilityEndTime;
    /**
     * The PublicVisibilityStartTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PublicVisibilityStartTime;
    /**
     * Constructor method for PresaleEventDescriptor
     * @uses PresaleEventDescriptor::setEventDate()
     * @uses PresaleEventDescriptor::setId()
     * @uses PresaleEventDescriptor::setName()
     * @uses PresaleEventDescriptor::setPreviewUrl()
     * @uses PresaleEventDescriptor::setPublicVisibilityEndTime()
     * @uses PresaleEventDescriptor::setPublicVisibilityStartTime()
     * @param string $eventDate
     * @param string $id
     * @param \patest\StructType\GlobalString $name
     * @param string $previewUrl
     * @param string $publicVisibilityEndTime
     * @param string $publicVisibilityStartTime
     */
    public function __construct($eventDate = null, $id = null, \patest\StructType\GlobalString $name = null, $previewUrl = null, $publicVisibilityEndTime = null, $publicVisibilityStartTime = null)
    {
        $this
            ->setEventDate($eventDate)
            ->setId($id)
            ->setName($name)
            ->setPreviewUrl($previewUrl)
            ->setPublicVisibilityEndTime($publicVisibilityEndTime)
            ->setPublicVisibilityStartTime($publicVisibilityStartTime);
    }
    /**
     * Get EventDate value
     * @return string|null
     */
    public function getEventDate()
    {
        return $this->EventDate;
    }
    /**
     * Set EventDate value
     * @param string $eventDate
     * @return \patest\StructType\PresaleEventDescriptor
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        $this->EventDate = $eventDate;
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \patest\StructType\PresaleEventDescriptor
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\PresaleEventDescriptor
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get PreviewUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviewUrl()
    {
        return isset($this->PreviewUrl) ? $this->PreviewUrl : null;
    }
    /**
     * Set PreviewUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previewUrl
     * @return \patest\StructType\PresaleEventDescriptor
     */
    public function setPreviewUrl($previewUrl = null)
    {
        // validation for constraint: string
        if (!is_null($previewUrl) && !is_string($previewUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previewUrl, true), gettype($previewUrl)), __LINE__);
        }
        if (is_null($previewUrl) || (is_array($previewUrl) && empty($previewUrl))) {
            unset($this->PreviewUrl);
        } else {
            $this->PreviewUrl = $previewUrl;
        }
        return $this;
    }
    /**
     * Get PublicVisibilityEndTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublicVisibilityEndTime()
    {
        return isset($this->PublicVisibilityEndTime) ? $this->PublicVisibilityEndTime : null;
    }
    /**
     * Set PublicVisibilityEndTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publicVisibilityEndTime
     * @return \patest\StructType\PresaleEventDescriptor
     */
    public function setPublicVisibilityEndTime($publicVisibilityEndTime = null)
    {
        // validation for constraint: string
        if (!is_null($publicVisibilityEndTime) && !is_string($publicVisibilityEndTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicVisibilityEndTime, true), gettype($publicVisibilityEndTime)), __LINE__);
        }
        if (is_null($publicVisibilityEndTime) || (is_array($publicVisibilityEndTime) && empty($publicVisibilityEndTime))) {
            unset($this->PublicVisibilityEndTime);
        } else {
            $this->PublicVisibilityEndTime = $publicVisibilityEndTime;
        }
        return $this;
    }
    /**
     * Get PublicVisibilityStartTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublicVisibilityStartTime()
    {
        return isset($this->PublicVisibilityStartTime) ? $this->PublicVisibilityStartTime : null;
    }
    /**
     * Set PublicVisibilityStartTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $publicVisibilityStartTime
     * @return \patest\StructType\PresaleEventDescriptor
     */
    public function setPublicVisibilityStartTime($publicVisibilityStartTime = null)
    {
        // validation for constraint: string
        if (!is_null($publicVisibilityStartTime) && !is_string($publicVisibilityStartTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($publicVisibilityStartTime, true), gettype($publicVisibilityStartTime)), __LINE__);
        }
        if (is_null($publicVisibilityStartTime) || (is_array($publicVisibilityStartTime) && empty($publicVisibilityStartTime))) {
            unset($this->PublicVisibilityStartTime);
        } else {
            $this->PublicVisibilityStartTime = $publicVisibilityStartTime;
        }
        return $this;
    }
}
