<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PresaleCodeStatus-Response StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PresaleCodeStatus-Response
 * @subpackage Structs
 */
class PresaleCodeStatus_Response extends AbstractStructBase
{
    /**
     * The CompletionPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CompletionPct;
    /**
     * The FailedCodes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $FailedCodes;
    /**
     * The IsComplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsComplete;
    /**
     * Constructor method for PresaleCodeStatus-Response
     * @uses PresaleCodeStatus_Response::setCompletionPct()
     * @uses PresaleCodeStatus_Response::setFailedCodes()
     * @uses PresaleCodeStatus_Response::setIsComplete()
     * @param float $completionPct
     * @param \patest\ArrayType\ArrayOfstring $failedCodes
     * @param bool $isComplete
     */
    public function __construct($completionPct = null, \patest\ArrayType\ArrayOfstring $failedCodes = null, $isComplete = null)
    {
        $this
            ->setCompletionPct($completionPct)
            ->setFailedCodes($failedCodes)
            ->setIsComplete($isComplete);
    }
    /**
     * Get CompletionPct value
     * @return float|null
     */
    public function getCompletionPct()
    {
        return $this->CompletionPct;
    }
    /**
     * Set CompletionPct value
     * @param float $completionPct
     * @return \patest\StructType\PresaleCodeStatus_Response
     */
    public function setCompletionPct($completionPct = null)
    {
        // validation for constraint: float
        if (!is_null($completionPct) && !(is_float($completionPct) || is_numeric($completionPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($completionPct, true), gettype($completionPct)), __LINE__);
        }
        $this->CompletionPct = $completionPct;
        return $this;
    }
    /**
     * Get FailedCodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getFailedCodes()
    {
        return isset($this->FailedCodes) ? $this->FailedCodes : null;
    }
    /**
     * Set FailedCodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $failedCodes
     * @return \patest\StructType\PresaleCodeStatus_Response
     */
    public function setFailedCodes(\patest\ArrayType\ArrayOfstring $failedCodes = null)
    {
        if (is_null($failedCodes) || (is_array($failedCodes) && empty($failedCodes))) {
            unset($this->FailedCodes);
        } else {
            $this->FailedCodes = $failedCodes;
        }
        return $this;
    }
    /**
     * Get IsComplete value
     * @return bool|null
     */
    public function getIsComplete()
    {
        return $this->IsComplete;
    }
    /**
     * Set IsComplete value
     * @param bool $isComplete
     * @return \patest\StructType\PresaleCodeStatus_Response
     */
    public function setIsComplete($isComplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplete) && !is_bool($isComplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplete, true), gettype($isComplete)), __LINE__);
        }
        $this->IsComplete = $isComplete;
        return $this;
    }
}
