<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PrepareAvailabilityFilterForBundleElementRequest
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PrepareAvailabilityFilterForBundleElementRequest
 * @subpackage Structs
 */
class PrepareAvailabilityFilterForBundleElementRequest extends ExtensibleDataContract
{
    /**
     * The BundleElementId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleElementId;
    /**
     * The BundleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BundleId;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $PriceTypeIds;
    /**
     * Constructor method for PrepareAvailabilityFilterForBundleElementRequest
     * @uses PrepareAvailabilityFilterForBundleElementRequest::setBundleElementId()
     * @uses PrepareAvailabilityFilterForBundleElementRequest::setBundleId()
     * @uses PrepareAvailabilityFilterForBundleElementRequest::setEventId()
     * @uses PrepareAvailabilityFilterForBundleElementRequest::setPriceTypeIds()
     * @param string $bundleElementId
     * @param string $bundleId
     * @param string $eventId
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     */
    public function __construct($bundleElementId = null, $bundleId = null, $eventId = null, \patest\ArrayType\ArrayOfguid $priceTypeIds = null)
    {
        $this
            ->setBundleElementId($bundleElementId)
            ->setBundleId($bundleId)
            ->setEventId($eventId)
            ->setPriceTypeIds($priceTypeIds);
    }
    /**
     * Get BundleElementId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBundleElementId()
    {
        return isset($this->BundleElementId) ? $this->BundleElementId : null;
    }
    /**
     * Set BundleElementId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bundleElementId
     * @return \patest\StructType\PrepareAvailabilityFilterForBundleElementRequest
     */
    public function setBundleElementId($bundleElementId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleElementId) && !is_string($bundleElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleElementId, true), gettype($bundleElementId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleElementId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleElementId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleElementId, true)), __LINE__);
        }
        if (is_null($bundleElementId) || (is_array($bundleElementId) && empty($bundleElementId))) {
            unset($this->BundleElementId);
        } else {
            $this->BundleElementId = $bundleElementId;
        }
        return $this;
    }
    /**
     * Get BundleId value
     * @return string|null
     */
    public function getBundleId()
    {
        return $this->BundleId;
    }
    /**
     * Set BundleId value
     * @param string $bundleId
     * @return \patest\StructType\PrepareAvailabilityFilterForBundleElementRequest
     */
    public function setBundleId($bundleId = null)
    {
        // validation for constraint: string
        if (!is_null($bundleId) && !is_string($bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bundleId, true), gettype($bundleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bundleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bundleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bundleId, true)), __LINE__);
        }
        $this->BundleId = $bundleId;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\PrepareAvailabilityFilterForBundleElementRequest
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $priceTypeIds
     * @return \patest\StructType\PrepareAvailabilityFilterForBundleElementRequest
     */
    public function setPriceTypeIds(\patest\ArrayType\ArrayOfguid $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
}
