<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PersistUserAcknowledgementReactionsRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PersistUserAcknowledgementReactionsRequest
 * @subpackage Structs
 */
class PersistUserAcknowledgementReactionsRequest extends ExtensibleDataContract
{
    /**
     * The ActionType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionType;
    /**
     * The CreatedAt
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $CreatedAt;
    /**
     * The CrmId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CrmId;
    /**
     * The OpenTransactionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpenTransactionId;
    /**
     * The OpenUserId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OpenUserId;
    /**
     * The Reactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfUserAcknowledgementReaction
     */
    public $Reactions;
    /**
     * The SeatGeekActionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $SeatGeekActionId;
    /**
     * The TransactionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionId;
    /**
     * Constructor method for PersistUserAcknowledgementReactionsRequest
     * @uses PersistUserAcknowledgementReactionsRequest::setActionType()
     * @uses PersistUserAcknowledgementReactionsRequest::setCreatedAt()
     * @uses PersistUserAcknowledgementReactionsRequest::setCrmId()
     * @uses PersistUserAcknowledgementReactionsRequest::setOpenTransactionId()
     * @uses PersistUserAcknowledgementReactionsRequest::setOpenUserId()
     * @uses PersistUserAcknowledgementReactionsRequest::setReactions()
     * @uses PersistUserAcknowledgementReactionsRequest::setSeatGeekActionId()
     * @uses PersistUserAcknowledgementReactionsRequest::setTransactionId()
     * @param string $actionType
     * @param string $createdAt
     * @param string $crmId
     * @param string $openTransactionId
     * @param string $openUserId
     * @param \patest\ArrayType\ArrayOfUserAcknowledgementReaction $reactions
     * @param int $seatGeekActionId
     * @param string $transactionId
     */
    public function __construct($actionType = null, $createdAt = null, $crmId = null, $openTransactionId = null, $openUserId = null, \patest\ArrayType\ArrayOfUserAcknowledgementReaction $reactions = null, $seatGeekActionId = null, $transactionId = null)
    {
        $this
            ->setActionType($actionType)
            ->setCreatedAt($createdAt)
            ->setCrmId($crmId)
            ->setOpenTransactionId($openTransactionId)
            ->setOpenUserId($openUserId)
            ->setReactions($reactions)
            ->setSeatGeekActionId($seatGeekActionId)
            ->setTransactionId($transactionId);
    }
    /**
     * Get ActionType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionType()
    {
        return isset($this->ActionType) ? $this->ActionType : null;
    }
    /**
     * Set ActionType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionType
     * @return \patest\StructType\PersistUserAcknowledgementReactionsRequest
     */
    public function setActionType($actionType = null)
    {
        // validation for constraint: string
        if (!is_null($actionType) && !is_string($actionType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionType, true), gettype($actionType)), __LINE__);
        }
        if (is_null($actionType) || (is_array($actionType) && empty($actionType))) {
            unset($this->ActionType);
        } else {
            $this->ActionType = $actionType;
        }
        return $this;
    }
    /**
     * Get CreatedAt value
     * @return string|null
     */
    public function getCreatedAt()
    {
        return $this->CreatedAt;
    }
    /**
     * Set CreatedAt value
     * @param string $createdAt
     * @return \patest\StructType\PersistUserAcknowledgementReactionsRequest
     */
    public function setCreatedAt($createdAt = null)
    {
        // validation for constraint: string
        if (!is_null($createdAt) && !is_string($createdAt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createdAt, true), gettype($createdAt)), __LINE__);
        }
        $this->CreatedAt = $createdAt;
        return $this;
    }
    /**
     * Get CrmId value
     * @return string|null
     */
    public function getCrmId()
    {
        return $this->CrmId;
    }
    /**
     * Set CrmId value
     * @param string $crmId
     * @return \patest\StructType\PersistUserAcknowledgementReactionsRequest
     */
    public function setCrmId($crmId = null)
    {
        // validation for constraint: string
        if (!is_null($crmId) && !is_string($crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crmId, true), gettype($crmId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($crmId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $crmId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($crmId, true)), __LINE__);
        }
        $this->CrmId = $crmId;
        return $this;
    }
    /**
     * Get OpenTransactionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenTransactionId()
    {
        return isset($this->OpenTransactionId) ? $this->OpenTransactionId : null;
    }
    /**
     * Set OpenTransactionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openTransactionId
     * @return \patest\StructType\PersistUserAcknowledgementReactionsRequest
     */
    public function setOpenTransactionId($openTransactionId = null)
    {
        // validation for constraint: string
        if (!is_null($openTransactionId) && !is_string($openTransactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openTransactionId, true), gettype($openTransactionId)), __LINE__);
        }
        if (is_null($openTransactionId) || (is_array($openTransactionId) && empty($openTransactionId))) {
            unset($this->OpenTransactionId);
        } else {
            $this->OpenTransactionId = $openTransactionId;
        }
        return $this;
    }
    /**
     * Get OpenUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOpenUserId()
    {
        return isset($this->OpenUserId) ? $this->OpenUserId : null;
    }
    /**
     * Set OpenUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $openUserId
     * @return \patest\StructType\PersistUserAcknowledgementReactionsRequest
     */
    public function setOpenUserId($openUserId = null)
    {
        // validation for constraint: string
        if (!is_null($openUserId) && !is_string($openUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($openUserId, true), gettype($openUserId)), __LINE__);
        }
        if (is_null($openUserId) || (is_array($openUserId) && empty($openUserId))) {
            unset($this->OpenUserId);
        } else {
            $this->OpenUserId = $openUserId;
        }
        return $this;
    }
    /**
     * Get Reactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfUserAcknowledgementReaction|null
     */
    public function getReactions()
    {
        return isset($this->Reactions) ? $this->Reactions : null;
    }
    /**
     * Set Reactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfUserAcknowledgementReaction $reactions
     * @return \patest\StructType\PersistUserAcknowledgementReactionsRequest
     */
    public function setReactions(\patest\ArrayType\ArrayOfUserAcknowledgementReaction $reactions = null)
    {
        if (is_null($reactions) || (is_array($reactions) && empty($reactions))) {
            unset($this->Reactions);
        } else {
            $this->Reactions = $reactions;
        }
        return $this;
    }
    /**
     * Get SeatGeekActionId value
     * @return int|null
     */
    public function getSeatGeekActionId()
    {
        return $this->SeatGeekActionId;
    }
    /**
     * Set SeatGeekActionId value
     * @param int $seatGeekActionId
     * @return \patest\StructType\PersistUserAcknowledgementReactionsRequest
     */
    public function setSeatGeekActionId($seatGeekActionId = null)
    {
        // validation for constraint: int
        if (!is_null($seatGeekActionId) && !(is_int($seatGeekActionId) || ctype_digit($seatGeekActionId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatGeekActionId, true), gettype($seatGeekActionId)), __LINE__);
        }
        $this->SeatGeekActionId = $seatGeekActionId;
        return $this;
    }
    /**
     * Get TransactionId value
     * @return string|null
     */
    public function getTransactionId()
    {
        return $this->TransactionId;
    }
    /**
     * Set TransactionId value
     * @param string $transactionId
     * @return \patest\StructType\PersistUserAcknowledgementReactionsRequest
     */
    public function setTransactionId($transactionId = null)
    {
        // validation for constraint: string
        if (!is_null($transactionId) && !is_string($transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionId, true), gettype($transactionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionId, true)), __LINE__);
        }
        $this->TransactionId = $transactionId;
        return $this;
    }
}
