<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PeripheralDeviceInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:PeripheralDeviceInfo
 * @subpackage Structs
 */
class PeripheralDeviceInfo extends AbstractStructBase
{
    /**
     * The Configuration
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AnyEntity
     */
    public $Configuration;
    /**
     * The DeviceCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceCategory;
    /**
     * The DeviceName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DeviceName;
    /**
     * The DriverName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DriverName;
    /**
     * The Hint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Hint;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SerializedDefinitionNode
     */
    public $Metadata;
    /**
     * The Role
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Role;
    /**
     * Constructor method for PeripheralDeviceInfo
     * @uses PeripheralDeviceInfo::setConfiguration()
     * @uses PeripheralDeviceInfo::setDeviceCategory()
     * @uses PeripheralDeviceInfo::setDeviceName()
     * @uses PeripheralDeviceInfo::setDriverName()
     * @uses PeripheralDeviceInfo::setHint()
     * @uses PeripheralDeviceInfo::setMetadata()
     * @uses PeripheralDeviceInfo::setRole()
     * @param \patest\StructType\AnyEntity $configuration
     * @param string $deviceCategory
     * @param string $deviceName
     * @param string $driverName
     * @param string $hint
     * @param \patest\StructType\SerializedDefinitionNode $metadata
     * @param string $role
     */
    public function __construct(\patest\StructType\AnyEntity $configuration = null, $deviceCategory = null, $deviceName = null, $driverName = null, $hint = null, \patest\StructType\SerializedDefinitionNode $metadata = null, $role = null)
    {
        $this
            ->setConfiguration($configuration)
            ->setDeviceCategory($deviceCategory)
            ->setDeviceName($deviceName)
            ->setDriverName($driverName)
            ->setHint($hint)
            ->setMetadata($metadata)
            ->setRole($role);
    }
    /**
     * Get Configuration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AnyEntity|null
     */
    public function getConfiguration()
    {
        return isset($this->Configuration) ? $this->Configuration : null;
    }
    /**
     * Set Configuration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AnyEntity $configuration
     * @return \patest\StructType\PeripheralDeviceInfo
     */
    public function setConfiguration(\patest\StructType\AnyEntity $configuration = null)
    {
        if (is_null($configuration) || (is_array($configuration) && empty($configuration))) {
            unset($this->Configuration);
        } else {
            $this->Configuration = $configuration;
        }
        return $this;
    }
    /**
     * Get DeviceCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceCategory()
    {
        return isset($this->DeviceCategory) ? $this->DeviceCategory : null;
    }
    /**
     * Set DeviceCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceCategory
     * @return \patest\StructType\PeripheralDeviceInfo
     */
    public function setDeviceCategory($deviceCategory = null)
    {
        // validation for constraint: string
        if (!is_null($deviceCategory) && !is_string($deviceCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceCategory, true), gettype($deviceCategory)), __LINE__);
        }
        if (is_null($deviceCategory) || (is_array($deviceCategory) && empty($deviceCategory))) {
            unset($this->DeviceCategory);
        } else {
            $this->DeviceCategory = $deviceCategory;
        }
        return $this;
    }
    /**
     * Get DeviceName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDeviceName()
    {
        return isset($this->DeviceName) ? $this->DeviceName : null;
    }
    /**
     * Set DeviceName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $deviceName
     * @return \patest\StructType\PeripheralDeviceInfo
     */
    public function setDeviceName($deviceName = null)
    {
        // validation for constraint: string
        if (!is_null($deviceName) && !is_string($deviceName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($deviceName, true), gettype($deviceName)), __LINE__);
        }
        if (is_null($deviceName) || (is_array($deviceName) && empty($deviceName))) {
            unset($this->DeviceName);
        } else {
            $this->DeviceName = $deviceName;
        }
        return $this;
    }
    /**
     * Get DriverName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDriverName()
    {
        return isset($this->DriverName) ? $this->DriverName : null;
    }
    /**
     * Set DriverName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $driverName
     * @return \patest\StructType\PeripheralDeviceInfo
     */
    public function setDriverName($driverName = null)
    {
        // validation for constraint: string
        if (!is_null($driverName) && !is_string($driverName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($driverName, true), gettype($driverName)), __LINE__);
        }
        if (is_null($driverName) || (is_array($driverName) && empty($driverName))) {
            unset($this->DriverName);
        } else {
            $this->DriverName = $driverName;
        }
        return $this;
    }
    /**
     * Get Hint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHint()
    {
        return isset($this->Hint) ? $this->Hint : null;
    }
    /**
     * Set Hint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hint
     * @return \patest\StructType\PeripheralDeviceInfo
     */
    public function setHint($hint = null)
    {
        // validation for constraint: string
        if (!is_null($hint) && !is_string($hint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hint, true), gettype($hint)), __LINE__);
        }
        if (is_null($hint) || (is_array($hint) && empty($hint))) {
            unset($this->Hint);
        } else {
            $this->Hint = $hint;
        }
        return $this;
    }
    /**
     * Get Metadata value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SerializedDefinitionNode|null
     */
    public function getMetadata()
    {
        return isset($this->Metadata) ? $this->Metadata : null;
    }
    /**
     * Set Metadata value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SerializedDefinitionNode $metadata
     * @return \patest\StructType\PeripheralDeviceInfo
     */
    public function setMetadata(\patest\StructType\SerializedDefinitionNode $metadata = null)
    {
        if (is_null($metadata) || (is_array($metadata) && empty($metadata))) {
            unset($this->Metadata);
        } else {
            $this->Metadata = $metadata;
        }
        return $this;
    }
    /**
     * Get Role value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRole()
    {
        return isset($this->Role) ? $this->Role : null;
    }
    /**
     * Set Role value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $role
     * @return \patest\StructType\PeripheralDeviceInfo
     */
    public function setRole($role = null)
    {
        // validation for constraint: string
        if (!is_null($role) && !is_string($role)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($role, true), gettype($role)), __LINE__);
        }
        if (is_null($role) || (is_array($role) && empty($role))) {
            unset($this->Role);
        } else {
            $this->Role = $role;
        }
        return $this;
    }
}
