<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.UIPaymentPlanExtended StructType
 * @subpackage Structs
 */
class Payment_UIPaymentPlanExtended extends AnyEntity
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The DateOfFirstInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfFirstInstallment;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_UIInstallment
     */
    public $Installments;
    /**
     * The InstallmentsScheduleKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsScheduleKind;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDetails;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The ProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProviderSpecificTokenId;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for Payment.UIPaymentPlanExtended
     * @uses Payment_UIPaymentPlanExtended::setClientAmount()
     * @uses Payment_UIPaymentPlanExtended::setDateOfFirstInstallment()
     * @uses Payment_UIPaymentPlanExtended::setInstallments()
     * @uses Payment_UIPaymentPlanExtended::setInstallmentsScheduleKind()
     * @uses Payment_UIPaymentPlanExtended::setItemId()
     * @uses Payment_UIPaymentPlanExtended::setNumberOfInstallments()
     * @uses Payment_UIPaymentPlanExtended::setPaymentDetails()
     * @uses Payment_UIPaymentPlanExtended::setPaymentMethodId()
     * @uses Payment_UIPaymentPlanExtended::setProviderSpecificTokenId()
     * @uses Payment_UIPaymentPlanExtended::setTransactionGuid()
     * @param \patest\StructType\Money $clientAmount
     * @param string $dateOfFirstInstallment
     * @param \patest\StructType\RecordSetOfPayment_UIInstallment $installments
     * @param string $installmentsScheduleKind
     * @param int $itemId
     * @param int $numberOfInstallments
     * @param string $paymentDetails
     * @param string $paymentMethodId
     * @param string $providerSpecificTokenId
     * @param string $transactionGuid
     */
    public function __construct(\patest\StructType\Money $clientAmount = null, $dateOfFirstInstallment = null, \patest\StructType\RecordSetOfPayment_UIInstallment $installments = null, $installmentsScheduleKind = null, $itemId = null, $numberOfInstallments = null, $paymentDetails = null, $paymentMethodId = null, $providerSpecificTokenId = null, $transactionGuid = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setDateOfFirstInstallment($dateOfFirstInstallment)
            ->setInstallments($installments)
            ->setInstallmentsScheduleKind($installmentsScheduleKind)
            ->setItemId($itemId)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setPaymentDetails($paymentDetails)
            ->setPaymentMethodId($paymentMethodId)
            ->setProviderSpecificTokenId($providerSpecificTokenId)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get DateOfFirstInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfFirstInstallment()
    {
        return isset($this->DateOfFirstInstallment) ? $this->DateOfFirstInstallment : null;
    }
    /**
     * Set DateOfFirstInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfFirstInstallment
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setDateOfFirstInstallment($dateOfFirstInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfFirstInstallment) && !is_string($dateOfFirstInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfFirstInstallment, true), gettype($dateOfFirstInstallment)), __LINE__);
        }
        if (is_null($dateOfFirstInstallment) || (is_array($dateOfFirstInstallment) && empty($dateOfFirstInstallment))) {
            unset($this->DateOfFirstInstallment);
        } else {
            $this->DateOfFirstInstallment = $dateOfFirstInstallment;
        }
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_UIInstallment|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_UIInstallment $installments
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setInstallments(\patest\StructType\RecordSetOfPayment_UIInstallment $installments = null)
    {
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get InstallmentsScheduleKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsScheduleKind()
    {
        return isset($this->InstallmentsScheduleKind) ? $this->InstallmentsScheduleKind : null;
    }
    /**
     * Set InstallmentsScheduleKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentScheduleKind::valueIsValid()
     * @uses \patest\EnumType\InstallmentScheduleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsScheduleKind
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setInstallmentsScheduleKind($installmentsScheduleKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentScheduleKind::valueIsValid($installmentsScheduleKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentScheduleKind', is_array($installmentsScheduleKind) ? implode(', ', $installmentsScheduleKind) : var_export($installmentsScheduleKind, true), implode(', ', \patest\EnumType\InstallmentScheduleKind::getValidValues())), __LINE__);
        }
        if (is_null($installmentsScheduleKind) || (is_array($installmentsScheduleKind) && empty($installmentsScheduleKind))) {
            unset($this->InstallmentsScheduleKind);
        } else {
            $this->InstallmentsScheduleKind = $installmentsScheduleKind;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
    /**
     * Get PaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return isset($this->PaymentDetails) ? $this->PaymentDetails : null;
    }
    /**
     * Set PaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetails
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        if (is_null($paymentDetails) || (is_array($paymentDetails) && empty($paymentDetails))) {
            unset($this->PaymentDetails);
        } else {
            $this->PaymentDetails = $paymentDetails;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get ProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProviderSpecificTokenId()
    {
        return isset($this->ProviderSpecificTokenId) ? $this->ProviderSpecificTokenId : null;
    }
    /**
     * Set ProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $providerSpecificTokenId
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setProviderSpecificTokenId($providerSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($providerSpecificTokenId) && !is_string($providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($providerSpecificTokenId, true), gettype($providerSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($providerSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $providerSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($providerSpecificTokenId, true)), __LINE__);
        }
        if (is_null($providerSpecificTokenId) || (is_array($providerSpecificTokenId) && empty($providerSpecificTokenId))) {
            unset($this->ProviderSpecificTokenId);
        } else {
            $this->ProviderSpecificTokenId = $providerSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Payment_UIPaymentPlanExtended
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
