<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.RefundVoucherPaymentItemInformation StructType
 * @subpackage Structs
 */
class Payment_RefundVoucherPaymentItemInformation extends Payment_BasePaymentItemInformation
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The ContinuationVoucherAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ContinuationVoucherAmount;
    /**
     * The ContinuationVoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContinuationVoucherNumber;
    /**
     * The ExpiryDateTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDateTime;
    /**
     * The VoucherNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VoucherNumber;
    /**
     * Constructor method for Payment.RefundVoucherPaymentItemInformation
     * @uses Payment_RefundVoucherPaymentItemInformation::setCategoryId()
     * @uses Payment_RefundVoucherPaymentItemInformation::setContinuationVoucherAmount()
     * @uses Payment_RefundVoucherPaymentItemInformation::setContinuationVoucherNumber()
     * @uses Payment_RefundVoucherPaymentItemInformation::setExpiryDateTime()
     * @uses Payment_RefundVoucherPaymentItemInformation::setVoucherNumber()
     * @param string $categoryId
     * @param \patest\StructType\Money $continuationVoucherAmount
     * @param int $continuationVoucherNumber
     * @param string $expiryDateTime
     * @param int $voucherNumber
     */
    public function __construct($categoryId = null, \patest\StructType\Money $continuationVoucherAmount = null, $continuationVoucherNumber = null, $expiryDateTime = null, $voucherNumber = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setContinuationVoucherAmount($continuationVoucherAmount)
            ->setContinuationVoucherNumber($continuationVoucherNumber)
            ->setExpiryDateTime($expiryDateTime)
            ->setVoucherNumber($voucherNumber);
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Payment_RefundVoucherPaymentItemInformation
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get ContinuationVoucherAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getContinuationVoucherAmount()
    {
        return isset($this->ContinuationVoucherAmount) ? $this->ContinuationVoucherAmount : null;
    }
    /**
     * Set ContinuationVoucherAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $continuationVoucherAmount
     * @return \patest\StructType\Payment_RefundVoucherPaymentItemInformation
     */
    public function setContinuationVoucherAmount(\patest\StructType\Money $continuationVoucherAmount = null)
    {
        if (is_null($continuationVoucherAmount) || (is_array($continuationVoucherAmount) && empty($continuationVoucherAmount))) {
            unset($this->ContinuationVoucherAmount);
        } else {
            $this->ContinuationVoucherAmount = $continuationVoucherAmount;
        }
        return $this;
    }
    /**
     * Get ContinuationVoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContinuationVoucherNumber()
    {
        return isset($this->ContinuationVoucherNumber) ? $this->ContinuationVoucherNumber : null;
    }
    /**
     * Set ContinuationVoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $continuationVoucherNumber
     * @return \patest\StructType\Payment_RefundVoucherPaymentItemInformation
     */
    public function setContinuationVoucherNumber($continuationVoucherNumber = null)
    {
        // validation for constraint: int
        if (!is_null($continuationVoucherNumber) && !(is_int($continuationVoucherNumber) || ctype_digit($continuationVoucherNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($continuationVoucherNumber, true), gettype($continuationVoucherNumber)), __LINE__);
        }
        if (is_null($continuationVoucherNumber) || (is_array($continuationVoucherNumber) && empty($continuationVoucherNumber))) {
            unset($this->ContinuationVoucherNumber);
        } else {
            $this->ContinuationVoucherNumber = $continuationVoucherNumber;
        }
        return $this;
    }
    /**
     * Get ExpiryDateTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDateTime()
    {
        return isset($this->ExpiryDateTime) ? $this->ExpiryDateTime : null;
    }
    /**
     * Set ExpiryDateTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDateTime
     * @return \patest\StructType\Payment_RefundVoucherPaymentItemInformation
     */
    public function setExpiryDateTime($expiryDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateTime) && !is_string($expiryDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateTime, true), gettype($expiryDateTime)), __LINE__);
        }
        if (is_null($expiryDateTime) || (is_array($expiryDateTime) && empty($expiryDateTime))) {
            unset($this->ExpiryDateTime);
        } else {
            $this->ExpiryDateTime = $expiryDateTime;
        }
        return $this;
    }
    /**
     * Get VoucherNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVoucherNumber()
    {
        return isset($this->VoucherNumber) ? $this->VoucherNumber : null;
    }
    /**
     * Set VoucherNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $voucherNumber
     * @return \patest\StructType\Payment_RefundVoucherPaymentItemInformation
     */
    public function setVoucherNumber($voucherNumber = null)
    {
        // validation for constraint: int
        if (!is_null($voucherNumber) && !(is_int($voucherNumber) || ctype_digit($voucherNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($voucherNumber, true), gettype($voucherNumber)), __LINE__);
        }
        if (is_null($voucherNumber) || (is_array($voucherNumber) && empty($voucherNumber))) {
            unset($this->VoucherNumber);
        } else {
            $this->VoucherNumber = $voucherNumber;
        }
        return $this;
    }
}
