<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.RefundVoucher StructType
 * @subpackage Structs
 */
class Payment_RefundVoucher extends Payment_BaseClientCredit
{
    /**
     * The CategoryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CategoryId;
    /**
     * The CategoryName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CategoryName;
    /**
     * The ExpirationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDate;
    /**
     * The IsExpired
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExpired;
    /**
     * The IsObsolete
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsObsolete;
    /**
     * The ReferenceNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReferenceNumber;
    /**
     * The Utilizations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_ClientCreditUtilization
     */
    public $Utilizations;
    /**
     * Constructor method for Payment.RefundVoucher
     * @uses Payment_RefundVoucher::setCategoryId()
     * @uses Payment_RefundVoucher::setCategoryName()
     * @uses Payment_RefundVoucher::setExpirationDate()
     * @uses Payment_RefundVoucher::setIsExpired()
     * @uses Payment_RefundVoucher::setIsObsolete()
     * @uses Payment_RefundVoucher::setReferenceNumber()
     * @uses Payment_RefundVoucher::setUtilizations()
     * @param string $categoryId
     * @param \patest\StructType\GlobalString $categoryName
     * @param string $expirationDate
     * @param bool $isExpired
     * @param bool $isObsolete
     * @param int $referenceNumber
     * @param \patest\StructType\RecordSetOfPayment_ClientCreditUtilization $utilizations
     */
    public function __construct($categoryId = null, \patest\StructType\GlobalString $categoryName = null, $expirationDate = null, $isExpired = null, $isObsolete = null, $referenceNumber = null, \patest\StructType\RecordSetOfPayment_ClientCreditUtilization $utilizations = null)
    {
        $this
            ->setCategoryId($categoryId)
            ->setCategoryName($categoryName)
            ->setExpirationDate($expirationDate)
            ->setIsExpired($isExpired)
            ->setIsObsolete($isObsolete)
            ->setReferenceNumber($referenceNumber)
            ->setUtilizations($utilizations);
    }
    /**
     * Get CategoryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCategoryId()
    {
        return isset($this->CategoryId) ? $this->CategoryId : null;
    }
    /**
     * Set CategoryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $categoryId
     * @return \patest\StructType\Payment_RefundVoucher
     */
    public function setCategoryId($categoryId = null)
    {
        // validation for constraint: string
        if (!is_null($categoryId) && !is_string($categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($categoryId, true), gettype($categoryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($categoryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $categoryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($categoryId, true)), __LINE__);
        }
        if (is_null($categoryId) || (is_array($categoryId) && empty($categoryId))) {
            unset($this->CategoryId);
        } else {
            $this->CategoryId = $categoryId;
        }
        return $this;
    }
    /**
     * Get CategoryName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCategoryName()
    {
        return isset($this->CategoryName) ? $this->CategoryName : null;
    }
    /**
     * Set CategoryName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $categoryName
     * @return \patest\StructType\Payment_RefundVoucher
     */
    public function setCategoryName(\patest\StructType\GlobalString $categoryName = null)
    {
        if (is_null($categoryName) || (is_array($categoryName) && empty($categoryName))) {
            unset($this->CategoryName);
        } else {
            $this->CategoryName = $categoryName;
        }
        return $this;
    }
    /**
     * Get ExpirationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationDate()
    {
        return isset($this->ExpirationDate) ? $this->ExpirationDate : null;
    }
    /**
     * Set ExpirationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationDate
     * @return \patest\StructType\Payment_RefundVoucher
     */
    public function setExpirationDate($expirationDate = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDate) && !is_string($expirationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDate, true), gettype($expirationDate)), __LINE__);
        }
        if (is_null($expirationDate) || (is_array($expirationDate) && empty($expirationDate))) {
            unset($this->ExpirationDate);
        } else {
            $this->ExpirationDate = $expirationDate;
        }
        return $this;
    }
    /**
     * Get IsExpired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExpired()
    {
        return isset($this->IsExpired) ? $this->IsExpired : null;
    }
    /**
     * Set IsExpired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExpired
     * @return \patest\StructType\Payment_RefundVoucher
     */
    public function setIsExpired($isExpired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExpired) && !is_bool($isExpired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExpired, true), gettype($isExpired)), __LINE__);
        }
        if (is_null($isExpired) || (is_array($isExpired) && empty($isExpired))) {
            unset($this->IsExpired);
        } else {
            $this->IsExpired = $isExpired;
        }
        return $this;
    }
    /**
     * Get IsObsolete value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsObsolete()
    {
        return isset($this->IsObsolete) ? $this->IsObsolete : null;
    }
    /**
     * Set IsObsolete value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isObsolete
     * @return \patest\StructType\Payment_RefundVoucher
     */
    public function setIsObsolete($isObsolete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isObsolete) && !is_bool($isObsolete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isObsolete, true), gettype($isObsolete)), __LINE__);
        }
        if (is_null($isObsolete) || (is_array($isObsolete) && empty($isObsolete))) {
            unset($this->IsObsolete);
        } else {
            $this->IsObsolete = $isObsolete;
        }
        return $this;
    }
    /**
     * Get ReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReferenceNumber()
    {
        return isset($this->ReferenceNumber) ? $this->ReferenceNumber : null;
    }
    /**
     * Set ReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $referenceNumber
     * @return \patest\StructType\Payment_RefundVoucher
     */
    public function setReferenceNumber($referenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($referenceNumber) && !(is_int($referenceNumber) || ctype_digit($referenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($referenceNumber, true), gettype($referenceNumber)), __LINE__);
        }
        if (is_null($referenceNumber) || (is_array($referenceNumber) && empty($referenceNumber))) {
            unset($this->ReferenceNumber);
        } else {
            $this->ReferenceNumber = $referenceNumber;
        }
        return $this;
    }
    /**
     * Get Utilizations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_ClientCreditUtilization|null
     */
    public function getUtilizations()
    {
        return isset($this->Utilizations) ? $this->Utilizations : null;
    }
    /**
     * Set Utilizations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_ClientCreditUtilization $utilizations
     * @return \patest\StructType\Payment_RefundVoucher
     */
    public function setUtilizations(\patest\StructType\RecordSetOfPayment_ClientCreditUtilization $utilizations = null)
    {
        if (is_null($utilizations) || (is_array($utilizations) && empty($utilizations))) {
            unset($this->Utilizations);
        } else {
            $this->Utilizations = $utilizations;
        }
        return $this;
    }
}
