<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.Printing.PaymentsPlanDetails StructType
 * @subpackage Structs
 */
class Payment_Printing_PaymentsPlanDetails extends AnyEntity
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The ClientCurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientCurrencyCode;
    /**
     * The DateOfFirstInstallment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateOfFirstInstallment;
    /**
     * The InstallmentPaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentPaymentMethodId;
    /**
     * The InstallmentProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstallmentProviderSpecificTokenId;
    /**
     * The Installments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_Printing_Installment
     */
    public $Installments;
    /**
     * The InstallmentsScheduleKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsScheduleKind;
    /**
     * The NumberOfInstallments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfInstallments;
    /**
     * The PaymentDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentDetails;
    /**
     * The PaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentInstallmentsScheduleId;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentMethodName;
    /**
     * The PaymentPlanName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $PaymentPlanName;
    /**
     * Constructor method for Payment.Printing.PaymentsPlanDetails
     * @uses Payment_Printing_PaymentsPlanDetails::setClientAmount()
     * @uses Payment_Printing_PaymentsPlanDetails::setClientCurrencyCode()
     * @uses Payment_Printing_PaymentsPlanDetails::setDateOfFirstInstallment()
     * @uses Payment_Printing_PaymentsPlanDetails::setInstallmentPaymentMethodId()
     * @uses Payment_Printing_PaymentsPlanDetails::setInstallmentProviderSpecificTokenId()
     * @uses Payment_Printing_PaymentsPlanDetails::setInstallments()
     * @uses Payment_Printing_PaymentsPlanDetails::setInstallmentsScheduleKind()
     * @uses Payment_Printing_PaymentsPlanDetails::setNumberOfInstallments()
     * @uses Payment_Printing_PaymentsPlanDetails::setPaymentDetails()
     * @uses Payment_Printing_PaymentsPlanDetails::setPaymentInstallmentsScheduleId()
     * @uses Payment_Printing_PaymentsPlanDetails::setPaymentMethodName()
     * @uses Payment_Printing_PaymentsPlanDetails::setPaymentPlanName()
     * @param \patest\StructType\Money $clientAmount
     * @param string $clientCurrencyCode
     * @param string $dateOfFirstInstallment
     * @param string $installmentPaymentMethodId
     * @param string $installmentProviderSpecificTokenId
     * @param \patest\StructType\RecordSetOfPayment_Printing_Installment $installments
     * @param string $installmentsScheduleKind
     * @param int $numberOfInstallments
     * @param string $paymentDetails
     * @param string $paymentInstallmentsScheduleId
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @param \patest\StructType\GlobalString $paymentPlanName
     */
    public function __construct(\patest\StructType\Money $clientAmount = null, $clientCurrencyCode = null, $dateOfFirstInstallment = null, $installmentPaymentMethodId = null, $installmentProviderSpecificTokenId = null, \patest\StructType\RecordSetOfPayment_Printing_Installment $installments = null, $installmentsScheduleKind = null, $numberOfInstallments = null, $paymentDetails = null, $paymentInstallmentsScheduleId = null, \patest\StructType\GlobalString $paymentMethodName = null, \patest\StructType\GlobalString $paymentPlanName = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setClientCurrencyCode($clientCurrencyCode)
            ->setDateOfFirstInstallment($dateOfFirstInstallment)
            ->setInstallmentPaymentMethodId($installmentPaymentMethodId)
            ->setInstallmentProviderSpecificTokenId($installmentProviderSpecificTokenId)
            ->setInstallments($installments)
            ->setInstallmentsScheduleKind($installmentsScheduleKind)
            ->setNumberOfInstallments($numberOfInstallments)
            ->setPaymentDetails($paymentDetails)
            ->setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentPlanName($paymentPlanName);
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get ClientCurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientCurrencyCode()
    {
        return isset($this->ClientCurrencyCode) ? $this->ClientCurrencyCode : null;
    }
    /**
     * Set ClientCurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientCurrencyCode
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setClientCurrencyCode($clientCurrencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($clientCurrencyCode) && !is_string($clientCurrencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientCurrencyCode, true), gettype($clientCurrencyCode)), __LINE__);
        }
        if (is_null($clientCurrencyCode) || (is_array($clientCurrencyCode) && empty($clientCurrencyCode))) {
            unset($this->ClientCurrencyCode);
        } else {
            $this->ClientCurrencyCode = $clientCurrencyCode;
        }
        return $this;
    }
    /**
     * Get DateOfFirstInstallment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateOfFirstInstallment()
    {
        return isset($this->DateOfFirstInstallment) ? $this->DateOfFirstInstallment : null;
    }
    /**
     * Set DateOfFirstInstallment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateOfFirstInstallment
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setDateOfFirstInstallment($dateOfFirstInstallment = null)
    {
        // validation for constraint: string
        if (!is_null($dateOfFirstInstallment) && !is_string($dateOfFirstInstallment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateOfFirstInstallment, true), gettype($dateOfFirstInstallment)), __LINE__);
        }
        if (is_null($dateOfFirstInstallment) || (is_array($dateOfFirstInstallment) && empty($dateOfFirstInstallment))) {
            unset($this->DateOfFirstInstallment);
        } else {
            $this->DateOfFirstInstallment = $dateOfFirstInstallment;
        }
        return $this;
    }
    /**
     * Get InstallmentPaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentPaymentMethodId()
    {
        return isset($this->InstallmentPaymentMethodId) ? $this->InstallmentPaymentMethodId : null;
    }
    /**
     * Set InstallmentPaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentPaymentMethodId
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setInstallmentPaymentMethodId($installmentPaymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentPaymentMethodId) && !is_string($installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentPaymentMethodId, true), gettype($installmentPaymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentPaymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentPaymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentPaymentMethodId, true)), __LINE__);
        }
        if (is_null($installmentPaymentMethodId) || (is_array($installmentPaymentMethodId) && empty($installmentPaymentMethodId))) {
            unset($this->InstallmentPaymentMethodId);
        } else {
            $this->InstallmentPaymentMethodId = $installmentPaymentMethodId;
        }
        return $this;
    }
    /**
     * Get InstallmentProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentProviderSpecificTokenId()
    {
        return isset($this->InstallmentProviderSpecificTokenId) ? $this->InstallmentProviderSpecificTokenId : null;
    }
    /**
     * Set InstallmentProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentProviderSpecificTokenId
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setInstallmentProviderSpecificTokenId($installmentProviderSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($installmentProviderSpecificTokenId) && !is_string($installmentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentProviderSpecificTokenId, true), gettype($installmentProviderSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($installmentProviderSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $installmentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($installmentProviderSpecificTokenId, true)), __LINE__);
        }
        if (is_null($installmentProviderSpecificTokenId) || (is_array($installmentProviderSpecificTokenId) && empty($installmentProviderSpecificTokenId))) {
            unset($this->InstallmentProviderSpecificTokenId);
        } else {
            $this->InstallmentProviderSpecificTokenId = $installmentProviderSpecificTokenId;
        }
        return $this;
    }
    /**
     * Get Installments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_Printing_Installment|null
     */
    public function getInstallments()
    {
        return isset($this->Installments) ? $this->Installments : null;
    }
    /**
     * Set Installments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_Printing_Installment $installments
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setInstallments(\patest\StructType\RecordSetOfPayment_Printing_Installment $installments = null)
    {
        if (is_null($installments) || (is_array($installments) && empty($installments))) {
            unset($this->Installments);
        } else {
            $this->Installments = $installments;
        }
        return $this;
    }
    /**
     * Get InstallmentsScheduleKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsScheduleKind()
    {
        return isset($this->InstallmentsScheduleKind) ? $this->InstallmentsScheduleKind : null;
    }
    /**
     * Set InstallmentsScheduleKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentScheduleKind::valueIsValid()
     * @uses \patest\EnumType\InstallmentScheduleKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsScheduleKind
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setInstallmentsScheduleKind($installmentsScheduleKind = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentScheduleKind::valueIsValid($installmentsScheduleKind)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentScheduleKind', is_array($installmentsScheduleKind) ? implode(', ', $installmentsScheduleKind) : var_export($installmentsScheduleKind, true), implode(', ', \patest\EnumType\InstallmentScheduleKind::getValidValues())), __LINE__);
        }
        if (is_null($installmentsScheduleKind) || (is_array($installmentsScheduleKind) && empty($installmentsScheduleKind))) {
            unset($this->InstallmentsScheduleKind);
        } else {
            $this->InstallmentsScheduleKind = $installmentsScheduleKind;
        }
        return $this;
    }
    /**
     * Get NumberOfInstallments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfInstallments()
    {
        return isset($this->NumberOfInstallments) ? $this->NumberOfInstallments : null;
    }
    /**
     * Set NumberOfInstallments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfInstallments
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setNumberOfInstallments($numberOfInstallments = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfInstallments) && !(is_int($numberOfInstallments) || ctype_digit($numberOfInstallments))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfInstallments, true), gettype($numberOfInstallments)), __LINE__);
        }
        if (is_null($numberOfInstallments) || (is_array($numberOfInstallments) && empty($numberOfInstallments))) {
            unset($this->NumberOfInstallments);
        } else {
            $this->NumberOfInstallments = $numberOfInstallments;
        }
        return $this;
    }
    /**
     * Get PaymentDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentDetails()
    {
        return isset($this->PaymentDetails) ? $this->PaymentDetails : null;
    }
    /**
     * Set PaymentDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentDetails
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setPaymentDetails($paymentDetails = null)
    {
        // validation for constraint: string
        if (!is_null($paymentDetails) && !is_string($paymentDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentDetails, true), gettype($paymentDetails)), __LINE__);
        }
        if (is_null($paymentDetails) || (is_array($paymentDetails) && empty($paymentDetails))) {
            unset($this->PaymentDetails);
        } else {
            $this->PaymentDetails = $paymentDetails;
        }
        return $this;
    }
    /**
     * Get PaymentInstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentInstallmentsScheduleId()
    {
        return isset($this->PaymentInstallmentsScheduleId) ? $this->PaymentInstallmentsScheduleId : null;
    }
    /**
     * Set PaymentInstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentInstallmentsScheduleId
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstallmentsScheduleId) && !is_string($paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstallmentsScheduleId, true), gettype($paymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentInstallmentsScheduleId, true)), __LINE__);
        }
        if (is_null($paymentInstallmentsScheduleId) || (is_array($paymentInstallmentsScheduleId) && empty($paymentInstallmentsScheduleId))) {
            unset($this->PaymentInstallmentsScheduleId);
        } else {
            $this->PaymentInstallmentsScheduleId = $paymentInstallmentsScheduleId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentMethodName
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setPaymentMethodName(\patest\StructType\GlobalString $paymentMethodName = null)
    {
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentPlanName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getPaymentPlanName()
    {
        return isset($this->PaymentPlanName) ? $this->PaymentPlanName : null;
    }
    /**
     * Set PaymentPlanName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $paymentPlanName
     * @return \patest\StructType\Payment_Printing_PaymentsPlanDetails
     */
    public function setPaymentPlanName(\patest\StructType\GlobalString $paymentPlanName = null)
    {
        if (is_null($paymentPlanName) || (is_array($paymentPlanName) && empty($paymentPlanName))) {
            unset($this->PaymentPlanName);
        } else {
            $this->PaymentPlanName = $paymentPlanName;
        }
        return $this;
    }
}
