<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.Printing.PaymentSession StructType
 * @subpackage Structs
 */
class Payment_Printing_PaymentSession extends Printing_Item_ComplexProperty_Base
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The BillingAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BillingAddress;
    /**
     * The CardCompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $CardCompanyName;
    /**
     * The CardExpirationMM
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardExpirationMM;
    /**
     * The CardExpirationYY
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardExpirationYY;
    /**
     * The CardHolderName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardHolderName;
    /**
     * The CardNumberMask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumberMask;
    /**
     * The CardSuffix
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardSuffix;
    /**
     * The CardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardType;
    /**
     * The ClearingCompany
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClearingCompany;
    /**
     * The ClearingCompanyName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $ClearingCompanyName;
    /**
     * The ClientAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientAddress;
    /**
     * The ClientEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientEmail;
    /**
     * The ClientFirstName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientFirstName;
    /**
     * The ClientIdentNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientIdentNumber;
    /**
     * The ClientLastName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientLastName;
    /**
     * The ClientPhone1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientPhone1;
    /**
     * The ClientPhone2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientPhone2;
    /**
     * The ClientRemark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientRemark;
    /**
     * The Comments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Comments;
    /**
     * The ConfirmationNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfirmationNumber;
    /**
     * The CurrencyCode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrencyCode;
    /**
     * The ExecutionHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExecutionHistory;
    /**
     * The InstallmentsData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Payment_Printing_InstallmentsData
     */
    public $InstallmentsData;
    /**
     * The LocalRefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LocalRefNumber;
    /**
     * The Operation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Operation;
    /**
     * The RefNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RefNumber;
    /**
     * The ResultExtraData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResultExtraData;
    /**
     * The StartDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StartDate;
    /**
     * Constructor method for Payment.Printing.PaymentSession
     * @uses Payment_Printing_PaymentSession::setAmount()
     * @uses Payment_Printing_PaymentSession::setBillingAddress()
     * @uses Payment_Printing_PaymentSession::setCardCompanyName()
     * @uses Payment_Printing_PaymentSession::setCardExpirationMM()
     * @uses Payment_Printing_PaymentSession::setCardExpirationYY()
     * @uses Payment_Printing_PaymentSession::setCardHolderName()
     * @uses Payment_Printing_PaymentSession::setCardNumberMask()
     * @uses Payment_Printing_PaymentSession::setCardSuffix()
     * @uses Payment_Printing_PaymentSession::setCardType()
     * @uses Payment_Printing_PaymentSession::setClearingCompany()
     * @uses Payment_Printing_PaymentSession::setClearingCompanyName()
     * @uses Payment_Printing_PaymentSession::setClientAddress()
     * @uses Payment_Printing_PaymentSession::setClientEmail()
     * @uses Payment_Printing_PaymentSession::setClientFirstName()
     * @uses Payment_Printing_PaymentSession::setClientIdentNumber()
     * @uses Payment_Printing_PaymentSession::setClientLastName()
     * @uses Payment_Printing_PaymentSession::setClientPhone1()
     * @uses Payment_Printing_PaymentSession::setClientPhone2()
     * @uses Payment_Printing_PaymentSession::setClientRemark()
     * @uses Payment_Printing_PaymentSession::setComments()
     * @uses Payment_Printing_PaymentSession::setConfirmationNumber()
     * @uses Payment_Printing_PaymentSession::setCurrencyCode()
     * @uses Payment_Printing_PaymentSession::setExecutionHistory()
     * @uses Payment_Printing_PaymentSession::setInstallmentsData()
     * @uses Payment_Printing_PaymentSession::setLocalRefNumber()
     * @uses Payment_Printing_PaymentSession::setOperation()
     * @uses Payment_Printing_PaymentSession::setRefNumber()
     * @uses Payment_Printing_PaymentSession::setResultExtraData()
     * @uses Payment_Printing_PaymentSession::setStartDate()
     * @param \patest\StructType\Money $amount
     * @param string $billingAddress
     * @param \patest\StructType\GlobalString $cardCompanyName
     * @param string $cardExpirationMM
     * @param string $cardExpirationYY
     * @param string $cardHolderName
     * @param string $cardNumberMask
     * @param string $cardSuffix
     * @param string $cardType
     * @param string $clearingCompany
     * @param \patest\StructType\GlobalString $clearingCompanyName
     * @param string $clientAddress
     * @param string $clientEmail
     * @param string $clientFirstName
     * @param string $clientIdentNumber
     * @param string $clientLastName
     * @param string $clientPhone1
     * @param string $clientPhone2
     * @param string $clientRemark
     * @param string $comments
     * @param string $confirmationNumber
     * @param string $currencyCode
     * @param string $executionHistory
     * @param \patest\StructType\Payment_Printing_InstallmentsData $installmentsData
     * @param int $localRefNumber
     * @param string $operation
     * @param string $refNumber
     * @param string $resultExtraData
     * @param string $startDate
     */
    public function __construct(\patest\StructType\Money $amount = null, $billingAddress = null, \patest\StructType\GlobalString $cardCompanyName = null, $cardExpirationMM = null, $cardExpirationYY = null, $cardHolderName = null, $cardNumberMask = null, $cardSuffix = null, $cardType = null, $clearingCompany = null, \patest\StructType\GlobalString $clearingCompanyName = null, $clientAddress = null, $clientEmail = null, $clientFirstName = null, $clientIdentNumber = null, $clientLastName = null, $clientPhone1 = null, $clientPhone2 = null, $clientRemark = null, $comments = null, $confirmationNumber = null, $currencyCode = null, $executionHistory = null, \patest\StructType\Payment_Printing_InstallmentsData $installmentsData = null, $localRefNumber = null, $operation = null, $refNumber = null, $resultExtraData = null, $startDate = null)
    {
        $this
            ->setAmount($amount)
            ->setBillingAddress($billingAddress)
            ->setCardCompanyName($cardCompanyName)
            ->setCardExpirationMM($cardExpirationMM)
            ->setCardExpirationYY($cardExpirationYY)
            ->setCardHolderName($cardHolderName)
            ->setCardNumberMask($cardNumberMask)
            ->setCardSuffix($cardSuffix)
            ->setCardType($cardType)
            ->setClearingCompany($clearingCompany)
            ->setClearingCompanyName($clearingCompanyName)
            ->setClientAddress($clientAddress)
            ->setClientEmail($clientEmail)
            ->setClientFirstName($clientFirstName)
            ->setClientIdentNumber($clientIdentNumber)
            ->setClientLastName($clientLastName)
            ->setClientPhone1($clientPhone1)
            ->setClientPhone2($clientPhone2)
            ->setClientRemark($clientRemark)
            ->setComments($comments)
            ->setConfirmationNumber($confirmationNumber)
            ->setCurrencyCode($currencyCode)
            ->setExecutionHistory($executionHistory)
            ->setInstallmentsData($installmentsData)
            ->setLocalRefNumber($localRefNumber)
            ->setOperation($operation)
            ->setRefNumber($refNumber)
            ->setResultExtraData($resultExtraData)
            ->setStartDate($startDate);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get BillingAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBillingAddress()
    {
        return isset($this->BillingAddress) ? $this->BillingAddress : null;
    }
    /**
     * Set BillingAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $billingAddress
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setBillingAddress($billingAddress = null)
    {
        // validation for constraint: string
        if (!is_null($billingAddress) && !is_string($billingAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($billingAddress, true), gettype($billingAddress)), __LINE__);
        }
        if (is_null($billingAddress) || (is_array($billingAddress) && empty($billingAddress))) {
            unset($this->BillingAddress);
        } else {
            $this->BillingAddress = $billingAddress;
        }
        return $this;
    }
    /**
     * Get CardCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getCardCompanyName()
    {
        return isset($this->CardCompanyName) ? $this->CardCompanyName : null;
    }
    /**
     * Set CardCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $cardCompanyName
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setCardCompanyName(\patest\StructType\GlobalString $cardCompanyName = null)
    {
        if (is_null($cardCompanyName) || (is_array($cardCompanyName) && empty($cardCompanyName))) {
            unset($this->CardCompanyName);
        } else {
            $this->CardCompanyName = $cardCompanyName;
        }
        return $this;
    }
    /**
     * Get CardExpirationMM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardExpirationMM()
    {
        return isset($this->CardExpirationMM) ? $this->CardExpirationMM : null;
    }
    /**
     * Set CardExpirationMM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardExpirationMM
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setCardExpirationMM($cardExpirationMM = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpirationMM) && !is_string($cardExpirationMM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpirationMM, true), gettype($cardExpirationMM)), __LINE__);
        }
        if (is_null($cardExpirationMM) || (is_array($cardExpirationMM) && empty($cardExpirationMM))) {
            unset($this->CardExpirationMM);
        } else {
            $this->CardExpirationMM = $cardExpirationMM;
        }
        return $this;
    }
    /**
     * Get CardExpirationYY value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardExpirationYY()
    {
        return isset($this->CardExpirationYY) ? $this->CardExpirationYY : null;
    }
    /**
     * Set CardExpirationYY value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardExpirationYY
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setCardExpirationYY($cardExpirationYY = null)
    {
        // validation for constraint: string
        if (!is_null($cardExpirationYY) && !is_string($cardExpirationYY)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardExpirationYY, true), gettype($cardExpirationYY)), __LINE__);
        }
        if (is_null($cardExpirationYY) || (is_array($cardExpirationYY) && empty($cardExpirationYY))) {
            unset($this->CardExpirationYY);
        } else {
            $this->CardExpirationYY = $cardExpirationYY;
        }
        return $this;
    }
    /**
     * Get CardHolderName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardHolderName()
    {
        return isset($this->CardHolderName) ? $this->CardHolderName : null;
    }
    /**
     * Set CardHolderName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardHolderName
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setCardHolderName($cardHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($cardHolderName) && !is_string($cardHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardHolderName, true), gettype($cardHolderName)), __LINE__);
        }
        if (is_null($cardHolderName) || (is_array($cardHolderName) && empty($cardHolderName))) {
            unset($this->CardHolderName);
        } else {
            $this->CardHolderName = $cardHolderName;
        }
        return $this;
    }
    /**
     * Get CardNumberMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumberMask()
    {
        return isset($this->CardNumberMask) ? $this->CardNumberMask : null;
    }
    /**
     * Set CardNumberMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumberMask
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setCardNumberMask($cardNumberMask = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumberMask) && !is_string($cardNumberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumberMask, true), gettype($cardNumberMask)), __LINE__);
        }
        if (is_null($cardNumberMask) || (is_array($cardNumberMask) && empty($cardNumberMask))) {
            unset($this->CardNumberMask);
        } else {
            $this->CardNumberMask = $cardNumberMask;
        }
        return $this;
    }
    /**
     * Get CardSuffix value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardSuffix()
    {
        return isset($this->CardSuffix) ? $this->CardSuffix : null;
    }
    /**
     * Set CardSuffix value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardSuffix
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setCardSuffix($cardSuffix = null)
    {
        // validation for constraint: string
        if (!is_null($cardSuffix) && !is_string($cardSuffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardSuffix, true), gettype($cardSuffix)), __LINE__);
        }
        if (is_null($cardSuffix) || (is_array($cardSuffix) && empty($cardSuffix))) {
            unset($this->CardSuffix);
        } else {
            $this->CardSuffix = $cardSuffix;
        }
        return $this;
    }
    /**
     * Get CardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardType()
    {
        return isset($this->CardType) ? $this->CardType : null;
    }
    /**
     * Set CardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardType
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setCardType($cardType = null)
    {
        // validation for constraint: string
        if (!is_null($cardType) && !is_string($cardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardType, true), gettype($cardType)), __LINE__);
        }
        if (is_null($cardType) || (is_array($cardType) && empty($cardType))) {
            unset($this->CardType);
        } else {
            $this->CardType = $cardType;
        }
        return $this;
    }
    /**
     * Get ClearingCompany value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClearingCompany()
    {
        return isset($this->ClearingCompany) ? $this->ClearingCompany : null;
    }
    /**
     * Set ClearingCompany value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clearingCompany
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClearingCompany($clearingCompany = null)
    {
        // validation for constraint: string
        if (!is_null($clearingCompany) && !is_string($clearingCompany)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clearingCompany, true), gettype($clearingCompany)), __LINE__);
        }
        if (is_null($clearingCompany) || (is_array($clearingCompany) && empty($clearingCompany))) {
            unset($this->ClearingCompany);
        } else {
            $this->ClearingCompany = $clearingCompany;
        }
        return $this;
    }
    /**
     * Get ClearingCompanyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getClearingCompanyName()
    {
        return isset($this->ClearingCompanyName) ? $this->ClearingCompanyName : null;
    }
    /**
     * Set ClearingCompanyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $clearingCompanyName
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClearingCompanyName(\patest\StructType\GlobalString $clearingCompanyName = null)
    {
        if (is_null($clearingCompanyName) || (is_array($clearingCompanyName) && empty($clearingCompanyName))) {
            unset($this->ClearingCompanyName);
        } else {
            $this->ClearingCompanyName = $clearingCompanyName;
        }
        return $this;
    }
    /**
     * Get ClientAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientAddress()
    {
        return isset($this->ClientAddress) ? $this->ClientAddress : null;
    }
    /**
     * Set ClientAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientAddress
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClientAddress($clientAddress = null)
    {
        // validation for constraint: string
        if (!is_null($clientAddress) && !is_string($clientAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientAddress, true), gettype($clientAddress)), __LINE__);
        }
        if (is_null($clientAddress) || (is_array($clientAddress) && empty($clientAddress))) {
            unset($this->ClientAddress);
        } else {
            $this->ClientAddress = $clientAddress;
        }
        return $this;
    }
    /**
     * Get ClientEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientEmail()
    {
        return isset($this->ClientEmail) ? $this->ClientEmail : null;
    }
    /**
     * Set ClientEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientEmail
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClientEmail($clientEmail = null)
    {
        // validation for constraint: string
        if (!is_null($clientEmail) && !is_string($clientEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientEmail, true), gettype($clientEmail)), __LINE__);
        }
        if (is_null($clientEmail) || (is_array($clientEmail) && empty($clientEmail))) {
            unset($this->ClientEmail);
        } else {
            $this->ClientEmail = $clientEmail;
        }
        return $this;
    }
    /**
     * Get ClientFirstName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientFirstName()
    {
        return isset($this->ClientFirstName) ? $this->ClientFirstName : null;
    }
    /**
     * Set ClientFirstName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientFirstName
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClientFirstName($clientFirstName = null)
    {
        // validation for constraint: string
        if (!is_null($clientFirstName) && !is_string($clientFirstName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientFirstName, true), gettype($clientFirstName)), __LINE__);
        }
        if (is_null($clientFirstName) || (is_array($clientFirstName) && empty($clientFirstName))) {
            unset($this->ClientFirstName);
        } else {
            $this->ClientFirstName = $clientFirstName;
        }
        return $this;
    }
    /**
     * Get ClientIdentNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientIdentNumber()
    {
        return isset($this->ClientIdentNumber) ? $this->ClientIdentNumber : null;
    }
    /**
     * Set ClientIdentNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientIdentNumber
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClientIdentNumber($clientIdentNumber = null)
    {
        // validation for constraint: string
        if (!is_null($clientIdentNumber) && !is_string($clientIdentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientIdentNumber, true), gettype($clientIdentNumber)), __LINE__);
        }
        if (is_null($clientIdentNumber) || (is_array($clientIdentNumber) && empty($clientIdentNumber))) {
            unset($this->ClientIdentNumber);
        } else {
            $this->ClientIdentNumber = $clientIdentNumber;
        }
        return $this;
    }
    /**
     * Get ClientLastName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientLastName()
    {
        return isset($this->ClientLastName) ? $this->ClientLastName : null;
    }
    /**
     * Set ClientLastName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientLastName
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClientLastName($clientLastName = null)
    {
        // validation for constraint: string
        if (!is_null($clientLastName) && !is_string($clientLastName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientLastName, true), gettype($clientLastName)), __LINE__);
        }
        if (is_null($clientLastName) || (is_array($clientLastName) && empty($clientLastName))) {
            unset($this->ClientLastName);
        } else {
            $this->ClientLastName = $clientLastName;
        }
        return $this;
    }
    /**
     * Get ClientPhone1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientPhone1()
    {
        return isset($this->ClientPhone1) ? $this->ClientPhone1 : null;
    }
    /**
     * Set ClientPhone1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientPhone1
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClientPhone1($clientPhone1 = null)
    {
        // validation for constraint: string
        if (!is_null($clientPhone1) && !is_string($clientPhone1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientPhone1, true), gettype($clientPhone1)), __LINE__);
        }
        if (is_null($clientPhone1) || (is_array($clientPhone1) && empty($clientPhone1))) {
            unset($this->ClientPhone1);
        } else {
            $this->ClientPhone1 = $clientPhone1;
        }
        return $this;
    }
    /**
     * Get ClientPhone2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientPhone2()
    {
        return isset($this->ClientPhone2) ? $this->ClientPhone2 : null;
    }
    /**
     * Set ClientPhone2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientPhone2
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClientPhone2($clientPhone2 = null)
    {
        // validation for constraint: string
        if (!is_null($clientPhone2) && !is_string($clientPhone2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientPhone2, true), gettype($clientPhone2)), __LINE__);
        }
        if (is_null($clientPhone2) || (is_array($clientPhone2) && empty($clientPhone2))) {
            unset($this->ClientPhone2);
        } else {
            $this->ClientPhone2 = $clientPhone2;
        }
        return $this;
    }
    /**
     * Get ClientRemark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientRemark()
    {
        return isset($this->ClientRemark) ? $this->ClientRemark : null;
    }
    /**
     * Set ClientRemark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientRemark
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setClientRemark($clientRemark = null)
    {
        // validation for constraint: string
        if (!is_null($clientRemark) && !is_string($clientRemark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientRemark, true), gettype($clientRemark)), __LINE__);
        }
        if (is_null($clientRemark) || (is_array($clientRemark) && empty($clientRemark))) {
            unset($this->ClientRemark);
        } else {
            $this->ClientRemark = $clientRemark;
        }
        return $this;
    }
    /**
     * Get Comments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getComments()
    {
        return isset($this->Comments) ? $this->Comments : null;
    }
    /**
     * Set Comments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $comments
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setComments($comments = null)
    {
        // validation for constraint: string
        if (!is_null($comments) && !is_string($comments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($comments, true), gettype($comments)), __LINE__);
        }
        if (is_null($comments) || (is_array($comments) && empty($comments))) {
            unset($this->Comments);
        } else {
            $this->Comments = $comments;
        }
        return $this;
    }
    /**
     * Get ConfirmationNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfirmationNumber()
    {
        return isset($this->ConfirmationNumber) ? $this->ConfirmationNumber : null;
    }
    /**
     * Set ConfirmationNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $confirmationNumber
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setConfirmationNumber($confirmationNumber = null)
    {
        // validation for constraint: string
        if (!is_null($confirmationNumber) && !is_string($confirmationNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($confirmationNumber, true), gettype($confirmationNumber)), __LINE__);
        }
        if (is_null($confirmationNumber) || (is_array($confirmationNumber) && empty($confirmationNumber))) {
            unset($this->ConfirmationNumber);
        } else {
            $this->ConfirmationNumber = $confirmationNumber;
        }
        return $this;
    }
    /**
     * Get CurrencyCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrencyCode()
    {
        return isset($this->CurrencyCode) ? $this->CurrencyCode : null;
    }
    /**
     * Set CurrencyCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currencyCode
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setCurrencyCode($currencyCode = null)
    {
        // validation for constraint: string
        if (!is_null($currencyCode) && !is_string($currencyCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currencyCode, true), gettype($currencyCode)), __LINE__);
        }
        if (is_null($currencyCode) || (is_array($currencyCode) && empty($currencyCode))) {
            unset($this->CurrencyCode);
        } else {
            $this->CurrencyCode = $currencyCode;
        }
        return $this;
    }
    /**
     * Get ExecutionHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExecutionHistory()
    {
        return isset($this->ExecutionHistory) ? $this->ExecutionHistory : null;
    }
    /**
     * Set ExecutionHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $executionHistory
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setExecutionHistory($executionHistory = null)
    {
        // validation for constraint: string
        if (!is_null($executionHistory) && !is_string($executionHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($executionHistory, true), gettype($executionHistory)), __LINE__);
        }
        if (is_null($executionHistory) || (is_array($executionHistory) && empty($executionHistory))) {
            unset($this->ExecutionHistory);
        } else {
            $this->ExecutionHistory = $executionHistory;
        }
        return $this;
    }
    /**
     * Get InstallmentsData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Payment_Printing_InstallmentsData|null
     */
    public function getInstallmentsData()
    {
        return isset($this->InstallmentsData) ? $this->InstallmentsData : null;
    }
    /**
     * Set InstallmentsData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Payment_Printing_InstallmentsData $installmentsData
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setInstallmentsData(\patest\StructType\Payment_Printing_InstallmentsData $installmentsData = null)
    {
        if (is_null($installmentsData) || (is_array($installmentsData) && empty($installmentsData))) {
            unset($this->InstallmentsData);
        } else {
            $this->InstallmentsData = $installmentsData;
        }
        return $this;
    }
    /**
     * Get LocalRefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLocalRefNumber()
    {
        return isset($this->LocalRefNumber) ? $this->LocalRefNumber : null;
    }
    /**
     * Set LocalRefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $localRefNumber
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setLocalRefNumber($localRefNumber = null)
    {
        // validation for constraint: int
        if (!is_null($localRefNumber) && !(is_int($localRefNumber) || ctype_digit($localRefNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($localRefNumber, true), gettype($localRefNumber)), __LINE__);
        }
        if (is_null($localRefNumber) || (is_array($localRefNumber) && empty($localRefNumber))) {
            unset($this->LocalRefNumber);
        } else {
            $this->LocalRefNumber = $localRefNumber;
        }
        return $this;
    }
    /**
     * Get Operation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperation()
    {
        return isset($this->Operation) ? $this->Operation : null;
    }
    /**
     * Set Operation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentSessionOperationKind::valueIsValid()
     * @uses \patest\EnumType\PaymentSessionOperationKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $operation
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setOperation($operation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentSessionOperationKind::valueIsValid($operation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentSessionOperationKind', is_array($operation) ? implode(', ', $operation) : var_export($operation, true), implode(', ', \patest\EnumType\PaymentSessionOperationKind::getValidValues())), __LINE__);
        }
        if (is_null($operation) || (is_array($operation) && empty($operation))) {
            unset($this->Operation);
        } else {
            $this->Operation = $operation;
        }
        return $this;
    }
    /**
     * Get RefNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRefNumber()
    {
        return isset($this->RefNumber) ? $this->RefNumber : null;
    }
    /**
     * Set RefNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $refNumber
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setRefNumber($refNumber = null)
    {
        // validation for constraint: string
        if (!is_null($refNumber) && !is_string($refNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($refNumber, true), gettype($refNumber)), __LINE__);
        }
        if (is_null($refNumber) || (is_array($refNumber) && empty($refNumber))) {
            unset($this->RefNumber);
        } else {
            $this->RefNumber = $refNumber;
        }
        return $this;
    }
    /**
     * Get ResultExtraData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResultExtraData()
    {
        return isset($this->ResultExtraData) ? $this->ResultExtraData : null;
    }
    /**
     * Set ResultExtraData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $resultExtraData
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setResultExtraData($resultExtraData = null)
    {
        // validation for constraint: string
        if (!is_null($resultExtraData) && !is_string($resultExtraData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resultExtraData, true), gettype($resultExtraData)), __LINE__);
        }
        if (is_null($resultExtraData) || (is_array($resultExtraData) && empty($resultExtraData))) {
            unset($this->ResultExtraData);
        } else {
            $this->ResultExtraData = $resultExtraData;
        }
        return $this;
    }
    /**
     * Get StartDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStartDate()
    {
        return isset($this->StartDate) ? $this->StartDate : null;
    }
    /**
     * Set StartDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $startDate
     * @return \patest\StructType\Payment_Printing_PaymentSession
     */
    public function setStartDate($startDate = null)
    {
        // validation for constraint: string
        if (!is_null($startDate) && !is_string($startDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($startDate, true), gettype($startDate)), __LINE__);
        }
        if (is_null($startDate) || (is_array($startDate) && empty($startDate))) {
            unset($this->StartDate);
        } else {
            $this->StartDate = $startDate;
        }
        return $this;
    }
}
