<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Payment.Printing.Installment StructType
 * @subpackage Structs
 */
class Payment_Printing_Installment extends AnyEntity
{
    /**
     * The ClientAmount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ClientAmount;
    /**
     * The DepositTransactionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DepositTransactionNumber;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The DueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DueDate;
    /**
     * The InstallmentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentStatus;
    /**
     * The InstallmentStatusName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentStatusName;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Order;
    /**
     * The PaidOnDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaidOnDate;
    /**
     * The PaymentInstallmentsScheduleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentInstallmentsScheduleId;
    /**
     * The PaymentMethodName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodName;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The PaymentStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatus;
    /**
     * The PaymentStatusName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentStatusName;
    /**
     * Constructor method for Payment.Printing.Installment
     * @uses Payment_Printing_Installment::setClientAmount()
     * @uses Payment_Printing_Installment::setDepositTransactionNumber()
     * @uses Payment_Printing_Installment::setDescription()
     * @uses Payment_Printing_Installment::setDueDate()
     * @uses Payment_Printing_Installment::setInstallmentStatus()
     * @uses Payment_Printing_Installment::setInstallmentStatusName()
     * @uses Payment_Printing_Installment::setNotes()
     * @uses Payment_Printing_Installment::setOrder()
     * @uses Payment_Printing_Installment::setPaidOnDate()
     * @uses Payment_Printing_Installment::setPaymentInstallmentsScheduleId()
     * @uses Payment_Printing_Installment::setPaymentMethodName()
     * @uses Payment_Printing_Installment::setPaymentMethodType()
     * @uses Payment_Printing_Installment::setPaymentStatus()
     * @uses Payment_Printing_Installment::setPaymentStatusName()
     * @param \patest\StructType\Money $clientAmount
     * @param string $depositTransactionNumber
     * @param string $description
     * @param string $dueDate
     * @param string $installmentStatus
     * @param string $installmentStatusName
     * @param string $notes
     * @param int $order
     * @param string $paidOnDate
     * @param string $paymentInstallmentsScheduleId
     * @param string $paymentMethodName
     * @param string $paymentMethodType
     * @param string $paymentStatus
     * @param string $paymentStatusName
     */
    public function __construct(\patest\StructType\Money $clientAmount = null, $depositTransactionNumber = null, $description = null, $dueDate = null, $installmentStatus = null, $installmentStatusName = null, $notes = null, $order = null, $paidOnDate = null, $paymentInstallmentsScheduleId = null, $paymentMethodName = null, $paymentMethodType = null, $paymentStatus = null, $paymentStatusName = null)
    {
        $this
            ->setClientAmount($clientAmount)
            ->setDepositTransactionNumber($depositTransactionNumber)
            ->setDescription($description)
            ->setDueDate($dueDate)
            ->setInstallmentStatus($installmentStatus)
            ->setInstallmentStatusName($installmentStatusName)
            ->setNotes($notes)
            ->setOrder($order)
            ->setPaidOnDate($paidOnDate)
            ->setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId)
            ->setPaymentMethodName($paymentMethodName)
            ->setPaymentMethodType($paymentMethodType)
            ->setPaymentStatus($paymentStatus)
            ->setPaymentStatusName($paymentStatusName);
    }
    /**
     * Get ClientAmount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getClientAmount()
    {
        return isset($this->ClientAmount) ? $this->ClientAmount : null;
    }
    /**
     * Set ClientAmount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $clientAmount
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setClientAmount(\patest\StructType\Money $clientAmount = null)
    {
        if (is_null($clientAmount) || (is_array($clientAmount) && empty($clientAmount))) {
            unset($this->ClientAmount);
        } else {
            $this->ClientAmount = $clientAmount;
        }
        return $this;
    }
    /**
     * Get DepositTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepositTransactionNumber()
    {
        return isset($this->DepositTransactionNumber) ? $this->DepositTransactionNumber : null;
    }
    /**
     * Set DepositTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $depositTransactionNumber
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setDepositTransactionNumber($depositTransactionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($depositTransactionNumber) && !is_string($depositTransactionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($depositTransactionNumber, true), gettype($depositTransactionNumber)), __LINE__);
        }
        if (is_null($depositTransactionNumber) || (is_array($depositTransactionNumber) && empty($depositTransactionNumber))) {
            unset($this->DepositTransactionNumber);
        } else {
            $this->DepositTransactionNumber = $depositTransactionNumber;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get DueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDueDate()
    {
        return isset($this->DueDate) ? $this->DueDate : null;
    }
    /**
     * Set DueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dueDate
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setDueDate($dueDate = null)
    {
        // validation for constraint: string
        if (!is_null($dueDate) && !is_string($dueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dueDate, true), gettype($dueDate)), __LINE__);
        }
        if (is_null($dueDate) || (is_array($dueDate) && empty($dueDate))) {
            unset($this->DueDate);
        } else {
            $this->DueDate = $dueDate;
        }
        return $this;
    }
    /**
     * Get InstallmentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentStatus()
    {
        return isset($this->InstallmentStatus) ? $this->InstallmentStatus : null;
    }
    /**
     * Set InstallmentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentStatus::valueIsValid()
     * @uses \patest\EnumType\InstallmentStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentStatus
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setInstallmentStatus($installmentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentStatus::valueIsValid($installmentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentStatus', is_array($installmentStatus) ? implode(', ', $installmentStatus) : var_export($installmentStatus, true), implode(', ', \patest\EnumType\InstallmentStatus::getValidValues())), __LINE__);
        }
        if (is_null($installmentStatus) || (is_array($installmentStatus) && empty($installmentStatus))) {
            unset($this->InstallmentStatus);
        } else {
            $this->InstallmentStatus = $installmentStatus;
        }
        return $this;
    }
    /**
     * Get InstallmentStatusName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentStatusName()
    {
        return isset($this->InstallmentStatusName) ? $this->InstallmentStatusName : null;
    }
    /**
     * Set InstallmentStatusName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $installmentStatusName
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setInstallmentStatusName($installmentStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($installmentStatusName) && !is_string($installmentStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($installmentStatusName, true), gettype($installmentStatusName)), __LINE__);
        }
        if (is_null($installmentStatusName) || (is_array($installmentStatusName) && empty($installmentStatusName))) {
            unset($this->InstallmentStatusName);
        } else {
            $this->InstallmentStatusName = $installmentStatusName;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get Order value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrder()
    {
        return isset($this->Order) ? $this->Order : null;
    }
    /**
     * Set Order value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $order
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setOrder($order = null)
    {
        // validation for constraint: int
        if (!is_null($order) && !(is_int($order) || ctype_digit($order))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($order, true), gettype($order)), __LINE__);
        }
        if (is_null($order) || (is_array($order) && empty($order))) {
            unset($this->Order);
        } else {
            $this->Order = $order;
        }
        return $this;
    }
    /**
     * Get PaidOnDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaidOnDate()
    {
        return isset($this->PaidOnDate) ? $this->PaidOnDate : null;
    }
    /**
     * Set PaidOnDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paidOnDate
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setPaidOnDate($paidOnDate = null)
    {
        // validation for constraint: string
        if (!is_null($paidOnDate) && !is_string($paidOnDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paidOnDate, true), gettype($paidOnDate)), __LINE__);
        }
        if (is_null($paidOnDate) || (is_array($paidOnDate) && empty($paidOnDate))) {
            unset($this->PaidOnDate);
        } else {
            $this->PaidOnDate = $paidOnDate;
        }
        return $this;
    }
    /**
     * Get PaymentInstallmentsScheduleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentInstallmentsScheduleId()
    {
        return isset($this->PaymentInstallmentsScheduleId) ? $this->PaymentInstallmentsScheduleId : null;
    }
    /**
     * Set PaymentInstallmentsScheduleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentInstallmentsScheduleId
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setPaymentInstallmentsScheduleId($paymentInstallmentsScheduleId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentInstallmentsScheduleId) && !is_string($paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentInstallmentsScheduleId, true), gettype($paymentInstallmentsScheduleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentInstallmentsScheduleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentInstallmentsScheduleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentInstallmentsScheduleId, true)), __LINE__);
        }
        if (is_null($paymentInstallmentsScheduleId) || (is_array($paymentInstallmentsScheduleId) && empty($paymentInstallmentsScheduleId))) {
            unset($this->PaymentInstallmentsScheduleId);
        } else {
            $this->PaymentInstallmentsScheduleId = $paymentInstallmentsScheduleId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodName()
    {
        return isset($this->PaymentMethodName) ? $this->PaymentMethodName : null;
    }
    /**
     * Set PaymentMethodName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodName
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setPaymentMethodName($paymentMethodName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodName) && !is_string($paymentMethodName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodName, true), gettype($paymentMethodName)), __LINE__);
        }
        if (is_null($paymentMethodName) || (is_array($paymentMethodName) && empty($paymentMethodName))) {
            unset($this->PaymentMethodName);
        } else {
            $this->PaymentMethodName = $paymentMethodName;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatus()
    {
        return isset($this->PaymentStatus) ? $this->PaymentStatus : null;
    }
    /**
     * Set PaymentStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentItemStatus::valueIsValid()
     * @uses \patest\EnumType\PaymentItemStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentStatus
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setPaymentStatus($paymentStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentItemStatus::valueIsValid($paymentStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentItemStatus', is_array($paymentStatus) ? implode(', ', $paymentStatus) : var_export($paymentStatus, true), implode(', ', \patest\EnumType\PaymentItemStatus::getValidValues())), __LINE__);
        }
        if (is_null($paymentStatus) || (is_array($paymentStatus) && empty($paymentStatus))) {
            unset($this->PaymentStatus);
        } else {
            $this->PaymentStatus = $paymentStatus;
        }
        return $this;
    }
    /**
     * Get PaymentStatusName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentStatusName()
    {
        return isset($this->PaymentStatusName) ? $this->PaymentStatusName : null;
    }
    /**
     * Set PaymentStatusName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentStatusName
     * @return \patest\StructType\Payment_Printing_Installment
     */
    public function setPaymentStatusName($paymentStatusName = null)
    {
        // validation for constraint: string
        if (!is_null($paymentStatusName) && !is_string($paymentStatusName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentStatusName, true), gettype($paymentStatusName)), __LINE__);
        }
        if (is_null($paymentStatusName) || (is_array($paymentStatusName) && empty($paymentStatusName))) {
            unset($this->PaymentStatusName);
        } else {
            $this->PaymentStatusName = $paymentStatusName;
        }
        return $this;
    }
}
